# ReNCAT_preprocessor



## Name
ReNCAT facility location preprocessor ("ReNCAT preprocessor")

## Description
This project is a QGIS plug-in that allows people to provide a set of layers that describe (spatial) siting considerations 
in locating facilities, and from these layers generate suggested locations for facilities of the type affected by those 
layers' information. It is similar to Argonne's GEM tool, but allows the user to add arbitrary layers, and the function
 for calculating the values that select the points is different. These potential locations can then be used downstream 
 for social burden calculations (e.g. through the ReNCAT software or the social burden QGIS plugin).


## Installation
This plugin was designed and tested in Windows QGIS 3.38 .  This plugin will not work with QGIS editions earlier than 
3.34 due to dependence on processing algorithms that were introduced in that edition. No guarantees are given for editions 
later than 3.40 or editions not run on Windows. Multiple editions of QGIS can be installed on the same machine simultaneously.


During development, installation can be performed from the github page:

Step 1: Download this repository as a zip file. Or, git clone it and zip the resulting directory.

Step 2: If QGIS is not already open, open it.

Step 3: In the "Plugins" menu, go to "Manage and Install Plugins".

Step 4: On the left-hand side of the resulting popup menu, click "Install from ZIP".

Step 5: Click the "..." button on the right-hand side of the "ZIP file" path box, navigate to the zip 
file with the downloaded plugin, and select it/hit ok.

Step 6: Click "install plugin".

This installs the plugin.

## Usage
There are three tasks that the preprocessor can perform: 

1. Generation of raster from layers of interest. 

2. Conversion of raster cells to points based on a "goodness" criterion

3. Export of points in a format suitable for inclusion in ReNCAT.

These tasks need not be performed in order if the user has layers suitable for the "later" tasks, such as 
already having a raster layer with "goodness" values, or a layer made up of extant infrastructure points 
which is to be exported as-is for ReNCAT. However, the examples will be provided as if starting from layers of interest.

### Generating rasters from existing layers

In this step, the user selects layers that contain geographic information about the siting criteria for their infrastructure of interest. 


In our example, we want plausible sites for electric vehicle (EV) chargers within the state of Florida. 
However, we have unusual criteria: we want to be close to cell towers 
so that the charging equipment can communicate with the company's servers, and we want the chargers 
to be close to rivers with sturgeon, 
because we want to ensure that conservation staff aren't stranded.
(These files are filtered from [HIFLD open datasets](https://hifld-geoplatform.hub.arcgis.com/) and from the Census Tiger shape files, 
and are provided in the examples folder.)

![QGIS display of a subset of sturgeon rivers, a subset of cellular towers, and the outline of the state of Florida, indicating the geographic features that will be used in the example. Some sturgeon river lines are outside the boundaries of the state.](readme_pics/Maps_geography.png "Area and features of interest, as displayed in QGIS")

#### 0. Ensure all layers are in the same CRS and in meters or feet

In this example case, all the layers have been pre-processed so they are in the same CRS, 
and that CRS is in meters or feet. If you are using your own data with this guide, 
please reproject your data in advance and ensure that all layers are in the same CRS and that that CRS is in meters or feet.
If you're not sure which one to use, EPSG:3857 is in meters and is valid worldwide.

#### 1. Open the plugin by clicking on the 'cat on a computer' icon that represents the plugin, in the QGIS taskbar.

![Picture showing the image to click to open the plugin](readme_pics/Plugin_icon_location.png "How to find the plugin's icon in QGIS.")

#### 2. Click on the 'Make Raster' tab to go to that tab.

![Picture showing the 'Make Raster' tab in the plugin menu.](readme_pics/Raster_tab_location.png "Location of the 'Make Raster' tab")

#### 3. Enter the desired cell size.
This is an indication of roughly how dense the desired possible locations might be. If you want 
points to be evaluated every 100 meters (or feet, if that's your CRS), put 100. For our purposes, we want to evaluate points in a
grid of 10-km resolution, so we'll put 10000.

![Picture showing how to input 10000-meter grid resolution into the plugin.](readme_pics/input_grid_size.png "Where to input the grid size information.")

#### 4. (optional) Select whether to use the union or extent of the layers. The default is to take the union of extents.
If you only want to consider locations that are within the boundaries of all your layers, then click this option. Otherwise, leave it blank, and 
points within the boundaries of any of your layers will be considered. 

In our example, we are willing to consider points that are farther away
from the rivers but are very close to cell towers, so we will not click this option.

#### 5. Scroll down and select layers, weights, and fields.

Lower down in the tab shows all the layers that are currently loaded. 

To use a particular layer, select its checkbox under "Include?". 

If there is a particular column in the attribute table that gives the relative importance of some features 
in a given layer, then select the "Use field?" checkbox and select the numeric field from the 
dropdown in the "Field to use" column. For example, if we wanted the height of the cell tower to be used to 
show which towers were better than others, we could do so (we won't in this example).

Some layers may be more important than others. For example, it's more important that our locations are 
near the rivers and the cell towers, but it's not so important that they be in Florida. So in the "Weight" column
 we've weighted both the cell towers and the rivers 5, but the Florida layer 1.

For point and line layers, like the cell tower and river layers respectively, we can select how far away from
those features are considered "good". In this case, we are ok with being 10,000 meters from the cell towers, but 
we want to be within 1000 meters of the rivers. (For polygon layers like the shape of Florida, the radius is disabled.)


TODO: update this picture for the new radius greyouts. 

![Picture showing the layers selected and the weights and radii described in the previous paragraphs.](readme_pics/input_layers_weights.png "How to select layers, weight the layers with respect to each other, and show the distance radius for the features.")



#### 6. Press 'Generate Raster'

This may take a few seconds to a few minutes, depending on the grid resolution and the size of the area of interest. 

If there's something wrong with the inputs you've selected or provided, the error message will be displayed in the QGIS window itself, not in the dialog.
It usually is most apparent as a bright yellow bar at the top of the map display and you can click on it to open up panels for more information.

In our case, the raster-making process was successful. The result is showing below: 

![The raster image produced by the above steps. The background is mostly black, with a dark grey outline of Florida. In the northwest portion, there are some sections that are light grey or white, indicating the areas that are more in line with our criteria](readme_pics/raster_output.png)


Troubleshooting notes: 

- If you select some field attribute to use for weights (for example, you wanted the cell towers to be weighted by their height), 
it is important that that weight not be 0 for any item. Due to the way rasterization is performed, if any of the values 
within such a field
are 0, the end result for any pixel in that feature's radius (or boundaries) will be a very large negative number.

- If the raster representing a particular input layer has the same value for the entire study area, then the 
final raster may either (1) have all values be the same large negative number or (2) be generated wrong, represented by 
an error icon in the Layers menu that looks like an exclamation point in a triangle. This is fundamentally caused by
at least one raster layer having all the same values in the area of interest. This can happen when: 
(a) in an input points or lines layer, the radius was set so large that the entire area of interest has the same 
value, 
(b) in a polygon layer, the entire area of interest is covered by polygons with the same value, 
(c) in a polygon layer, the entire area of interest is covered by a single polygon (either literally, 
or because the grid cells are much larger than the size of the polygons). 
If this happens, there should be a warning in the "Python warnings" panel 
panel of the "Log Messages" window telling you which is the offending layer.

- If using the 'intersection' option for the final area (rather than the default, which is union), if the 
maximum or minimum value of any input layer only occurs outside the final area, the values of the final
raster will be within 0 and 1, but may not include either of those values.


### Generating points from raster layer

In this step, the user selects a raster layer and processes some or all of the cells into points, which represent (notional) facility locations.

#### 1. Click on the "Make Points from Raster" tab.

#### 2. Select the raster layer of interest from the dropdown.

In this case, we'll be using the raster generated in the previous section/tab.

![Image showing the dropdown menu where the raster is selected, and the raster layer being used in this example.](readme_pics/Makepoints_raster_selection.png "Where to select the raster layer from which to make points")

#### 3. Select filter levels and values

There are several values available in our raster image: 
0 (representing not being in Florida, not being close to the river, and not being close to a cell tower), 
0.090 (usually the cells that are in Florida),
0.454 (cells close to the river, but not in Florida or near cell towers) and 
0.545 (cells in Florida and close to either the cell towers or the rivers). 
One would be the maximum value, and would occur if there were cells that were in Florida, close to rivers, 
and close to cell towers. There are no such cells, so this value doesn't occur.

To get one point for all cells, regardless of value, click the box to the left of "Return all".

To select one point for all cells above a certain value, then click the box to the left of 
"Return if at least specific value" and fill in that value in the text box to the right.

To get one point for only the cells with the maximum value, leave both checkboxes blank.

For our purposes, we want all cells with values of 0.45 or higher, so we will fill in 0.45 and click the relevant checkbox: 

![Image showing how to get one point for all cells of at least the value of interest.](readme_pics/filter_specificvalue.png)

#### 4. Click "Generate points".

If successful, this will create a points layer in the QGIS main window. In our case, this looks like this (superimposed over the raster): 

![Image showing points representing raster cells of value at least the target value from our example. They are placed at the centroids of the lighter-colored raster cells, which are also shown.](readme_pics/filtered_points.png)


### Exporting points for ReNCAT

In this step, the user exports points from a points layer, including the points' sector and lat-lon locations, 
to a file formatted for import into ReNCAT.

All points' locations will be provided in EPSG:4326, which is a lat/lon coordinate reference system that is 
valid worldwide (as opposed to in a specific geographic area). 

#### 1. Click on the "Export Points for ReNCAT" tab

#### 2. Select the points layer of interest from the dropdown menu.

#### 3. Type in the points' intended sector.

This could be *EV charger* if the points are meant to represent EV chargers. If you are planning to add 
these points to an extant ReNCAT category, make sure that your spelling, 
uppercase/lowercase, and spaces match.

If this field is left blank, the resulting output will have the sector as "facility".

#### 4. Select where to save the file, and by what name.

A screenshot from our example is below.

![Screenshot showing the points layer generated in the previous tab selected in the dropdown, the sector filled in with 'EV charger', and desired save location of the file filled in.](readme_pics/points_export_menu.png)

#### 5. Click 'Export Points'.

The file will be generated in the location you selected. If opened in a web browser, the resulting file might look like this: 

![Image showing the resulting JSON file open in a web browser, displayed in a pretty-print JSON format. The top-level key is 'model', which contains the key 'facilities'. The list of facilities are organized by index, and have the attributes 'id', 'latitude', 'longitude', and 'category'. The category is 'EV charger'.](readme_pics/model_subset.png)




## Authors and acknowledgment

### Authors: 

Emily Moog, ermoog@sandia.gov *

Richard Garrett, ragarre@sandia.gov

### Acknowledgements: 

Amanda Wachtel, awachte@sandia.gov

Darryl Melander, djmelan@sandia.gov

*Corresponding developer


## Project status
As of February 2026, this plugin has been publicly released. Edits may be undertaken pending project and funding needs.