# -*- coding: utf-8 -*-

"""
/***************************************************************************
 RenameBands
                                 A QGIS plugin
 Rename and reorder raster bands
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-09-09
        copyright            : (C) 2021 by J. Pierson, UMR 6554 LETG, CNRS
        email                : julie.pierson@univ-brest.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'J. Pierson, UMR 6554 LETG, CNRS'
__date__ = '2021-09-09'
__copyright__ = '(C) 2021 by J. Pierson, UMR 6554 LETG, CNRS'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessingAlgorithm,
                       QgsProcessingParameterDefinition,
                       QgsProcessingParameterRasterDestination)
from osgeo import gdal

# custom band table widget
class ParameterBandTable(QgsProcessingParameterDefinition):

    def __init__(self, name='', description='', parent=None, optional=False):
        super().__init__(name, description, None, optional)
        self.parent = parent
        self.setMetadata({'widget_wrapper': 'BandTableWidget.BandTableWidgetWrapper'})

    def type(self):
        return 'Input parameters'

    def clone(self):
        return ParameterBandTable(self.name(), self.description(), self.parent, self.flags())
    
    
    # getting output values as a list, 1st element for layer name, 2nd for layer path,
    # then one element for each row :
    # ['mylayer', '/path/to/mylayer.tif', 'band 1, old name 1, new name 1', 'band 2, old name 2, new name 2']
    # (see BandTableWidget.py to change this)
    @staticmethod
    def tableValuesAsList(value):
        if value is None:
            return None

        if value == '':
            return None

        else:
            return value.split(';')


class RenameBandsAlgorithm(QgsProcessingAlgorithm):
    """
    This is an algorithm that takes a raster layer and
    rename and/or reorder its bands.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    INPUT = 'INPUT'
    OUTPUT = 'OUTPUT'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        
        # custom parameter : band table widget
        self.addParameter(
            ParameterBandTable(
                self.INPUT,
                self.tr('Input parameters'),
                False # True if optional
            )
        )
            
        # output raster layer
        self.addParameter(
            QgsProcessingParameterRasterDestination(
                'OUTPUT',
                self.tr('Raster output')
            )
        )


    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # RETRIEVE INPUTS AND OUTPUT
        input_param = ParameterBandTable.tableValuesAsList(parameters[self.INPUT])
        output_raster_path = self.parameterAsOutputLayer(parameters, self.OUTPUT, context)
        
        # GETTING USEFUL PARAMETERS
        
        input_raster_path = input_param[1]
        band_data = input_param[2:]
        
        # number of rows in table
        nb_row = len(band_data)
        # index of column used for band order
        index_bandorder = 0
        # index of column used for old band name
        index_oldname = 1
        # index of column used for new band name
        index_newname = 2
        
        # transform band_table in a nested list, with 1 element per band, and name and order of each band
        # [['band 1', 1], ['band 2', 2], ['band 3', 3]]
        band_table = [i.split(',') for i in band_data]
        
        # REORDERING BANDS
        
        # get order of bands as a list, i.e. [3,2,1]
        band_order = [i[index_bandorder] for i in band_table]
        # reordering bands using gdal_translate
        kwargs = {'bandList': band_order}
        output_raster = gdal.Translate(output_raster_path, input_raster_path, **kwargs)
        
        # RENAMING BANDS
            
        # iterate over each band to set its description using table input
        for band_number in range(nb_row):
            band = output_raster.GetRasterBand(band_number + 1)
            new_name = band_table[band_number][index_newname]
            # if no new name was set, use old name
            if new_name == '':
                new_name = band_table[band_number][index_oldname]
            band.SetDescription(new_name)
            
        # RETURNING RESULTS

        # Return the results of the algorithm as a dictionary
        return {self.OUTPUT: output_raster_path}


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Rename and reorder bands'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return RenameBandsAlgorithm()
