# Rename bands processing plugin for QGIS

## Brief summary

These 2 scripts can be used to rename bands from a raster file :

- **Rename and reorder bands** allows user to choose a raster input and rename and/or reorder its bands
- **Merge and rename bands** allows user to choose multiple single band rasters and merge them as a multiband raster, and to select band names and order in the process

This plugin is added in processing, in a provider called "rename bands".

**Beware !!** *Merge and rename bands* only works with QGIS 3.20 (see https://github.com/qgis/QGIS/issues/28658).

## How it works

### Rename and reorder bands

This script takes 2 input paramaters :

- a raster layer (must be already loaded in QGIS)
- a table with 3 columns. When a raster layer is selected, this table is automatically populated with one row for each band. The table columns are for : 1/ band order (1, 2, 3...) 2/ band name (this column can be empty if no description is set for the bands) 3/ new band name

User can then :
- edit the third column to set new band names
- change band order by using up and down button
- remove a band by selecting it and pressing the minus button.

A raster output is created. It will be the same as the input raster but with different band names and order, according to user input. It may have less bands than input raster, if user deleted bands in table.

### Merge and rename bands

This script takes 2 input parameters :

- a list of single band raster layers (must be already loaded in QGIS), a band name can be set for each layer
- a nodata value

Layers are then merged to create a multi-band raster, in the order defined by user.

## Dependencies

This plugin uses the following Python modules :

- osgeo

## More details

Do not hesitate to message me if there is any problem, or if you have any ideas to make it better ! It is experimental work.

