# -*- coding: utf-8 -*-

"""
/***************************************************************************
 MergeAndRenameBands
                                 A QGIS plugin
 Merge and Rename raster bands
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-09-09
        copyright            : (C) 2021 by J. Pierson, UMR 6554 LETG, CNRS
        email                : julie.pierson@univ-brest.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'J. Pierson, UMR 6554 LETG, CNRS'
__date__ = '2021-09-09'
__copyright__ = '(C) 2021 by J. Pierson, UMR 6554 LETG, CNRS'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessingAlgorithm,
                       QgsProject,
                       QgsProcessingParameterDefinition,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterRasterDestination)
import processing
from osgeo import gdal

# custom band table widget
class ParameterMergeBandTable(QgsProcessingParameterDefinition):

    def __init__(self, name='', description='', parent=None, optional=False):
        super().__init__(name, description, None, optional)
        self.parent = parent
        self.setMetadata({'widget_wrapper': 'MergeBandTableWidget.MergeBandTableWidgetWrapper'})

    def type(self):
        return 'Input parameters'

    def clone(self):
        return ParameterMergeBandTable(self.name(), self.description(), self.parent, self.flags())
    
    
    # getting output values as a list, one element for each row in table :
    # ['band 1, new name 1', 'band 2, new name 2']
    # (see BandTableWidget.py to change this)
    @staticmethod
    def tableValuesAsList(value):
        if value is None:
            return None

        if value == '':
            return None

        else:
            return value.split(';')


class MergeAndRenameAlgorithm(QgsProcessingAlgorithm):
    """
    This is an algorithm that takes a raster layer and
    rename and/or reorder its bands.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    INPUT = 'INPUT'
    NODATA = 'NODATA'
    OUTPUT = 'OUTPUT'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        
        # custom parameter : band table widget
        self.addParameter(
            ParameterMergeBandTable(
                self.INPUT,
                self.tr('Input parameters'),
                False # True if optional
            )
        )
        
        # parameter for no data value
        self.addParameter(
            QgsProcessingParameterNumber(
                    self.NODATA,
                    self.tr('No data value'), 
                    type=QgsProcessingParameterNumber.Integer, 
                    defaultValue=0,
                    optional=True
            )
        )
            
        # output raster layer
        self.addParameter(
            QgsProcessingParameterRasterDestination(
                'OUTPUT',
                self.tr('Raster output')
            )
        )


    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # RETRIEVE INPUTS AND OUTPUT
        input_param = ParameterMergeBandTable.tableValuesAsList(parameters[self.INPUT])
        nodata = self.parameterAsDouble(parameters, self.NODATA, context)
        output_raster_path = self.parameterAsOutputLayer(parameters, self.OUTPUT, context)
        
        # GETTING USEFUL PARAMETERS
        
        # number of rows in table = number of bands to merge
        nb_row = len(input_param)
        # index of column used for old band name
        index_oldname = 0
        # index of column used for new band name
        index_newname = 1
        
        # transform band_table in a nested list, with 1 element per band, and name and order of each band
        # [['band 1', 1], ['band 2', 2], ['band 3', 3]]
        band_table = [i.split(',') for i in input_param]
        
        # getting path of each input raster
        rasterNames = [i[index_oldname] for i in band_table]
        rasterLayers = [QgsProject.instance().mapLayersByName(i)[0] for i in rasterNames]
        rasterPaths = [i.source() for i in rasterLayers]
        
        # MERGING BANDS
        merge_param = {
                'INPUT' : rasterPaths,
                'SEPARATE' : True,
                'NODATA_OUTPUT' : nodata,
                'OUTPUT' : output_raster_path
                }
        processing.run("gdal:merge", merge_param, context=context, feedback=feedback)

        
        # RENAMING BANDS
        
        # reading merged raster as a gdal raster
        merged_raster = gdal.Open(output_raster_path)
        # iterate over each band to set its description using table input
        for band_number in range(nb_row):
            band = merged_raster.GetRasterBand(band_number + 1)
            new_name = band_table[band_number][index_newname]
            # if no new name was set, use old name
            if new_name == '':
                new_name = band_table[band_number][index_oldname]
            band.SetDescription(new_name)
            
        # RETURNING RESULTS

        # Return the results of the algorithm as a dictionary
        return {self.OUTPUT: output_raster_path}


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Merge and rename bands'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return MergeAndRenameAlgorithm()
