# -*- coding: utf-8 -*-
"""
/***************************************************************************
 RemoteSensingToolkitDockWidget
                                 A QGIS plugin
 This plugin computes biophysical indices
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-06-12
        git sha              : $Format:%H$
        copyright            : (C) 2023 by F.E. Ezzaher; N. Ben Achhab; H. Naciri; N. Raissouni
        email                : RST.QGIS@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import pip    
import qgis.utils
try:
    import openpyxl
except:
    if qgis.utils.iface.actionShowPythonDialog().isChecked():
        qgis.utils.iface.messageBar().pushMessage("Your message here", level=qgis.core.Qgis.Info, duration=5)
        pip.main(['install','openpyxl'])
    else: 
        qgis.utils.iface.actionShowPythonDialog().trigger()
        pip.main(['install','openpyxl'])

try:
    import sklearn
except:
    if qgis.utils.iface.actionShowPythonDialog().isChecked():
        qgis.utils.iface.messageBar().pushMessage("Your message here", level=qgis.core.Qgis.Info, duration=5)
        pip.main(['install','scikit-learn'])
    else: 
        qgis.utils.iface.actionShowPythonDialog().trigger()
        pip.main(['install','scikit-learn'])


import os
import sys
import struct
from osgeo import gdal
from osgeo import ogr 
from osgeo import osr
from functools import partial
import operator


from qgis.PyQt import QtGui, QtWidgets, uic, QtCore
from qgis.PyQt.QtGui import QDesktopServices
from PyQt5.QtGui import QPixmap
from qgis.PyQt.QtCore import pyqtSignal, Qt, pyqtSlot, QUrl
from qgis.PyQt.QtWidgets import QApplication, QFileDialog, QTreeWidgetItem, QTabWidget, QWidget, QDialog, QAbstractButton, QMenu, QVBoxLayout, QPushButton, QMessageBox
from qgis.core import QgsRasterLayer,QgsProject,QgsProcessing
from qgis.analysis import QgsRasterCalculator, QgsRasterCalculatorEntry
from qgis.utils import iface, reloadPlugin
from qgis.utils import iface
from qgis.PyQt.QtGui import QImage
from qgis.PyQt.QtWidgets import QLabel

import processing
import xml.etree.ElementTree as et

import socket
import csv

import numpy as np
#import openpyxl
from openpyxl import Workbook
from openpyxl.chart import Reference, LineChart, ScatterChart, Series
import pandas as pd
import matplotlib.pyplot as plt
from sklearn.ensemble import IsolationForest
import tempfile
import shutil

global raster_list
raster_list=[]
global mean_list
mean_list=[]
global min_list
min_list=[]
global max_list
max_list=[]
global std_list
std_list=[]
global var_list
var_list=[]


import platform
system = platform.system()
if system == 'Windows':
    import winsound
elif system == 'Darwin':
    import subprocess
else:
    pass


from qgis.core import (
    QgsMessageLog,
    QgsGeometry,
)

from qgis.gui import (
    QgsMessageBar,
)

from qgis.PyQt.QtWidgets import (
    QSizePolicy,
    QPushButton,
    QDialog,
    QGridLayout,
    QDialogButtonBox,
)
import time
from qgis.PyQt.QtWidgets import QProgressBar
from qgis.PyQt.QtCore import *
from qgis.core import Qgis

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'remote_sensing_toolkit_dockwidget_base.ui'))
    
FORM_CLASS2, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'Dialog.ui'))
    
FORM_CLASS3, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'About.ui'))

FORM_CLASS4, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'Helpfile.ui'))   

class Help(QDialog, FORM_CLASS4):
    def __init__ (self, parent=None):
        super(Help, self).__init__(parent)
        self.setupUi(self)   

class About(QDialog, FORM_CLASS3):
    def __init__ (self, parent=None):
        super(About, self).__init__(parent)
        self.setupUi(self)         
        self.pb_closeabout.clicked.connect(self.Close_About)
    def Close_About(self):
        self.close()
        
class EditButtonsWidget(QtWidgets.QWidget):
    def __init__(self, parent=None):
        super(EditButtonsWidget,self).__init__(parent)

        # add QHBox
        layout = QtWidgets.QHBoxLayout()

        # adjust spacings to your needs
        layout.setContentsMargins(0,0,0,0)
        layout.setSpacing(0)

        # add your buttons
        EditButtonsWidget.line_edit=QtWidgets.QLineEdit()
        EditButtonsWidget.line_edit.setFixedSize(170,30)  
        EditButtonsWidget.push_button=QtWidgets.QPushButton('...')
        EditButtonsWidget.push_button.setFixedSize(30, 30)
        
        layout.addWidget(EditButtonsWidget.line_edit)
        layout.addWidget(EditButtonsWidget.push_button)
        self.setLayout(layout)
        
class Dialog(QDialog, FORM_CLASS2):
    closingPlugin = pyqtSignal()
    def __init__(self, parent=None):
        """Constructor."""
        super(Dialog, self).__init__(parent)
        self.setupUi(self) 
        self.test=RemoteSensingToolkitDockWidget()
        #file Selection interface
        self.tb_bandfolder2.setEnabled(tb_bandfolder2_state)
        self.tb_bandfolder3.setEnabled(tb_bandfolder3_state)
        self.tb_bandfolder4.setEnabled(tb_bandfolder4_state)        
        self.tb_bandfolder1.clicked.connect(self.add_bandfolder1)
        self.tb_bandfolder2.clicked.connect(self.add_bandfolder2)
        self.tb_bandfolder3.clicked.connect(self.add_bandfolder3)
        self.tb_bandfolder4.clicked.connect(self.add_bandfolder4)        
        self.tb_outfolderFS.clicked.connect(self.select_folder_FS)
        self.pb_runall.clicked.connect(self.memory_save_FS)
        self.tableWidget_FileSelection.setVerticalHeaderItem(0, QtWidgets.QTableWidgetItem("Item"))
        self.tableWidget_FileSelection.verticalHeaderItem(0).setText(header1)
        self.tableWidget_FileSelection.setVerticalHeaderItem(1, QtWidgets.QTableWidgetItem("Item1"))
        self.tableWidget_FileSelection.verticalHeaderItem(1).setText(header2)  
        self.tableWidget_FileSelection.setVerticalHeaderItem(2, QtWidgets.QTableWidgetItem("Item2"))
        self.tableWidget_FileSelection.verticalHeaderItem(2).setText(header3)          
        self.tableWidget_FileSelection.setVerticalHeaderItem(3, QtWidgets.QTableWidgetItem("Item3"))
        self.tableWidget_FileSelection.verticalHeaderItem(3).setText(header4)  
        self.tableWidget_FileSelection.verticalHeader().setMaximumWidth(100)
        self.tableWidget_FileSelection.verticalHeader().setMinimumWidth(100)
        
        #Manual Selection interface
        self.pbD_addrow.clicked.connect(self.add_rows)
        self.pbD_delrow.clicked.connect(self.del_rows)
        self.tbD_outputfolder.clicked.connect(self.select_folder)
        self.tableWidget_ManualSelection.setColumnWidth(0,200)
        self.tableWidget_ManualSelection.setColumnWidth(1,200)
        self.var=EditButtonsWidget()
        self.pbD_memorysave.clicked.connect(self.memory_save)
        self.pbD_memorysave.setEnabled(False)
        self.tableWidget_ManualSelection.setColumnCount(cols_num)
        if self.tableWidget_ManualSelection.columnCount()==1: 
            self.tableWidget_ManualSelection.setHorizontalHeaderItem(0, QtWidgets.QTableWidgetItem("Item"))
            self.tableWidget_ManualSelection.horizontalHeaderItem(0).setText(header1)
        if self.tableWidget_ManualSelection.columnCount()==3: 
            self.tableWidget_ManualSelection.setHorizontalHeaderItem(2, QtWidgets.QTableWidgetItem("Item1"))
            self.tableWidget_ManualSelection.horizontalHeaderItem(2).setText(header3)
            self.tableWidget_ManualSelection.setColumnWidth(2,200)
        if self.tableWidget_ManualSelection.columnCount()==4:
            self.tableWidget_ManualSelection.setHorizontalHeaderItem(2, QtWidgets.QTableWidgetItem("Item1"))
            self.tableWidget_ManualSelection.horizontalHeaderItem(2).setText(header3)
            self.tableWidget_ManualSelection.setColumnWidth(2,200)
            self.tableWidget_ManualSelection.setHorizontalHeaderItem(3, QtWidgets.QTableWidgetItem("Item1"))
            self.tableWidget_ManualSelection.horizontalHeaderItem(3).setText(header4)
        if self.tableWidget_ManualSelection.columnCount()==5:
            self.tableWidget_ManualSelection.setHorizontalHeaderItem(2, QtWidgets.QTableWidgetItem("Item1"))
            self.tableWidget_ManualSelection.horizontalHeaderItem(2).setText(header3)
            self.tableWidget_ManualSelection.setColumnWidth(2,200)
            self.tableWidget_ManualSelection.setHorizontalHeaderItem(3, QtWidgets.QTableWidgetItem("Item1"))
            self.tableWidget_ManualSelection.horizontalHeaderItem(3).setText(header4)
            self.tableWidget_ManualSelection.setHorizontalHeaderItem(4, QtWidgets.QTableWidgetItem("Item1"))
            self.tableWidget_ManualSelection.horizontalHeaderItem(4).setText(header5)             
        if self.tableWidget_ManualSelection.columnCount()==2:
            self.tableWidget_ManualSelection.setHorizontalHeaderItem(0, QtWidgets.QTableWidgetItem("Item"))
            self.tableWidget_ManualSelection.horizontalHeaderItem(0).setText(header1)
            self.tableWidget_ManualSelection.setHorizontalHeaderItem(1, QtWidgets.QTableWidgetItem("Item1"))
            self.tableWidget_ManualSelection.horizontalHeaderItem(1).setText(header2)
        
        for i in range(self.tableWidget_ManualSelection.columnCount()):
            self.tableWidget_ManualSelection.setCellWidget(0, i, EditButtonsWidget())        
            self.var.push_button.clicked.connect(partial(self.open_dialog, self.var.line_edit))
            self.tableWidget_ManualSelection.setColumnWidth(self.tableWidget_ManualSelection.columnCount()-1,200)
    
             
    def add_rows(self):
        self.tableWidget_ManualSelection.insertRow(self.tableWidget_ManualSelection.rowCount())        
        for j in range(self.tableWidget_ManualSelection.columnCount()):
            self.tableWidget_ManualSelection.setCellWidget(self.tableWidget_ManualSelection.rowCount()-1,j, EditButtonsWidget())
            self.var.push_button.clicked.connect(partial(self.open_dialog, self.var.line_edit))
    def del_rows(self):
        selected_row=self.tableWidget_ManualSelection.selectionModel().selectedRows()
        for index in sorted(selected_row):
            self.tableWidget_ManualSelection.removeRow(index.row())

    def select_folder(self):
        global out_directory
        global outfolder_LEtext
        out_directory= str(QtWidgets.QFileDialog.getExistingDirectory())
        self.leD_outputfolder.setText('{}'.format(out_directory))
        outfolder_LEtext=self.leD_outputfolder.text()
        self.pbD_memorysave.setEnabled(True)
        self.cbD_analysis.setEnabled(True)
  
    def open_dialog(self, le: QtWidgets.QLineEdit):
        file_name = QFileDialog.getOpenFileName(self, 'Open file')
        le.setText(file_name[0])
                   
    def memory_save(self):
        global state 
        for i in range(self.tableWidget_ManualSelection.rowCount()):
            for j in range(self.tableWidget_ManualSelection.columnCount()):
                widget= self.tableWidget_ManualSelection.cellWidget(i,j)
                if isinstance(widget, EditButtonsWidget):
                    table_item=widget.findChild(QtWidgets.QLineEdit)
                    table_itemtext=table_item.text()
                    raster_list.append(table_itemtext)
               
        if self.cbD_analysis.isChecked()==True:
            state='True'
            print('checkbox is checked')
        else:
            state='False'
            print('checkbox is not checked')
        self.close()
            


    # File Selection Code
    def add_bandfolder1(self):
        bandfolder1_directory= str(QtWidgets.QFileDialog.getExistingDirectory()) 
        self.le_bandfolder1.setText('{}'.format(bandfolder1_directory))
                    
    def add_bandfolder2(self):
        bandfolder2_directory= str(QtWidgets.QFileDialog.getExistingDirectory())
        self.le_bandfolder2.setText('{}'.format(bandfolder2_directory))
        
    def add_bandfolder3(self):
        bandfolder3_directory= str(QtWidgets.QFileDialog.getExistingDirectory())
        self.le_bandfolder3.setText('{}'.format(bandfolder3_directory))  
        
    def add_bandfolder4(self):
        bandfolder4_directory= str(QtWidgets.QFileDialog.getExistingDirectory())
        self.le_bandfolder4.setText('{}'.format(bandfolder4_directory))        
        
    def select_folder_FS(self):
        global out_directory
        global outfolder_LEtext        
        out_directory= str(QtWidgets.QFileDialog.getExistingDirectory())
        self.le_outfolderFS.setText('{}'.format(out_directory))
        outfolder_LEtext=self.le_outfolderFS.text()
        self.pb_runall.setEnabled(True)
        if mask_var=='Clipping_by_mask':
            self.cb_analysis_FS.setEnabled(True) 
        elif mask_var=='AI-based_outlier_detection':
            self.cb_analysis_FS.setEnabled(False)
        elif mask_var=='Cloud_masking':
            self.cb_analysis_FS.setEnabled(False)       
        elif mask_var=='Scaling':
            self.cb_analysis_FS.setEnabled(False)              
        else:
            self.cb_analysis_FS.setEnabled(True)
        
    def memory_save_FS(self):
        global state
        raster_list_1=[]
        raster_list_2=[]
        raster_list_3=[]
        raster_list_4=[]

        #Sorting inserted data          
        for filename in os.listdir(self.le_bandfolder1.text()):
            f=os.path.join(self.le_bandfolder1.text(), filename)
            if os.path.isfile(f):
                raster_list_1.append(f) 
        if tb_bandfolder2_state==True:
            for filename in os.listdir(self.le_bandfolder2.text()):
                f=os.path.join(self.le_bandfolder2.text(), filename)
                if os.path.isfile(f):
                    raster_list_2.append(f)                 
        if tb_bandfolder3_state==True:
            for filename in os.listdir(self.le_bandfolder3.text()):
                f=os.path.join(self.le_bandfolder3.text(), filename)
                if os.path.isfile(f):
                    raster_list_3.append(f) 
        if tb_bandfolder4_state==True:
            for filename in os.listdir(self.le_bandfolder4.text()):
                f=os.path.join(self.le_bandfolder4.text(), filename)
                if os.path.isfile(f):
                    raster_list_4.append(f) 
                    
            
        if mask_var=='Clipping_by_mask':
            for f1 in raster_list_1:
                raster_list.append(f1)
                raster_list.append(raster_list_2[0])
        elif mask_var=='Composite':
            for f1 in raster_list_1:
                raster_list.append(f1)
        elif mask_var=='AI-based_outlier_detection':
            for f1 in raster_list_1:
                raster_list.append(f1)
        elif mask_var=='Cloud_masking':
            for f1 in raster_list_1:
                raster_list.append(f1)
                raster_list.append(raster_list_2[0])                
        elif mask_var=='Scaling':
            for f1 in raster_list_1:
                raster_list.append(f1)                  
        else:
        
            if len(raster_list_3)==0:
                for f1, f2 in zip(raster_list_1, raster_list_2):
                    raster_list.append(f1)
                    raster_list.append(f2)                      
            elif len(raster_list_4)==0:
                for f1, f2, f3 in zip(raster_list_1, raster_list_2, raster_list_3):
                    raster_list.append(f1)
                    raster_list.append(f2)    
                    raster_list.append(f3)     
            else:    
                for f1, f2, f3, f4 in zip(raster_list_1, raster_list_2, raster_list_3, raster_list_4):
                    raster_list.append(f1)
                    raster_list.append(f2)    
                    raster_list.append(f3)
                    raster_list.append(f4)                       
       
        #Statistics checkbox
        if self.cb_analysis_FS.isChecked()==True:
            state='True'
            print('checkbox is checked')
        else:
            state='False'
            print('checkbox is not checked')
        self.close()
        


class RemoteSensingToolkitDockWidget(QtWidgets.QDockWidget, QDialog, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(RemoteSensingToolkitDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        #initiating itemVARs
        itemVAR_AVHRR=''
        itemVAR_Sentinel=''
        itemVAR_Landsat=''
        itemVAR_ASTER=''
        itemVAR_MODIS=''

        #Dialog
        self.pushButton.clicked.connect(self.showDialog)
        self.dialogs = list()

        #Calculate_Satellite
        self.pb_CalculateAVHRR.clicked.connect(self.calculate_AVHRR)
        self.pb_CalculateSentinel.clicked.connect(self.calculate_Sentinel)
        self.pb_CalculateLandsat.clicked.connect(self.calculate_Landsat)
        self.pb_CalculateASTER.clicked.connect(self.calculate_ASTER)
        self.pb_CalculateMODIS.clicked.connect(self.calculate_MODIS)        
        #ShowEquation
        self.treeWidgetAVHRR.itemClicked.connect(self.onItemClick_AVHRR)
        self.treeWidgetSentinel.itemClicked.connect(self.onItemClick_Sentinel)
        self.treeWidgetLandsat.itemClicked.connect(self.onItemClick_Landsat)
        self.treeWidgetASTER.itemClicked.connect(self.onItemClick_ASTER)
        self.treeWidgetMODIS.itemClicked.connect(self.onItemClick_MODIS)
        
        #Help&About
        self.helpmenu= QtWidgets.QMenu()
        self.helpmenu.addAction("Help", self.open_help)
        self.Help_list=list()
        self.helpmenu.addAction("About", self.open_about)
        self.About_list=list()
        self.pb_help.setMenu(self.helpmenu)        
        
        #Hide parameter boxes
        self.label_parameter1AVHRR.setVisible(False)
        self.label_parameter2AVHRR.setVisible(False)
        self.label_parameter3AVHRR.setVisible(False)  
        self.le_parameter1AVHRR.setVisible(False)
        self.le_parameter2AVHRR.setVisible(False)
        self.le_parameter3AVHRR.setVisible(False)         
        
        self.label_parameter1Sentinel.setVisible(False)
        self.label_parameter2Sentinel.setVisible(False)
        self.label_parameter3Sentinel.setVisible(False)  
        self.le_parameter1Sentinel.setVisible(False)
        self.le_parameter2Sentinel.setVisible(False)
        self.le_parameter3Sentinel.setVisible(False)         
        
        self.label_parameter1Landsat.setVisible(False)
        self.label_parameter2Landsat.setVisible(False)
        self.label_parameter3Landsat.setVisible(False)  
        self.le_parameter1Landsat.setVisible(False)
        self.le_parameter2Landsat.setVisible(False)
        self.le_parameter3Landsat.setVisible(False)         
        
        self.label_parameter1ASTER.setVisible(False)
        self.label_parameter2ASTER.setVisible(False)
        self.label_parameter3ASTER.setVisible(False)  
        self.le_parameter1ASTER.setVisible(False)
        self.le_parameter2ASTER.setVisible(False)
        self.le_parameter3ASTER.setVisible(False)         

        self.label_parameter1MODIS.setVisible(False)
        self.label_parameter2MODIS.setVisible(False)
        self.label_parameter3MODIS.setVisible(False)  
        self.le_parameter1MODIS.setVisible(False)
        self.le_parameter2MODIS.setVisible(False)
        self.le_parameter3MODIS.setVisible(False) 
        
             
        #AVHRR
        treeAVHRR=et.parse(os.path.join(os.path.dirname(__file__),'AVHRR.xml'))
        treeAVHRR = treeAVHRR.getroot()
        self.treeWidgetAVHRR.setColumnCount(1)
        aAVHRR=QTreeWidgetItem([treeAVHRR.tag])
        self.treeWidgetAVHRR.addTopLevelItem(aAVHRR)
        
        #Sentinel
        treeSentinel=et.parse(os.path.join(os.path.dirname(__file__),'Sentinel2.xml'))
        treeSentinel=treeSentinel.getroot()
        self.treeWidgetSentinel.setColumnCount(1)
        aSentinel=QTreeWidgetItem([treeSentinel.tag])
        self.treeWidgetSentinel.addTopLevelItem(aSentinel)
        
        #Landsat
        treeLandsat=et.parse(os.path.join(os.path.dirname(__file__),'Landsat.xml'))
        treeLandsat=treeLandsat.getroot()
        self.treeWidgetLandsat.setColumnCount(1)
        aLandsat=QTreeWidgetItem([treeLandsat.tag])
        self.treeWidgetLandsat.addTopLevelItem(aLandsat)
        
        #ASTER
        treeASTER=et.parse(os.path.join(os.path.dirname(__file__),'ASTER.xml'))
        treeASTER=treeASTER.getroot()
        self.treeWidgetASTER.setColumnCount(1)
        aASTER=QTreeWidgetItem([treeASTER.tag])
        self.treeWidgetASTER.addTopLevelItem(aASTER)
        
        #MODIS
        treeMODIS=et.parse(os.path.join(os.path.dirname(__file__),'MODIS.xml'))
        treeMODIS=treeMODIS.getroot()
        self.treeWidgetMODIS.setColumnCount(1)
        aMODIS=QTreeWidgetItem([treeMODIS.tag])
        self.treeWidgetMODIS.addTopLevelItem(aMODIS)
              
        
        def displaytreeAVHRR(aAVHRR,sAVHRR):
            for child in sAVHRR:
                branch=QTreeWidgetItem([child.tag])
                aAVHRR.addChild(branch)
                displaytreeAVHRR(branch,child)
            if sAVHRR.text is not None:
                content=sAVHRR.text
                aAVHRR.addChild(QTreeWidgetItem([content]))
        displaytreeAVHRR(aAVHRR,treeAVHRR)
                           
        def displaytreeSentinel(aSentinel, sSentinel):
            for child in sSentinel:
                branch=QTreeWidgetItem([child.tag])
                aSentinel.addChild(branch)
                displaytreeSentinel(branch, child)
            if sSentinel.text is not None:
                content=sSentinel.text
                aSentinel.addChild(QTreeWidgetItem([content]))
        displaytreeSentinel(aSentinel, treeSentinel)
                
        def displaytreeLandsat(aLandsat, sLandsat):
            for child in sLandsat:
                branch=QTreeWidgetItem([child.tag])
                aLandsat.addChild(branch)
                displaytreeLandsat(branch, child)
            if sLandsat.text is not None:
                content=sLandsat.text
                aLandsat.addChild(QTreeWidgetItem([content]))
        displaytreeLandsat(aLandsat, treeLandsat)
        
        def displaytreeASTER(aASTER, sASTER):
            for child in sASTER:
                branch=QTreeWidgetItem([child.tag])
                aASTER.addChild(branch)
                displaytreeASTER(branch, child)
            if sASTER.text is not None:
                content=sASTER.text
                aASTER.addChild(QTreeWidgetItem([content]))
        displaytreeASTER(aASTER, treeASTER)
                
        def displaytreeMODIS(aMODIS, sMODIS):
            for child in sMODIS:
                branch=QTreeWidgetItem([child.tag])
                aMODIS.addChild(branch)
                displaytreeMODIS(branch, child)
            if sMODIS.text is not None:
                content=sMODIS.text
                aMODIS.addChild(QTreeWidgetItem([content]))
        displaytreeMODIS(aMODIS, treeMODIS)      



    def open_help(self):
        #help=Help()
        #self.Help_list.append(help)
        #help.show() 
        file_path= os.path.join(os.path.dirname(__file__),'RST Plugin Help.chm')
        url= QUrl.fromLocalFile(file_path)
        QDesktopServices.openUrl(url)

               
    def open_about(self):  
        about=About()
        self.About_list.append(about)
        about.show()        



    def onItemClick_AVHRR(self):
        itemAVHRR= self.treeWidgetAVHRR.currentItem() 
        global itemVAR_AVHRR
        itemVAR_AVHRR=itemAVHRR.text(0)   
        global mask_var
        mask_var=itemAVHRR.text(0)
        global header1
        global header2
        global header3
        global header4
        global cols_num
        global tb_bandfolder2_state
        global tb_bandfolder3_state
        global tb_bandfolder4_state        

        
        
        if itemAVHRR.text(0)=='NDVI':
            self.te_AVHRR.setText('NDVI= (band2-band1)/(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)  
            
        elif itemAVHRR.text(0)=='Cloud_masking':
            self.te_AVHRR.setText('Cloud mask AVHRR bands using Albedo method (0.9 < Albedo < 1.1) and Band 1 < 0.44 Threshold')
            cols_num=2
            header1='band1'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)             
            
        elif itemAVHRR.text(0)=='Scaling':
            self.te_AVHRR.setText('Scale AVHRR bands')
            cols_num=1
            header1='Band'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setText('Scale factor') 
            self.label_parameter2AVHRR.setText('Offset')
            self.label_parameter1AVHRR.setVisible(True)
            self.label_parameter2AVHRR.setVisible(True) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(True)
            self.le_parameter2AVHRR.setVisible(True)
            self.le_parameter3AVHRR.setVisible(False)               
            
        elif itemAVHRR.text(0)=='AI-based_outlier_detection':
            self.te_AVHRR.setText('Detect outliers in Time series using Isolation forest')
            cols_num=1
            header1='Time series CSV'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False
            self.le_minAVHRR.setEnabled(False) 
            self.le_minAVHRR.setReadOnly(True)
            self.le_maxAVHRR.setEnabled(False) 
            self.le_maxAVHRR.setReadOnly(True)
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setText('Contamination') 
            self.label_parameter1AVHRR.setVisible(True)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(True)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)  
        elif itemAVHRR.text(0)=='Composite':
            self.te_AVHRR.setText('10 Days composite using NDVI')
            cols_num=2
            header1='NDVI'
            header2='Band'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)                          
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)              
                
        elif itemAVHRR.text(0)=='SAVI':
            self.te_AVHRR.setText('SAVI= ((1+L)*(band2-band1))/(band2+band1+L), L: Soil brightness correction factor')
            cols_num=2
            header1='band2'
            header2='band1'  
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)     
            self.label_parameter1AVHRR.setVisible(True) 
            self.label_parameter1AVHRR.setText('L') 
            self.le_parameter1AVHRR.setVisible(True)      
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
           
        elif itemAVHRR.text(0)=='MSAVI':
            self.te_AVHRR.setText('MSAVI= 0.5*(2*band2+1-sqrt((2*band2+1)^2-8*(band2-band1)))')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)   
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
                        
        elif itemAVHRR.text(0)=='OSAVI':
            self.te_AVHRR.setText('OSAVI= (band2-band1)/(band2+band1+0.16)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)  
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
            
        elif itemAVHRR.text(0)=='GEMI':
            self.te_AVHRR.setText('GEMI= eta*(1-0.25*eta)-((band1 -0.125)/(1-band1)),   eta= (2(band2^2-band1^2)+1.5*band2+0.5*band1)/(band2+band1+0.5)')
            cols_num=2
            header1='band2'
            header2='band1'  
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)   
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            

        elif itemAVHRR.text(0)=='DVI':
            self.te_AVHRR.setText('DVI= band2-band1')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            

        elif itemAVHRR.text(0)=='TVI-Transformed':
            self.te_AVHRR.setText('TVI-Transformed= sqrt(0.5+NDVI), NDVI=(band2-band1)/(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
            
        elif itemAVHRR.text(0)=='TTVI':
            self.te_AVHRR.setText('TTVI= sqrt(0.5+Abs(NDVI)), NDVI=(band2-band1)/(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)   
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            

        elif itemAVHRR.text(0)=='RDVI':       
            self.te_AVHRR.setText('RDVI= (band2-band1)/sqrt(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                 
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            

        elif itemAVHRR.text(0)=='WDVI':
            self.te_AVHRR.setText('WDVI= band2-C*band1, C=(rs,nir)/(rs,red), (rs,nir):Near-infrared reflectance of the soil (rs,red):Red reflectance of the soil')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(True) 
            self.label_parameter1AVHRR.setText('C') 
            self.le_parameter1AVHRR.setVisible(True)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            

        elif itemAVHRR.text(0)=='NLI':
            self.te_AVHRR.setText('NLI= ((band2^2)-band1)/((band2^2)+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
            
        elif itemAVHRR.text(0)=='MSI':
            self.te_AVHRR.setText('MSI= (band3/band2)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)    
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
                       
        elif itemAVHRR.text(0)=='NDMI':
            self.te_AVHRR.setText('NDMI= (band2-band3)/(band2+band3)')
            cols_num=2
            header1='band2'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
                     
        elif itemAVHRR.text(0)=='BAI':
            self.te_AVHRR.setText('BAI= 1/(((0.1-band1)^2)+((0.06-band2)^2))')
            cols_num=2
            header1='band1'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)   
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
            
        elif itemAVHRR.text(0)=='NDBI':
            self.te_AVHRR.setText('NDBI= (band3-band2)/(band3+band2)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)

        elif itemAVHRR.text(0)=='Clipping_by_mask':
            self.te_AVHRR.setText('Clip raster by mask layer')
            cols_num=2
            header1='Raster'
            header2='Mask Layer'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)                          
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)
            
        elif itemAVHRR.text(0)=='TSAVI':
            self.te_AVHRR.setText('TSAVI= [a*(band2-a*band1-b)]/[band1+a*band2-a*b+X*(1+a^2)], a:Soil line slope, b:Soil line intercept, X:Adjustment factor to minimize soil noise ')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(True)
            self.label_parameter2AVHRR.setVisible(True) 
            self.label_parameter3AVHRR.setVisible(True) 
            self.label_parameter1AVHRR.setText('a')
            self.label_parameter2AVHRR.setText('b') 
            self.label_parameter3AVHRR.setText('X')   
            self.le_parameter1AVHRR.setVisible(True)
            self.le_parameter2AVHRR.setVisible(True)
            self.le_parameter3AVHRR.setVisible(True)
            
        elif itemAVHRR.text(0)=='SR':
            self.te_AVHRR.setText('SR= band2/band1')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            

        elif itemAVHRR.text(0)=='MSR':
            self.te_AVHRR.setText('MSR= ((band2/band1)- 1)/(sqrt((band2/band1)+ 1))')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)   
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)           
            
        elif itemAVHRR.text(0)=='EVI2':
            self.te_AVHRR.setText('EVI2= 2.5*[(band2-band1)/(band2+2.4*band1+1)]')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            

        elif itemAVHRR.text(0)=='BU':
            self.te_AVHRR.setText('BU= ((band3-band2)/(band3+band2))-((band2-band1)/(band2+band1))')
            cols_num=3
            header1='band3'
            header2='band2'
            header3='band1'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True) 
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
            
        elif itemAVHRR.text(0)=='CTVI':
            self.te_AVHRR.setText('CTVI= ((NDVI+0.5)/(Abs(NDVI+0.5))*sqrt(Abs(NDVI+0.5)), NDVI= (band2 – band1)/(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                  
            self.pushButton.setEnabled(True)  
            self.label_parameter1AVHRR.setVisible(False)
            self.label_parameter2AVHRR.setVisible(False) 
            self.label_parameter3AVHRR.setVisible(False)  
            self.le_parameter1AVHRR.setVisible(False)
            self.le_parameter2AVHRR.setVisible(False)
            self.le_parameter3AVHRR.setVisible(False)            
            
    def onItemClick_Sentinel(self):
        itemSentinel= self.treeWidgetSentinel.currentItem()
        global itemVAR_Sentinel
        itemVAR_Sentinel=itemSentinel.text(0)
        global mask_var
        mask_var=itemSentinel.text(0)        
        global header1
        global header2
        global header3
        global header4
        global header5
        global cols_num
        global tb_bandfolder2_state
        global tb_bandfolder3_state
        global tb_bandfolder4_state
        
        if itemSentinel.text(0)=='NDVI':       
            self.te_Sentinel.setText('NDVI= (band8-band4)/(band8+band4)')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False            
            self.pushButton.setEnabled(True)   
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)

        elif itemSentinel.text(0)=='Cloud_masking':       
            self.te_Sentinel.setText('Cloud mask Sentinel-2 bands using Scene Classifier Layer (SCL)')
            cols_num=2
            header1='Band'
            header2='SCL'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False            
            self.pushButton.setEnabled(True)   
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='Scaling':       
            self.te_Sentinel.setText('Scale Sentinel-2 bands')
            cols_num=1
            header1='Band'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False            
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setText('Scale factor')
            self.label_parameter2Sentinel.setText('Offset')
            self.label_parameter1Sentinel.setVisible(True)
            self.label_parameter2Sentinel.setVisible(True) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(True)
            self.le_parameter2Sentinel.setVisible(True)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='AI-based_outlier_detection':
            self.te_Sentinel.setText('Detect outliers in Time series using Isolation forest')
            cols_num=1
            header1='Time series CSV'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False        
            self.le_minSentinel.setEnabled(False) 
            self.le_minSentinel.setReadOnly(True)
            self.le_maxSentinel.setEnabled(False) 
            self.le_maxSentinel.setReadOnly(True)            
            self.pushButton.setEnabled(True)      
            self.label_parameter1Sentinel.setText('Contamination')            
            self.label_parameter1Sentinel.setVisible(True)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(True)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='GNDVI':
            self.te_Sentinel.setText('GNDVI=(band8-band3)/(band8+band3)')
            cols_num=2            
            header1='band8'
            header2='band3'
            header3= ' '
            header4= ' '   
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)    
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='EVI':
            self.te_Sentinel.setText('EVI= G*(band8-band4)/(band8+C1*band4-C2*band2+L), G= 2.5  C1=6  C2=7.5  L=1')
            cols_num=3
            header1='band8'
            header2='band4'
            header3='band2'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False 
            self.pushButton.setEnabled(True)   
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='SAVI':
            self.te_Sentinel.setText('SAVI= ((1+L)*(band8-band4))/(band8+band4+L), L: Soil brightness correction factor')
            cols_num=2
            header1='band8'
            header2='band4' 
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True)    
            self.label_parameter1Sentinel.setVisible(True) 
            self.label_parameter1Sentinel.setText('L') 
            self.le_parameter1Sentinel.setVisible(True)  
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='MSAVI':
            self.te_Sentinel.setText('MSAVI= 0.5*(2*band8+1-sqrt((2*band8+1)^2-8*(band8-band4)))')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True)     
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='OSAVI':
            self.te_Sentinel.setText('OSAVI= (band8-band4)/(band8+band4+0.16)')
            cols_num=2            
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)    
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='GOSAVI':
            self.te_Sentinel.setText('GOSAVII= (band8-band3)/(band8+band3+0.16)')
            cols_num=2            
            header1='band8'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False               
            self.pushButton.setEnabled(True)    
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='GSAVI':
            self.te_Sentinel.setText('GSAVI= (1+L)*(band8-band3)/(band8+band3+L), L:Soil adjustment factor')
            cols_num=2            
            header1='band8'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(True) 
            self.label_parameter1Sentinel.setText('L') 
            self.le_parameter1Sentinel.setVisible(True)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='MCARI':
            self.te_Sentinel.setText('MCARI= ((band5-band4)-0.2*(band5-band3))*(band5/band4)')
            cols_num=3
            header1='band5'
            header2='band4'
            header3='band3'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='Datt1':
            self.te_Sentinel.setText('Datt1= (band8-band5)/(band8-band4)')
            cols_num=3
            header1='band8'
            header2='band5'
            header3='band4'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='Datt4':
            self.te_Sentinel.setText('Datt4= band4/(band3*band5)')
            cols_num=3
            header1='band4'
            header2='band3'
            header3='band5'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='Datt6':
            self.te_Sentinel.setText('Datt6= band8A/(band3*band5)')
            cols_num=3
            header1='band8A'
            header2='band3'
            header3='band5'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)           
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='GEMI':
            self.te_Sentinel.setText('GEMI= eta*(1-0.25*eta)-((band4-0.125)/(1-band4)),   eta= (2(band8^2-band4^2)+1.5*band8+0.5*band4)/(band8+band4+0.5)')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='DVI':       
            self.te_Sentinel.setText('DVI= band8-band4')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='REDVI':       
            self.te_Sentinel.setText('REDVI= band8-band5')
            cols_num=2
            header1='band8'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='GARI':
            self.te_Sentinel.setText('GARI= (band8-(band3-λ(band2 -band4)))/(band8+(band3-λ(band2 -band4))), λ:Parameter to control the atmospheric correction')
            cols_num=4
            header1='band8'
            header2='band3'
            header3='band2'
            header4='band4'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(True) 
            self.label_parameter1Sentinel.setText('λ') 
            self.le_parameter1Sentinel.setVisible(True)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='GDVI':       
            self.te_Sentinel.setText('GDVI= band8-band3')
            cols_num=2
            header1='band8'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='NDRE':
            self.te_Sentinel.setText('NDRE= (band8-band5)/(band8+band5)')
            cols_num=2            
            header1='band8'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='CCCI':
            self.te_Sentinel.setText('CCCI= ((band8 -band5)/(band8 +band5))/((band8 -band4)/(band8 +band4))')
            cols_num=3
            header1='band8'
            header2='band5'
            header3='band4'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False               
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  

        elif itemSentinel.text(0)=='GLI':
            self.te_Sentinel.setText('GLI= (2*band3-band4-band2)/(2*band3+band4+band2)')
            cols_num=3
            header1='band3'
            header2='band4'
            header3='band2'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False               
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  

        elif itemSentinel.text(0)=='TVI-Transformed':       
            self.te_Sentinel.setText('TVI-Transformed= sqrt(0.5+NDVI), NDVI=(band8-band4)/(band8+band4)')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='TTVI':       
            self.te_Sentinel.setText('TTVI= sqrt(0.5+Abs(NDVI)), NDVI=(band8-band4)/(band8+band4)')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)       
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='IPVI':       
            self.te_Sentinel.setText('IPVI= band8/(band4+band8)')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='RDVI':       
            self.te_Sentinel.setText('RDVI= (band8-band4)/sqrt(band8+band4)')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='WDVI':       
            self.te_Sentinel.setText('WDVI= band8-C*band4, C=(rs,nir)/(rs,red), (rs,nir):Near-infrared reflectance of the soil (rs,red):Red reflectance of the soil')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)
            self.label_parameter1Sentinel.setVisible(True) 
            self.label_parameter1Sentinel.setText('C') 
            self.le_parameter1Sentinel.setVisible(True)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  

        elif itemSentinel.text(0)=='VARI':
            self.te_Sentinel.setText('VARI= (band3-band4)/(band3+band4-band2)')
            cols_num=3
            header1='band3'
            header2='band4'
            header3='band2' 
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='ARVI':
            self.te_Sentinel.setText('ARVI= (band8-band4 -γ*(band4-band2))/(band8+band4 -γ*(band4-band2)), γ:Atmospherci self-correcting factor')
            cols_num=3
            header1='band8'
            header2='band4'
            header3='band2'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(True) 
            self.label_parameter1Sentinel.setText('γ') 
            self.le_parameter1Sentinel.setVisible(True)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='SARVI':
            self.te_Sentinel.setText('SARVI= (1+L)*(band8-band4-γ*(band4-band2))/(band8+band4-γ*(band4-band2)+L),  γ:Atmospherci self-correcting factor, L:Soil adjustment factor')
            cols_num=3
            header1='band8'
            header2='band4'
            header3='band2'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)   
            self.label_parameter1Sentinel.setVisible(True) 
            self.label_parameter1Sentinel.setText('γ') 
            self.label_parameter2Sentinel.setVisible(True) 
            self.label_parameter2Sentinel.setText('L') 
            self.le_parameter1Sentinel.setVisible(True) 
            self.le_parameter2Sentinel.setVisible(True)    
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='NLI':       
            self.te_Sentinel.setText('NLI= ((band8^2)-band4)/((band8^2)+band4)')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='MNLI':       
            self.te_Sentinel.setText('MNLI= ((band8^2)-band4)*(1+L)/((band8^2)+band4+L), L:Soil adjustment factor')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(True) 
            self.label_parameter1Sentinel.setText('L') 
            self.le_parameter1Sentinel.setVisible(True)       
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='NDGI':       
            self.te_Sentinel.setText('NDGI= (band3-band4)/(band3+band4)')
            cols_num=2
            header1='band3'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='TDVI':       
            self.te_Sentinel.setText('TDVI= 1.5*(band8-band4)/sqrt(band8^2+band4+0.5)')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='WDRVI':       
            self.te_Sentinel.setText('WDRVI= (a*band8-band4)/(a*band8+band4), a:Weighting coefficient with value of 0.1-0.2')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)     
            self.label_parameter1Sentinel.setVisible(True) 
            self.label_parameter1Sentinel.setText('a') 
            self.le_parameter1Sentinel.setVisible(True)          
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='ENDVI':
            self.te_Sentinel.setText('ENDVI= ((band8+band3)-(2*band2))/((band8+band3)+(2*band2))')
            cols_num=3
            header1='band8'
            header2='band3'
            header3='band2'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='MSI':
            self.te_Sentinel.setText('MSI= (band11/band8)')
            cols_num=2            
            header1='band11'
            header2='band8'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)        
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
                      
        elif itemSentinel.text(0)=='NDMI':
            self.te_Sentinel.setText('NDMI= (band8-band11)/(band8+band11)')
            cols_num=2            
            header1='band8'
            header2='band11'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)           
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
           
        elif itemSentinel.text(0)=='NDWI':
            self.te_Sentinel.setText('NDWI= (band3-band8)/(band3+band8)')
            cols_num=2
            header1='band3'
            header2='band8'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)       
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
          
        elif itemSentinel.text(0)=='NBR':
            self.te_Sentinel.setText('NBR= (band8-band12)/(band8+band12)')
            cols_num=2
            header1='band8'
            header2='band12'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)          
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='NBR2':
            self.te_Sentinel.setText('NBR2= (band11-band12)/(band11+band12)')
            cols_num=2
            header1='band11'
            header2='band12'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='BAI':
            self.te_Sentinel.setText('BAI= 1/(((0.1-band4)^2)+((0.06-band8)^2))')
            cols_num=2
            header1='band4'
            header2='band8'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)         
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
                        
        elif itemSentinel.text(0)=='NDBI':
            self.te_Sentinel.setText('NDBI= (band11-band8)/(band11+band8)')
            cols_num=2
            header1='band11'
            header2='band8'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)     
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='CVI':
            self.te_Sentinel.setText('CVI= (band8*band4)/(band3^2)')
            cols_num=3
            header1='band8'
            header2='band4'
            header3='band3'
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)        
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='GCI':
            self.te_Sentinel.setText('GCI= (band8/band3)-1')
            cols_num=2
            header1='band8'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)         
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='LAI':
            self.te_Sentinel.setText('LAI= 3.16*EVI-0.118, with EVI=G*(band8-band4)/(band8+C1*band4-C2*band2+L), G= 2.5  C1=6  C2=7.5  L=1')
            cols_num=3
            header1='band8'
            header2='band4'
            header3='band2'
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)         
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='Clipping_by_mask':
            self.te_Sentinel.setText('Clip raster by mask layer')
            cols_num=2
            header1='Raster'
            header2='Mask Layer'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False               
            self.pushButton.setEnabled(True)       
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='SIPI':       
            self.te_Sentinel.setText('SIPI= (band8-band2)/(band8-band4)')
            cols_num=3
            header1='band8'
            header2='band2'
            header3='band4'
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  

        elif itemSentinel.text(0)=='GRVI':       
            self.te_Sentinel.setText('GRVI= band8/band3')
            cols_num=2
            header1='band8'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False            
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  

        elif itemSentinel.text(0)=='SLAVI':
            self.te_Sentinel.setText('SLAVI= band8/(band4+band11)')
            cols_num=3
            header1='band8'
            header2='band4'
            header3='band11'  
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False               
            self.pushButton.setEnabled(True)        
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='NPCI':       
            self.te_Sentinel.setText('NPCI= (band4-band2)/(band4+band2)')
            cols_num=2
            header1='band4'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)         
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  

        elif itemSentinel.text(0)=='PSRI':
            self.te_Sentinel.setText('PSRI= (band4-band2)/band8')
            cols_num=3
            header1='band4'
            header2='band2'
            header3='band8' 
            header4= ' '  
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='GVMI':       
            self.te_Sentinel.setText('GVMI= ((band8+0.1)-(band11+0.02))/((band8+0.1)+(band11+0.02))')
            cols_num=2
            header1='band8'
            header2='band11'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)            
            
        elif itemSentinel.text(0)=='NDSI-Snow':       
            self.te_Sentinel.setText('NDSI-Snow= (band3-band11)/(band3+band11)')
            cols_num=2
            header1='band3'
            header2='band11'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='NHI':       
            self.te_Sentinel.setText('NHI= (band11-band3)/(band11+band3)')
            cols_num=2
            header1='band11'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True)        
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='TSAVI':
            self.te_Sentinel.setText('TSAVI= a*(band8-a*band4-b)]/[band4+a*band8-a*b+X*(1+a2)], a:Soil line slope, b:Soil line intercept, X:Adjustment factor to minimize soil noise ')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(True)
            self.label_parameter2Sentinel.setVisible(True) 
            self.label_parameter3Sentinel.setVisible(True) 
            self.label_parameter1Sentinel.setText('a')
            self.label_parameter2Sentinel.setText('b') 
            self.label_parameter3Sentinel.setText('X')   
            self.le_parameter1Sentinel.setVisible(True)
            self.le_parameter2Sentinel.setVisible(True)
            self.le_parameter3Sentinel.setVisible(True)

        elif itemSentinel.text(0)=='SR':
            self.te_Sentinel.setText('SR= band8/band4')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)      

        elif itemSentinel.text(0)=='RERVI':
            self.te_Sentinel.setText('SR= band8/band5')
            cols_num=2
            header1='band8'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='MSR':
            self.te_Sentinel.setText('MSR= ((band8/band4)-1)/(sqrt((band8/band4)+1))')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='EVI2':
            self.te_Sentinel.setText('EVI2= 2.5*[(band8-band4)/(band8+2.4*band4+1)]')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='AFRI1.6':
            self.te_Sentinel.setText('AFRI1.6= (band8-0.66*band11)/(band8+0.66*band11) ')
            cols_num=2
            header1='band8'
            header2='band11'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='AFRI2.1':
            self.te_Sentinel.setText('AFRI2.1= (band8-0.5*band12)/(band8+ 0.5*band12) ')
            cols_num=2
            header1='band8'
            header2='band12'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True)   
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='ARI':
            self.te_Sentinel.setText('ARI= (1/band3)-(1/band5)')
            cols_num=2
            header1='band3'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='CI-RE':
            self.te_Sentinel.setText('CI-RE= (band8/band5)–1')
            cols_num=2
            header1='band8'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)             
            
        elif itemSentinel.text(0)=='CI-G':
            self.te_Sentinel.setText('CI-G= (band8/band3)–1')
            cols_num=2
            header1='band8'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True)      
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='TVI-Triangular':
            self.te_Sentinel.setText('TVI-Triangular= 0.5*[120*(band8-band3)-200*(band4-band3)]')
            cols_num=3
            header1='band8'
            header2='band3'
            header3='band4' 
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False                
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='MTVI1':
            self.te_Sentinel.setText('MTVI1= 1.2*[1.2*(band8-band3)-2.5*(band4-band3)]')
            cols_num=3
            header1='band8'
            header2='band3'
            header3='band4'  
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False               
            self.pushButton.setEnabled(True)   
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='MTVI2':
            self.te_Sentinel.setText('MTVI2= 1.5*[1.2 (band8-band3)-2.5*(band4-band3)]/sqrt[(2*band8+1)*2-(6*band8-5*sqrt(band4)-0.5]')
            cols_num=3
            header1='band8'
            header2='band3'
            header3='band4' 
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False               
            self.pushButton.setEnabled(True)      
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='CMRI':
            self.te_Sentinel.setText('CMRI= [((band8-band4)/(band8+band4))-((band3-band8)/(band3+band8))]')
            cols_num=3
            header1='band8'
            header2='band4'
            header3='band3'  
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False               
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
           
        elif itemSentinel.text(0)=='NNIR':
            self.te_Sentinel.setText('NNIR= band8/(band8+band4+band3)')
            cols_num=3
            header1='band8'
            header2='band4'
            header3='band3' 
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False               
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='RR':
            self.te_Sentinel.setText('RR= (band8/band4)*(band3/band4)*(band8/band6)')
            cols_num=4
            header1='band8'
            header2='band4'
            header3='band3'
            header4='band6'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True               
            self.pushButton.setEnabled(True)          
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='GR':
            self.te_Sentinel.setText('GR= band3/band4')
            cols_num=2
            header1='band3'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)         
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='VIRE':
            self.te_Sentinel.setText('VIRE= (10000-band8)/(band6)^2')
            cols_num=2
            header1='band8'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='VIRRE':
            self.te_Sentinel.setText('VIRRE= band8/band6')
            cols_num=2
            header1='band8'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)    
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='SVI':
            self.te_Sentinel.setText('SVI= (band8-band6)/(band8+band6)')
            cols_num=2
            header1='band8'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              
            
        elif itemSentinel.text(0)=='MNDWI':
            self.te_Sentinel.setText('MNDWI= (band3-band11)/(band3+band11)')
            cols_num=2
            header1='band3'
            header2='band11'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='BU':
            self.te_Sentinel.setText('BU= ((band11-band8)/(band11+band8))-((band8-band4)/(band8+band4))')
            cols_num=3
            header1='band11'
            header2='band8'
            header3='band4'  
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='UI':
            self.te_Sentinel.setText('UI= (band12-band8)/(band12+band8)')
            cols_num=2
            header1='band12'
            header2='band8'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False            
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='DBSI':
            self.te_Sentinel.setText('DBSI= [(band11-band3)/(band11+band3)]-NDVI, NDVI=(band8-band4)/(band8+band4)')
            cols_num=4
            header1='band11'
            header2='band3'
            header3='band8'
            header4='band4'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True            
            self.pushButton.setEnabled(True)            
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='DNVI':
            self.te_Sentinel.setText('DNVI= (band11-band12)^2/sqrt(band11+band12)')
            cols_num=2
            header1='band11'
            header2='band12'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False            
            self.pushButton.setEnabled(True)      
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='RGR':
            self.te_Sentinel.setText('RGR= band4/band3')
            cols_num=2
            header1='band4'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='CSI':
            self.te_Sentinel.setText('CSI= band8/band12')
            cols_num=2
            header1='band8'
            header2='band12'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)         
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='RENDVI':
            self.te_Sentinel.setText('RENDVI= (band8-band5)/(band8+band5)')
            cols_num=2
            header1='band8'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='DSWI':
            self.te_Sentinel.setText('DSWI= (band8+band3)/(band11+band4)')
            cols_num=4
            header1='band8'
            header2='band3'
            header3='band11'
            header4='band4'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True 
            tb_bandfolder4_state=True             
            self.pushButton.setEnabled(True)     
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='AWEInsh':
            self.te_Sentinel.setText('AWEInsh= 4*(band3+band11)-(0,25*band8+2,75*band12)')
            cols_num=4
            header1='band3'
            header2='band11'
            header3='band8'
            header4='band12'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True            
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='CMR':
            self.te_Sentinel.setText('CMR= band11/band12')
            cols_num=2
            header1='band11'
            header2='band12'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='FMR':
            self.te_Sentinel.setText('FMR= band11/band8')
            cols_num=2
            header1='band11'
            header2='band8'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='IOR':
            self.te_Sentinel.setText('IOR= band4/band2')
            cols_num=2
            header1='band4'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)             
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='CTVI':       
            self.te_Sentinel.setText('CTVI= ((NDVI+0.5)/(Abs(NDVI+0.5))*sqrt(Abs(NDVI+0.5)),  NDVI = (band8–band4)/(band8+band4)')
            cols_num=2
            header1='band8'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)              
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='IBI2':
            self.te_Sentinel.setText('IBI2= 2*band11/(band11+band8)-[band8/(band8+band4)+band3/(band3+band11)]/2*band11/(band11+band8)+[band8/(band8+band4)+band3/(band3+band11)]')
            cols_num=4
            header1='band11'
            header2='band8'
            header3='band4'
            header4='band3'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True             
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='NDSI-Salinity':
            self.te_Sentinel.setText('NDSI-Salinity= (band4-band8)/(band4+band8)')
            cols_num=2
            header1='band4'
            header2='band8'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)              

        elif itemSentinel.text(0)=='SI':
            self.te_Sentinel.setText('SI= sqrt(band3*band4)')
            cols_num=2
            header1='band3'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)  
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='NDI':
            self.te_Sentinel.setText('NDI= (band12-band7)/(band12+band7)')
            cols_num=2
            header1='band12'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='TBI':
            self.te_Sentinel.setText('TBI= (band12-band3)/(band3-band11)')
            cols_num=3
            header1='band12'
            header2='band3'
            header3='band11' 
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='CRSI':
            self.te_Sentinel.setText('CRSI= sqrt((band8*band4-band3*band2)/(band8*band4+band3*band2))')
            cols_num=4
            header1='band8'
            header2='band4'
            header3='band3'
            header4='band2'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='BLB1':
            self.te_Sentinel.setText('BLB1= (band8A+band3)/(band12+band4)')
            cols_num=4
            header1='band8A'
            header2='band3'
            header3='band12'
            header4='band4'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='BLB2':
            self.te_Sentinel.setText('BLB2= band11/band4')
            cols_num=2
            header1='band11'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True)   
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
        elif itemSentinel.text(0)=='CLSI':
            self.te_Sentinel.setText('CLSI= ((band4-band3)/(band4+band3))+band6')
            cols_num=3
            header1='band4'
            header2='band3'
            header3='band6'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False             
            self.pushButton.setEnabled(True) 
            self.label_parameter1Sentinel.setVisible(False)
            self.label_parameter2Sentinel.setVisible(False) 
            self.label_parameter3Sentinel.setVisible(False)  
            self.le_parameter1Sentinel.setVisible(False)
            self.le_parameter2Sentinel.setVisible(False)
            self.le_parameter3Sentinel.setVisible(False)  
            
    def onItemClick_Landsat(self):
        itemLandsat= self.treeWidgetLandsat.currentItem()
        global itemVAR_Landsat
        itemVAR_Landsat=itemLandsat.text(0) 
        global mask_var
        mask_var=itemLandsat.text(0)        
        global header1
        global header2
        global header3
        global header4
        global header5
        global cols_num
        global tb_bandfolder2_state
        global tb_bandfolder3_state
        global tb_bandfolder4_state        
        
        if itemLandsat.text(0)=='NDVI':
            self.te_Landsat.setText('NDVI= (band5-band4)/(band5+band4)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)      
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='Cloud_masking':
            self.te_Landsat.setText('Cloud mask Landsat 8/9 bands using the QA band')
            cols_num=2
            header1='Band'
            header2='QA Band'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)      
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  

        elif itemLandsat.text(0)=='Scaling':
            self.te_Landsat.setText('Scale Landsat 8/9 bands')
            cols_num=1
            header1='Band'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)
            self.label_parameter1Landsat.setText('Scale factor')
            self.label_parameter2Landsat.setText('Offset')           
            self.label_parameter1Landsat.setVisible(True)
            self.label_parameter2Landsat.setVisible(True) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(True)
            self.le_parameter2Landsat.setVisible(True)
            self.le_parameter3Landsat.setVisible(False)  

        elif itemLandsat.text(0)=='AI-based_outlier_detection':
            self.te_Landsat.setText('Detect outliers in Time series using Isolation forest')
            cols_num=1
            header1='Time series CSV'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False        
            self.le_minLandsat.setEnabled(False) 
            self.le_minLandsat.setReadOnly(True)
            self.le_maxLandsat.setEnabled(False) 
            self.le_maxLandsat.setReadOnly(True)            
            self.pushButton.setEnabled(True)   
            self.label_parameter1Landsat.setText('Contamination')    
            self.label_parameter1Landsat.setVisible(True)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(True)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='GNDVI':
            self.te_Landsat.setText('GNDVI= (band5-band3)/(band5+band3)')
            cols_num=2
            header1='band5'
            header2='band3' 
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)     
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='EVI':
            self.te_Landsat.setText('EVI= G*(band5-band4)/(band5+C1*band4-C2*band2+L), G= 2.5  C1=6  C2=7.5  L=1')
            cols_num=3
            header1='band5'
            header2='band4'
            header3='band2'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)     
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='SAVI':
            self.te_Landsat.setText('SAVI= ((1+L)*(band5-band4))/(band5+band4+L), L: Soil brightness correction factor')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)     
            self.label_parameter1Landsat.setVisible(True) 
            self.label_parameter1Landsat.setText('L') 
            self.le_parameter1Landsat.setVisible(True)            
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='MSAVI':
            self.te_Landsat.setText('MSAVI= 0.5*(2*band5+1-sqrt((2*band5+1)^2-8*(band5-band4)))')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              
            
        elif itemLandsat.text(0)=='OSAVI':
            self.te_Landsat.setText('OSAVI= (band5-band4)/(band5+band4+0.16)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)    
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='GOSAVI':
            self.te_Landsat.setText('GOSAVI= (band5-band3)/(band5+band3+0.16)')
            cols_num=2
            header1='band5'
            header2='band3' 
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='GSAVI':
            self.te_Landsat.setText('GSAVI= (1+L)*(band5-band3)/(band5+band3+L), L:Soil adjustment factor')
            cols_num=2            
            header1='band5'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(True) 
            self.label_parameter1Landsat.setText('L') 
            self.le_parameter1Landsat.setVisible(True)   
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='GEMI':
            self.te_Landsat.setText('GEMI= eta*(1-0.25*eta)-((band4-0.125)/(1-band4)),  eta= (2(band5^2-band4^2)+1.5*band5+0.5*band4)/(band5+band4+0.5)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)      
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              
 
        elif itemLandsat.text(0)=='DVI':
            self.te_Landsat.setText('DVI= band5-band4')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='GARI':
            self.te_Landsat.setText('GARI= (band5-(band3 -λ(band2-band4)))/(band5+(band3 -λ(band2-band4))), λ:Parameter to control the atmospheric correction')
            cols_num=4
            header1='band5'
            header2='band3'
            header3='band2'
            header4='band4'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(True) 
            self.label_parameter1Landsat.setText('λ') 
            self.le_parameter1Landsat.setVisible(True)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)             

        elif itemLandsat.text(0)=='GDVI':       
            self.te_Landsat.setText('GDVI= band5-band3')
            cols_num=2
            header1='band5'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='GLI':
            self.te_Landsat.setText('GLI= (2*band3-band4-band2)/(2*band3+band4+band2)')
            cols_num=3
            header1='band3'
            header2='band4'
            header3='band2'  
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='TVI-Transformed':       
            self.te_Landsat.setText('TVI-Transformed= sqrt(0.5+NDVI), NDVI=(band5-band4)/(band5+band4)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              
            
        elif itemLandsat.text(0)=='TTVI':       
            self.te_Landsat.setText('TTVI= sqrt(0.5+Abs(NDVI)), NDVI=(band5-band4)/(band5+band4)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='IPVI':       
            self.te_Landsat.setText('IPVI= band5/(band4+band5)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='RDVI':       
            self.te_Landsat.setText('RDVI= (band5-band4)/sqrt(band5+band4)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='WDVI':       
            self.te_Landsat.setText('WDVI= band5-C*band4, C=(rs,nir)/(rs,red), (rs,nir):Near-infrared reflectance of the soil (rs,red):Red reflectance of the soil')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(True) 
            self.label_parameter1Landsat.setText('C') 
            self.le_parameter1Landsat.setVisible(True)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='VARI':
            self.te_Landsat.setText('VARI= (band3-band4)/(band3+band4-band2)')
            cols_num=3
            header1='band3'
            header2='band4'
            header3='band2' 
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='ARVI':
            self.te_Landsat.setText('ARVI= (band5-band4 -γ*(band4-band2))/(band5+band4 -γ*(band4-band2)), γ:Atmospherci self-correcting factor')
            cols_num=3
            header1='band5'
            header2='band4'
            header3='band2'  
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(True) 
            self.label_parameter1Landsat.setText('γ') 
            self.le_parameter1Landsat.setVisible(True)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  

        elif itemLandsat.text(0)=='SARVI':
            self.te_Landsat.setText('SARVI= (1+L)*(band5-band4-γ*(band4-band2))/(band5+band4-γ*(band4-band2)+L),  γ:Atmospherci self-correcting factor, L:Soil adjustment factor')
            cols_num=3
            header1='band5'
            header2='band4'
            header3='band2'  
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)
            self.label_parameter1Landsat.setVisible(True) 
            self.label_parameter1Landsat.setText('γ') 
            self.label_parameter2Landsat.setVisible(True) 
            self.label_parameter2Landsat.setText('L')             
            self.le_parameter1Landsat.setVisible(True)  
            self.le_parameter2Landsat.setVisible(True)           
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter3Landsat.setVisible(False)              
            
        elif itemLandsat.text(0)=='NLI':
            self.te_Landsat.setText('NLI= ((band5^2)-band4)/((band5^2)+band4)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)             
            
        elif itemLandsat.text(0)=='MNLI':
            self.te_Landsat.setText('MNLI= ((band5^2)-band4)*(1+L)/((band5^2)+band4+L), L:Soil adjustment factor')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)     
            self.label_parameter1Landsat.setVisible(True) 
            self.label_parameter1Landsat.setText('L') 
            self.le_parameter1Landsat.setVisible(True)            
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NDGI':
            self.te_Landsat.setText('NDGI= (band3-band4)/(band3+band4)')
            cols_num=2
            header1='band3'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              
            
        elif itemLandsat.text(0)=='RI':
            self.te_Landsat.setText('RI= (band4-band3)/(band4+band3)')
            cols_num=2
            header1='band4'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='TDVI':
            self.te_Landsat.setText('TDVI= 1.5*(band5-band4)/sqrt(band5^2+band4+0.5)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              

        elif itemLandsat.text(0)=='WDRVI':
            self.te_Landsat.setText('WDRVI= (a*band5-band4)/(a*band5+band4), a:Weighting coefficient with value of 0.1-0.2')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)  
            self.label_parameter1Landsat.setVisible(True) 
            self.label_parameter1Landsat.setText('a') 
            self.le_parameter1Landsat.setVisible(True)           
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              
            
        elif itemLandsat.text(0)=='MSI':
            self.te_Landsat.setText('MSI= (band6/band5)')
            cols_num=2
            header1='band6'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)    
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              
            
        elif itemLandsat.text(0)=='NDMI':
            self.te_Landsat.setText('NDMI= (band5-band6)/(band5+band6)')
            cols_num=2
            header1='band5'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NDWI':
            self.te_Landsat.setText('NDWI= (band3-band5)/(band3+band5)')
            cols_num=2
            header1='band3'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NBR':
            self.te_Landsat.setText('NBR= (band5-band7)/(band5+band7)')
            cols_num=2
            header1='band5'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)  
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NBR2':
            self.te_Landsat.setText('NBR2= (band6-band7)/(band6+band7)')
            cols_num=2
            header1='band6'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)               
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='BAI':
            self.te_Landsat.setText('BAI= 1/(((0.1-band4)^2)+((0.06-band5)^2))')
            cols_num=2
            header1='band4'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)           
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='DBI':
            self.te_Landsat.setText('DBI= ((band2-band10)/(band2+band10))-NDVI,  NDVI=(band5-band4)/(band5+band4)')
            cols_num=4
            header1='band2'
            header2='band10'
            header3='band5'
            header4='band4'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True)        
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NDBI':
            self.te_Landsat.setText('NDBI= (band6-band5)/(band6+band5)')
            cols_num=2
            header1='band6'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)         
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)              
            
        elif itemLandsat.text(0)=='CVI':
            self.te_Landsat.setText('CVI= (band5*band4)/(band3^2)')
            cols_num=3
            header1='band5'
            header2='band4'
            header3='band3'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)        
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='GCI':
            self.te_Landsat.setText('GCI= (band5/band3)-1')
            cols_num=2
            header1='band5'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='LAI':
            self.te_Landsat.setText('LAI= 3.16*EVI-0.118, with EVI=G*(band5-band4)/(band5+C1*band4-C2*band2+L), G= 2.5  C1=6  C2=7.5  L=1')
            cols_num=3
            header1='band5'
            header2='band4'
            header3='band2'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)           
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='Clipping_by_mask':
            self.te_Landsat.setText('Clip raster by mask layer')
            cols_num=2
            header1='Raster'
            header2='Mask Layer'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)                     
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='SIPI':
            self.te_Landsat.setText('SIPI= (band5-band2)/(band5-band4)')
            cols_num=3
            header1='band5'
            header2='band2'
            header3='band4'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='GRVI':
            self.te_Landsat.setText('GRVI= band5/band3')
            cols_num=2
            header1='band5'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)             
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='SLAVI':
            self.te_Landsat.setText('SLAVI= band5/(band4+band6)')
            cols_num=3
            header1='band5'
            header2='band4'
            header3='band6'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NPCI':
            self.te_Landsat.setText('NPCI= (band4-band2)/(band4+band2)')
            cols_num=2
            header1='band4'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='PSRI':
            self.te_Landsat.setText('PSRI= (band4-band2)/band5')
            cols_num=3
            header1='band4'
            header2='band2'
            header3='band5'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='GVMI':
            self.te_Landsat.setText('GVMI= ((band5+0.1)-(band6+0.02))/((band5+0.1)+(band6+0.02))')
            cols_num=2
            header1='band5'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NDSI-Snow':
            self.te_Landsat.setText('NDSI-Snow= (band3-band6)/(band3+band6)')
            cols_num=2
            header1='band3'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NHI':
            self.te_Landsat.setText('NHI= (band6-band3)/(band6+band3)')
            cols_num=2
            header1='band6'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='TSAVI':
            self.te_Landsat.setText('TSAVI= [a*(band5-a*band4-b)]/[band4+a*band5-a*b+X*(1+a2)], a:Soil line slope, b:Soil line intercept, X:Adjustment factor to minimize soil noise')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(True)
            self.label_parameter2Landsat.setVisible(True) 
            self.label_parameter3Landsat.setVisible(True) 
            self.label_parameter1Landsat.setText('a')
            self.label_parameter2Landsat.setText('b') 
            self.label_parameter3Landsat.setText('X')   
            self.le_parameter1Landsat.setVisible(True)
            self.le_parameter2Landsat.setVisible(True)
            self.le_parameter3Landsat.setVisible(True)
            
        elif itemLandsat.text(0)=='SR':
            self.te_Landsat.setText('SR= band5/band4')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='MSR':
            self.te_Landsat.setText('MSR= ((band5/band4)-1)/(sqrt((band5/band4)+1))')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='EVI2':
            self.te_Landsat.setText('EVI2= 2.5*[(band5-band4)/(band5+2.4*band4+1)]')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='AFRI1.6':
            self.te_Landsat.setText('AFRI1.6= (band5-0.66*band6)/(band5+0.66*band6)')
            cols_num=2
            header1='band5'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='AFRI2.1':
            self.te_Landsat.setText('AFRI2.1= (band5-0.5*band7)/(band5+ 0.5*band7)')
            cols_num=2
            header1='band5'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)             
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='TVI-Triangular':
            self.te_Landsat.setText('TVI-Triangular= 0.5*[120*(band5-band3)-200*(band4-band3)]')
            cols_num=3
            header1='band5'
            header2='band3'
            header3= 'band4'            
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)   
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='CMRI':
            self.te_Landsat.setText('CMRI= [((band5-band4)/(band5+band4))-((band3-band5)/(band3+band5))]')
            cols_num=3
            header1='band5'
            header2='band4'
            header3='band3'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NNIR':
            self.te_Landsat.setText('NNIR= band5/(band5+ band4+band3)')
            cols_num=3
            header1='band5'
            header2='band4'
            header3='band3'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='MNDWI':
            self.te_Landsat.setText('MNDWI= (band3–band6)/(band3+band6)')
            cols_num=2
            header1='band3'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='BU':
            self.te_Landsat.setText('BU= ((band6-band5)/(band6+band5))-((band5-band4)/(band5+band4))')
            cols_num=3
            header1='band6'
            header2='band5'
            header3='band4'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='EBBI':
            self.te_Landsat.setText('EBBI= (band7-band5)/10*[sqrt(band7+band6)]')
            cols_num=3
            header1='band7'
            header2='band5'
            header3='band6'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='UI':
            self.te_Landsat.setText('UI= (band7-band5)/(band7+band5)')
            cols_num=2
            header1='band7'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NDBal':
            self.te_Landsat.setText('NDBaI= (band6-band11)/(band6+band11)')
            cols_num=2
            header1='band6'
            header2='band11'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)         
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='DBSI':
            self.te_Landsat.setText('DBSI= [(band6-band3)/(band6+band3)]-NDVI, NDVI= (band5-band4)/(band5+band4)')
            cols_num=4
            header1='band6'
            header2='band3'
            header3='band5'
            header4='band4'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True)           
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='DNVI':
            self.te_Landsat.setText('DNVI= (band6-band7)^2/sqrt(band6+band7)')
            cols_num=2
            header1='band6'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='RGR':
            self.te_Landsat.setText('RGR= band4/band3')
            cols_num=2
            header1='band4'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='CSI':
            self.te_Landsat.setText('CSI= band5/band7')
            cols_num=2
            header1='band5'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='DSWI':
            self.te_Landsat.setText('DSWI= (band5+band3)/(band6+band4)')
            cols_num=4
            header1='band5'
            header2='band3'
            header3='band6'
            header4='band4' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True)           
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='AWEInsh':
            self.te_Landsat.setText('AWEInsh= 4*(band3+band6)-(0,25*band5+2,75*band7)')
            cols_num=4
            header1='band3'
            header2='band6'
            header3='band5'
            header4='band7'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True)           
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='CMR':
            self.te_Landsat.setText('CMR= band6/band7')
            cols_num=2
            header1='band6'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='FMR':
            self.te_Landsat.setText('FMR= band6/band5')
            cols_num=2
            header1='band6'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='IOR':
            self.te_Landsat.setText('IOR= band4/band2')
            cols_num=2
            header1='band4'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)    
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='BDI':
            self.te_Landsat.setText('BDI= band4-band6')
            cols_num=2
            header1='band4'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)              
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='CTVI':
            self.te_Landsat.setText('CTVI= ((NDVI+0.5)/(Abs(NDVI+0.5))*sqrt(Abs(NDVI+0.5)),  NDVI= (band5–band4)/(band5+band4)')
            cols_num=2
            header1='band5'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)   
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='IBI2':
            self.te_Landsat.setText('IBI2= 2*band6/(band6+band5)-[band5/(band5+band4)+band3/(band3+band6)]/2*band6/(band6+band5)+[band5/(band5+band4)+band3/(band3+band6)]')
            cols_num=4
            header1='band6'
            header2='band5'
            header3='band4'
            header4='band3'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NDSI-Salinity':
            self.te_Landsat.setText('NDSI-Salinity= (band4-band5)/(band4+band5)')
            cols_num=2
            header1='band4'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='SI':
            self.te_Landsat.setText('SI= sqrt(band3*band4)')
            cols_num=2
            header1='band3'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='NDISI':
            self.te_Landsat.setText('NDISI= (band10-((band3+band5+band6)/3))/(band10+((band3+band5+band6)/3))')
            cols_num=4
            header1='band10'
            header2='band3'
            header3='band5'
            header4='band6'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True)             
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='VrNIR-BI':
            self.te_Landsat.setText('VrNIR-BI= (band4-band5)/(band4+band5)')
            cols_num=2
            header1='band4'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
        elif itemLandsat.text(0)=='VgNIR-BI':
            self.te_Landsat.setText('VgNIR-BI= (band3-band5)/(band3+band5)')
            cols_num=2
            header1='band3'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1Landsat.setVisible(False)
            self.label_parameter2Landsat.setVisible(False) 
            self.label_parameter3Landsat.setVisible(False)  
            self.le_parameter1Landsat.setVisible(False)
            self.le_parameter2Landsat.setVisible(False)
            self.le_parameter3Landsat.setVisible(False)  
            
    def onItemClick_ASTER(self):
        itemASTER= self.treeWidgetASTER.currentItem()
        global itemVAR_ASTER
        itemVAR_ASTER=itemASTER.text(0)
        global mask_var
        mask_var=itemASTER.text(0)        
        global header1
        global header2
        global header3
        global header4
        global header5
        global cols_num
        global tb_bandfolder2_state
        global tb_bandfolder3_state
        global tb_bandfolder4_state        
        
        
        if itemASTER.text(0)=='NDVI':
            self.te_ASTER.setText('NDVI=(band3-band2)/(band3+band2)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)   
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False)      

        elif itemASTER.text(0)=='Scaling':
            self.te_ASTER.setText('Scale ASTER bands')
            cols_num=1
            header1='Band'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)
            self.label_parameter1ASTER.setText('Scale factor') 
            self.label_parameter2ASTER.setText('Offset') 
            self.label_parameter1ASTER.setVisible(True)
            self.label_parameter2ASTER.setVisible(True) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(True)
            self.le_parameter2ASTER.setVisible(True)
            self.le_parameter3ASTER.setVisible(False) 

        elif itemASTER.text(0)=='Cloud_masking':
            self.te_ASTER.setText('Cloud mask ASTER bands using QA band')
            cols_num=2
            header1='Band'
            header2='QA band'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)   
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False)              

        elif itemASTER.text(0)=='AI-based_outlier_detection':
            self.te_ASTER.setText('Detect outliers in Time series using Isolation forest')
            cols_num=1
            header1='Time series CSV'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False       
            self.le_minASTER.setEnabled(False) 
            self.le_minASTER.setReadOnly(True)
            self.le_maxASTER.setEnabled(False) 
            self.le_maxASTER.setReadOnly(True)            
            self.pushButton.setEnabled(True)  
            self.label_parameter1ASTER.setText('Contamination')              
            self.label_parameter1ASTER.setVisible(True)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(True)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False)  
            
        elif itemASTER.text(0)=='GNDVI':
            self.te_ASTER.setText('GNDVI=(band3-band1)/(band3+band1)')
            cols_num=2
            header1='band3'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)   
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False)             

        elif itemASTER.text(0)=='SAVI':
            self.te_ASTER.setText('SAVI=((1+L)*(band3-band2))/(band3+band2+L), L: Soil brightness correction factor')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)       
            self.label_parameter1ASTER.setVisible(True) 
            self.label_parameter1ASTER.setText('L') 
            self.le_parameter1ASTER.setVisible(True)                  
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='MSAVI':
            self.te_ASTER.setText('MSAVI=0.5*(2*band3+1-sqrt((2*band3+1)^2-8*(band3-band2)))')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)           
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='OSAVI':
            self.te_ASTER.setText('OSAVI=(band3-band2)/(band3+band2+0.16)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='GOSAVI':
            self.te_ASTER.setText('GOSAVI=(band3-band1)/(band3+band1+0.16)')
            cols_num=2
            header1='band3'
            header2='band1' 
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='GSAVI':
            self.te_ASTER.setText('GSAVI= (1+L)*(band3-band1)/(band3+band1+L), L:Soil adjustment factor')
            cols_num=2            
            header1='band3'
            header2='band1' 
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(True) 
            self.label_parameter1ASTER.setText('L') 
            self.le_parameter1ASTER.setVisible(True)            
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='GEMI':
            self.te_ASTER.setText('GEMI= eta*(1-0.25*eta)-((band2-0.125)/(1-band2)),  eta= (2(band3^2-band2^2)+1.5*band3+0.5*band2)/(band3+band2+0.5)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False)             

        elif itemASTER.text(0)=='DVI':
            self.te_ASTER.setText('DVI= band3-band2')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='GDVI':
            self.te_ASTER.setText('GDVI= band3-band1')
            cols_num=2
            header1='band3'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)  
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='TVI-Transformed':       
            self.te_ASTER.setText('TVI-Transformed= sqrt(0.5+NDVI), NDVI=(band3-band2)/(band3+band2)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='TTVI':       
            self.te_ASTER.setText('TTVI= sqrt(0.5+Abs(NDVI)), NDVI=(band3-band2)/(band3+band2)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)             
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='IPVI':       
            self.te_ASTER.setText('IPVI= band3/(band2+band3)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='RDVI':       
            self.te_ASTER.setText('RDVI=  (band3-band2)/sqrt(band3+band2)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='WDVI':       
            self.te_ASTER.setText('WDVI= band3-C*band2, C=(rs,nir)/(rs,red), (rs,nir):Near-infrared reflectance of the soil (rs,red):Red reflectance of the soil')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(True) 
            self.label_parameter1ASTER.setText('C') 
            self.le_parameter1ASTER.setVisible(True)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='NLI':
            self.te_ASTER.setText('NLI= ((band3^2)-band2)/((band3^2)+band2)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False)             

        elif itemASTER.text(0)=='NDGI':
            self.te_ASTER.setText('NDGI= (band1-band2)/(band1+band2)')
            cols_num=2
            header1='band1'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='RI':
            self.te_ASTER.setText('RI= (band2-band1)/(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='MSI':
            self.te_ASTER.setText('MSI= (band4/band3)')
            cols_num=2
            header1='band4'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='NDMI':
            self.te_ASTER.setText('NDMI= (band3-band4)/(band3+band4)')
            cols_num=2
            header1='band3'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)             
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='NDWI':
            self.te_ASTER.setText('NDWI= (band1-band3)/(band1+band3)')
            cols_num=2
            header1='band1'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='NBR':
            self.te_ASTER.setText('NBR= (band3-band5)/(band3+band5)')
            cols_num=2
            header1='band3'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='BAI':
            self.te_ASTER.setText('BAI= 1/(((0.1-band2)^2)+((0.06-band3)^2))')
            cols_num=2
            header1='band2'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)        
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='NDBI':
            self.te_ASTER.setText('NDBI= (band4-band3)/(band4+band3)')
            cols_num=2
            header1='band4'
            header2='band3'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='CVI':
            self.te_ASTER.setText('CVI= (band3*band2)/(band1^2)')
            cols_num=3
            header1='band3'
            header2='band2'
            header3='band1'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='GCI':
            self.te_ASTER.setText('GCI= (band3/band1)-1')
            cols_num=2
            header1='band3'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)        
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='Clipping_by_mask':
            self.te_ASTER.setText('Clip raster by mask layer')
            cols_num=2
            header1='Raster'
            header2='Mask Layer'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)                       
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='GRVI':
            self.te_ASTER.setText('GRVI= band3/band1')
            cols_num=2
            header1='band3'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='SLAVI':
            self.te_ASTER.setText('SLAVI= band3/(band2+band4)')
            cols_num=3
            header1='band3'
            header2='band2'
            header3='band4'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='GVMI':
            self.te_ASTER.setText('GVMI= ((band3+0.1)-(band4+0.02))/((band3+0.1)+(band4+0.02))')
            cols_num=2
            header1='band3'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='NDSI-Snow':
            self.te_ASTER.setText('NDSI-Snow= (band1-band4)/(band1+band4)')
            cols_num=2
            header1='band1'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='NHI':
            self.te_ASTER.setText('NHI= (band4-band1)/(band4+band1)')
            cols_num=2
            header1='band4'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)           
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='TSAVI':
            self.te_ASTER.setText('TSAVI= [a*(band3-a*band2-b)/[band2+a*band3-a*b+X*(1+a2)], a:Soil line slope, b:Soil line intercept, X:Adjustment factor to minimize soil noise')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)
            self.label_parameter1ASTER.setVisible(True)
            self.label_parameter2ASTER.setVisible(True) 
            self.label_parameter3ASTER.setVisible(True) 
            self.label_parameter1ASTER.setText('a')
            self.label_parameter2ASTER.setText('b') 
            self.label_parameter3ASTER.setText('X')   
            self.le_parameter1ASTER.setVisible(True)
            self.le_parameter2ASTER.setVisible(True)
            self.le_parameter3ASTER.setVisible(True)
            
        elif itemASTER.text(0)=='SR':
            self.te_ASTER.setText('SR= band3/band2')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='MSR':
            self.te_ASTER.setText('MSR= ((band3/band2)-1)/(sqrt((band3/band2)+1))')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)        
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='EVI2':
            self.te_ASTER.setText('EVI2= 2.5*[(band3-band2)/(band3+2.4*band2+1)]')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='AFRI1.6':
            self.te_ASTER.setText('AFRI1.6= (band3-0.66*band4)/(band3+0.66*band4)')
            cols_num=2
            header1='band3'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='AFRI2.1':
            self.te_ASTER.setText('AFRI 2.1= (band3-0.5*band5)/(band3+ 0.5*band5)')
            cols_num=2
            header1='band3'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='CI-G':
            self.te_ASTER.setText('CI-G= (band3/band1) – 1')
            cols_num=2
            header1='band3'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)   
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='TVI-Triangular':
            self.te_ASTER.setText('TVI-Triangular= 0.5*[120*(band3-band1)-200*(band2-band1)]')
            cols_num=3
            header1='band3'
            header2='band1'
            header3='band2'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='MTVI1':
            self.te_ASTER.setText('MTVI1= 1.2*[1.2*(band3-band1)-2.5*(band2-band1)]')
            cols_num=3
            header1='band3'
            header2='band1'
            header3='band2'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='MTVI2':
            self.te_ASTER.setText('MTVI2= 1.5*[1.2*(band3-band1)-2.5*(band2-band1)]/sqrt[(2*band3+1)*2-(6*band3-5*sqrt(band2)-0.5]')
            cols_num=3
            header1='band3'
            header2='band1'
            header3='band2'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)     
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False)             

        elif itemASTER.text(0)=='CMRI':
            self.te_ASTER.setText('CMRI= [((band3-band2)/(band3+band2))-((band1-band3)/(band1+band3))]')
            cols_num=3
            header1='band3'
            header2='band2'
            header3='band1'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='NNIR':
            self.te_ASTER.setText('NNIR= band3/(band3+band2+band1)')
            cols_num=3
            header1='band3'
            header2='band2'
            header3='band1'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)       
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='MNDWI':
            self.te_ASTER.setText('MNDWI= (band1-band4)/(band1+band4)')
            cols_num=2
            header1='band1'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='BU':
            self.te_ASTER.setText('BU= ((band4-band3)/(band4+band3))-((band3-band2)/(band3+band2))')
            cols_num=3
            header1='band3'
            header2='band2'
            header3='band1'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='RGR':
            self.te_ASTER.setText('RGR= band2/band1')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='CSI':
            self.te_ASTER.setText('CSI= band3/band5')
            cols_num=2
            header1='band3'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='CTVI':
            self.te_ASTER.setText('CTVI= ((NDVI+0.5)/(Abs(NDVI+0.5))*sqrt(Abs(NDVI+0.5)),  NDVI= (band3 – band2)/(band3+band2)')
            cols_num=2
            header1='band3'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
        elif itemASTER.text(0)=='IBI2':
            self.te_ASTER.setText('IBI2= 2*band4/(band4+band3)-[band3/(band3+band2)+band1/(band1+band4)]/2*band4/(band4+band3)+[band3/(band3+band2)+band1/(band1+band4)]')
            cols_num=4
            header1='band4'
            header2='band3'
            header3='band2'
            header4='band1'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True) 
            self.label_parameter1ASTER.setVisible(False)
            self.label_parameter2ASTER.setVisible(False) 
            self.label_parameter3ASTER.setVisible(False)  
            self.le_parameter1ASTER.setVisible(False)
            self.le_parameter2ASTER.setVisible(False)
            self.le_parameter3ASTER.setVisible(False) 
            
    def onItemClick_MODIS(self):
        itemMODIS= self.treeWidgetMODIS.currentItem()
        global itemVAR_MODIS
        itemVAR_MODIS=itemMODIS.text(0)
        global mask_var
        mask_var=itemMODIS.text(0)
        global header1
        global header2
        global header3
        global header4
        global header5
        global cols_num
        global tb_bandfolder2_state
        global tb_bandfolder3_state
        global tb_bandfolder4_state        
        
        if itemMODIS.text(0)=='NDVI':
            self.te_MODIS.setText('NDVI= (band2-band1)/(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 

        elif itemMODIS.text(0)=='Cloud_masking':
            self.te_MODIS.setText('Cloud mask MODIS bands using QA band')
            cols_num=2
            header1='Band'
            header2='QA Band'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False)
            
        elif itemMODIS.text(0)=='Scaling':
            self.te_MODIS.setText('Scale MODIS bands')
            cols_num=1
            header1='Band'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setText('Scale factor')
            self.label_parameter2MODIS.setText('Offset')
            self.label_parameter1MODIS.setVisible(True)
            self.label_parameter2MODIS.setVisible(True) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(True)
            self.le_parameter2MODIS.setVisible(True)
            self.le_parameter3MODIS.setVisible(False)            

        elif itemMODIS.text(0)=='AI-based_outlier_detection':
            self.te_MODIS.setText('Detect outliers in Time series using Isolation forest')
            cols_num=1
            header1='Time series CSV'
            header2= ' '
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=False  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False         
            self.le_minMODIS.setEnabled(False) 
            self.le_minMODIS.setReadOnly(True)
            self.le_maxMODIS.setEnabled(False) 
            self.le_maxMODIS.setReadOnly(True)            
            self.pushButton.setEnabled(True)     
            self.label_parameter1MODIS.setText('Contamination')              
            self.label_parameter1MODIS.setVisible(True)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(True)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False)  
            
        elif itemMODIS.text(0)=='GNDVI':
            self.te_MODIS.setText('GNDVI= (band2-band4)/(band2+band4)')
            cols_num=2
            header1='band2'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)           
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='EVI':
            self.te_MODIS.setText('EVI= G*(band2-band1)/(band2+C1*band1-C2*band3+L), G= 2.5  C1=6  C2=7.5  L=1')
            cols_num=3
            header1='band2'
            header2='band1'
            header3='band3'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='SAVI':
            self.te_MODIS.setText('SAVI= ((1+L)*(band2-band1))/(band2+band1+L), L:Soil brightness correction factor')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)    
            self.label_parameter1MODIS.setVisible(True) 
            self.label_parameter1MODIS.setText('L') 
            self.le_parameter1MODIS.setVisible(True)            
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='MSAVI':
            self.te_MODIS.setText('MSAVI= 0.5*(2*band2+1-sqrt((2*band2+1)^2-8*(band2-band1)))')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='OSAVI':
            self.te_MODIS.setText('OSAVI= (band2-band1)/(band2+band1+0.16)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='GEMI':
            self.te_MODIS.setText('GEMI= eta*(1-0.25*eta)-((band1-0.125)/(1-band1)),  eta= (2(band2^2-band1^2)+1.5*band2+0.5*band1)/(band2+band1+0.5)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='DVI':
            self.te_MODIS.setText('DVI= band2-band1')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='GLI':
            self.te_MODIS.setText('GLI= (2*band4-band1-band3)/(2*band4+band1+band3)')
            cols_num=3
            header1='band4'
            header2='band1'
            header3='band3' 
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='TVI-Transformed':       
            self.te_MODIS.setText('TVI-Transformed= sqrt(0.5+NDVI), NDVI= (band2-band1)/(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='TTVI':       
            self.te_MODIS.setText('TTVI= sqrt(0.5+Abs(NDVI)), NDVI=(band2-band1)/(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='RDVI':       
            self.te_MODIS.setText('RDVI= (band2-band1)/sqrt(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='WDVI':       
            self.te_MODIS.setText('WDVI= band2-C*band1, C=(rs,nir)/(rs,red), (rs,nir):Near-infrared reflectance of the soil (rs,red):Red reflectance of the soil')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(True) 
            self.label_parameter1MODIS.setText('C') 
            self.le_parameter1MODIS.setVisible(True)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='VARI':
            self.te_MODIS.setText('VARI= (band4-band1)/(band4+band1-band3)')
            cols_num=3
            header1='band4'
            header2='band1'
            header3='band3'  
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='ARVI':
            self.te_MODIS.setText('ARVI= (band2-band1-γ*(band1-band3))/(band2+band1-γ*(band1-band3)), γ:Atmospherci self-correcting factor')
            cols_num=3
            header1='band2'
            header2='band1'
            header3='band3'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(True) 
            self.label_parameter1MODIS.setText('γ') 
            self.le_parameter1MODIS.setVisible(True)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='SARVI':
            self.te_MODIS.setText('SARVI= (1+L)*(band2-band1-γ*(band1-band3))/(band2+band1-γ*(band1-band3)+L),  γ:Atmospherci self-correcting factor, L:Soil adjustment factor')
            cols_num=3
            header1='band2'
            header2='band1'
            header3='band3' 
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(True) 
            self.label_parameter1MODIS.setText('γ') 
            self.label_parameter2MODIS.setVisible(True) 
            self.label_parameter2MODIS.setText('L')            
            self.le_parameter1MODIS.setVisible(True)
            self.le_parameter2MODIS.setVisible(True)
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NDGI':
            self.te_MODIS.setText('NDGI= (band4-band1)/(band4+band1)')
            cols_num=2
            header1='band1'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='WDRVI':
            self.te_MODIS.setText('WDRVI= (a*band2-band1)/(a*band2+band1), a:Weighting coefficient with value of 0.1-0.2')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)    
            self.label_parameter1MODIS.setVisible(True)
            self.label_parameter1MODIS.setText('a') 
            self.le_parameter1MODIS.setVisible(True)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False)            
            
        elif itemMODIS.text(0)=='MSI':
            self.te_MODIS.setText('MSI= (band6/band2)')
            cols_num=2
            header1='band6'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='GARI':
            self.te_MODIS.setText('GARI= (band2-(band4-λ(band3-band1)))/(band2+(band4-λ(band3-band1))), λ:Parameter to control the atmospheric correction')
            cols_num=4
            header1='band2'
            header2='band4'
            header3='band3'
            header4='band1'           
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(True) 
            self.label_parameter1MODIS.setText('λ') 
            self.le_parameter1MODIS.setVisible(True)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NDMI':
            self.te_MODIS.setText('NDMI= (band2-band6)/(band2+band6)')
            cols_num=2
            header1='band2'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NDWI':
            self.te_MODIS.setText('NDWI= (band4-band2)/(band4+band2)')
            cols_num=2
            header1='band4'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)         
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NBR':
            self.te_MODIS.setText('NBR= (band2-band7)/(band2+band7)')
            cols_num=2
            header1='band2'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='BAI':
            self.te_MODIS.setText('BAI= 1/(((0.1-band1)^2)+((0.06-band2)^2))')
            cols_num=2
            header1='band1'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NDBI':
            self.te_MODIS.setText('NDBI= (band6-band2)/(band6+band2)')
            cols_num=2
            header1='band6'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)        
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='CVI':
            self.te_MODIS.setText('CVI= (band2*band1)/(band4^2)')
            cols_num=3
            header1='band2'
            header2='band1'
            header3='band4'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)           
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='GCI':
            self.te_MODIS.setText('GCI= (band2/band4)-1')
            cols_num=2
            header1='band2'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='LAI':
            self.te_MODIS.setText('LAI= 3.16*EVI-0.118, with EVI=G*(band2-band1)/(band2+C1*band1-C2*band3+L), G= 2.5  C1=6  C2=7.5  L=1')
            cols_num=3
            header1='band2'
            header2='band1'
            header3='band3'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)           
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='Clipping_by_mask':
            self.te_MODIS.setText('Clip raster by mask layer')
            cols_num=2
            header1='Raster'
            header2='Mask Layer'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)             
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='GRVI':
            self.te_MODIS.setText('GRVI= band1/band4')
            cols_num=2
            header1='band1'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='SLAVI':
            self.te_MODIS.setText('SLAVI= band2/(band1+band6)')
            cols_num=3
            header1='band2'
            header2='band1'
            header3='band6'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='PSRI':
            self.te_MODIS.setText('PSRI= (band1-band3)/band2')
            cols_num=3
            header1='band1'
            header2='band3'
            header3='band2'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='GVMI':
            self.te_MODIS.setText('GVMI= ((band2+0.1)-(band6+0.02))/((band2+0.1)+(band6+0.02))')
            cols_num=2
            header1='band2'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NDSI-Snow':
            self.te_MODIS.setText('NDSI-Snow= (band4-band6)/(band4+band6)')
            cols_num=2
            header1='band4'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)           
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='TSAVI':
            self.te_MODIS.setText('TSAVI= [a*(band2-a*band1-b)]/[band1+a*band2-a*b+X*(1+a2)], a:Soil line slope, b:Soil line intercept, X:Adjustment factor to minimize soil noise')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(True)
            self.label_parameter2MODIS.setVisible(True) 
            self.label_parameter3MODIS.setVisible(True) 
            self.label_parameter1MODIS.setText('a')
            self.label_parameter2MODIS.setText('b') 
            self.label_parameter3MODIS.setText('X')   
            self.le_parameter1MODIS.setVisible(True)
            self.le_parameter2MODIS.setVisible(True)
            self.le_parameter3MODIS.setVisible(True)

        elif itemMODIS.text(0)=='SR':
            self.te_MODIS.setText('SR= band2/band1')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False    
            self.pushButton.setEnabled(True)            
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='MSR':
            self.te_MODIS.setText('MSR= ((band2/band1)-1)/(sqrt((band2/band1)+1))')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)          
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='EVI2':
            self.te_MODIS.setText('EVI2= 2.5*[(band2-band1)/(band2+2.4*band1+1)]')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='AFRI1.6':
            self.te_MODIS.setText('AFRI1.6= (band2-0.66*band6)/(band2+0.66*band6)')
            cols_num=2
            header1='band2'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='AFRI2.1':
            self.te_MODIS.setText('AFRI2.1= (band2-0.5*band7)/(band2+ 0.5*band7)')
            cols_num=2
            header1='band2'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)              
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='CI-G':
            self.te_MODIS.setText('CI-G= (band2/band4) –1')
            cols_num=2
            header1='band2'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='CMRI':
            self.te_MODIS.setText('CMRI= [((band2-band1)/(band2+band1))-((band4-band2)/(band4+band2))]')
            cols_num=3
            header1='band2'
            header2='band1'
            header3='band4'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)            
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NNIR':
            self.te_MODIS.setText('NNIR= band2/(band2+band1+band4)')
            cols_num=3
            header1='band2'
            header2='band1'
            header3='band4'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)           
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='MNDWI':
            self.te_MODIS.setText('MNDWI= (band4-band6)/(band4+band6)')
            cols_num=2
            header1='band4'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)  
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NDII':
            self.te_MODIS.setText('NDII= (band2-band6)/(band2+band6)')
            cols_num=2
            header1='band2'
            header2='band6'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='Gratio':
            self.te_MODIS.setText('Gratio= band4/band1')
            cols_num=2
            header1='band4'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)              
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False)   
            
        elif itemMODIS.text(0)=='3BSI':
            self.te_MODIS.setText('3BSI= (band4-band7)/(band5+band7)')
            cols_num=3
            header1='band4'
            header2='band7'
            header3='band5'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NDPI':
            self.te_MODIS.setText('NDPI= (band2-(0.74*band1+0.26*band6))/(band2+(0.74*band1+0.26*band6))')
            cols_num=3
            header1='band2'
            header2='band1'
            header3='band6'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='BU':
            self.te_MODIS.setText('BU= ((band6-band2)/(band6+band2))-((band2-band1)/(band2+band1))')
            cols_num=3
            header1='band6'
            header2='band2'
            header3='band1'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)             
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='UI':
            self.te_MODIS.setText('UI= (band7-band2)/(band7+band2) ')
            cols_num=2
            header1='band7'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='DBSI':
            self.te_MODIS.setText('DBSI= [(band6-band4)/(band6+band4)]-NDVI, NDVI=(band2-band1)/(band2+band1)')
            cols_num=4
            header1='band6'
            header2='band4'
            header3='band2'
            header4='band1'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='DNVI':
            self.te_MODIS.setText('DNVI= (band6-band7)^2/sqrt(band6+band7)')
            cols_num=2
            header1='band6'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='RGR':
            self.te_MODIS.setText('RGR= band1/band4 ')
            cols_num=2
            header1='band1'
            header2='band4'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='CSI':
            self.te_MODIS.setText('CSI= band2/band7')
            cols_num=2
            header1='band2'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='SRWI':
            self.te_MODIS.setText('SRWI= band2/band5')
            cols_num=2
            header1='band2'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NMDI':
            self.te_MODIS.setText('NMDI= (band2-(band6-band7))/(band2+(band6-band7))')
            cols_num=3
            header1='band2'
            header2='band6'
            header3='band7'
            header4= ' ' 
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)              
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='SSM':
            self.te_MODIS.setText('SSM= band6/band7')
            cols_num=2
            header1='band6'
            header2='band7'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='DSWI':
            self.te_MODIS.setText('DSWI= (band2+band4)/(band6+band1)')
            cols_num=4
            header1='band2'
            header2='band4'
            header3='band6'
            header4='band1'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True)   
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='SIWSI':
            self.te_MODIS.setText('SIWSI= (band2-band5)/(band2+band5)')
            cols_num=2
            header1='band2'
            header2='band5'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='AWEInsh':
            self.te_MODIS.setText('AWEInsh= 4*(band4+band6)-(0,25*band2+2,75*band7)')
            cols_num=4
            header1='band4'
            header2='band6'
            header3='band2'
            header4='band7'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True)            
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='CTVI':
            self.te_MODIS.setText('CTVI= ((NDVI+0.5)/(Abs(NDVI+0.5))*sqrt(Abs(NDVI+0.5)),  NDVI= (band2–band1)/(band2+band1)')
            cols_num=2
            header1='band2'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='IBI2':
            self.te_MODIS.setText('IBI2= 2*band6/(band6+band2)-[band2/(band2+band1)+band4/(band4+band6)]/2*band6/(band6+band2)+[band2/(band2+band1)+band4/(band4+band6)]')
            cols_num=4
            header1='band6'
            header2='band2'
            header3='band1'
            header4='band4'
            tb_bandfolder2_state=True            
            tb_bandfolder3_state=True  
            tb_bandfolder4_state=True              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='NDSI-Salinity':
            self.te_MODIS.setText('NDSI-Salinity= (band1-band2)/(band1+band2)')
            cols_num=2
            header1='band1'
            header2='band2'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True)  
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 
            
        elif itemMODIS.text(0)=='SI':
            self.te_MODIS.setText('SI= sqrt(band4*band1)')
            cols_num=2
            header1='band4'
            header2='band1'
            header3= ' '
            header4= ' ' 
            tb_bandfolder2_state=True  
            tb_bandfolder3_state=False  
            tb_bandfolder4_state=False              
            self.pushButton.setEnabled(True) 
            self.label_parameter1MODIS.setVisible(False)
            self.label_parameter2MODIS.setVisible(False) 
            self.label_parameter3MODIS.setVisible(False)  
            self.le_parameter1MODIS.setVisible(False)
            self.le_parameter2MODIS.setVisible(False)
            self.le_parameter3MODIS.setVisible(False) 



    def calculate_AVHRR(self):
              
        #Computing        
        if itemVAR_AVHRR is not None and itemVAR_AVHRR=='NDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):               
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')   
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())
                
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)

                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum=((array1-array2)/(array1+array2))
                rassum = rassum.filled(np.nan)

           
                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
            
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)
            elif system == 'Darwin':
                sound_file=os.path.join(os.path.dirname(__file__),'beep.wav')
                subprocess.call(['afplay', sound_file])
             
            iface.messageBar().clearWidgets()

        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='Scaling':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(len(raster_list)):               
                fp=os.path.join(raster_list[i])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array1=array1.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                try:
                    scale = float(self.le_parameter1AVHRR.text())
                except ValueError:
                    scale = 1.0
                
                try:
                    offset = float(self.le_parameter2AVHRR.text())
                except ValueError:
                    offset = 0.0
                rassum= array1 * scale + offset    

                
           
                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
            
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)
            elif system == 'Darwin':
                sound_file=os.path.join(os.path.dirname(__file__),'beep.wav')
                subprocess.call(['afplay', sound_file])
             
            iface.messageBar().clearWidgets()


        elif itemVAR_AVHRR=='Cloud_masking':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):               
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                if array1.shape != array2.shape:
                    # Resample QA band to match array1 dimensions
                    temp_ds = gdal.GetDriverByName('MEM').Create('', rasterX.RasterXSize, rasterX.RasterYSize, 1, gdal.GDT_UInt16)
                    temp_ds.SetGeoTransform(rasterX.GetGeoTransform())
                    temp_ds.SetProjection(rasterX.GetProjection())
                    gdal.ReprojectImage(rasterX2, temp_ds, rasterX2.GetProjection(), rasterX.GetProjection(), gdal.GRA_NearestNeighbour)
                    array2 = temp_ds.ReadAsArray()
                    temp_ds = None  # clean up
                array1=array1.astype('float32')
                array2=array2.astype('uint16')    
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename = outfolder_LEtext+'/'+itemVAR_AVHRR+'_'+name
                #outputfilename_ch2 = outfolder_LEtext+'/'+itemVAR_AVHRR+'_CH2_'+name


                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                
                #driver=gdal.GetDriverByName("GTiff")
                #outds2=driver.Create(outputfilename_ch2, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                #outds2.SetGeoTransform(rasterX.GetGeoTransform())
                #outds2.SetProjection(rasterX.GetProjection())

                
                #array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)

                
                """array2[array2 == 0] = np.nan
                albedo = array1 / array2
                albedo_mask = (albedo >= 0.9) & (albedo <= 1.1)
                ch1_mask = array1 <= 0.44
                cloud_mask = albedo_mask & ch1_mask

                array1 = np.where(cloud_mask, array1, np.nan)
                array2 = np.where(cloud_mask, array2, np.nan)

                rassum = array1
                rassum2 = array2"""
                bits_0_2 = array2 & 0b111
                cloud_mask = np.isin(bits_0_2, [1, 2, 3])
                array1 = np.where(cloud_mask, np.nan, array1)
                rassum=array1
           
                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                out_band = outds.GetRasterBand(1)
                out_band.SetNoDataValue(-9999)
                out_band.WriteArray(rassum)
                
                #outds2.GetRasterBand(1).WriteArray(rassum2)
                outds = None
                #outds2 = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
            
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)
            elif system == 'Darwin':
                sound_file=os.path.join(os.path.dirname(__file__),'beep.wav')
                subprocess.call(['afplay', sound_file])
             
            iface.messageBar().clearWidgets()
            
            
        elif itemVAR_AVHRR=='AI-based_outlier_detection':

            # Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft | Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            wb = Workbook()
            ws = wb.active
            ws.title = "Outliers_detection"

            for i in range(10):
                time.sleep(1)
                progress.setValue(i + 1)

            for i in range(len(raster_list)):
                fp = os.path.join(raster_list[i])
                df = pd.read_csv(fp, delimiter=';', parse_dates=True)

                # Identify date column
                date_column = None
                for col in df.columns:
                    if pd.api.types.is_datetime64_any_dtype(df[col]) or pd.api.types.is_string_dtype(df[col]):
                        try:
                            df[col] = pd.to_datetime(df[col])
                            date_column = col
                            break
                        except (ValueError, TypeError):
                            continue
                
                # Identify EVI column
                evi_column = None
                numeric_columns = df.select_dtypes(include=['number']).columns
                if date_column:
                    numeric_columns = numeric_columns.drop(date_column, errors='ignore')
                if len(numeric_columns) > 0:
                    evi_column = numeric_columns[0]
                
                if date_column is None or evi_column is None:
                    QgsMessageLog.logMessage(f"Could not identify date or Biophysical index column in {fp}", level=Qgis.Warning)
                    continue
                
                # Model fitting and outlier detection
                if self.le_parameter1AVHRR.text():
                    Contparameter1=float(self.le_parameter1AVHRR.text()) 
                    model = IsolationForest(contamination=Contparameter1)
                    model.fit(df[[evi_column]])
                    df['outliers'] = pd.Series(model.predict(df[[evi_column]])).apply(lambda x: 'yes' if (x == -1) else 'no')
                else:
                    model = IsolationForest(contamination=0.01)
                    model.fit(df[[evi_column]])
                    df['outliers'] = pd.Series(model.predict(df[[evi_column]])).apply(lambda x: 'yes' if (x == -1) else 'no')
                    
                # Plotting results
                plt.figure(figsize=(10, 6))
                plt.plot(df[date_column].values, df[evi_column].values, label='Biophysical index')

                # Highlight outliers
                outliers = df[df['outliers'] == 'yes']
                plt.scatter(outliers[date_column].values, outliers[evi_column].values, color='red', label='Outliers')

                plt.xlabel('Date')
                plt.ylabel('Biophysical index')
                plt.title('Outliers detection')
                plt.legend()
                plt.grid(True)

                # Save the plot as an image
                img_path = os.path.join(tempfile.gettempdir(), f"plot_{i}.png")
                plt.savefig(img_path)
                plt.close()

                # Create a dialog to display the plot
                dialog = QDialog()
                dialog.setWindowTitle("Outliers detection")
                layout = QVBoxLayout()
                label = QLabel()
                label.setPixmap(QPixmap(img_path))
                # Button to save the image
                save_image_button = QPushButton("Save as image")
                save_image_button.clicked.connect(lambda: self.save_image(img_path))  # Connect to save_image method
                layout.addWidget(save_image_button, alignment=Qt.AlignBottom | Qt.AlignRight)
                layout.addWidget(label)
                dialog.setLayout(layout)
                
                dialog.exec_()
                                
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)
                elif system == 'Darwin':
                    sound_file=os.path.join(os.path.dirname(__file__),'beep.wav')
                    subprocess.call(['afplay', sound_file])    

                # Insert data into Excel with correct date format
                for row in df.itertuples():
                    ws.append(row[1:])
                
                
                # Highlight outliers as points
                outliers = df[df['outliers'] == 'yes']
                for j, outlier in outliers.iterrows():
                    outlier_xvalue = outlier[date_column]
                    outlier_yvalue = outlier[evi_column]

                # Log completion
                QgsMessageLog.logMessage(f"Processed {fp} and detected outliers.", level=Qgis.Info)

            # Save the Excel workbook
            excel_path = os.path.join(outfolder_LEtext, 'Outliers_detection.xlsx')
            wb.save(excel_path)

            # Show a message box with the path to the saved Excel file
            QMessageBox.information(None, "Process completed", f"Results saved to {excel_path}")

            iface.messageBar().clearWidgets()
            iface.messageBar().pushMessage("Process completed.", level=Qgis.Success)
    
            iface.messageBar().clearWidgets()  
            
        elif itemVAR_AVHRR=='Composite':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            print(raster_list)
            for i in range(0,len(raster_list)):
            
                fp=os.path.join(raster_list[i])         
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array1=array1.astype('float32')
                                        
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                rassum= (array1-0.1)
 
                outds.WriteArray(rassum)
                outds = None
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)          
            iface.messageBar().clearWidgets()             
                
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='SAVI':   
            if self.le_parameter1AVHRR.text():
                SAVIparameter1=float(self.le_parameter1AVHRR.text())   
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                
                for i in range(0,len(raster_list)-1,2):                
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')                         
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                    name_str=''

                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                         
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                     
                    array2=np.ma.masked_where(array1+array2+SAVIparameter1 ==0, array2)   
                    array2=np.ma.masked_where(((1+SAVIparameter1)*(array1-array2))/(array1+array2+SAVIparameter1) ==0, array2)
                    array1=np.ma.masked_where(((1+SAVIparameter1)*(array1-array2))/(array1+array2+SAVIparameter1) ==0, array1)                   
                    rassum=((1+SAVIparameter1)*(array1-array2))/(array1+array2+SAVIparameter1)
                    rassum = rassum.filled(np.nan)

                    if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                        min_value= float(self.le_minAVHRR.text())
                        max_value=float(self.le_maxAVHRR.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                        min_value= float(self.le_minAVHRR.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                        max_value= float(self.le_maxAVHRR.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan)
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)
                        
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()                  
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')
           
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='MSAVI':      
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
        
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())
            
                      
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array2=np.ma.masked_where((((2*array1+1)*(2*array1+1))-8*(array1-array2)) <0, array2)
                array2=np.ma.masked_where(0.5*(2*array1+1-np.sqrt(((2*array1+1)*(2*array1+1))-8*(array1-array2))) ==0, array2)                               
                rassum=0.5*(2*array1+1-np.sqrt(((2*array1+1)*(2*array1+1))-8*(array1-array2)))
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()               
            
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='OSAVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

           
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)     
                array2=np.ma.masked_where(array1+array2+0.16 ==0, array2)
                array2=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array2)
                array1=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array1)                
                rassum= (array1-array2)/(array1+array2+0.16)
                rassum = rassum.filled(np.nan)
                
                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                   

        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='GEMI':   
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
        
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array1=np.ma.masked_where(array1+array2+0.5 ==0, array1)
                array2=np.ma.masked_where(1-array2 ==0, array2)
                array2=np.ma.masked_where((((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5))*(1-0.25*(((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5)))-((array2-0.125)/(1-array2))  ==0.125, array2)                                              
                rassum=(((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5))*(1-0.25*(((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5)))-((array2-0.125)/(1-array2))             
                rassum = rassum.filled(np.nan)
                
                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='DVI':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                
                #array2[array2==0]=np.nan               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                      
                array2=np.ma.masked_where((array1-array2) ==0, array2)
                array1=np.ma.masked_where((array1-array2) ==0, array1)                   
                rassum= array1-array2
                rassum=rassum.filled(np.nan)
           
                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()   

        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='TVI-Transformed':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array1=np.ma.masked_where((0.5+((array1-array2)/(array1+array2)))<0, array1)
                rassum= np.sqrt(0.5+((array1-array2)/(array1+array2)))               
                
                rassum = rassum.filled(np.nan)
           
                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 
                    
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='TTVI':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array1=np.ma.masked_where((0.5+((array1-array2)/(array1+array2)))<0, array1)
                rassum= np.sqrt(0.5+ np.absolute((array1-array2)/(array1+array2)))
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)           
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                    

        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='RDVI':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                
                array2=np.ma.masked_where((array1+array2) ==0, array2)
                rassum= ((array1-array2)/np.sqrt(array1+array2))
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)           
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)            

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='WDVI':
            if self.le_parameter1AVHRR.text():
                WDVIparameter1=float(self.le_parameter1AVHRR.text())
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    
                
                for i in range(0,len(raster_list)-1,2):            
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                    name_str=''
           
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())
                                   
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                    array2=np.ma.masked_where((array1-WDVIparameter1*array2) ==0, array2)                                
                    rassum= (array1-WDVIparameter1*array2)
                    rassum=rassum.filled(np.nan)
                 
                    if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                        min_value= float(self.le_minAVHRR.text())
                        max_value=float(self.le_maxAVHRR.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                        min_value= float(self.le_minAVHRR.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                        max_value= float(self.le_maxAVHRR.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan)
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)
                    
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                  
                  
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='NLI':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                
                array2=np.ma.masked_where((array1*array1)+array2 ==0, array2)      
                rassum=((array1*array1)-array2)/((array1*array1)+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)           
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
            
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()
                
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='MSI':     
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
        
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())
    
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()          
            
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='NDMI':    
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                    
                        
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='BAI':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                               
                array2=np.ma.masked_where((((0.1-array1)*(0.1-array1))+((0.06-array2)*(0.06-array2))) ==0, array2)
                array1=np.ma.masked_where(((0.1-array1)*(0.1-array1)) ==0.01, array2)  
                array2=np.ma.masked_where(((0.06-array2)*(0.06-array2)) ==0.0036, array2)                                  
                rassum= 1/(((0.1-array1)*(0.1-array1))+((0.06-array2)*(0.06-array2)))
                rassum=rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()              

        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='NDBI':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                   
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 
               
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='EVI2':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where((array1+2.4*array2+1) ==0, array2)
                array2=np.ma.masked_where((2.5*((array1-array2)/(array1+2.4*array2+1))) ==0, array2)
                array1=np.ma.masked_where((2.5*((array1-array2)/(array1+2.4*array2+1))) ==0, array1)                
                rassum= 2.5*((array1-array2)/(array1+2.4*array2+1))
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)          
            iface.messageBar().clearWidgets()

        elif itemVAR_AVHRR=='Clipping_by_mask':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)              
    
            for i in range(0,len(raster_list)-1,2):
                gdal.UseExceptions()
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])             
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+'Clipped'+'-'+name
                name_str=''
                
                result=gdal.Warp(outputfilename, fp, cutlineDSName=fp2, cropToCutline=True, dstNodata = np.nan)
                
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)          
            iface.messageBar().clearWidgets()  

        elif itemVAR_AVHRR=='SR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)                                
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)          
            iface.messageBar().clearWidgets()          

        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='BU':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())



                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)

                
                array1=np.ma.masked_where(array1+array2 ==0, array1)
                array2=np.ma.masked_where(array2+array3 ==0, array2)
                rassum= ((array1-array2)/(array1+array2))-((array2-array3)/(array2+array3))
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()            
            
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='CTVI':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):               
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum=(((array1-array2)/(array1+array2))+0.5)/(np.absolute(((array1-array2)/(array1+array2))+0.5)* np.sqrt(np.absolute(((array1-array2)/(array1+array2))+0.5)))
                rassum=np.ma.masked_where(rassum<0, rassum)
                rassum=np.ma.masked_where(rassum>1.3, rassum)
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)           
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
            
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()
                
        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='TSAVI':
            if self.le_parameter1AVHRR.text() and self.le_parameter2AVHRR.text() and self.le_parameter3AVHRR.text():
                TSAVIparameter1=float(self.le_parameter1AVHRR.text())
                TSAVIparameter2=float(self.le_parameter2AVHRR.text())
                TSAVIparameter3=float(self.le_parameter3AVHRR.text())
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    
                
                for i in range(0,len(raster_list)-1,2):            
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                    name_str=''
                                 
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())
                                   
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                       
                    array2=np.ma.masked_where((TSAVIparameter1*array1+array2-TSAVIparameter1*TSAVIparameter2+TSAVIparameter3*(1+TSAVIparameter1*TSAVIparameter1)) ==0, array2)
                    rassum= (TSAVIparameter1*(array1-TSAVIparameter1*array2-TSAVIparameter2))/(TSAVIparameter1*array1+array2-TSAVIparameter1*TSAVIparameter2+TSAVIparameter3*(1+TSAVIparameter1*TSAVIparameter1))
                    rassum = rassum.filled(np.nan)
                 
                    if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                        min_value= float(self.le_minAVHRR.text())
                        max_value=float(self.le_maxAVHRR.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                        min_value= float(self.le_minAVHRR.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                        max_value= float(self.le_maxAVHRR.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan)
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                

        elif itemVAR_AVHRR is not None and itemVAR_AVHRR=='MSR':
                            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_AVHRR+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array2=np.ma.masked_where(array2 ==0, array2)                
                array2=np.ma.masked_where(np.sqrt((array1/array2)+1) ==0, array2)
                array1=np.ma.masked_where(((array1/array2)+1) <0, array1)
                rassum= ((array1/array2)-1)/(np.sqrt((array1/array2)+1))
                rassum = rassum.filled(np.nan)

                if self.le_minAVHRR.text() and self.le_maxAVHRR.text():
                    min_value= float(self.le_minAVHRR.text())
                    max_value=float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text() and self.le_maxAVHRR.text()=='':
                    min_value= float(self.le_minAVHRR.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minAVHRR.text()=='' and self.le_maxAVHRR.text():
                    max_value= float(self.le_maxAVHRR.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()    
            
                                
        if state=='True':    
            mean_file=outfolder_LEtext+'/statistics-mean.txt'
            std_file=outfolder_LEtext+'/statistics-standard deviation.txt'
            var_file=outfolder_LEtext+'/statistics-variance.txt'
            max_file=outfolder_LEtext+'/statistics-maximum.txt'
            min_file=outfolder_LEtext+'/statistics-minimum.txt'
            open_mean_file=open(mean_file, "w")
            open_std_file=open(std_file, "w")
            open_var_file=open(var_file, "w")
            open_max_file=open(max_file, "w")
            open_min_file=open(min_file, "w")
            open_mean_file.write("mean:")
            for element in mean_list:
                open_mean_file.write(str(element)+",  ")           
            open_std_file.write("std:")
            for element in std_list:
                open_std_file.write(str(element)+",  ")
            open_var_file.write("var:")
            for element in var_list:
                open_var_file.write(str(element)+",  ")                
            open_max_file.write("max:")
            for element in max_list:
                open_max_file.write(str(element)+",  ")                    
            open_min_file.write("min:")
            for element in min_list:
                open_min_file.write(str(element)+",  ")  
               
            # Csv file   
            x_axis=list(range(1,len(mean_list)+1))
            x_axis.insert(0,'X')   
            Csv=outfolder_LEtext+'/Statistics.csv'
            outfile = open(Csv,'w')
            out = csv.writer(outfile)
            mean_list.insert(0,'Mean')
            std_list.insert(0,'Standard deviation')
            var_list.insert(0,'Variance')
            min_list.insert(0,'Minimum')
            max_list.insert(0,'Maximum')
            out.writerows(zip(x_axis, mean_list, std_list, var_list, min_list, max_list))
            outfile.close()
            
            # Csv to Excel file
            Excel=outfolder_LEtext+'/Statistics.xlsx'
            Excel_outfile=open(Excel, 'w')
            read_csvfile=pd.read_csv(Csv)
            read_csvfile.to_excel(Excel, index=False)
            
            # Insert a chart in Excel file
            wb=openpyxl.load_workbook(Excel)
            ws=wb.active
            values=Reference(ws, min_col=2, min_row=1, max_col=6, max_row=len(mean_list))
            x_values=Reference(ws,range_string='Sheet1!A2:A200')
            chart=LineChart()
            chart.add_data(values, titles_from_data= True)
            chart.set_categories(x_values)
            chart.title='Statistics'
            chart.x_axis.title='Time'
            chart.y_axis.title=' '
            chart.legend.positon='b'
            ws.add_chart(chart, 'H1')
            wb.save(Excel)
                
        iface.messageBar().pushMessage('Calculation completed', level=Qgis.Success)                
        self.close()
        reloadPlugin('remote_sensing_toolkit')             
                      
    def calculate_Sentinel(self):
              
        #Computing        
        if itemVAR_Sentinel=='NDVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage('Executing...')
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
                
            for i in range(0,len(raster_list)-1,2):            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                         
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                              
                   
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)                
                rassum = rassum.filled(np.nan)
 
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                    
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            
            progressMessageBar = iface.messageBar().createMessage("Done...")                
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()

        elif itemVAR_Sentinel=='Scaling':
            #Progress
            progressMessageBar = iface.messageBar().createMessage('Executing...')
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
                
            for i in range(len(raster_list)):               
                fp=os.path.join(raster_list[i])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array1=array1.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                try:
                    scale = float(self.le_parameter1Sentinel.text())
                except ValueError:
                    scale = 1.0
                
                try:
                    offset = float(self.le_parameter2Sentinel.text())
                except ValueError:
                    offset = 0.0
                rassum= array1 * scale + offset    
 
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                    
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            
            progressMessageBar = iface.messageBar().createMessage("Done...")                
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()


        elif itemVAR_Sentinel=='Cloud_masking':
            #Progress
            progressMessageBar = iface.messageBar().createMessage('Executing...')
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
                
            for i in range(0,len(raster_list)-1,2):            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                if array1.shape != array2.shape:
                    # Resample QA band to match array1 dimensions
                    temp_ds = gdal.GetDriverByName('MEM').Create('', rasterX.RasterXSize, rasterX.RasterYSize, 1, gdal.GDT_UInt16)
                    temp_ds.SetGeoTransform(rasterX.GetGeoTransform())
                    temp_ds.SetProjection(rasterX.GetProjection())
                    gdal.ReprojectImage(rasterX2, temp_ds, rasterX2.GetProjection(), rasterX.GetProjection(), gdal.GRA_NearestNeighbour)
                    array2 = temp_ds.ReadAsArray()
                    temp_ds = None  # clean up
                array1=array1.astype('float32')
                array2=array2.astype('uint16') 
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                   

                invalid_classes = [3, 8, 9, 10]
                cloud_mask = ~np.isin(array2, invalid_classes)
                array1 = np.where(cloud_mask, array1, np.nan)

                rassum = array1
 
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                    
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            
            progressMessageBar = iface.messageBar().createMessage("Done...")                
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()
            
                   
        elif itemVAR_Sentinel=='AI-based_outlier_detection':
            # Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft | Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            wb = Workbook()
            ws = wb.active
            ws.title = "Outliers_detection"

            for i in range(10):
                time.sleep(1)
                progress.setValue(i + 1)

            for i in range(len(raster_list)):
                fp = os.path.join(raster_list[i])
                df = pd.read_csv(fp, delimiter=';', parse_dates=True)

                # Identify date column
                date_column = None
                for col in df.columns:
                    if pd.api.types.is_datetime64_any_dtype(df[col]) or pd.api.types.is_string_dtype(df[col]):
                        try:
                            df[col] = pd.to_datetime(df[col])
                            date_column = col
                            break
                        except (ValueError, TypeError):
                            continue
                
                # Identify EVI column
                evi_column = None
                numeric_columns = df.select_dtypes(include=['number']).columns
                if date_column:
                    numeric_columns = numeric_columns.drop(date_column, errors='ignore')
                if len(numeric_columns) > 0:
                    evi_column = numeric_columns[0]
                
                if date_column is None or evi_column is None:
                    QgsMessageLog.logMessage(f"Could not identify date or Biophysical index column in {fp}", level=Qgis.Warning)
                    continue

                # Model fitting and outlier detection
                if self.le_parameter1Sentinel.text():
                    Contparameter1=float(self.le_parameter1Sentinel.text()) 
                    model = IsolationForest(contamination=Contparameter1)
                    model.fit(df[[evi_column]])
                    df['outliers'] = pd.Series(model.predict(df[[evi_column]])).apply(lambda x: 'yes' if (x == -1) else 'no')
                else:
                    model = IsolationForest(contamination=0.01)
                    model.fit(df[[evi_column]])
                    df['outliers'] = pd.Series(model.predict(df[[evi_column]])).apply(lambda x: 'yes' if (x == -1) else 'no')

                # Plotting results
                plt.figure(figsize=(10, 6))
                plt.plot(df[date_column].values, df[evi_column].values, label='Biophysical index')

                # Highlight outliers
                outliers = df[df['outliers'] == 'yes']
                plt.scatter(outliers[date_column].values, outliers[evi_column].values, color='red', label='Outliers')

                plt.xlabel('Date')
                plt.ylabel('Biophysical index')
                plt.title('Outliers detection')
                plt.legend()
                plt.grid(True)

                # Save the plot as an image
                img_path = os.path.join(tempfile.gettempdir(), f"plot_{i}.png")
                plt.savefig(img_path)
                plt.close()

                # Create a dialog to display the plot
                dialog = QDialog()
                dialog.setWindowTitle("Outliers detection")
                layout = QVBoxLayout()
                label = QLabel()
                label.setPixmap(QPixmap(img_path))
                # Button to save the image
                save_image_button = QPushButton("Save as image")
                save_image_button.clicked.connect(lambda: self.save_image(img_path))  # Connect to save_image method
                layout.addWidget(save_image_button, alignment=Qt.AlignBottom | Qt.AlignRight)
                layout.addWidget(label)
                dialog.setLayout(layout)
                
                dialog.exec_()
                                
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)
                elif system == 'Darwin':
                    sound_file=os.path.join(os.path.dirname(__file__),'beep.wav')
                    subprocess.call(['afplay', sound_file])    

                # Insert data into Excel with correct date format
                for row in df.itertuples():
                    ws.append(row[1:])
                
                
                # Highlight outliers as points
                outliers = df[df['outliers'] == 'yes']
                for j, outlier in outliers.iterrows():
                    outlier_xvalue = outlier[date_column]
                    outlier_yvalue = outlier[evi_column]

                # Log completion
                QgsMessageLog.logMessage(f"Processed {fp} and detected outliers.", level=Qgis.Info)

            # Save the Excel workbook
            excel_path = os.path.join(outfolder_LEtext, 'Outliers_detection.xlsx')
            wb.save(excel_path)

            # Show a message box with the path to the saved Excel file
            QMessageBox.information(None, "Process completed", f"Results saved to {excel_path}")

            iface.messageBar().clearWidgets()
            iface.messageBar().pushMessage("Process completed.", level=Qgis.Success)
    
            iface.messageBar().clearWidgets()  
            
        elif itemVAR_Sentinel=='GNDVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
                
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                        
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)               
                rassum = rassum.filled(np.nan)
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                
 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='EVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)

                array2=np.ma.masked_where(array1+ 6*array2-7.5*array3+1 ==0, array2)  
                array2=np.ma.masked_where((2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1)) == 0, array2)  
                array1=np.ma.masked_where((2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1)) == 0, array1)
                array3=np.ma.masked_where((2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1)) == 0, array3)                
                rassum= (2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1))               
                rassum = rassum.filled(np.nan)
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                
 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                 
            
        elif itemVAR_Sentinel=='SAVI':
            if self.le_parameter1Sentinel.text():
                SAVIparameter1=float(self.le_parameter1Sentinel.text()) 
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    
                for i in range(0,len(raster_list)-1,2):
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')                         
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                    
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                    name_str=''
                    
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                     
                    array2=np.ma.masked_where(array1+array2+SAVIparameter1 ==0, array2)   
                    array2=np.ma.masked_where(((1+SAVIparameter1)*(array1-array2))/(array1+array2+SAVIparameter1) ==0, array2)
                    array1=np.ma.masked_where(((1+SAVIparameter1)*(array1-array2))/(array1+array2+SAVIparameter1) ==0, array1)                   
                    rassum=((1+SAVIparameter1)*(array1-array2))/(array1+array2+SAVIparameter1)
                    rassum = rassum.filled(np.nan)

                    if self.le_minSentinel.text() and self.le_maxSentinel.text():
                        min_value= float(self.le_minSentinel.text())
                        max_value=float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                        min_value= float(self.le_minSentinel.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                        max_value= float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan)                
     
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)
                        
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()       
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                
            
        elif itemVAR_Sentinel=='MSAVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where((((2*array1+1)*(2*array1+1))-8*(array1-array2)) <0, array2)
                array2=np.ma.masked_where((0.5*(2*array1+1-np.sqrt(((2*array1+1)*(2*array1+1))-8*(array1-array2)))) == 0, array2) 
                array1=np.ma.masked_where((0.5*(2*array1+1-np.sqrt(((2*array1+1)*(2*array1+1))-8*(array1-array2)))) == 0, array1)                 
                rassum=0.5*(2*array1+1-np.sqrt(((2*array1+1)*(2*array1+1))-8*(array1-array2)))
                rassum = rassum.filled(np.nan)
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                

        elif itemVAR_Sentinel=='OSAVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2+0.16 ==0, array2)
                array2=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array2)
                array1=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array1)                
                rassum= (array1-array2)/(array1+array2+0.16)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()               

        elif itemVAR_Sentinel=='GOSAVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array2=np.ma.masked_where(array1+array2+0.16 ==0, array2)
                array2=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array2)
                array1=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array1)                
                rassum= (array1-array2)/(array1+array2+0.16)
                rassum = rassum.filled(np.nan)                

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='GSAVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            if self.le_parameter1Sentinel.text():
                GSAVIparameter1=float(self.le_parameter1Sentinel.text())     
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    
                for i in range(0,len(raster_list)-1,2):
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')                         
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                    
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                    name_str=''
                             
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                    array2=np.ma.masked_where(array1+array2+0.5==0, array2) 
                    array2=np.ma.masked_where(((1+GSAVIparameter1)*(array1-array2))/(array1+array2+GSAVIparameter1) == 0, array2)
                    array1=np.ma.masked_where(((1+GSAVIparameter1)*(array1-array2))/(array1+array2+GSAVIparameter1) == 0, array1)                            
                    rassum=((1+GSAVIparameter1)*(array1-array2))/(array1+array2+GSAVIparameter1)
                    rassum = rassum.filled(np.nan)

                    if self.le_minSentinel.text() and self.le_maxSentinel.text():
                        min_value= float(self.le_minSentinel.text())
                        max_value=float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                        min_value= float(self.le_minSentinel.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                        max_value= float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')    

        elif itemVAR_Sentinel=='MCARI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= ((array1-array2)-0.2*(array1-array3))*(array1/array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='GEMI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array1=np.ma.masked_where(array1+array2+0.5 ==0, array1)
                array2=np.ma.masked_where(1-array2 ==0, array2)
                array2=np.ma.masked_where((((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5))*(1-0.25*(((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5)))-((array2-0.125)/(1-array2))  ==0.125, array2)                                              
                rassum=(((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5))*(1-0.25*(((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5)))-((array2-0.125)/(1-array2))             
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='DVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                

                array2=np.ma.masked_where((array1-array2) ==0, array2)
                array1=np.ma.masked_where((array1-array2) ==0, array1)                   
                rassum= array1-array2
                rassum=rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                    
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 
            
        elif itemVAR_Sentinel=='REDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                

                array2=np.ma.masked_where((array1-array2) ==0, array2)
                array1=np.ma.masked_where((array1-array2) ==0, array1)                   
                rassum= array1-array2
                rassum=rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                    
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()             

        elif itemVAR_Sentinel=='GARI':
            if self.le_parameter1Sentinel.text():
                GARIparameter1=float(self.le_parameter1Sentinel.text())
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    
                
                for i in range(0,len(raster_list)-1,4):          
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])
                    fp3=os.path.join(raster_list[i+2])
                    fp4=os.path.join(raster_list[i+3])
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                    rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array3=rasterX3.ReadAsArray()
                    array4=rasterX4.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    array3=array3.astype('float32')
                    array4=array4.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                    name_str=''
                                   
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                    array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                    array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)                

                    array2=np.ma.masked_where((array1+(array2-GARIparameter1*(array3-array4)))==0, array2)
                    array1=np.ma.masked_where((array1+(array2-GARIparameter1*(array3-array4)))==0, array1)
                    rassum= (array1-(array2-GARIparameter1*(array3-array4)))/(array1+(array2-GARIparameter1*(array3-array4)))               
                    rassum = rassum.filled(np.nan)
                 
                    if self.le_minSentinel.text() and self.le_maxSentinel.text():
                        min_value= float(self.le_minSentinel.text())
                        max_value=float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                        min_value= float(self.le_minSentinel.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                        max_value= float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan)                 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                
                  
        elif itemVAR_Sentinel=='GDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where((array1-array2) ==0, array2)
                array1=np.ma.masked_where((array1-array2) ==0, array1)                   
                rassum= array1-array2
                rassum=rassum.filled(np.nan)
 
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                    
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='NDRE':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)              
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)                
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                

                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='CCCI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array1=np.ma.masked_where(array1+array2+0.5==0, array1)
                array2=np.ma.masked_where(array1-array3==0, array2)                      
                rassum= ((array1-array2)/(array1+array2))/((array1-array3)/(array1+array3))
                rassum=np.ma.masked_where(rassum<0, rassum)
                rassum=np.ma.masked_where(rassum>1, rassum)                
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='GLI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
         
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(2*array1+array2+array3 ==0, array2)
                rassum= (2*array1-array2-array3)/(2*array1+array2+array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='TVI-Transformed':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array2=np.ma.masked_where(0.5+((array1-array2)/(array1+array2)) <0, array2)
                rassum= np.sqrt(0.5+((array1-array2)/(array1+array2)))
                rassum = rassum.filled(np.nan)
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)            
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 
                    
        elif itemVAR_Sentinel=='TTVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array2=np.ma.masked_where(0.5+((array1-array2)/(array1+array2)) <0, array2)
                rassum= np.sqrt(0.5+np.absolute((array1-array2)/(array1+array2)))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)            
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                     

        elif itemVAR_Sentinel=='IPVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum=  array1/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='RDVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array2=np.ma.masked_where(array1+array2 <0, array2)
                rassum= ((array1-array2)/np.sqrt(array1+array2))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='WDVI':
            if self.le_parameter1Sentinel.text():
                WDVIparameter1=float(self.le_parameter1Sentinel.text())
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)    
                    
                for i in range(0,len(raster_list)-1,2):            
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                    name_str=''
                    
             
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())
                                   
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                    array2=np.ma.masked_where((array1-WDVIparameter1*array2) ==0, array2)                                
                    rassum= (array1-WDVIparameter1*array2)
                    rassum=rassum.filled(np.nan)
                 
                    if self.le_minSentinel.text() and self.le_maxSentinel.text():
                        min_value= float(self.le_minSentinel.text())
                        max_value=float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                        min_value= float(self.le_minSentinel.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                        max_value= float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan)                 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                
                                    
        elif itemVAR_Sentinel=='VARI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2+array3 ==0, array2)    
                rassum= (array1-array2)/(array1+array2+array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='ARVI':
            if self.le_parameter1Sentinel.text():
                ARVIparameter1=float(self.le_parameter1Sentinel.text())
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    
                for i in range(0,len(raster_list)-1,3):
                
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])
                    fp3=os.path.join(raster_list[i+2])
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array3=rasterX3.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    array3=array3.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                    name_str=''
                 
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

      
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                    array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                    array2=np.ma.masked_where(array1+array2-(ARVIparameter1*(array2-array3))==0, array2)    
                    rassum= (array1-array2-(ARVIparameter1*(array2-array3)))/(array1+array2-(ARVIparameter1*(array2-array3)))              
                    
                    rassum = rassum.filled(np.nan)

                    if self.le_minSentinel.text() and self.le_maxSentinel.text():
                        min_value= float(self.le_minSentinel.text())
                        max_value=float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                        min_value= float(self.le_minSentinel.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                        max_value= float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')    

        elif itemVAR_Sentinel=='SARVI':
            if self.le_parameter1Sentinel.text() and self.le_parameter2Sentinel.text():
                SARVIparameter1=float(self.le_parameter1Sentinel.text())
                SARVIparameter2=float(self.le_parameter2Sentinel.text())
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    
                for i in range(0,len(raster_list)-1,3):
                
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])
                    fp3=os.path.join(raster_list[i+2])
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array3=rasterX3.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    array3=array3.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                    name_str=''
        
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

      
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                    array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                    array2=np.ma.masked_where(array1+array2-(SARVIparameter1*(array2-array3))+SARVIparameter2 ==0, array2)
                    array2=np.ma.masked_where(((1+SARVIparameter2)*(array1-array2-(SARVIparameter1*(array2-array3)))/(array1+array2-(SARVIparameter1*(array2-array3)+SARVIparameter2))) == 0, array2)
                    array1=np.ma.masked_where(((1+SARVIparameter2)*(array1-array2-(SARVIparameter1*(array2-array3)))/(array1+array2-(SARVIparameter1*(array2-array3)+SARVIparameter2))) == 0, array1)                
                    
                    rassum= (1+SARVIparameter2)*(array1-array2-(SARVIparameter1*(array2-array3)))/(array1+array2-(SARVIparameter1*(array2-array3))+SARVIparameter2)
                    rassum = rassum.filled(np.nan)

                    if self.le_minSentinel.text() and self.le_maxSentinel.text():
                        min_value= float(self.le_minSentinel.text())
                        max_value=float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                        min_value= float(self.le_minSentinel.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                        max_value= float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                    

        elif itemVAR_Sentinel=='NLI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                          
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array2=np.ma.masked_where((array1*array1)+array2 ==0, array2)
                rassum=((array1*array1)-array2)/((array1*array1)+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)            
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='MNLI':
            if self.le_parameter1Sentinel.text():
                MNLIparameter1=float(self.le_parameter1Sentinel.text())        
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)    
                    
                for i in range(0,len(raster_list)-1,2):            
                    
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')                         
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                    name_str=''
                                 
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                    array2=np.ma.masked_where((array1*array1)+array2+MNLIparameter1 == 0, array2)                
                    array2=np.ma.masked_where(((1+MNLIparameter1)*((array1*array1)-array2)/((array1*array1)+array2+MNLIparameter1)) == 0, array2)
                    array1=np.ma.masked_where(((1+MNLIparameter1)*((array1*array1)-array2)/((array1*array1)+array2+MNLIparameter1)) == 0, array1)                
                    rassum=(1+MNLIparameter1)*((array1*array1)-array2)/((array1*array1)+array2+MNLIparameter1)
                    rassum = rassum.filled(np.nan)

                    if self.le_minSentinel.text() and self.le_maxSentinel.text():
                        min_value= float(self.le_minSentinel.text())
                        max_value=float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                        min_value= float(self.le_minSentinel.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                        max_value= float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan)            
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)
                        
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                 

        elif itemVAR_Sentinel=='NDGI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):        
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                         
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum=((array1-array2)/(array1+array2))                 
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)            
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='TDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):        
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array2=np.ma.masked_where((array1*array1)+array2+0.5 ==0, array2)
                array2=np.ma.masked_where((array1*array1)+array2+0.5 <0, array2)
                array2=np.ma.masked_where((1.5*(array1-array2)/np.sqrt((array1*array1)+array2+0.5)) == 0, array2)
                array1=np.ma.masked_where((1.5*(array1-array2)/np.sqrt((array1*array1)+array2+0.5)) == 0, array1)                
                rassum=1.5*(array1-array2)/np.sqrt((array1*array1)+array2+0.5)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)            
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='WDRVI':
            if self.le_parameter1Sentinel.text():
                WDRVIparameter1=float(self.le_parameter1Sentinel.text())     
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)    
                    
                for i in range(0,len(raster_list)-1,2):        
                    
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')                         
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                    name_str=''
                    
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                    array2=np.ma.masked_where((WDRVIparameter1*array1)+array2 ==0, array2)
                    rassum=(((WDRVIparameter1*array1)-array2)/((WDRVIparameter1*array1)+array2))
                    rassum = rassum.filled(np.nan)

                    if self.le_minSentinel.text() and self.le_maxSentinel.text():
                        min_value= float(self.le_minSentinel.text())
                        max_value=float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                        min_value= float(self.le_minSentinel.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                        max_value= float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan)            
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)
                        
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                 
                

        elif itemVAR_Sentinel=='ENDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2+2*array3 ==0, array2)
                rassum= ((array1+array2)-(2*array3))/(array1+array2+2*array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 
                
        elif itemVAR_Sentinel=='MSI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()               

        elif itemVAR_Sentinel=='NDMI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
 
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                 
            
        elif itemVAR_Sentinel=='NDWI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                 
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                
           
        elif itemVAR_Sentinel=='NBR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
        
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                 
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()    
                    
        elif itemVAR_Sentinel=='NBR2':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                 
                array2=np.ma.masked_where(array1+array2 ==0, array2)             
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                       
                        
        elif itemVAR_Sentinel=='BAI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                 
                array2=np.ma.masked_where((((0.1-array1)*(0.1-array1))+((0.06-array2)*(0.06-array2))) ==0, array2)
                array1=np.ma.masked_where(((0.1-array1)*(0.1-array1)) ==0.01, array2)  
                array2=np.ma.masked_where(((0.06-array2)*(0.06-array2)) ==0.0036, array2)                                  
                rassum= 1/(((0.1-array1)*(0.1-array1))+((0.06-array2)*(0.06-array2)))
                rassum=rassum.filled(np.nan)


                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                

        elif itemVAR_Sentinel=='NDBI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                 
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()               
            
        elif itemVAR_Sentinel=='CVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array3*array3 ==0, array2)
                rassum= (array1*array2)/(array3*array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                
            
        elif itemVAR_Sentinel=='GCI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
        
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)-1
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                 

        elif itemVAR_Sentinel=='LAI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where((array1+ 6*array2-7.5*array3+1) ==0, array2)
                rassum= 3.16*(2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1))-0.118
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                

        elif itemVAR_Sentinel=='Clipping_by_mask':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
                gdal.UseExceptions()
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])             
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+'Clipped'+'-'+name
                name_str=''
                result=gdal.Warp(outputfilename, fp, cutlineDSName=fp2, cropToCutline=True, dstNodata = np.nan)
            
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)          
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='SIPI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array1-array3 ==0, array2)
                rassum= (array1-array2)/(array1-array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='GRVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= array1/array2
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='SLAVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array2+array3 ==0, array2)
                rassum= array1/(array2+array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()   

        elif itemVAR_Sentinel=='NPCI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)
 
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='PSRI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array3=np.ma.masked_where(array3 ==0, array3)
                rassum= (array1-array2)/(array3)
                               
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='GVMI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(((array1+0.1)+(array2+0.02)) ==0, array2)
                array1=np.ma.masked_where(((array1+0.1)+(array2+0.02)) ==0, array1)  
                array2=np.ma.masked_where(((array1+0.1)-(array2+0.02)) ==0, array2)
                array1=np.ma.masked_where(((array1+0.1)-(array2+0.02)) ==0, array1)
                array2=np.ma.masked_where(((array1+0.1)-(array2+0.02)) ==0.08, array2)
                array1=np.ma.masked_where(((array1+0.1)-(array2+0.02)) ==0.08, array1)   
                array2=np.ma.masked_where(((array1+0.1)+(array2+0.02)) ==0.12, array2)
                array1=np.ma.masked_where(((array1+0.1)+(array2+0.02)) ==0.12, array1)                
                rassum= ((array1+0.1)-(array2+0.02))/((array1+0.1)+(array2+0.02))                              
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='NDSI-Snow':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='NHI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 
                
        elif itemVAR_Sentinel=='TSAVI':
            if self.le_parameter1Sentinel.text() and self.le_parameter2Sentinel.text() and self.le_parameter3Sentinel.text():
                TSAVIparameter1=float(self.le_parameter1Sentinel.text())
                TSAVIparameter2=float(self.le_parameter2Sentinel.text())
                TSAVIparameter3=float(self.le_parameter3Sentinel.text())
                #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)    
                
                for i in range(0,len(raster_list)-1,2):
            
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                    name_str=''
                                  
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())
                                   
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                       
                    array2=np.ma.masked_where((TSAVIparameter1*array1+array2-TSAVIparameter1*TSAVIparameter2+TSAVIparameter3*(1+TSAVIparameter1*TSAVIparameter1)) ==0, array2)
                    rassum= (TSAVIparameter1*(array1-TSAVIparameter1*array2-TSAVIparameter2))/(TSAVIparameter1*array1+array2-TSAVIparameter1*TSAVIparameter2+TSAVIparameter3*(1+TSAVIparameter1*TSAVIparameter1))
                    rassum = rassum.filled(np.nan)
                 
                    if self.le_minSentinel.text() and self.le_maxSentinel.text():
                        min_value= float(self.le_minSentinel.text())
                        max_value=float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                        min_value= float(self.le_minSentinel.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                        max_value= float(self.le_maxSentinel.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)
                    
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                
                
        elif itemVAR_Sentinel=='SR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)                                
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 
            
        elif itemVAR_Sentinel=='RERVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)                                
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()             

        elif itemVAR_Sentinel=='MSR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
          
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)  
                array2=np.ma.masked_where(array2 ==0, array2)                
                array2=np.ma.masked_where(np.sqrt((array1/array2)+1) ==0, array2)
                array1=np.ma.masked_where(((array1/array2)+1) <0, array1)
                rassum= ((array1/array2)-1)/(np.sqrt((array1/array2)+1))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()               

        elif itemVAR_Sentinel=='EVI2':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where((array1+2.4*array2+1) ==0, array2)
                array2=np.ma.masked_where((2.5*((array1-array2)/(array1+2.4*array2+1))) ==0, array2)
                array1=np.ma.masked_where((2.5*((array1-array2)/(array1+2.4*array2+1))) ==0, array1)                
                rassum= 2.5*((array1-array2)/(array1+2.4*array2+1))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='AFRI1.6':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+0.66*array2 ==0, array2)
                rassum= (array1-0.66*array2)/(array1+0.66*array2)
                rassum = rassum.filled(np.nan)
                rassum = np.ma.masked_array(rassum, ~np.isfinite(rassum)).filled(np.nan) 

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='AFRI2.1':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+0.5*array2 ==0, array2)
                rassum= (array1-0.5*array2)/(array1+0.5*array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='ARI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                array1=np.ma.masked_where(array1 ==0, array1)
                rassum= (1/array1)-(1/array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='CI-RE':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)-1
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='CI-G':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)-1
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  
 
        elif itemVAR_Sentinel=='TVI-Triangular':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan) 
                array2=np.ma.masked_where((0.5*(120*(array1-array2)-200*(array3-array2))) == 0, array2)
                array1=np.ma.masked_where((0.5*(120*(array1-array2)-200*(array3-array2))) == 0, array1) 
                array3=np.ma.masked_where((0.5*(120*(array1-array2)-200*(array3-array2))) == 0, array3)               
                rassum= 0.5*(120*(array1-array2)-200*(array3-array2))
                rassum=rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='MTVI1':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                                   
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)    
                array2=np.ma.masked_where((1.2*(1.2*(array1-array2)-2.5*(array3-array2)))==0, array2)
                array1=np.ma.masked_where((1.2*(1.2*(array1-array2)-2.5*(array3-array2)))==0, array1) 
                array3=np.ma.masked_where((1.2*(1.2*(array1-array2)-2.5*(array3-array2)))==0, array3)                
                rassum= 1.2*(1.2*(array1-array2)-2.5*(array3-array2))
                rassum= rassum.filled(np.nan)
 
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='MTVI2':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(np.sqrt(((2*array1+1)*(2*array1+1))-(6*array1-5*np.sqrt(array3))-0.5) ==0, array2)
                array1=np.ma.masked_where((((2*array1+1)*(2*array1+1))-(6*array1-5*np.sqrt(array3))-0.5) <0, array1)
                array3=np.ma.masked_where(array3 <0, array3)
                array2=np.ma.masked_where((1.5*(1.2*(array1-array2)-2.5*(array3-array2))/np.sqrt(((2*array1+1)*(2*array1+1))-(6*array1-5*np.sqrt(array3))-0.5)) ==0, array2)
                array1=np.ma.masked_where((1.5*(1.2*(array1-array2)-2.5*(array3-array2))/np.sqrt(((2*array1+1)*(2*array1+1))-(6*array1-5*np.sqrt(array3))-0.5)) ==0, array1) 
                array3=np.ma.masked_where((1.5*(1.2*(array1-array2)-2.5*(array3-array2))/np.sqrt(((2*array1+1)*(2*array1+1))-(6*array1-5*np.sqrt(array3))-0.5)) ==0, array3)                               
                rassum= 1.5*(1.2*(array1-array2)-2.5*(array3-array2))/np.sqrt(((2*array1+1)*(2*array1+1))-(6*array1-5*np.sqrt(array3))-0.5)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                  

        elif itemVAR_Sentinel=='CMRI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array1=np.ma.masked_where(array3+array1 ==0, array1)
                rassum= ((array1-array2)/(array1+array2))-((array3-array1)/(array3+array1))
                rassum = rassum.filled(np.nan)
 
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='NNIR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2+array3 ==0, array2)        
                rassum= array1/(array1+array2+array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='RR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,4):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                fp4=os.path.join(raster_list[i+3])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array4=rasterX4.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                array4=array4.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)
              
                array2=np.ma.masked_where(array2 ==0, array2)
                array4=np.ma.masked_where(array4 ==0, array4)
                rassum= (array1/array2)*(array3/array2)*(array1/array4)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='GR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
          
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='VIRE':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array2*array2 ==0, array2)
                rassum= (10000-array1)/(array2*array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='VIRRE':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= array1/array2
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Sentinel=='SVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)
 
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()      

        elif itemVAR_Sentinel=='MNDWI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='BU':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                 
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array3=np.ma.masked_where(array2+array3 ==0, array3)                
                rassum= ((array1-array2)/(array1+array2))-((array2-array3)/(array2+array3))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='UI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2 ==0, array2)      
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='DBSI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,4):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                fp4=os.path.join(raster_list[i+3])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array4=rasterX4.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                array4=array4.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                 
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array4= array4/10000 
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array3=np.ma.masked_where(array3+array4 ==0, array3)
                rassum= ((array1-array2)/(array1+array2))-((array3-array4)/(array3+array4))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='DNVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
              
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array1=np.ma.masked_where(array1+array2 < 0, array1)
                rassum= ((array1-array2)*(array1-array2))/np.sqrt(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                      

        elif itemVAR_Sentinel=='RGR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
               
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= array1/array2
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()   
                    
        elif itemVAR_Sentinel=='CSI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)                
                rassum= array1/array2
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                     
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()     
 
        elif itemVAR_Sentinel=='RENDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                       

        elif itemVAR_Sentinel=='DSWI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,4):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                fp4=os.path.join(raster_list[i+3])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array4=rasterX4.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                array4=array4.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                                 
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)                
                array3=np.ma.masked_where(array3+array4 ==0, array3)
                rassum= ((array1+array2)/(array3+array4))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                   
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()   

        elif itemVAR_Sentinel=='AWEInsh':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,4):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                fp4=os.path.join(raster_list[i+3])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array4=rasterX4.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                array4=array4.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)                   
                VAR1= 4*(array1+array2)
                VAR2= (0.25*array3+ 2.75*array4)
                VAR1=np.ma.masked_where(4*(array1+array2) ==0, VAR1)  
                VAR2=np.ma.masked_where((0.25*array3+ 2.75*array4) ==0, VAR2) 
                VAR1 = VAR1.filled(np.nan)
                VAR2 = VAR2.filled(np.nan)                
                rassum= VAR1-VAR2
                


                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                   
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='CMR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= array1/array2
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 

                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                      

        elif itemVAR_Sentinel=='FMR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= array1/array2
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()    

        elif itemVAR_Sentinel=='IOR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= array1/array2
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                        

        elif itemVAR_Sentinel=='CTVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):               
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array1=np.ma.masked_where(array1+array2 ==0, array1)
                array2=np.ma.masked_where(1.5*array1- 0.5*array2 ==0, array2)
                rassum=(((array1-array2)/(array1+array2))+0.5)/(np.absolute(((array1-array2)/(array1+array2))+0.5)* np.sqrt(np.absolute(((array1-array2)/(array1+array2))+0.5)))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                     

        elif itemVAR_Sentinel=='IBI2':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,4):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                fp4=os.path.join(raster_list[i+3])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array4=rasterX4.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                array4=array4.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)                
                array1=np.ma.masked_where(array1+array2 ==0, array1)
                array2=np.ma.masked_where(array2+array3 ==0, array2)
                array4=np.ma.masked_where(array4+array1 ==0, array4)
                array3=np.ma.masked_where(((2*array1/(array1+array2))+((array2/(array2+array3))+(array4/(array4+array1)))) ==0, array3)
                rassum= ((2*array1/(array1+array2))-((array2/(array2+array3))+(array4/(array4+array1))))/((2*array1/(array1+array2))+((array2/(array2+array3))+(array4/(array4+array1))))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)                 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='NDSI-Salinity':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):               
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
             
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)              
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()   
                    
        elif itemVAR_Sentinel=='SI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)

            for i in range(0,len(raster_list)-1,2):               
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)   
                array2=np.ma.masked_where(array1+array2 <0, array2)                
                array2=np.ma.masked_where((np.sqrt(array1*array2))==0, array2)
                array1=np.ma.masked_where((np.sqrt(array1*array2))==0, array1)                  
                rassum= np.sqrt(array1*array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='NDI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):               
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                 
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)
 
                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan)
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                      

        elif itemVAR_Sentinel=='TBI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array2=np.ma.masked_where(array2-array3 ==0, array2)
                rassum= (array1-array2)/(array2-array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='Datt1':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array1=np.ma.masked_where(array1-array3 ==0, array1)
                rassum= (array1-array2)/(array1-array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  
                    
        elif itemVAR_Sentinel=='Datt4':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
          
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array1=np.ma.masked_where(array1*array3 ==0, array1)
                rassum= (array1)/(array2*array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='Datt6':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array1=np.ma.masked_where(array2*array3 ==0, array1)
                rassum= (array1)/(array2*array3)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  
                    
        elif itemVAR_Sentinel=='CRSI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,4):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                fp4=os.path.join(raster_list[i+3])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array4=rasterX4.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                array4=array4.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
                  
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)      
                array2=np.ma.masked_where((array1*array2)+(array3*array4) ==0, array2)                
                array2=np.ma.masked_where(((array1*array2)-(array3*array4))/((array1*array2)+(array3*array4)) <0, array2)
                rassum= np.sqrt(((array1*array2)-(array3*array4))/((array1*array2)+(array3*array4)))
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='BLB1':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,4):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                fp4=os.path.join(raster_list[i+3])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array4=rasterX4.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                array4=array4.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)                
                array3=np.ma.masked_where(array3+array4 ==0, array3)
                rassum= (array1+array2)/(array3+array4)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Sentinel=='BLB2':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):               
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
          
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
               
                array2=np.ma.masked_where(array2 ==0, array2)      
                rassum= (array1/array2)
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()   

        elif itemVAR_Sentinel=='CLSI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Sentinel+'-'+name
                name_str=''
 
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

  
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= ((array1-array2)/(array1+array2))+array3
                rassum = rassum.filled(np.nan)

                if self.le_minSentinel.text() and self.le_maxSentinel.text():
                    min_value= float(self.le_minSentinel.text())
                    max_value=float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text() and self.le_maxSentinel.text()=='':
                    min_value= float(self.le_minSentinel.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minSentinel.text()=='' and self.le_maxSentinel.text():
                    max_value= float(self.le_maxSentinel.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  
                     
        if state=='True':    
            mean_file=outfolder_LEtext+'/statistics-mean.txt'
            std_file=outfolder_LEtext+'/statistics-standard deviation.txt'
            var_file=outfolder_LEtext+'/statistics-variance.txt'
            max_file=outfolder_LEtext+'/statistics-maximum.txt'
            min_file=outfolder_LEtext+'/statistics-minimum.txt'
            open_mean_file=open(mean_file, "w")
            open_std_file=open(std_file, "w")
            open_var_file=open(var_file, "w")
            open_max_file=open(max_file, "w")
            open_min_file=open(min_file, "w")
            open_mean_file.write("mean:")
            for element in mean_list:
                open_mean_file.write(str(element)+",  ")           
            open_std_file.write("std:")
            for element in std_list:
                open_std_file.write(str(element)+",  ")
            open_var_file.write("var:")
            for element in var_list:
                open_var_file.write(str(element)+",  ")                
            open_max_file.write("max:")
            for element in max_list:
                open_max_file.write(str(element)+",  ")                    
            open_min_file.write("min:")
            for element in min_list:
                open_min_file.write(str(element)+",  ")  
                
                
            # Csv file   
            x_axis=list(range(1,len(mean_list)+1))
            x_axis.insert(0,'X')   
            Csv=outfolder_LEtext+'/Statistics.csv'
            outfile = open(Csv,'w')
            out = csv.writer(outfile)
            mean_list.insert(0,'Mean')
            std_list.insert(0,'Standard deviation')
            var_list.insert(0,'Variance')
            min_list.insert(0,'Minimum')
            max_list.insert(0,'Maximum')
            out.writerows(zip(x_axis, mean_list, std_list, var_list, min_list, max_list))
            outfile.close()
            
            # Csv to Excel file
            Excel=outfolder_LEtext+'/Statistics.xlsx'
            Excel_outfile=open(Excel, 'w')
            read_csvfile=pd.read_csv(Csv)
            read_csvfile.to_excel(Excel, index=False)
            
            # Insert a chart in Excel file
            wb=openpyxl.load_workbook(Excel)
            ws=wb.active
            values=Reference(ws, min_col=2, min_row=1, max_col=6, max_row=len(mean_list))
            x_values=Reference(ws,range_string='Sheet1!A2:A200')
            chart=LineChart()
            chart.add_data(values, titles_from_data= True)
            chart.set_categories(x_values)
            chart.title='Statistics'
            chart.x_axis.title='Time'
            chart.y_axis.title=' '
            chart.legend.positon='b'
            ws.add_chart(chart, 'H1')
            wb.save(Excel)
                
        iface.messageBar().pushMessage('Calculation completed', level=Qgis.Success)
        self.close()
        reloadPlugin('remote_sensing_toolkit')   
                            
    def calculate_Landsat(self):    
              
        #Computing 
        if itemVAR_Landsat=='NDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):        
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
            
                array2=np.ma.masked_where(array1+array2 ==0, array2)      
                rassum=((array1-array2)/(array1+array2))                
                rassum = rassum.filled(np.nan)

                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()        

        elif itemVAR_Landsat=='Scaling':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(len(raster_list)):               
                fp=os.path.join(raster_list[i])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array1=array1.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                try:
                    scale = float(self.le_parameter1Landsat.text())
                except ValueError:
                    scale = 1.0
                
                try:
                    offset = float(self.le_parameter2Landsat.text())
                except ValueError:
                    offset = 0.0
                rassum= array1 * scale + offset    

                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()      

        elif itemVAR_Landsat=='Cloud_masking':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):        
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                if array1.shape != array2.shape:
                    # Resample QA band to match array1 dimensions
                    temp_ds = gdal.GetDriverByName('MEM').Create('', rasterX.RasterXSize, rasterX.RasterYSize, 1, gdal.GDT_UInt16)
                    temp_ds.SetGeoTransform(rasterX.GetGeoTransform())
                    temp_ds.SetProjection(rasterX.GetProjection())
                    gdal.ReprojectImage(rasterX2, temp_ds, rasterX2.GetProjection(), rasterX.GetProjection(), gdal.GRA_NearestNeighbour)
                    array2 = temp_ds.ReadAsArray()
                    temp_ds = None  # clean up
                array1=array1.astype('float32')
                array2=array2.astype('uint16')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)

                invalid_classes = [21826, 21890, 22080, 22144, 22280,23888,23952,24088,24216,24344,24472,54596,54852,55052]
                cloud_mask = ~np.isin(array2, invalid_classes)

                array1 = np.where(cloud_mask, array1, np.nan)
      
                rassum=array1               

                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

            
        elif itemVAR_Landsat=='AI-based_outlier_detection':
            # Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft | Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            wb = Workbook()
            ws = wb.active
            ws.title = "Outliers_detection"

            for i in range(10):
                time.sleep(1)
                progress.setValue(i + 1)

            for i in range(len(raster_list)):
                fp = os.path.join(raster_list[i])
                df = pd.read_csv(fp, delimiter=';', parse_dates=True)

                # Identify date column
                date_column = None
                for col in df.columns:
                    if pd.api.types.is_datetime64_any_dtype(df[col]) or pd.api.types.is_string_dtype(df[col]):
                        try:
                            df[col] = pd.to_datetime(df[col])
                            date_column = col
                            break
                        except (ValueError, TypeError):
                            continue
                
                # Identify EVI column
                evi_column = None
                numeric_columns = df.select_dtypes(include=['number']).columns
                if date_column:
                    numeric_columns = numeric_columns.drop(date_column, errors='ignore')
                if len(numeric_columns) > 0:
                    evi_column = numeric_columns[0]
                
                if date_column is None or evi_column is None:
                    QgsMessageLog.logMessage(f"Could not identify date or Biophysical index column in {fp}", level=Qgis.Warning)
                    continue

                # Model fitting and outlier detection
                if self.le_parameter1Landsat.text():
                    Contparameter1=float(self.le_parameter1Landsat.text()) 
                    model = IsolationForest(contamination=Contparameter1)
                    model.fit(df[[evi_column]])
                    df['outliers'] = pd.Series(model.predict(df[[evi_column]])).apply(lambda x: 'yes' if (x == -1) else 'no')
                else:
                    model = IsolationForest(contamination=0.01)
                    model.fit(df[[evi_column]])
                    df['outliers'] = pd.Series(model.predict(df[[evi_column]])).apply(lambda x: 'yes' if (x == -1) else 'no')

                # Plotting results
                plt.figure(figsize=(10, 6))
                plt.plot(df[date_column].values, df[evi_column].values, label='Biophysical index')

                # Highlight outliers
                outliers = df[df['outliers'] == 'yes']
                plt.scatter(outliers[date_column].values, outliers[evi_column].values, color='red', label='Outliers')

                plt.xlabel('Date')
                plt.ylabel('Biophysical index')
                plt.title('Outliers detection')
                plt.legend()
                plt.grid(True)

                # Save the plot as an image
                img_path = os.path.join(tempfile.gettempdir(), f"plot_{i}.png")
                plt.savefig(img_path)
                plt.close()

                # Create a dialog to display the plot
                dialog = QDialog()
                dialog.setWindowTitle("Outliers detection")
                layout = QVBoxLayout()
                label = QLabel()
                label.setPixmap(QPixmap(img_path))
                # Button to save the image
                save_image_button = QPushButton("Save as image")
                save_image_button.clicked.connect(lambda: self.save_image(img_path))  # Connect to save_image method
                layout.addWidget(save_image_button, alignment=Qt.AlignBottom | Qt.AlignRight)
                layout.addWidget(label)
                dialog.setLayout(layout)
                
                dialog.exec_()
                                
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)
                elif system == 'Darwin':
                    sound_file=os.path.join(os.path.dirname(__file__),'beep.wav')
                    subprocess.call(['afplay', sound_file])    

                # Insert data into Excel with correct date format
                for row in df.itertuples():
                    ws.append(row[1:])
                
                
                # Highlight outliers as points
                outliers = df[df['outliers'] == 'yes']
                for j, outlier in outliers.iterrows():
                    outlier_xvalue = outlier[date_column]
                    outlier_yvalue = outlier[evi_column]

                # Log completion
                QgsMessageLog.logMessage(f"Processed {fp} and detected outliers.", level=Qgis.Info)

            # Save the Excel workbook
            excel_path = os.path.join(outfolder_LEtext, 'Outliers_detection.xlsx')
            wb.save(excel_path)

            # Show a message box with the path to the saved Excel file
            QMessageBox.information(None, "Process completed", f"Results saved to {excel_path}")

            iface.messageBar().clearWidgets()
            iface.messageBar().pushMessage("Process completed.", level=Qgis.Success)
    
            iface.messageBar().clearWidgets()  
            
        elif itemVAR_Landsat=='GNDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
          
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
               
                rassum = rassum.filled(np.nan)

                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                
    
        elif itemVAR_Landsat=='EVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                 
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array1+ 6*array2-7.5*array3+1 ==0, array2)  
                array2=np.ma.masked_where((2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1)) == 0, array2)  
                array1=np.ma.masked_where((2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1)) == 0, array1)
                array3=np.ma.masked_where((2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1)) == 0, array3)                
                rassum= (2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1))               
                rassum = rassum.filled(np.nan)
                 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()              

        elif itemVAR_Landsat=='SAVI':
            if self.le_parameter1Landsat.text():
                SAVIparameter1=float(self.le_parameter1Landsat.text())   
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    
                for i in range(0,len(raster_list)-1,2):
                
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')                         
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                    name_str=''

                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                         
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                     
                    array2=np.ma.masked_where(array1+array2+SAVIparameter1 ==0, array2)   
                    array2=np.ma.masked_where(((1+SAVIparameter1)*(array1-array2))/(array1+array2+SAVIparameter1) ==0, array2)
                    array1=np.ma.masked_where(((1+SAVIparameter1)*(array1-array2))/(array1+array2+SAVIparameter1) ==0, array1)                   
                    rassum=((1+SAVIparameter1)*(array1-array2))/(array1+array2+SAVIparameter1)
                    rassum = rassum.filled(np.nan)

                    if self.le_minLandsat.text() and self.le_maxLandsat.text():
                        min_value= float(self.le_minLandsat.text())
                        max_value=float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                        min_value= float(self.le_minLandsat.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                        max_value= float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()       
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                 
            
        elif itemVAR_Landsat=='MSAVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where((((2*array1+1)*(2*array1+1))-8*(array1-array2)) <0, array2)
                array2=np.ma.masked_where(0.5*(2*array1+1-np.sqrt(((2*array1+1)*(2*array1+1))-8*(array1-array2))) ==0, array2)                               
                rassum=0.5*(2*array1+1-np.sqrt(((2*array1+1)*(2*array1+1))-8*(array1-array2)))
                rassum = rassum.filled(np.nan)
                 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                

        elif itemVAR_Landsat=='OSAVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2+0.16 ==0, array2)
                array2=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array2)
                array1=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array1)                
                rassum= (array1-array2)/(array1+array2+0.16)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None 
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()             

        elif itemVAR_Landsat=='GOSAVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2+0.16 ==0, array2)
                array2=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array2)
                array1=np.ma.masked_where(((array1-array2)/(array1+array2+0.16)) == 0, array1)                
                rassum= (array1-array2)/(array1+array2+0.16)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='GSAVI':
            if self.le_parameter1Landsat.text():
                GSAVIparameter1=float(self.le_parameter1Landsat.text())       
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    
                for i in range(0,len(raster_list)-1,2):
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')                         
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                    name_str=''
            
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                    array2=np.ma.masked_where(array1+array2+0.5==0, array2) 
                    array2=np.ma.masked_where(((1+GSAVIparameter1)*(array1-array2))/(array1+array2+GSAVIparameter1) == 0, array2)
                    array1=np.ma.masked_where(((1+GSAVIparameter1)*(array1-array2))/(array1+array2+GSAVIparameter1) == 0, array1)                            
                    rassum=((1+GSAVIparameter1)*(array1-array2))/(array1+array2+GSAVIparameter1)
                    rassum = rassum.filled(np.nan)

                    if self.le_minLandsat.text() and self.le_maxLandsat.text():
                        min_value= float(self.le_minLandsat.text())
                        max_value=float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                        min_value= float(self.le_minLandsat.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                        max_value= float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')    

        elif itemVAR_Landsat=='GEMI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
        
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array1=np.ma.masked_where(array1+array2+0.5 ==0, array1)
                array2=np.ma.masked_where(1-array2 ==0, array2)
                array2=np.ma.masked_where((((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5))*(1-0.25*(((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5)))-((array2-0.125)/(1-array2))  ==0.125, array2)                                              
                rassum=(((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5))*(1-0.25*(((2*(array1*array1)-(array2*array2))+1.5*array1+0.5*array2)/(array1+array2+0.5)))-((array2-0.125)/(1-array2))             
                rassum = rassum.filled(np.nan)
                 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='DVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):        
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where((array1-array2) ==0, array2)
                array1=np.ma.masked_where((array1-array2) ==0, array1)                   
                rassum= array1-array2
                rassum=rassum.filled(np.nan)
            
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='GARI':
            if self.le_parameter1Landsat.text():
                GARIparameter1=float(self.le_parameter1Landsat.text())
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)    
                    
                for i in range(0,len(raster_list)-1,4):          
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])
                    fp3=os.path.join(raster_list[i+2])
                    fp4=os.path.join(raster_list[i+3])
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                    rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array3=rasterX3.ReadAsArray()
                    array4=rasterX4.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    array3=array3.astype('float32')
                    array4=array4.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                    name_str=''
                                
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                    array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                    array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)                

                    array2=np.ma.masked_where((array1+(array2-GARIparameter1*(array3-array4)))==0, array2)
                    array1=np.ma.masked_where((array1+(array2-GARIparameter1*(array3-array4)))==0, array1)
                    rassum= (array1-(array2-GARIparameter1*(array3-array4)))/(array1+(array2-GARIparameter1*(array3-array4)))               
                    rassum = rassum.filled(np.nan)
                 
                    if self.le_minLandsat.text() and self.le_maxLandsat.text():
                        min_value= float(self.le_minLandsat.text())
                        max_value=float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                        min_value= float(self.le_minLandsat.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                        max_value= float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)
                    
                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')                
                  
        elif itemVAR_Landsat=='GDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                     
                array2=np.ma.masked_where((array1-array2) ==0, array2)
                array1=np.ma.masked_where((array1-array2) ==0, array1)                   
                rassum= array1-array2
                rassum=rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='GLI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                 
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

 
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                
                array2=np.ma.masked_where(2*array1+array2+array3 ==0, array2)
                rassum= (2*array1-array2-array3)/(2*array1+array2+array3)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()  

        elif itemVAR_Landsat=='TVI-Transformed':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array2=np.ma.masked_where(0.5+((array1-array2)/(array1+array2)) <0, array2)
                rassum= np.sqrt(0.5+((array1-array2)/(array1+array2)))
                rassum = rassum.filled(np.nan)
            
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 
                    
        elif itemVAR_Landsat=='TTVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array2=np.ma.masked_where(0.5+((array1-array2)/(array1+array2)) <0, array2)
                rassum= np.sqrt(0.5+np.absolute((array1-array2)/(array1+array2)))
                rassum = rassum.filled(np.nan)
            
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                     

        elif itemVAR_Landsat=='IPVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
          
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum=  array1/(array1+array2)
                rassum = rassum.filled(np.nan)
            
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='RDVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array2=np.ma.masked_where(array1+array2 <0, array2)
                rassum= ((array1-array2)/np.sqrt(array1+array2))
                rassum = rassum.filled(np.nan)
            
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='WDVI':
            if self.le_parameter1Landsat.text():
                WDVIparameter1=float(self.le_parameter1Landsat.text())               
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)    
                    
                for i in range(0,len(raster_list)-1,2):            
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                    name_str=''
              
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())
                                   
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                    array2=np.ma.masked_where((array1-WDVIparameter1*array2) ==0, array2)                                
                    rassum= (array1-WDVIparameter1*array2)
                    rassum=rassum.filled(np.nan)
                 
                    if self.le_minLandsat.text() and self.le_maxLandsat.text():
                        min_value= float(self.le_minLandsat.text())
                        max_value=float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                        min_value= float(self.le_minLandsat.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                        max_value= float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets()
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')     

        elif itemVAR_Landsat=='VARI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2+array3 ==0, array2)    
                rassum= (array1-array2)/(array1+array2+array3)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='ARVI':
            if self.le_parameter1Landsat.text():
                ARVIparameter1=float(self.le_parameter1Landsat.text())
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)    
                    
                for i in range(0,len(raster_list)-1,3):
                
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])
                    fp3=os.path.join(raster_list[i+2])
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array3=rasterX3.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    array3=array3.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                    name_str=''
                   
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

      
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                    array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                    array2=np.ma.masked_where(array1+array2-(ARVIparameter1*(array2-array3))==0, array2)    
                    rassum= (array1-array2-(ARVIparameter1*(array2-array3)))/(array1+array2-(ARVIparameter1*(array2-array3)))              
                    
                    rassum = rassum.filled(np.nan)

                    if self.le_minLandsat.text() and self.le_maxLandsat.text():
                        min_value= float(self.le_minLandsat.text())
                        max_value=float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                        min_value= float(self.le_minLandsat.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                        max_value= float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')    

        elif itemVAR_Landsat=='SARVI':
            if self.le_parameter1Landsat.text() and self.le_parameter2Landsat.text():
                SARVIparameter1=float(self.le_parameter1Landsat.text())
                SARVIparameter2=float(self.le_parameter2Landsat.text())
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)    
                    
                for i in range(0,len(raster_list)-1,3):
                
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])
                    fp3=os.path.join(raster_list[i+2])
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array3=rasterX3.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')
                    array3=array3.astype('float32')
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                    name_str=''
         
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

      
                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan) 
                    array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                    array2=np.ma.masked_where(array1+array2-(SARVIparameter1*(array2-array3))+SARVIparameter2 ==0, array2)
                    array2=np.ma.masked_where(((1+SARVIparameter2)*(array1-array2-(SARVIparameter1*(array2-array3)))/(array1+array2-(SARVIparameter1*(array2-array3)+SARVIparameter2))) == 0, array2)
                    array1=np.ma.masked_where(((1+SARVIparameter2)*(array1-array2-(SARVIparameter1*(array2-array3)))/(array1+array2-(SARVIparameter1*(array2-array3)+SARVIparameter2))) == 0, array1)                
                    
                    rassum= (1+SARVIparameter2)*(array1-array2-(SARVIparameter1*(array2-array3)))/(array1+array2-(SARVIparameter1*(array2-array3))+SARVIparameter2)
                    rassum = rassum.filled(np.nan)

                    if self.le_minLandsat.text() and self.le_maxLandsat.text():
                        min_value= float(self.le_minLandsat.text())
                        max_value=float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                        min_value= float(self.le_minLandsat.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                        max_value= float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')   

        elif itemVAR_Landsat=='NLI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):            
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where((array1*array1)+array2 ==0, array2)
                rassum=((array1*array1)-array2)/((array1*array1)+array2)
                rassum = rassum.filled(np.nan)
            
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='MNLI':
            if self.le_parameter1Landsat.text():
                MNLIparameter1=float(self.le_parameter1Landsat.text())        
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                    

                for i in range(0,len(raster_list)-1,2):            
                    
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')                         
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                    name_str=''
           
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                    array2=np.ma.masked_where((array1*array1)+array2+MNLIparameter1 == 0, array2)                
                    array2=np.ma.masked_where(((1+MNLIparameter1)*((array1*array1)-array2)/((array1*array1)+array2+MNLIparameter1)) == 0, array2)
                    array1=np.ma.masked_where(((1+MNLIparameter1)*((array1*array1)-array2)/((array1*array1)+array2+MNLIparameter1)) == 0, array1)                
                    rassum=(1+MNLIparameter1)*((array1*array1)-array2)/((array1*array1)+array2+MNLIparameter1)
                    rassum = rassum.filled(np.nan)

                    if self.le_minLandsat.text() and self.le_maxLandsat.text():
                        min_value= float(self.le_minLandsat.text())
                        max_value=float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                        min_value= float(self.le_minLandsat.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                        max_value= float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')     
                
        elif itemVAR_Landsat=='MSI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
       
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()               

        elif itemVAR_Landsat=='NDGI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):        
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
               
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum=((array1-array2)/(array1+array2))               
                rassum = rassum.filled(np.nan)
            
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
                    
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='RI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):        
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum=((array1-array2)/(array1+array2))
                rassum = rassum.filled(np.nan)
            
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='TDVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):        
                
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
         
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                array2=np.ma.masked_where((array1*array1)+array2+0.5 ==0, array2)
                array2=np.ma.masked_where((array1*array1)+array2+0.5 <0, array2)
                array2=np.ma.masked_where((1.5*(array1-array2)/np.sqrt((array1*array1)+array2+0.5)) == 0, array2)
                array1=np.ma.masked_where((1.5*(array1-array2)/np.sqrt((array1*array1)+array2+0.5)) == 0, array1)                
                rassum=1.5*(array1-array2)/np.sqrt((array1*array1)+array2+0.5)
                rassum = rassum.filled(np.nan)
            
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='WDRVI':
            if self.le_parameter1Landsat.text():
                WDRVIparameter1=float(self.le_parameter1Landsat.text())     
                    #Progress
                progressMessageBar = iface.messageBar().createMessage("Executing...")
                progress = QProgressBar()
                progress.setMaximum(10)
                progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
                progressMessageBar.layout().addWidget(progress)
                iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
                for i in range(10):
                    time.sleep(1)
                    progress.setValue(i+1)                   
                for i in range(0,len(raster_list)-1,2):        
                    
                    fp=os.path.join(raster_list[i])
                    fp2=os.path.join(raster_list[i+1])           
                    rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                    rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                    array1=rasterX.ReadAsArray()
                    array2=rasterX2.ReadAsArray()
                    array1=array1.astype('float32')
                    array2=array2.astype('float32')                         
                    name_str=''
                    for char in reversed(raster_list[i]):
                        if char!='/' and char!='\\':
                            name_str=name_str+char
                        else:
                            break

                    name= name_str[::-1]
                
                    
                    outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                    name_str=''
                    
                    driver=gdal.GetDriverByName("GTiff")
                    outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                    outds.SetGeoTransform(rasterX.GetGeoTransform())
                    outds.SetProjection(rasterX.GetProjection())

                    array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                    array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                
                    array2=np.ma.masked_where((WDRVIparameter1*array1)+array2 ==0, array2)
                    rassum=(((WDRVIparameter1*array1)-array2)/((WDRVIparameter1*array1)+array2))
                    rassum = rassum.filled(np.nan)

                    if self.le_minLandsat.text() and self.le_maxLandsat.text():
                        min_value= float(self.le_minLandsat.text())
                        max_value=float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum<(min_value), rassum)
                        rassum=np.ma.masked_where(rassum>(max_value), rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                        min_value= float(self.le_minLandsat.text())
                        rassum=np.ma.masked_where(rassum<min_value, rassum)
                        rassum = rassum.filled(np.nan)
                    elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                        max_value= float(self.le_maxLandsat.text())
                        rassum=np.ma.masked_where(rassum>max_value, rassum) 
                        rassum = rassum.filled(np.nan) 
                    outds.WriteArray(rassum)
                    outds = None
                    if state=='True':
                        a=np.nanmean(rassum)
                        mean_list.append(a)
                        b=np.nanstd(rassum)
                        std_list.append(b)
                        c=np.nanvar(rassum)
                        var_list.append(c)
                        d=np.nanmax(rassum)
                        max_list.append(d)
                        e=np.nanmin(rassum)
                        min_list.append(e)

                duration = 1000  
                freq = 440  
                if system == 'Windows':
                    winsound.Beep(freq, duration)           
                iface.messageBar().clearWidgets() 
            else:
                iface.messageBar().pushMessage('Missing parameter, please enter all required parameters', level=Qgis.Warning)
                self.close()
                reloadPlugin('remote_sensing_toolkit')  

        elif itemVAR_Landsat=='NDMI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                
            
        elif itemVAR_Landsat=='NDWI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()               
           
        elif itemVAR_Landsat=='NBR':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                          
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()     
           
        elif itemVAR_Landsat=='NBR2':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)                
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                       
                        
        elif itemVAR_Landsat=='BAI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                 
                array2=np.ma.masked_where((((0.1-array1)*(0.1-array1))+((0.06-array2)*(0.06-array2))) ==0, array2)
                array1=np.ma.masked_where(((0.1-array1)*(0.1-array1)) ==0.01, array2)  
                array2=np.ma.masked_where(((0.06-array2)*(0.06-array2)) ==0.0036, array2)                                  
                rassum= 1/(((0.1-array1)*(0.1-array1))+((0.06-array2)*(0.06-array2)))
                rassum=rassum.filled(np.nan)
                 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                
            
        elif itemVAR_Landsat=='DBI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,4):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                fp4=os.path.join(raster_list[i+3])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                rasterX4=gdal.Open(fp4, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array4=rasterX4.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                array4=array4.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array4= array4/10000
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array4 = np.ma.masked_array(array4, ~np.isfinite(array4)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                array3=np.ma.masked_where(array3+array4 ==0, array3)
                rassum= ((array1-array2)/(array1+array2))-((array3-array4)/(array3+array4))
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                

        elif itemVAR_Landsat=='NDBI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)                      
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                 
            
        elif itemVAR_Landsat=='CVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                            
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)
                array2=np.ma.masked_where(array3*array3 ==0, array2)
                rassum= (array1*array2)/(array3*array3)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None 
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()                
            
        elif itemVAR_Landsat=='GCI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')                         
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())
 
                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)

                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= (array1/array2)-1
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)
 
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()               

        elif itemVAR_Landsat=='LAI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where((array1+ 6*array2-7.5*array3+1) ==0, array2)
                rassum= 3.16*(2.5*(array1-array2)/(array1+ 6*array2-7.5*array3+1))-0.118
                rassum = rassum.filled(np.nan)
                 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None             
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 
                
        elif itemVAR_Landsat=='Clipping_by_mask':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
                gdal.UseExceptions()
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])             
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+'Clipped'+'-'+name
                name_str=''
                result=gdal.Warp(outputfilename, fp, cutlineDSName=fp2, cropToCutline=True, dstNodata = np.nan)
            
            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)          
            iface.messageBar().clearWidgets() 
            
        elif itemVAR_Landsat=='SIPI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                              
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array1-array3 ==0, array2)
                rassum= (array1-array2)/(array1-array3)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets()   

        elif itemVAR_Landsat=='GRVI':
            #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                           
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array2 ==0, array2)
                rassum= array1/array2
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='SLAVI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,3):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])
                fp3=os.path.join(raster_list[i+2])
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                rasterX3=gdal.Open(fp3, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array3=rasterX3.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                array3=array3.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
                             
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())


                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array3 = np.ma.masked_array(array3, ~np.isfinite(array3)).filled(np.nan)                
                array2=np.ma.masked_where(array2+array3 ==0, array2)
                rassum= array1/(array2+array3)
                rassum = rassum.filled(np.nan)
 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='NPCI':
                    #Progress
            progressMessageBar = iface.messageBar().createMessage("Executing...")
            progress = QProgressBar()
            progress.setMaximum(10)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            for i in range(10):
                time.sleep(1)
                progress.setValue(i+1)
            for i in range(0,len(raster_list)-1,2):
            
                fp=os.path.join(raster_list[i])
                fp2=os.path.join(raster_list[i+1])           
                rasterX=gdal.Open(fp, gdal.GA_ReadOnly)
                rasterX2=gdal.Open(fp2, gdal.GA_ReadOnly)
                array1=rasterX.ReadAsArray()
                array2=rasterX2.ReadAsArray()
                array1=array1.astype('float32')
                array2=array2.astype('float32')
                name_str=''
                for char in reversed(raster_list[i]):
                    if char!='/' and char!='\\':
                        name_str=name_str+char
                    else:
                        break

                name= name_str[::-1]
                
                    
                outputfilename=outfolder_LEtext+'/'+itemVAR_Landsat+'-'+name
                name_str=''
         
                driver=gdal.GetDriverByName("GTiff")
                outds=driver.Create(outputfilename, xsize=rasterX.RasterXSize, ysize=rasterX.RasterYSize, bands=1, eType=gdal.GDT_Float32)
                outds.SetGeoTransform(rasterX.GetGeoTransform())
                outds.SetProjection(rasterX.GetProjection())

                array1 = np.ma.masked_array(array1, ~np.isfinite(array1)).filled(np.nan)
                array2 = np.ma.masked_array(array2, ~np.isfinite(array2)).filled(np.nan)
                array2=np.ma.masked_where(array1+array2 ==0, array2)
                rassum= (array1-array2)/(array1+array2)
                rassum = rassum.filled(np.nan)
                 
                if self.le_minLandsat.text() and self.le_maxLandsat.text():
                    min_value= float(self.le_minLandsat.text())
                    max_value=float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum<(min_value), rassum)
                    rassum=np.ma.masked_where(rassum>(max_value), rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text() and self.le_maxLandsat.text()=='':
                    min_value= float(self.le_minLandsat.text())
                    rassum=np.ma.masked_where(rassum<min_value, rassum)
                    rassum = rassum.filled(np.nan)
                elif self.le_minLandsat.text()=='' and self.le_maxLandsat.text():
                    max_value= float(self.le_maxLandsat.text())
                    rassum=np.ma.masked_where(rassum>max_value, rassum) 
                    rassum = rassum.filled(np.nan) 
                outds.WriteArray(rassum)
                outds = None
                if state=='True':
                    a=np.nanmean(rassum)
                    mean_list.append(a)
                    b=np.nanstd(rassum)
                    std_list.append(b)
                    c=np.nanvar(rassum)
                    var_list.append(c)
                    d=np.nanmax(rassum)
                    max_list.append(d)
                    e=np.nanmin(rassum)
                    min_list.append(e)

            duration = 1000  
            freq = 440  
            if system == 'Windows':
                winsound.Beep(freq, duration)           
            iface.messageBar().clearWidgets() 

        elif itemVAR_Landsat=='PSRI':
   