# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ReliefFill
                                 A QGIS plugin
 Masks out altitude or basins upstream or downstream from a starting point.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-07-06
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Nicolas Specklin
        email                : n.specklin@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog

# Required module for the geoprocessing
#from osgeo import gdal
from qgis.core import QgsRasterLayer, QgsProject, QgsMessageLog, Qgis
from qgis.gui import QgsMessageBar
from .relief_lib import * 

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .relief_fill_dialog import ReliefFillDialog
import os.path

class ReliefFill:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ReliefFill_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Relief Fill')
        self.dlg = ReliefFillDialog()

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    def select_input_dem(self):
        """Shows a dialog to select a DEM file."""
        filename = QFileDialog.getOpenFileName(self.dlg, 'Open a file', '/home', 'Image files (*.png *.xpm *.jpg *.bmp *.tif *.ecw);;ASCII files (*.txt)')
        if filename:
            self.dlg.input_dem_txt.setText(filename[0])
    
    def select_output(self):
        """Shows a dialog to select a DEM file."""
        filename = QFileDialog.getSaveFileName(self.dlg, 'Save to', '/home', 'GeoTIFF image file (*.tif)')
        if filename:
            self.dlg.output_txt.setText(filename[0])

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ReliefFill', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/relief_fill/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'relief_fill'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Relief Fill'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = ReliefFillDialog()
            self.dlg.input_dem_browse.clicked.connect(self.select_input_dem)
            self.dlg.output_browse.clicked.connect(self.select_output)

        # show the dialog
        self.dlg.show()
        #self.dlg.input_dem_browse.clicked.connect(self.select_input_dem)
        #self.dlg.output_browse.clicked.connect(self.select_output)
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # USER INPUTS
            # Projected geographic coordinates of the starting point
            # must be in the same CRS as the input DEM
            X_GEO = float(self.dlg.input_pt_x.text())
            Y_GEO = float(self.dlg.input_pt_y.text())
            TYPE = self.dlg.menu_direction.currentText()
            IN_PATH = self.dlg.input_dem_txt.text()
            OUT_PATH = self.dlg.output_txt.text()
            
            # Loading DEM file as a GDAL dataset
            data_src = read_img(IN_PATH)
            
            # Loading the GDAL dataset as a numpy array
            dem_array = data_src.GetRasterBand(1).ReadAsArray()
            
            # Converting the geographic coordinates to pixel coordinates ([row][column])
            col = x_to_col(data_src, X_GEO)
            row = y_to_row(data_src, Y_GEO)
            
            # Logging processing information
            QgsMessageLog.logMessage("Raster dimensions", "Relief Fill", level=Qgis.Info)
            QgsMessageLog.logMessage("Columns : " + str(data_src.RasterXSize), "Relief Fill", level=Qgis.Info)
            QgsMessageLog.logMessage("Rows : " + str(data_src.RasterYSize), "Relief Fill", level=Qgis.Info)
            QgsMessageLog.logMessage("GeoTransform parameters : " + str(data_src.GetGeoTransform()), "Relief Fill", level=Qgis.Info)
            QgsMessageLog.logMessage("Spatial reference system : " + data_src.GetSpatialRef().GetName(), "Relief Fill", level=Qgis.Info)
            QgsMessageLog.logMessage("Pixel coordinates", "Relief Fill", level=Qgis.Info)
            QgsMessageLog.logMessage("Row index " + str(row), "Relief Fill", level=Qgis.Info)
            QgsMessageLog.logMessage("Column index " + str(col), "Relief Fill", level=Qgis.Info)
            QgsMessageLog.logMessage("Starting elevation : " + str(dem_array[row][col]) + " m", "Relief Fill", level=Qgis.Info)
            
            if self.dlg.menu_relief.currentText() == "altitude":
                alt_mask = altitude_fill4(dem_array, col, row, TYPE)
                write_img(data_src, alt_mask, OUT_PATH)
            else:
                basin = basin_fill(dem_array, col, row, TYPE)
                write_img(data_src, basin, OUT_PATH)
            
            out_rlayer = QgsRasterLayer(OUT_PATH, "fill layer")
            QgsProject.instance().addMapLayer(out_rlayer)
            myiface = MyIface()
            myiface.messageBar().pushMessage("Completed", "processing parameters logged in the Relief Fill Message Panel", level=Qgis.Info, duration=3)
