# -*- coding: utf-8 -*-
"""
/***************************************************************************
 RelazioniPlugin
                                 A QGIS plugin
 This plugin helps in the management of 1:N project relations
 Generated by Plugin Builder
                              -------------------
        begin                : 2024-10-03
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Federico Gianoli
        email                : gianoli.federico@gmail.com
 ***************************************************************************/

"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
import os.path

# Import the dialog file directly
from .RelazioniPlugin_dialog import RelazioniPluginDialog


class RelazioniPlugin:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        self.dlg = None

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        #icon_path = ':/plugins/relazioniplugin/icon.png'
        icon_path = os.path.join(self.plugin_dir, 'icon.png')  # Percorso dell'icona nella radice del plugin
        self.action = QAction(QIcon(icon_path), "Relation Manager", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Relation Manager", self.action)

    def unload(self):
        """Remove the plugin menu item and icon."""
        self.iface.removePluginMenu("&Relation Manager", self.action)
        self.iface.removeToolBarIcon(self.action)

    def run(self):
        """Run method that performs all the real work."""
        if not self.dlg:
            self.dlg = RelazioniPluginDialog()

        self.dlg.show()
        result = self.dlg.exec_()

        if result:
            # Do something useful here if needed
            pass
