# -*- coding: utf-8 -*-
"""
/***************************************************************************
 RefrescarPSQL
                                 A QGIS plugin
 Botón para recargar una capa desde PostGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-17
        git sha              : $Format:%H$
        copyright            : (C) 2025 by QChRis
        email                : naitsirhc696@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os.path

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import (
    QAction, QDialog, QListWidget, QListWidgetItem, QVBoxLayout,
    QPushButton, QLabel, QHBoxLayout, QWidget, QCheckBox
)
from qgis.core import QgsProject

# Initialize Qt resources from file resources.py
from .resources import *


class RefrescarPSQL:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)

        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir, 'i18n', f'RefrescarPSQL_{locale}.qm')

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr('&RefrescarPSQL')
        self.first_start = None

    def tr(self, message):
        return QCoreApplication.translate('RefrescarPSQL', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None
    ):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)
        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)
        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        icon_path = os.path.join(self.plugin_dir, 'icono.png')
        self.add_action(
            icon_path,
            text=self.tr('RefrescarPSQL'),
            callback=self.run,
            parent=self.iface.mainWindow()
        )
        self.first_start = True

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(self.tr('&RefrescarPSQL'), action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Función para refrescar múltiples capas PostGIS con checkboxes y orden alfabético."""
        layers = QgsProject.instance().mapLayers().values()
        pg_layers = [layer for layer in layers if layer.providerType() == 'postgres']
        layer_names = sorted([layer.name() for layer in pg_layers])

        if not layer_names:
            self.iface.messageBar().pushWarning(
                "⚠️ No hay capas PostGIS",
                "No se encontraron capas válidas para recargar."
            )
            return

        dialog = QDialog(self.iface.mainWindow())
        dialog.setWindowTitle("Seleccionar capas para recargar")
        layout = QVBoxLayout(dialog)

        layout.addWidget(QLabel("Seleccione una o varias capas para recargar:"))

        list_widget = QListWidget()
        checkboxes = {}

        for name in layer_names:
            item = QListWidgetItem(list_widget)
            widget = QWidget()
            cb = QCheckBox(name)
            checkboxes[name] = cb
            cb_layout = QHBoxLayout()
            cb_layout.addWidget(cb)
            cb_layout.setContentsMargins(0, 0, 0, 0)
            widget.setLayout(cb_layout)
            list_widget.setItemWidget(item, widget)

        layout.addWidget(list_widget)

        # Botones
        btn_layout = QHBoxLayout()
        btn_select_all = QPushButton("Seleccionar todo")
        btn_unselect_all = QPushButton("Deseleccionar todo")
        btn_ok = QPushButton("Aceptar")
        btn_cancel = QPushButton("Cancelar")

        btn_layout.addWidget(btn_select_all)
        btn_layout.addWidget(btn_unselect_all)
        btn_layout.addWidget(btn_ok)
        btn_layout.addWidget(btn_cancel)

        layout.addLayout(btn_layout)

        btn_select_all.clicked.connect(lambda: [cb.setChecked(True) for cb in checkboxes.values()])
        btn_unselect_all.clicked.connect(lambda: [cb.setChecked(False) for cb in checkboxes.values()])
        btn_ok.clicked.connect(dialog.accept)
        btn_cancel.clicked.connect(dialog.reject)

        if dialog.exec_() == QDialog.Accepted:
            selected = [name for name, cb in checkboxes.items() if cb.isChecked()]
            if not selected:
                self.iface.messageBar().pushWarning("⚠️ Sin selección", "No seleccionó ninguna capa.")
                return

            for name in selected:
                layer = QgsProject.instance().mapLayersByName(name)[0]
                layer.setDataSource(layer.source(), layer.name(), layer.providerType())
                layer.triggerRepaint()

            self.iface.messageBar().pushMessage(
                "✅ Capas recargadas",
                ", ".join(selected),
                level=0
            )
