"""QGIS Redistricting Plugin - Context menu provider for plan group

        begin                : 2023-08-04
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Cryptodira
        email                : stuart@cryptodira.org

/***************************************************************************
 *                                                                         *
 *   This program is free software you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details. You should have          *
 *   received a copy of the GNU General Public License along with this     *
 *   program. If not, see <http://www.gnu.org/licenses/>.                  *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.core import (
    Qgis,
    QgsApplication,
    QgsLayerTree,
    QgsLayerTreeGroup,
    QgsLayerTreeNode,
    QgsMapLayer,
    QgsMeshLayer,
    QgsRasterLayer,
    QgsVectorLayer
)
from qgis.gui import (
    QgisInterface,
    QgsLayerTreeView,
    QgsLayerTreeViewDefaultActions,
    QgsLayerTreeViewMenuProvider
)
from qgis.PyQt.QtCore import (
    QModelIndex,
    QObject
)
from qgis.PyQt.QtWidgets import QMenu

from ..core.utils import tr


class PlanMenuProvider(QObject, QgsLayerTreeViewMenuProvider):
    def __init__(self, iface: QgisInterface):
        super().__init__()
        self.iface = iface
        self.view: QgsLayerTreeView = iface.layerTreeView()
        self.canvas = iface.mapCanvas()
