import sys
from PyQt5.QtWidgets import QMenu
from PyQt5.QtCore import pyqtSignal
from PyQt5.QtGui import QIcon, QPixmap
import os
from qgis.core import QgsMessageLog

class CheckableQMenu(QMenu):
    itemSelected = pyqtSignal(str)

    def __init__(self, title, parent=None):
        """Initializes the QMenu widget with the checked Unchecked Icon"""
        super().__init__(title, parent)
        self.title = title

        path = os.path.join(os.path.dirname(os.path.realpath(__file__)), "../images/icons.png")
        checkedIcon = QPixmap(path).copy(16*2,16*3,16,16)
        self.checkedIcon = QIcon(checkedIcon)

        self.uncheckedIcon = QIcon()

    def checkParentMenu(self):
        """This handles the emit so that it doesn't get triggered during the setup phase
        """
        self.itemSelected.emit(self.objectName)

    def updateCheckedStatus(self):
        """The function goes over the actions of the QMenu and check if there is anything selected. update the check icon accordingly
        """
        checked = False
        for action in self.actions():
            if action.isChecked():
                checked = True
                self.setIcon(self.checkedIcon)
        
        if not checked:
            self.setIcon(self.uncheckedIcon)

    def addAction(self, action):
        """This function overrides the default action, which is there to emit the itemSelected event

        Args:
            action (QAction): The selected action
        """
        action.triggered.connect(self.emitItemSelected)
        super().addAction(action)

    def emitItemSelected(self):
        """This handles the emit so that it doesn't get triggered during the setup phase
        """
        self.itemSelected.emit(self.objectName())