import requests
import hashlib
from qgis.core import QgsMessageLog
from PyQt5.QtNetwork import QNetworkRequest
from PyQt5.QtCore import QUrl
from ..constants import DOMAIN, SESSION_KEY_NO_PARAM, ACCESS_TOKEN_URL
import urllib

def getSessionKey(username, password):
    """Gets the session key for the given username and password

    Args:
        username (_type_): username
        password (_type_): password

    Returns:
        str: Session Key. None if something is wrong, most likely invalid username or password.
    """

    md5Password = hashlib.md5(password.encode()).hexdigest()

    # i copied this from the realEarth web app so im not exactly sure what I am putting in here.
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0',
        'X-Requested-With': 'XMLHttpRequest'
    }

    # using session here so i can manage cookies.
    initialUrl = DOMAIN
    url = SESSION_KEY_NO_PARAM

    params = {'userid': username, 'password': md5Password}
    with requests.Session() as s:
        response = s.get(initialUrl)
        cookieDict = s.cookies.get_dict()

        newResponse = s.get(url, headers=headers, params = params, cookies = cookieDict)

   # TODO: Handle no internet connection

    if newResponse.status_code == 200:
        # success
        sessionKey = newResponse.text
        return sessionKey
    
    return None
    
def getAccessToken(username, sessionKey):
    """Gets the Access token for the given username and session key

    Args:
        username (str): username
        sessionKey (str): session key

    Returns:
        str: Access token. None if something is wrong
    """
    
    tokenUrl = ACCESS_TOKEN_URL
    tokenRequest = requests.get(tokenUrl)
    if tokenRequest.status_code == 200:
        # success
        tokenKey = tokenRequest.text
        return tokenKey
    
    return None