import sys
from PyQt5.QtWidgets import QWidget, QHBoxLayout, QLabel
from PyQt5.QtCore import pyqtSignal, Qt
from PyQt5.QtGui import QIcon, QPixmap

class IconWithLabel(QWidget):
    clicked = pyqtSignal()
    def __init__(self, icon = None, label = None):
        super(IconWithLabel, self).__init__()
        self.icon = icon
        self.label = label

        # Sets up a horizontal layout for the icon
        self.layout = QHBoxLayout(self)
        self.layout.setContentsMargins(0, 0, 0, 0)
        self.layout.setAlignment(Qt.AlignCenter)

        self.setLayout(self.layout)

        # icon label
        self.iconLabel = QLabel()
        self.layout.addWidget(self.iconLabel)

        self.layout.addSpacing(5)

        # text label
        self.textLabel = QLabel()
        self.layout.addWidget(self.textLabel)

    def setIcon(self, icon):
        self.iconLabel.setPixmap(icon)

    def setText(self, text):
        self.textLabel.setText(text)

    def mousePressEvent(self, event):
        self.clicked.emit()

