from queue import PriorityQueue
import re
class Search:
    def tokenize(self, text):
        """converts text to tokens"""
        return re.split(r'[\W-]+', text.lower())
    

    def search(self, products, query, favorite):
        """Searches for a list of products given a query.
            TODO: probably implement some other algorithm like TFIDF sometime later if i have the time

        Args:
            products (_type_): The list of products to search through
            query (_type_): The given query
        """
        queryTokens = self.tokenize(query)

        results = PriorityQueue()
        for p in products:
            score = 0
            matched = {"name": 0, "id": 0, "description": 0}
            
            tokens = {
                "name": self.tokenize(p["name"]),
                "description": self.tokenize(p["description"]),
                "id": self.tokenize(p["id"])
            }

            # doing max so that we don't have division by 0
            totNameChar = max(len(p["name"]),1)
            totalIdChar = max(len(p["id"]),1)
            totalDescChar = max(len(p["description"]),1)

            scaleFactor = {
                "name": 2,
                "description": 1,
                "id": 1
            }

            for qt in queryTokens:
                # Check if the query token is a substring of any token in each field
                for field in tokens:
                    for token in tokens[field]:
                        if qt in token:
                            score+=float(1*scaleFactor[field])
                            matched[field] += len(qt)

            # negate the score so higher scores are returned first
            if score > 0:
                # product is considered late if it is not static and status is 1
                late = not p["static"] and p["status"] == 1

                # adjusting the score based on the proportion of the characters
                score *= max(matched["name"]/totNameChar, matched["id"]/totalIdChar, matched["description"]/totalDescChar)*2
                
                # Last element just sees if this product is inside favorite list.
                results.put((-score, p["name"], p["id"], p["description"], late, p["categories"], p["type"], p["id"] in favorite))

        return results