# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file '.\realEarth_dockwidget_base.ui'
#
# Created by: PyQt5 UI code generator 5.15.10
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.


from PyQt5 import QtCore, QtGui, QtWidgets
from .customWidget.SearchResultHandler import SearchResultHandler
from .customWidget.SearchBar import SearchBar
from .customWidget.CustomDropDown import CustomDropDown
from .customWidget.CheckableQMenu import CheckableQMenu
from .customWidget.IconWithLabel import IconWithLabel
from .customWidget.pluginOverviewWindow import PluginOverviewWindow
from .customWidget.validationTab import ValidationTab
from .utils.Search import Search
from .constants import ALL_PRODUCT_URL, BASEMAP_URL, LABEL_URL, SSEC_ABOUT_URL, RE_ABOUT_URL
from concurrent.futures import ThreadPoolExecutor, as_completed
from .customWidget.preferencesTab import PreferencesTab
from .utils import utils
from collections import defaultdict
from qgis.core import QgsMessageLog, QgsSettings
import requests
import os
import json

class Ui_RealEarthDockWidgetBase(object):

    def page_titleSetup(self, parent, parentWidget):
        """Sets up the title page of the RealEarth widget

        Args:
            parent (widget): widget to be added to.
        """
        self.titleLabel = IconWithLabel(parentWidget)
        self.titleLabel.setObjectName("titleLabel")

        font = QtGui.QFont()
        font.setPointSize(12)
        self.titleLabel.setIcon(QtGui.QPixmap(os.path.join(os.path.dirname(__file__), 'images/ssec-logo.png')))
        self.titleLabel.iconLabel.setScaledContents(True)
        self.titleLabel.iconLabel.setFixedSize(36,25)
        self.titleLabel.textLabel.setFont(font)
        

        parent.addWidget(self.titleLabel)

    
    def tabSetup(self,parent):
        """Sets up the tab layout of the RealEarth dock widget.

        Args:
            parent: the layout to add the tab widget to.
        """
        self.tabWidget = QtWidgets.QTabWidget(self.dwContent)
        self.tabWidget.setObjectName("tabWidget")
        # NOTE: The order of the tab was switched around
        # Main tab
        self.tab2 = QtWidgets.QWidget()
        self.tab2.setObjectName("tab2")
        self.tabWidget.addTab(self.tab2, "")

        # Preferences tab
        self.tab3 = QtWidgets.QWidget()
        self.tab3.setObjectName("tab3")
        self.tabWidget.addTab(self.tab3, "")

        # Api validation tab
        self.tab1 = QtWidgets.QWidget()
        self.tab1.setObjectName("tab1")
        self.tabWidget.addTab(self.tab1, "")

        self.tabWidget.setCurrentIndex(0)
        parent.addWidget(self.tabWidget)

        self.tabWidget.currentChanged.connect(self.tabChangedEvent)

    def tabChangedEvent(self, event=None):
        """This function helps with resetting some of the widgets according to the preferences"""
        if self.tabWidget.currentIndex() == 1:
            # in this tab, only needs to change the expand button to either enabled or disabled
            if self.settings.value("realEarth/iconToggle", True, type=bool):
                self.expandButton.setEnabled(False)
                self.expandButton.setToolTip("Expand All is disabled when load icon is enabled.")
            else:
                self.expandButton.setEnabled(True)
                self.expandButton.setToolTip("Expand all categories")


    def tab2VLayoutSetup(self, parent):
        """sets up the vertical layout of the second tab.

        Args:
            parent: the layout to add the vertical layout to.
        """
        self.t2VLayoutWidget = QtWidgets.QWidget(parent)
        self.t2VLayoutWidget.setObjectName("t2VLayoutWidget")
        self.t2VLayout = QtWidgets.QVBoxLayout(self.t2VLayoutWidget)
        self.t2VLayout.setContentsMargins(-3, 15, -3, 20)
        self.t2VLayout.setObjectName("t2VLayout")

        #Setting size policy so it fits the entire tab (hopefully)
        self.t2VLayoutWidget.setSizePolicy(QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Expanding)
        parent.setLayout(self.t2VLayout)

    def t2GSelectSetup(self, parent):
        """Sets up the groupbox widget that deals with product selection.

        Args:
            parent (widget): the layout to add the groupbox widget to.
        """
        self.t2GSelect = QtWidgets.QGroupBox(parent)
        self.t2GSelect.setMinimumSize(QtCore.QSize(0,90))
        self.t2GSelect.setAlignment(QtCore.Qt.AlignCenter)
        self.t2GSelect.setObjectName("t2GSelect")
        self.t2GSelect.setMaximumHeight(600)
        self.t2VLayout.addWidget(self.t2GSelect)

    def t2GTimeSetup(self, parent):
        """Sets up the groupbox widget that deals with time selection of the product.

        Args:
            parent (widget): the widget to add to the groubox widget to.
        """
        self.t2GTime = QtWidgets.QGroupBox(parent)
        self.t2GTime.setMinimumSize(QtCore.QSize(0,90))
        self.t2GTime.setAlignment(QtCore.Qt.AlignCenter)
        self.t2GTime.setObjectName("t2GTime")
        self.t2VLayout.addWidget(self.t2GTime)

    def t2ButtonSetup(self, parent, parentWidget):
        """Sets up the button used to add the layer.

        Args:
            parent (widget): the widget to add to the groubox widget
        """
        # Adding a horizontal layout for two buttons
        self.layerButtonsLayout = QtWidgets.QHBoxLayout()
        parent.addLayout(self.layerButtonsLayout)

        # setting the add layer button
        self.addLayerButton = QtWidgets.QPushButton(parentWidget)
        self.addLayerButton.setCursor(QtGui.QCursor(QtCore.Qt.PointingHandCursor))
        self.addLayerButton.setObjectName("addLayerButton")
        self.layerButtonsLayout.addWidget(self.addLayerButton)

    def selectVLayoutSetup(self, parent):
        """sets up the vertical layout of the first combobox widget.

        Args:
            parent: the layout to add the vertical layout to.
        """
        self.selectVLayoutWidget = QtWidgets.QWidget(parent)
        self.selectVLayoutWidget.setObjectName("selectVLayoutWidget")
        self.selectVLayout = QtWidgets.QVBoxLayout(self.t2VLayoutWidget)
        self.selectVLayout.setContentsMargins(-3, 30, -3, 20)
        self.selectVLayout.setObjectName("selectVLayout")

        #Setting size policy so it fits the entire groupbox (hopefully)
        self.selectVLayoutWidget.setSizePolicy(QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Expanding)
        parent.setLayout(self.selectVLayout)
    
    def searchLineSetup(self, parent, parentWidget):
        """This is a QLineEditComplter that will be used to search for a product.

        Args:
            parent (_type_): layout to add the combobox widget to.
            parentWidget (_type_): widget to add the combobox widget to.
        """
        self.model = QtCore.QStringListModel([p["name"] for p in self.productList])
        
        numProduct = format(len(self.productList), ',d')
        placeholderText = f"Search from {numProduct} products..."
        self.search = SearchBar(self.model, placeholderText, parentWidget)
        self.search.searchBar.returnPressed.connect(self.searchReturnEvent)
        self.search.clearButton.triggered.connect(self.searchClearEvent)
        parent.addWidget(self.search)

    def searchClearEvent(self):
        if self.comBoxShown:
            # if category comboboxes are already shown, the just need to clear the search bar
            self.search.searchBar.clear()
            return
        
        # clearing search bar and showing category comboxes back.
        self.search.searchBar.clear()
        self.showComboBoxes()

    def searchReturnEvent(self):
        """This handles calling the functions to either bring back the comboboxes or show the results
        """
        self.comBoxShown = True
        text = self.search.searchBar.text()

        if text == self.searchBarText:
            # The searchBarText hasn't changed, so don't do anything
            return
        
        if text == "":
            self.showComboBoxes()
        else:
            self.showResults(text)

    def showResults(self, text):
        
        """Shows the search results for the given text

        Args:
            text (_type_): text to search for
        """
        # Setting these buttons to be disabled since they are not needed
        self.collapseButton.setEnabled(False)
        self.collapseButton.setToolTip("")
        self.expandButton.setEnabled(False)
        self.expandButton.setToolTip("")
        self.refreshButton.setEnabled(False)
        self.refreshButton.setToolTip("")
        self.comBoxShown = False
        self.searchBarText = text

        searchHandler = Search()
        # passing in self.favorite because i dont want to loop through the entire product list everytime I add or remove a favorite
        results = searchHandler.search(self.productList, text, self.favorite)

        # hides the comboboxes
        for c in self.categoryComBoxes:
            c.hide()
        
        self.catVBox.setSpacing(0) # remove the and spacing
        self.catVBox.setContentsMargins(0,0,0,0) # set margin to 0
        # Finding the max number of results from settings
        maxResults = self.settings.value("realEarth/maxResults", 40, type=int)

        # Update the number of results
        resultSize = results.qsize()
        minResult = str(min(resultSize, maxResults))
        # Adding a + sign if the number of search result is greater than the number displayed
        numResult = minResult + "+" if resultSize >  maxResults else minResult
        self.t2GSelect.setTitle(f"{numResult} Result(s)")

        # Starts to add the results
        self.searchResultHandler.removeAllResults()
        self.searchResultHandler.addResultLabels(results,maxResults)

        # Set scroll bar position to the top
        self.catScroll.verticalScrollBar().setValue(self.catScroll.verticalScrollBar().minimum())

    def resultClickedHandler(self, text):
        pass

    def showComboBoxes(self):
        """Shows/unhides all the comboboxes in that section that was origionally search results."""
        # Enable the collapse button again and conditionally enable the expand button depending on the setting
        self.collapseButton.setEnabled(True)
        self.collapseButton.setToolTip("Collapse all categories")
        # enable the refresh button
        self.refreshButton.setEnabled(True)
        self.refreshButton.setToolTip("Refresh Products")
        
        if self.settings.value("realEarth/iconToggle", True, type=bool) == False:
            self.expandButton.setEnabled(True)
            self.expandButton.setToolTip("Expand all categories")
        else:
            self.expandButton.setToolTip("Expand All is disabled when load icon is enabled.")

        # showing the comboboxes
        self.catVBox.setSpacing(-1) # default?
        self.catVBox.setContentsMargins(11,11,11,11) # set margin back to default
        self.searchBarText = ""
        self.searchResultHandler.removeAllResults()
        for c in self.categoryComBoxes:
            c.show()

        # Reset scroll bar position to the top
        self.catScroll.verticalScrollBar().setValue(self.catScroll.verticalScrollBar().minimum())

        # Change back to select a product
        self.t2GSelect.setTitle(f"Select a Product ({len(self.categories)} Categories)")


    def catScrollAreaSetup(self, parent):
        """Setting up the scroll area for the comboboxes"""
        self.catScroll = QtWidgets.QScrollArea()
        self.catScroll.setMinimumHeight(40)

        self.catWidget = QtWidgets.QWidget() # This is used to contain the collection of vertical box
        self.catVBox = QtWidgets.QVBoxLayout() # This contains the comboboxes
        self.catVBox.setAlignment(QtCore.Qt.AlignTop)

        self.catWidget.setLayout(self.catVBox)

        # Scroll Area Properties
        self.catScroll.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOn)
        
        self.catScroll.setWidgetResizable(True)
        
        self.catScroll.setWidget(self.catWidget)
        parent.addWidget(self.catScroll)

    def categoryDropDownSetup(self, parent, parentWidget):
        """Sets up the comboboxes for each category"""
        self.categoryComBoxes = []
        # Append Favorite category first
        # TODO: add fav
        self.categoryComBoxes.append(CustomDropDown("Favorite", self.settings))
        self.categoryComBoxes[0].itemSelected.connect(self.comboxChangedHandler)
        self.categoryComBoxes[0].updateFav.connect(self.updateFav)
        
        toAdd = []
        # appending products to favorite combox
        for item in self.favoriteCategory:
            toAdd.append([item["name"], item["id"], item["late"], item["description"], item["type"], item["favorite"]])
        self.categoryComBoxes[0].addItem(toAdd)

        parent.addWidget(self.categoryComBoxes[0])

        for i in range(len(self.categories)):
            self.categoryComBoxes.append(CustomDropDown(self.categories[i], self.settings))
            #Block signals first so that Handler won't be called upon start up
            
            toAdd = []
            # Adding each products of the categorylist based on if it is late or not. Late: orange, not late: green.
            
            for index, p in enumerate(self.categoriesFull[self.categories[i]]):
                
                # third element is whether the product is late or not.
                toAdd.append([p["name"], p["id"], p["late"], p["description"], p["type"], p["favorite"]])
            # i+1 to account for the first favorite category
            self.categoryComBoxes[i+1].itemSelected.connect(self.comboxChangedHandler)
            self.categoryComBoxes[i+1].addItem(toAdd)
            self.categoryComBoxes[i+1].updateFav.connect(self.updateFav)

            parent.addWidget(self.categoryComBoxes[i+1])

    def updateFav(self, item):
        """Updates the favorite category

        Args:
            item (list): product with all the necessary information to add
        """
        # item[5] is pre updated value. so if item[5] is false, then item should be put into favorite
        if not item[5]:
            self.favoriteCategory.append({"name": item[0], "id": item[1], "late": item[2], "description": item[3], "type": item[4], "favorite": True})
            self.favorite.append(item[1])
            # update the QSettings
            favStr = json.dumps(self.favorite)
            self.settings.setValue("realEarth/favoriteProducts", favStr)
            self.settings.sync()
            item[5] = True
            # TODO: Update product
        else:
            # remove item from category list
            for i in self.favoriteCategory:
                if i["id"] == item[1]:
                    self.favoriteCategory.remove(i)
            item[5] = False
            # remove id from fav list
            self.favorite.remove(item[1])
            # update the QSettings
            favStr = json.dumps(self.favorite)
            self.settings.setValue("realEarth/favoriteProducts", favStr)

        # rebuild the combox
        self.removeAndRebuildComBox()

        # update all occurrences of this item in the category
        for i in range(len(self.categoryComBoxes)):
            self.categoryComBoxes[i].updateStar(item)
            # update the state of the combox if it is expanded
            if self.categoryComBoxes[i].isExpanded:
                self.categoryComBoxes[i].collapse()
                self.categoryComBoxes[i].expand()

    def removeAndRebuildComBox(self):
        """Removes the favorite combox and rebuilds it
        """
        self.categoryComBoxes[0].removeAll()
        toAdd = []
        for item in self.favoriteCategory:
            toAdd.append([item["name"], item["id"], item["late"], item["description"], item["type"], item["favorite"]])
        self.categoryComBoxes[0].addItem(toAdd)
        # Run the expand manually to start fetching icons
        if self.categoryComBoxes[0].isExpanded:
            # only run this when it is expanded
            self.categoryComBoxes[0].collapse()
            self.categoryComBoxes[0].expand()

    def explainDotsLabelSetup(self, parent):
        """This function sets up the label that explains what the color dots in front of the products mean. and sets up the layout for future buttons."""
        self.explainLayout = QtWidgets.QHBoxLayout()
        parent.addLayout(self.explainLayout)

        self.explainDotsLabel = QtWidgets.QLabel("<span style='font-size:12px; font-weight:bold'>R</span>: Raster&nbsp;&nbsp;&nbsp;<span style='font-size:12px; font-weight:bold'>V</span>: Vector&nbsp;&nbsp;&nbsp;<span style='color: #38CF38; font-size:12px; font-weight:bold'>On Time&nbsp;&nbsp;&nbsp;</span> <span style='color: #F75D1E; font-size:12px; font-weight:bold'>Late</span>")
        self.explainDotsLabel.setStyleSheet("font-size: 12px;")
        self.explainLayout.addWidget(self.explainDotsLabel)

    def collapseExpandButtonSetup(self, parent):
        """Since this one aligns right, so need to make another layout"""
        self.collapseExpandLayout = QtWidgets.QHBoxLayout()
        parent.addStretch()
        parent.addLayout(self.collapseExpandLayout)

        self.collapseExpandLayout.setAlignment(QtCore.Qt.AlignRight | QtCore.Qt.AlignVCenter)

        # I am hiding the expand button for now because it will possibly crash the app for loading icons for 1000+ products.

        # Initializing the push button
        self.collapseButton = QtWidgets.QPushButton()
        self.expandButton = QtWidgets.QPushButton()
        self.collapseButton.setToolTip("Collapse all categories")
        self.expandButton.setToolTip("Expand all categories")
        self.collapseButton.clicked.connect(self.collapseAllHandler)
        self.expandButton.clicked.connect(self.expandAllHandler)

        # Setting up the icons
        if self.theme == "Blend of Gray":
            relativePath = "images/iconsGrayTheme.png"
        else:
            relativePath = "images/icons.png"
        path = os.path.join(os.path.dirname(os.path.realpath(__file__)), relativePath)
        collapseIcon = QtGui.QPixmap(path).copy(0,0,16,16)
        expandIcon = QtGui.QPixmap(path).copy(4*16,0,16,16)

        self.expandButton.setIcon(QtGui.QIcon(expandIcon))
        self.collapseButton.setIcon(QtGui.QIcon(collapseIcon))

        # Adding the buttons to the widgets
        self.collapseExpandLayout.addWidget(self.expandButton)
        self.collapseExpandLayout.addWidget(self.collapseButton)

        # Only enable this button when load icon is disabled to prevent your qgis from crashing
        if self.settings.value("realEarth/iconToggle", True, type=bool):
            self.expandButton.setEnabled(False)
            self.expandButton.setToolTip("Expand All is disabled when load icon is enabled.")

        # Setting refresh button here. Doing refresh because it is a more reasonable place to put it
        self.refreshButton = QtWidgets.QPushButton()
        self.refreshButton.setToolTip("Refresh Products")
        self.refreshButton.clicked.connect(self.updateData)
        refreshIcon = QtGui.QPixmap(path).copy(11*16,4*16,16,16)
        self.refreshButton.setIcon(QtGui.QIcon(refreshIcon))
        self.collapseExpandLayout.addWidget(self.refreshButton)

    def updateData(self):
        """Does another request to the api and rebuilds the category list
        """
        QtWidgets.QApplication.setOverrideCursor(QtCore.Qt.BusyCursor)
        self.dataSetup()
        QtWidgets.QApplication.restoreOverrideCursor()

        self.t2GSelect.setTitle(f"Select a Product ({len(self.categories)} Categories)")

        numProduct = format(len(self.productList), ',d')
        placeholderText = f"Search from {numProduct} products..."
        self.search.searchBar.setPlaceholderText(placeholderText)

        # remove everything in combobox
        for c in self.categoryComBoxes:
            c.removeAll()
            # remove the combobox itself
            c.deleteLater()
        
        # Rebuild them all
        self.categoryDropDownSetup(self.catVBox, self.catWidget)

    def collapseAllHandler(self):
        """Hide all the comboboxes items"""
        for comBox in self.categoryComBoxes:
            comBox.collapse()

    def expandAllHandler(self):
        """Expands all comboboxes items"""
        for comBox in self.categoryComBoxes:
            comBox.expand()

    def comboxChangedHandler(self, product, id, shape):
        """Helper function to set up the correct parameters to call timeSearchAndUpdateList

        Args:
            comBoxIndex (_type_): index of the combobox in the categoryComBoxesList
            index (_type_): index of the item in the combobox
        """
        self.selectedProduct = product
        self.timeSearchAndUpdateList((product,id, shape))

    def apiCall(self,url):
        """Helper function used by the ThreadPoolExecutor to do api requests

        Args:
            url (_type_): url of the thing to call

        Returns:
            _type_: response
        """
        try:
            response = requests.get(url)
            return response
        except requests.exceptions.RequestException as e:
            return None

    def dataSetup(self):
        """This sets up the data such as categories and products.
        """
        # making the two api requests two threads so it wont block the main thread
        futures = []

        urls = [
            ALL_PRODUCT_URL,
            BASEMAP_URL,
            LABEL_URL
        ]
        
        output = {}
        # run the requests concurrently
        with ThreadPoolExecutor(min(10, os.cpu_count() * 2)) as exe:
            futures = {exe.submit(self.apiCall, url): url for url in urls}
            for future in as_completed(futures):
                output[futures[future]] = future.result()
        
        # Save the stuff to a variable
        self.productList = output[urls[0]].json()
        self.baseMapResponse = (output[urls[1]], urls[1])
        self.labelResponse = (output[urls[2]], urls[2])

        # Retreiveing data for favorite products                        
        self.categoriesFull = defaultdict(list)

        favoriteString = self.settings.value("realEarth/favoriteProducts", "")
        if favoriteString:
            self.favorite = json.loads(favoriteString)
        else:
            self.favorite = []
        self.favoriteCategory = []
        # setting the category list
        for product in self.productList:
            # If statement to build up the category for favorite and adding a new field to the product
            # FIY: Favorite category should always be built on the available products and not the favorite list itself.
            if product["id"] in self.favorite:
                self.favoriteCategory.append(product)
                product["favorite"] = True
            else:
                # Set the field to false if the product does not appear in the favorite list
                product["favorite"] = False
            product["late"] = (not product["static"] and product["status"] == 1)

            for category in product["categories"]:
                self.categoriesFull[category].append(product)


        self.categories = list(self.categoriesFull.keys())
        self.categories.sort()

        self.theme = self.settings.value("UI/uitheme")
        if self.theme is None:
            self.theme = self.settings.value("UI/UITheme")

    def timeSelectionSetup(self, parent):
        # horizontal layout to store the time and the checkboxes
        self.timeLayout = QtWidgets.QHBoxLayout()
        self.timeLayout.setAlignment(QtCore.Qt.AlignTop)

        # Making of the QListWidget
        self.timeList = QtWidgets.QListWidget()
        self.timeLayout.addWidget(self.timeList)
        self.timeList.setSelectionMode(QtWidgets.QAbstractItemView.ExtendedSelection)
        self.timeList.itemSelectionChanged.connect(self.updateOptionButtons)

        parent.setLayout(self.timeLayout)

    def updateOptionButtons(self):
        """Helper function to enable/disable auto refetch option
        """
        for i in self.timeList.selectedItems():
            # If the selected items include (current) or (latest) then enable the option
            if "(Current)" in i.text() or "(Latest Forecast)" in i.text():
                self.refetchLayerOption.setEnabled(True)
                refetchPeriod = self.settings.value("realEarth/refetchPeriod", 5, type=int)
                self.refetchLayerOption.setToolTip(f"Refetch (Current) and (Latest Forecast) layers every {refetchPeriod} minute(s).")
                return
            
        # none of the selected are current or latest, so disable the option
        self.refetchLayerOption.setEnabled(False)
        self.refetchLayerOption.setToolTip("Option only available for (Current) and (Latest Forecast) layers")
        


    def layerOptionsSetup(self, parent):
        """"This sets up the widget for checkboxes to change properties of the layers"""
        # vertical laout to store the checkboxes
        self.optionsLayout = QtWidgets.QVBoxLayout()
        self.optionsLayout.setAlignment(QtCore.Qt.AlignTop)

        # Setting up title for other options
        self.renderOptionsTitle = QtWidgets.QLabel("Render Options")
        self.renderOptionsTitle.setStyleSheet("font-size:12px;")
        self.optionsLayout.addWidget(self.renderOptionsTitle)
        self.renderOptionsTitle.setAlignment(QtCore.Qt.AlignCenter)

        self.optionsLayout.addSpacing(-3)

        # divider line for the options title and the checkboxes
        line = QtWidgets.QFrame()
        line.setFrameShape(QtWidgets.QFrame.HLine)
        line.setFrameShadow(QtWidgets.QFrame.Sunken)
        line.setMaximumHeight(1)
        line.setStyleSheet("border:1px solid #dcdcdc")
        self.optionsLayout.addWidget(line)

        # Render Options Radio buttons setup
        self.renderRasterRadio = QtWidgets.QRadioButton("Raster Tile")
        self.renderRasterRadio.setToolTip("Render as Raster Tile (WMTS)")
        self.renderRasterRadio.setObjectName("renderRaster")

        self.renderVectorRadio = QtWidgets.QRadioButton("Vector")
        self.renderVectorRadio.setToolTip("Select a vector product to enable")
        self.renderVectorRadio.setObjectName("renderVector")
        self.renderVectorRadio.setEnabled(False)

        self.renderVectorTileRadio = QtWidgets.QRadioButton("Vector Tile")
        self.renderVectorTileRadio.setToolTip("Select a vector product to enable")
        self.renderVectorTileRadio.setObjectName("renderVectorTile")
        self.renderVectorTileRadio.setEnabled(False)

        self.options = [self.renderRasterRadio, self.renderVectorRadio, self.renderVectorTileRadio]

        # Adding widget
        self.optionsLayout.addWidget(self.renderRasterRadio)
        self.optionsLayout.addSpacing(-3)
        self.optionsLayout.addWidget(self.renderVectorRadio)
        self.optionsLayout.addSpacing(-3)
        self.optionsLayout.addWidget(self.renderVectorTileRadio)

        # button group to hold the radio buttons
        self.radioButtonGroup = QtWidgets.QButtonGroup()
        self.radioButtonGroup.addButton(self.renderRasterRadio)
        self.radioButtonGroup.addButton(self.renderVectorRadio)
        self.radioButtonGroup.addButton(self.renderVectorTileRadio)

        # setting the default radio button, which is raster
        self.renderRasterRadio.setChecked(True)

        self.optionsLayout.addSpacing(5)

        # Setting up title for the option
        self.optionsTitle = QtWidgets.QLabel("Layer Options")
        self.optionsTitle.setStyleSheet("font-size:12px;")
        self.optionsLayout.addWidget(self.optionsTitle)
        self.optionsTitle.setAlignment(QtCore.Qt.AlignCenter)
        self.optionsLayout.addSpacing(-3)
        # divider line for the options title and the checkboxes
        line = QtWidgets.QFrame()
        line.setFrameShape(QtWidgets.QFrame.HLine)
        line.setFrameShadow(QtWidgets.QFrame.Sunken)
        line.setMaximumHeight(1)
        line.setStyleSheet("border:1px solid #dcdcdc")
        self.optionsLayout.addWidget(line)
        # Creating Checkboxes
        

        # adding a horizontal box due to having to fit in the refresh button
        self.opacityHbox = QtWidgets.QHBoxLayout()
        self.opacityHbox.setAlignment(QtCore.Qt.AlignLeft)
        self.optionsLayout.addLayout(self.opacityHbox)
        
        # Opacity Slider option
        self.opacityOptions = QtWidgets.QCheckBox("Opacity Slider")
        self.opacityOptions.setObjectName("opacity")
        self.options.append(self.opacityOptions)
        self.opacityHbox.addWidget(self.opacityOptions)
        
        # Update button goes next to the layer options since some options below are not supposed to be refreshed.
        # Makes a horizontal layout so i can center the button
        self.updateButton = QtWidgets.QPushButton()
        self.updateButton.setFixedSize(18,18)
        self.updateButton.setToolTip("Update the selected layer with the updated checkboxes")

        # Setting up the icon
        # Setting up the icons
        if self.theme == "Blend of Gray":
            relativePath = "images/iconsGrayTheme.png"
        else:
            relativePath = "images/icons.png"
        path = os.path.join(os.path.dirname(os.path.realpath(__file__)), relativePath)
        updateIcon = QtGui.QPixmap(path).copy(11*16,4*16,16,16)
        self.updateButton.setIcon(QtGui.QIcon(updateIcon))
        self.updateButton.setEnabled(False)
        self.updateButton.setToolTip("Select layer(s) from the Layers panel to update options")
        self.opacityHbox.addWidget(self.updateButton)
        
        self.refetchLayerOption = QtWidgets.QCheckBox("Auto Refresh layer")
        # only enabled when the selected layer includes a current or latest forecast
        self.refetchLayerOption.setEnabled(False)
        self.refetchLayerOption.setToolTip("Option only available for (Current) and (Latest Forecast) layers")
        self.refetchLayerOption.setObjectName("refetchLayer")
        self.options.append(self.refetchLayerOption)
        self.optionsLayout.addWidget(self.refetchLayerOption)

        self.optionsLayout.addStretch()
        # add a timer at the bottom
        refetchPeriod = self.settings.value("realEarth/refetchPeriod", 5, type=int)
        self.clock = QtWidgets.QLabel(f"Next refetch: {refetchPeriod} minute(s)")
        self.clock.setAlignment(QtCore.Qt.AlignCenter)
        self.clock.setStyleSheet("color: #3B3B3B;")
        self.optionsLayout.addWidget(self.clock)
        self.clock.hide()

        parent.addLayout(self.optionsLayout)

        # setting minimum size for the t2GTime
        hint = self.t2GTime.sizeHint()
        # -30 because somehow hint is still larger than the size the widgets needed
        self.t2GTime.setMinimumHeight(hint.height()-30)


    def timeSearchAndUpdateList(self, product):
        """This is a helper function to search for the product time and update the list.

        Args:
            id (_type_): the id of the product
        """
        # Enable/disbale the render as vector option depending on what shape the selected product is
        if product[2] == "vector" or product[2] == "shape":
            self.renderVectorRadio.setEnabled(True)
            self.renderVectorRadio.setToolTip("Render as Vector (WFS)")

            self.renderVectorTileRadio.setEnabled(True)
            self.renderVectorTileRadio.setToolTip("Render as Vector Tile (MVT)")
        else:
            # when disabled, want to switch selection to raster by default
            self.renderRasterRadio.setChecked(True)

            self.renderVectorRadio.setEnabled(False)
            self.renderVectorRadio.setToolTip("Select a vector Product to enable")

            self.renderVectorTileRadio.setEnabled(False)
            self.renderVectorTileRadio.setToolTip("Select a vector product to enable")

        # Search for the time
        time = utils.searchTime(product)
        
        # Populating the time list with all the time
        self.t2GTime.repaint()
        utils.updateList(self.selectedProduct, self.t2GTime, self.timeList, time)

    def aboutSetup(self, parent):
        """This sets up the about section that links to the about page of the ssec website

        Args:
            parent (_type_): parent layout
        """

        self.aboutLayout = QtWidgets.QHBoxLayout()
        self.aboutLayout.setContentsMargins(0,0,0,0)
        # spacer item?
        spacer1 = QtWidgets.QSpacerItem(30, 24, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.aboutLayout.addItem(spacer1)

        # add label
        self.ssecTextLabel = QtWidgets.QLabel(self.dwContent)
        self.ssecTextLabel.setAlignment(QtCore.Qt.AlignCenter)
        self.ssecTextLabel.setOpenExternalLinks(True)
        self.aboutLayout.addWidget(self.ssecTextLabel)

        spacer2 = QtWidgets.QSpacerItem(30, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.aboutLayout.addItem(spacer2)

        # add label
        self.realEarthTextLabel = QtWidgets.QLabel(self.dwContent)
        self.realEarthTextLabel.setCursor(QtCore.Qt.PointingHandCursor)
        self.realEarthTextLabel.setAlignment(QtCore.Qt.AlignCenter)
        self.realEarthTextLabel.setOpenExternalLinks(True)
        self.aboutLayout.addWidget(self.realEarthTextLabel)

        spacer3 = QtWidgets.QSpacerItem(30, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.aboutLayout.addItem(spacer3)

        # Add version
        self.version = None
        with open(os.path.join(os.path.dirname(__file__), "metadata.txt")) as fp:
            lines = fp.readlines()
            for line in lines:
                temp = line.split("=")
                if (temp[0]) == "version":
                    self.version = temp[1]
                    break

        if self.version is not None:
            self.versionLabel = IconWithLabel(self.dwContent)

            self.versionLabel.setCursor(QtCore.Qt.PointingHandCursor)

            self.aboutLayout.addWidget(self.versionLabel)
            self.versionLabel.clicked.connect(self.openAboutWindow)

        spacer3 = QtWidgets.QSpacerItem(5, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.aboutLayout.addItem(spacer3)

        parent.addLayout(self.aboutLayout,2,0,1,1)

    def openAboutWindow(self):
        """Opens the window with the plugin metadata
        """
        if self.aboutWindow is None:
            self.aboutWindow = PluginOverviewWindow()
            self.aboutWindow.show()
            self.aboutWindow.windowClosed.connect(self.closeAboutWindow)
        else:
            self.aboutWindow.raise_()

    def closeAboutWindow(self):
        """Helper function to close the window
        """
        self.aboutWindow = None

    def loadSettings(self):
        """Loads in the settings"""
        self.settings = QgsSettings()

    def t2MenuSetup(self, tab):
        """This sets up the menu bar for tab 2, which will be there to select the basemap/label"""
        
        self.t2Menu = QtWidgets.QMenuBar(tab)
        self.t2Menu.setNativeMenuBar(False)

        # Setting the menu
        self.baseMapOption = QtWidgets.QMenu(self.t2Menu)
        self.baseMapOption.setTitle("▾ Base Map")
        self.t2Menu.addMenu(self.baseMapOption)

        # Adding basemap items
        basemaps = utils.getWmts(self.baseMapResponse)

        # Using a action group to hold each action so that only one can be checked at a time
        self.baseMapActionGroup = QtWidgets.QActionGroup(self.t2Menu)
        self.baseMapActionGroup.setExclusive(True)

        # Adding a default none basemap
        action = QtWidgets.QAction("No Base Map", self.t2Menu)
        action.setData(None)
        action.setCheckable(True)
        action.setChecked(True)
        # Need to connect this to the updateSubMenu function
        action.triggered.connect(lambda: self.updateSubMenu("Basemap"))
        self.baseMapOption.addAction(action)
        self.baseMapActionGroup.addAction(action)
        
        # Used to save all the basemap submenus for updating the check status
        self.baseMapMenus = []

        for provider in basemaps.keys():
            # Adding a submenu for each provider
            menu = CheckableQMenu(provider, self.t2Menu)
            menu.setObjectName("Basemap")
            menu.setToolTipsVisible(True)
            menu.itemSelected.connect(self.updateSubMenu)
            self.baseMapMenus.append(menu)
            
            # Adding the basemap for the provider
            for basemap in basemaps[provider]:
                action = QtWidgets.QAction(basemap["Name"], self.t2Menu)
                action.setData(basemap)
                action.setToolTip(basemap["Abstract"])
                action.setCheckable(True)
                menu.addAction(action)

                self.baseMapActionGroup.addAction(action)

            self.baseMapOption.addMenu(menu)


        self.labelOption = QtWidgets.QMenu(self.t2Menu)
        self.labelOption.setTitle("▾ Label")
        self.t2Menu.addMenu(self.labelOption)

        
        # Do the same thing for labels

        labels = utils.getWmts(self.labelResponse)
        self.labelActionGroup = QtWidgets.QActionGroup(self.t2Menu)
        self.labelActionGroup.setExclusive(True)

        action = QtWidgets.QAction("No Label", self.t2Menu)
        action.setData(None)
        action.setCheckable(True)
        action.setChecked(True)
        # Need to connect this to the updateSubMenu function
        action.triggered.connect(lambda: self.updateSubMenu("Label"))
        self.labelOption.addAction(action)
        self.labelActionGroup.addAction(action)
        
        # Stores all the label submenus so their check status can be updated later
        self.labelMenus = []

        for provider in labels.keys():
            # Adding a submenu for each provider
            menu = CheckableQMenu(provider, self.t2Menu)
            menu.setToolTipsVisible(True)
            menu.setObjectName("Label")
            menu.itemSelected.connect(self.updateSubMenu)
            self.labelMenus.append(menu)
            
            # Adding the basemap for the provider
            for label in labels[provider]:
                action = QtWidgets.QAction(label["Name"], self.t2Menu)
                action.setData(label)
                action.setToolTip(label["Abstract"])
                action.setCheckable(True)
                
                menu.addAction(action)

                self.labelActionGroup.addAction(action)

            self.labelOption.addMenu(menu)

        tab.layout().setMenuBar(self.t2Menu)
        self.t2Menu.show()

    def updateSubMenu(self, objectName):
        """Updates the submenu checked state.

        Args:
            objectName (str): object name so we know which list of menus to update
        """
        if objectName == "Basemap":
            # updating the basemap menus
            for menu in self.baseMapMenus:
                menu.updateCheckedStatus()
        elif objectName == "Label":
            for menu in self.labelMenus:
                menu.updateCheckedStatus()

    def modifyPreferencesTitle(self, changed):
        """Function to modify the preferences title depending if there is unapplied settings

        Args:
            changed (_type_): _description_
        """
        if changed:
            self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab3), "* Preferences")
        else:
            self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab3), "Preferences")

    def setupUi(self, RealEarthDockWidgetBase):
        self.loadSettings()
        # This is used to check if the about window is opened or not
        self.aboutWindow = None
        
        self.selectedProduct = ""
        # This variable is used to determine if search results needs to be changed to the category comboboxes or not.
        self.comBoxShown = True

        # This is here so people don't spam return and do multiple requests to search
        self.searchBarText = ""
        self.searchResultHandler = SearchResultHandler(self)

        # To keep track of the previous search results
        self.searchResults = []

        # setting up the base of the widget
        RealEarthDockWidgetBase.setObjectName("RealEarthDockWidgetBase")
        RealEarthDockWidgetBase.resize(448, 839)
        RealEarthDockWidgetBase.setStyleSheet("")
        self.dwContent = QtWidgets.QWidget()
        self.dwContent.setObjectName("dwContent")
        self.gridLayout = QtWidgets.QGridLayout(self.dwContent)
        self.gridLayout.setContentsMargins(0, 0, 0, 0)
        self.gridLayout.setObjectName("gridLayout")

        self.dataSetup()
        self.page_titleSetup(self.gridLayout, RealEarthDockWidgetBase)
        self.tabSetup(self.gridLayout)
        self.tab2VLayoutSetup(self.tab2)
        self.t2GSelectSetup(self.t2VLayoutWidget)
        # add spacing between two groupboxes
        self.t2VLayout.addSpacing(10)
        self.t2GTimeSetup(self.t2VLayoutWidget)

        # sets up the two button to add layer and refresh layer
        self.t2ButtonSetup(self.t2VLayout, self.t2VLayoutWidget)

        # Inside Search or Select a product will be a vertical layout
        self.selectVLayoutSetup(self.t2GSelect)
        # there is some weird padding so im including a negative spacing
        self.selectVLayout.addSpacing(-25)

        self.searchLineSetup(self.selectVLayout, self.selectVLayoutWidget)

        # adding spacing between search and the box
        self.catScrollAreaSetup(self.selectVLayout)

        self.selectVLayout.addSpacing(-5)
        #self.catComboSetup(self.catVBox, self.catWidget)
        self.categoryDropDownSetup(self.catVBox, self.catWidget)

        self.selectVLayout.addSpacing(5)

        #explaining what the dots mean
        self.explainDotsLabelSetup(self.selectVLayout)

        # removing some spacing
        self.selectVLayout.addSpacing(-10)

        # Adding the collapse expand button
        self.collapseExpandButtonSetup(self.explainLayout)

        # Time selection
        self.timeSelectionSetup(self.t2GTime)

        # layer options
        self.layerOptionsSetup(self.timeLayout)

        #about section setup
        self.aboutSetup(self.gridLayout)

        # Setting up the preferences tab
        self.preferencesBox = QtWidgets.QVBoxLayout()
        self.tab3.setLayout(self.preferencesBox)
        self.preferencesWidget = PreferencesTab(self.preferencesBox, self.settings)
        self.preferencesWidget.settingsChanged.connect(self.modifyPreferencesTitle)
        self.preferencesBox.addWidget(self.preferencesWidget)

        # Setting up the validation tab
        self.validationBox = QtWidgets.QVBoxLayout()
        self.validationBox.setAlignment(QtCore.Qt.AlignTop)
        self.tab1.setLayout(self.validationBox)
        self.validationWidget = ValidationTab(self.validationBox, self.settings)
        self.validationBox.addWidget(self.validationWidget)
        self.validationWidget.loggedIn.connect(self.loggedInHandler)
        self.validationWidget.loggedOut.connect(self.loggedOutHandler)

        # Setting up menubar
        self.t2MenuSetup(self.tab2)

        RealEarthDockWidgetBase.setWidget(self.dwContent)
        self.retranslateUi(RealEarthDockWidgetBase)
        QtCore.QMetaObject.connectSlotsByName(RealEarthDockWidgetBase)

    def loggedInHandler(self, username, accessToken):
        """Handles the login event

        Args:
            username (str): username
            accessToken (str): accessToken
        """
        self.titleLabel.setText("RealEarth-Logged In")
        
        # Switch to select layer tab since logged in
        self.tabWidget.setCurrentIndex(0)


    def loggedOutHandler(self):
        """Handles the logout event
        """
        self.titleLabel.setText("RealEarth-Guest")
        

    def retranslateUi(self, RealEarthDockWidgetBase):
        _translate = QtCore.QCoreApplication.translate

        # tab title setup
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab1), _translate("RealEarthDockWidgetBase", "Login"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab2), _translate("RealEarthDockWidgetBase", "Select Layer"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab3), _translate("RealEarthDockWidgetBase", "Preferences"))
        self.t2GSelect.setTitle(_translate("RealEarthDockWidgetBase", f"Select a Product ({len(self.categories)} Categories)"))
        self.t2GTime.setTitle(_translate("RealEarthDockWidgetBase", "Select a Product From Above"))
        self.addLayerButton.setText(_translate("RealEarthDockWidgetBase", "Add Layer(s)"))
        self.titleLabel.setText(_translate("RealEarthDockWidgetBase", "<html><head/><body><p><span style=\" font-size: 15px;\">RealEarth-Guest</span></a></p></body></html>"))
        self.ssecTextLabel.setText(_translate("RealEarthDockWidgetBase", f"<html><head/><body><p><a href=\"{SSEC_ABOUT_URL}\"><span style=\" font-weight:600; font-size: 12px; text-decoration: underline; color: #213F82\">About SSEC</span></a></p></body></html>"))
        self.realEarthTextLabel.setText(_translate("RealEarthDockWidgetBase", f"<html><head/><body><p><a href=\"{RE_ABOUT_URL}\"><span style=\" font-weight:600; font-size: 12px; text-decoration: underline; color: #213F82\">About RealEarth</span></a></p></body></html>"))
        self.versionLabel.textLabel.setText(_translate("RealEarthDockWidgetBase", f"<html><head/><body><p><span style=\" font-size: 12px;\">Version: {self.version}</span></a></p></body></html>"))


if __name__ == "__main__":
    import sys
    app = QtWidgets.QApplication(sys.argv)
    RealEarthDockWidgetBase = QtWidgets.QDockWidget()

    #importing styling
    #with open('style/styles.qss') as f:
    #    app.setStyleSheet(f.read())
    ui = Ui_RealEarthDockWidgetBase()
    ui.setupUi(RealEarthDockWidgetBase)
    RealEarthDockWidgetBase.show()
    sys.exit(app.exec_())
