from PyQt5.QtWidgets import QLineEdit, QCompleter, QHBoxLayout, QGraphicsDropShadowEffect, QWidget, QAction
from PyQt5.QtCore import Qt, QEvent
from PyQt5.QtGui import QColor, QIcon, QPixmap
from qgis.core import QgsMessageLog
import os

class SearchBar(QWidget):
    def __init__(self, model, placeholder, parent=None):
        super(SearchBar, self).__init__(parent)
        self.setObjectName("searchBarWidget")

        #initializing the ui
        # Setting up a horizontal layout to fit both search bar and cancel button
        self.hbox = QHBoxLayout()
        self.setLayout(self.hbox)

        self.searchBar = QLineEdit(self)
        self.searchBar.setObjectName("searchBar")
        self.searchBar.setPlaceholderText(placeholder)
        self.searchBar.installEventFilter(self)

        # adding a dropshadow effect so it looks a little nicer
        shadow = QGraphicsDropShadowEffect()
        shadow.setBlurRadius(3)
        shadow.setXOffset(0)
        shadow.setYOffset(2)
        shadow.setColor(QColor(0, 0, 0, 100))
        self.searchBar.setGraphicsEffect(shadow)

        # Setting the mechanism for the autocomplete suggestions
        self.completer = QCompleter(self.searchBar)
        self.completer.setModel(model)
        self.completer.setCaseSensitivity(Qt.CaseInsensitive)

        self.searchBar.setCompleter(self.completer)

        # Adding Icon
        path = os.path.join(os.path.dirname(os.path.realpath(__file__)), "../images/icons.png")
        self.searchBar.addAction(self.extractIcon(path, 10*16, 7*16, 16, 16), QLineEdit.LeadingPosition)

        # clear button only showed up when focus in
        self.clearButton = QAction(self)
        self.clearButton.setIcon(self.extractIcon(path, 2*16, 12*16, 16, 16))
        #self.clearButton.triggered.connect(self.searchBar.clear)

        self.searchBar.addAction(self.clearButton, QLineEdit.TrailingPosition)
        self.clearButton.setVisible(False)
        self.clearButton.setToolTip("Clear Search and Reset Categories")

        self.hbox.addWidget(self.searchBar)
        #self.hbox.addWidget(self.cancelButton)

    def eventFilter(self, obj, event):
        """This function handles the showing up and removal of the clear button when focus in and out is triggered"""
        # focus in means that search bar is activated for typing
        if event.type() == QEvent.FocusIn and obj is self.searchBar:
            self.clearButton.setVisible(True)

        if event.type() == QEvent.FocusOut and obj is self.searchBar and not self.searchBar.text():
            self.clearButton.setVisible(False)
        return super(SearchBar, self).eventFilter(obj, event)

    def extractIcon(self, path, x, y, width, height):
        """This function extracts an icon from the given image

        Args:
            path (_type_): path to the image
            x (_type_): x coord
            y (_type_): y coord
            width (_type_): width of the icon
            height (_type_): height of the icon
        """

        pixmap = QPixmap(path)
        return QIcon(pixmap.copy(x, y, width, height))





