from PyQt5.QtWidgets import QLabel, QApplication
from PyQt5.QtCore import Qt

class HoverLabel(QLabel):
    """This class is only here so that I can change the cursor when the mose is over the info icon

    Args:
        QLabel (_type_): _description_
    """
    def __init__(self, parent=None):
        """overrides the __init__ method to set mouse tracking

        Args:
            parent (_type_, optional): _description_. Defaults to None.
        """
        super().__init__(parent)
        self.setMouseTracking(True)  # Enable mouse tracking

    def enterEvent(self, event):
        """Enter event handler. changes cursor to the one with quesiton mark beside it

        Args:
            event (_type_): _description_
        """
        QApplication.setOverrideCursor(Qt.WhatsThisCursor)
        super().enterEvent(event)

    def leaveEvent(self, event):
        """Leave Event handler. chagnes the cursor back to original

        Args:
            event (_type_): _description_
        """
        QApplication.restoreOverrideCursor()
        super().leaveEvent(event)