from .SearchResult import SearchResult
from PyQt5.QtCore import QTimer, pyqtSignal
from ..constants import ICON_URL
from qgis.core import QgsMessageLog

class SearchResultHandler():
    """This could've been in the main ui class, but its way too complicated so im creating a separate class for it.
    """
    updateFav = pyqtSignal(list)
    def __init__(self, master):
        self.master = master
        self.timer = QTimer()
        self.timer.timeout.connect(self.updateIcons)
        self.timer.start(100)
        self.results = []

    def addResultLabels(self, results, max):
        """This function creates all the searchResult widgets

        Args:
            results (_type_): The list of results that was retrieved
            max (_type_): The max number of results to add
        """
        # Starts to add the results
        for i in range(min(results.qsize(),max)):
            result = results.get()
            resultId = result[2]
            iconUrl = ICON_URL.format(id=resultId)
            searchResult = SearchResult(result, iconUrl, self.master.theme, self.master.catWidget)
            searchResult.updateFav.connect(self.updateFavHandler)
            searchResult.leftClicked.connect(self.createResult(result))
            self.master.searchResults.append(searchResult)
            self.master.catVBox.addWidget(searchResult)

        self.results = self.master.searchResults
        self.timer.start(100)

    def updateFavHandler(self, item):
        """This just calls teh master function

        Args:
            item (_type_): item to update
        """
        self.master.updateFav(item)

    def createResult(self, result):
        """this is just a helper function to prevent the resultClickedHandler from being accidentally triggered"""
        return lambda: self.resultClickedHandler(result)

    def removeAllResults(self):
        """ Removes all the search result widgets """
        # stops timer so it stops trying to retrieve iamges
        self.timer.stop()
        for i in self.master.searchResults:
            self.master.catVBox.removeWidget(i)
            i.deleteLater()


        self.results = []
        self.master.searchResults = []

    def updateIcons(self):
        """This updates the icon
        """
        if not self.master.settings.value("realEarth/iconToggle", True, type=bool):
            return
        allLoaded = True
        for result in self.results:
            if not result.loadIcon():
                allLoaded = False
        if allLoaded:
            self.timer.stop()

    def resultClickedHandler(self, result):
        """Calls the master function to handle the popup of time selection."""
        self.master.selectedProduct = result[1]
        # passes in a duple (name, id, showlegend)
        self.master.timeSearchAndUpdateList((result[1],result[2], result[6]))