# -*- coding: utf-8 -*-
"""
/***************************************************************************
 RealCentroidDialog
                                 A QGIS plugin
 Create internal point for a polygon layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-12-01
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Zotan Siki
        email                : siki1958@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5 import QtCore

from qgis.core import QgsMapLayerProxyModel, QgsSettings
from qgis.gui import QgsEncodingFileDialog

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'realcentroid_dialog_base.ui'))


class RealCentroidDialog(QtWidgets.QDialog, FORM_CLASS):
    """ dialog class for realcentroid QGIS3 plugin """
    def __init__(self, parent=None):
        """Constructor."""
        super(RealCentroidDialog, self).__init__(parent)
        self.setupUi(self)
        self.encoding = None
        self.layerBox.currentIndexChanged.connect(self.sel)
        self.browseButton.clicked.connect(self.browse)
        self.cancelBtn.clicked.connect(self.reject)
        self.okBtn.clicked.connect(self.ok)

    def showEvent(self, event):
        """ initialize dialog widgets """

        # filter polygonlayers
        self.layerBox.setFilters(QgsMapLayerProxyModel.PolygonLayer)
        # clear previous pointlayer
        self.pointEdit.clear()
        self.sel()

    def sel(self):
        """ check/uncheck selectBox if selected layer changed """
        l = self.layerBox.currentLayer()
        try:
            sf = l.selectedFeatures()
        except:
            sf = None
        if sf: # is not None and len(sf):
            self.selectedBox.setEnabled(True)
            self.selectedBox.setCheckState(QtCore.Qt.Checked)
        else:
            self.selectedBox.setEnabled(False)
            self.selectedBox.setCheckState(QtCore.Qt.Unchecked)

    def browse(self):
        """ open save layer dialog """
        settings = QgsSettings()
        dirName = settings.value("/UI/lastShapefileDir")
        encode = settings.value("/UI/encoding")
        fileDialog = QgsEncodingFileDialog(self, "Output shape file", dirName,
                                           "Shape file (*.shp)", encode)
        fileDialog.setDefaultSuffix("shp")
        fileDialog.setFileMode(QtWidgets.QFileDialog.AnyFile)
        fileDialog.setAcceptMode(QtWidgets.QFileDialog.AcceptSave)
        #fileDialog.setConfirmOverwrite(True)
        if not fileDialog.exec_() == QtWidgets.QDialog.Accepted:
            return
        files = fileDialog.selectedFiles()
        self.pointEdit.setText(files[0])
        self.encoding = fileDialog.encoding()

    def ok(self):
        """ check widgets """
        if len(self.layerBox.currentText()) == 0:
            QtWidgets.QMessageBox.warning(self, "Realcentroid", \
                QtWidgets.QApplication.translate("RealCentroid", \
                "No polygon layer selected", None))
            return
        if len(self.pointEdit.text()) == 0:
            QtWidgets.QMessageBox.warning(self, "Realcentroid", \
                QtWidgets.QApplication.translate("RealCentroid", \
                "No point layer given", None))
            return
        self.accept()
