# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ReadOnlySwitcher
                                 A QGIS plugin
Read-Only Switcher enables you to quickly toggle the read-only flag for one 
or more selected vector layers directly from the Layers panel, eliminating 
the need to open the Project Properties dialog.

When multiple layers with mixed read-only statuses are selected, the plugin 
sets all layers to read-only by default to ensure data safety.

Raster layers and non-vector layers are automatically excluded from the 
toggling process, with clear notifications to the user.

This tool streamlines layer management, protects your data from accidental 
edits, and is especially useful in collaborative environments where different 
users may need different editing permissions on the same project.


 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Lei Ding
        email                : lleidding@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'read_only_switcher_dialog_base.ui'))


class ReadOnlySwitcherDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(ReadOnlySwitcherDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
