# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ReadOnlySwitcher
                                 A QGIS plugin
Read-Only Switcher enables you to quickly toggle the read-only flag for one 
or more selected vector layers directly from the Layers panel, eliminating 
the need to open the Project Properties dialog.

When multiple layers with mixed read-only statuses are selected, the plugin 
sets all layers to read-only by default to ensure data safety.

Raster layers and non-vector layers are automatically excluded from the 
toggling process, with clear notifications to the user.

This tool streamlines layer management, protects your data from accidental 
edits, and is especially useful in collaborative environments where different 
users may need different editing permissions on the same project.


 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Lei Ding
        email                : lleidding@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load ReadOnlySwitcher class from file ReadOnlySwitcher.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    from .read_only_switcher import ReadOnlySwitcher
    return ReadOnlySwitcher(iface)
