# -*- coding: utf-8 -*-

import os

from qgis.gui import *
from qgis.core import *
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import *

VIEW_ENGINE = None
try:
    from qgis.PyQt.QtWebKitWidgets import QWebView
    VIEW_ENGINE = 'WebKit'
except:    
    try:
        from qgis.PyQt.QtWebEngineWidgets import QWebEngineView
        VIEW_ENGINE = 'WebEngine'
    except:
        VIEW_ENGINE = None

from qgis.PyQt.QtPrintSupport import QPrinter


FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'base.ui'))


class rdiNotice(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        super(rdiNotice, self).__init__()
        self.setupUi(self)
        layout = QtWidgets.QVBoxLayout()
        layout.setAlignment(Qt.AlignmentFlag.AlignTop)
        self.dockWidgetContents.setLayout(layout)
        self.setWindowTitle("RDI - Manuel d'utilisation")
        self.layout = layout
        self.parent = parent
        self.root = os.path.join(os.path.dirname(__file__), "help")
        self.imageFolder = os.path.join(os.path.dirname(__file__), "images")
        self.ressources = os.path.join(self.root, "ressources")
        self.affHTML()
        self.affNavButton()

    def affHTML(self):
        self.file = os.path.join(self.root, "notice.htm")
        self.url = QUrl.fromLocalFile(self.file)
        if VIEW_ENGINE is None:
            self.affNav()
            l = QtWidgets.QLabel("Erreur de chargement du moteur de visualisation intégré des pages web\nLa notice sera accessible seulement via le navigateur")
            l.setWordWrap(True)
            self.layout.addWidget(l)
            return
        if VIEW_ENGINE=='WebKit':
            self.view = QWebView(self)
            self.view.settings().setUserStyleSheetUrl(QUrl.fromLocalFile(os.path.join(self.ressources, "notice.css")))
            self.view.settings().setUserStyleSheetUrl(QUrl.fromLocalFile(os.path.join(self.ressources, "nav.css")))
        if VIEW_ENGINE=='WebEngine':
            self.view = QWebEngineView(self)
        screen = QtWidgets.QDesktopWidget().availableGeometry()
        self.view.setFixedHeight(screen.height()-80)
        self.view.load(self.url)
        self.layout.addWidget(self.view)
    
    def affNavButton(self):
        hbox = QtWidgets.QHBoxLayout()
        l = QtWidgets.QLabel(" ")
        hbox.addWidget(l)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "browser.png"))
        butt = QtWidgets.QPushButton(ico, "   Afficher dans un navigateur")
        butt.setMaximumWidth(200)
        butt.clicked.connect(self.affNav)
        self.layout.addLayout(hbox)
        hbox.addWidget(butt)
        l = QtWidgets.QLabel(" ")
        hbox.addWidget(l)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "print.png"))
        butt = QtWidgets.QPushButton(ico, "   Imprimer en PDF")
        if VIEW_ENGINE is None:
            butt.setEnabled(False)
        butt.setMaximumWidth(200)
        butt.clicked.connect(self.affPdf)
        self.layout.addLayout(hbox)
        hbox.addWidget(butt)
        l = QtWidgets.QLabel(" ")
        hbox.addWidget(l)
    
    def actuPage(self, tag=None):
        if tag and tag!="":
            self.tag = tag
            self.url.setFragment(tag)
            if VIEW_ENGINE is None:
                self.affNav()
                return
            self.view.load(self.url)
    
    def actuLabel(self):
        self.label.setText(self.url.toString())
    
    def affNav(self):
        QtGui.QDesktopServices.openUrl(self.url)
        
    def affPdf(self):
        if VIEW_ENGINE is None:
            return
        saveLocation = os.path.join(self.root, "RDI_notice.pdf");
        printer = QPrinter(QPrinter.HighResolution)
        printer.setOutputFileName(saveLocation)
        if VIEW_ENGINE=='WebKit':
            self.view.page().mainFrame().evaluateJavaScript("flat();")
            self.view.print(printer)
            self.view.page().mainFrame().evaluateJavaScript("unflat();")
        if VIEW_ENGINE=='WebEngine':   
            self.view.page().mainFrame().runJavaScript("flat();")
            self.view.print(printer)
            self.view.page().mainFrame().runJavaScript("unflat();")
        QtGui.QDesktopServices.openUrl(QUrl.fromLocalFile(saveLocation))
        
    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()
