# -*- coding: utf-8 -*-

import os, sys, configparser, shutil, zipfile
from functools import partial

from qgis.gui import *
from qgis.core import *
from PyQt5 import QtGui, QtWidgets, uic, QtNetwork, QtXml, QtDesigner
from PyQt5.QtCore import *
from qgis.utils import iface

from .rdi_tools import flashMsg
from .rdi_meta import rdiMeta


class rdiMaj(QObject):

    def __init__(self):
        QObject.__init__(self)
        self.meta = rdiMeta()
        self.name = self.meta.getName()
        self.version = ""
        self.dispo = False
        
    def test(self):
        return
        self.testRepository()
        # self.meta.writeIni("name", self.name)
    
    def testRepository(self):
        urls = []
        urls.append('http://piece-jointe-carto.developpement-durable.gouv.fr/DEPT067A/QGIS/plugins/plugins.xml')
        v = Qgis.QGIS_VERSION.split('.')
        urls.append('https://plugins.qgis.org/plugins/plugins.xml?qgis='+v[0]+'.'+v[1])
        for url in urls:
            if self.dispo: break
            self.repository = url
            self.doRequest(url) 
    
    def aff(self):
        msg = f"Une nouvelle version du plugin {self.name} est disponible. Allez dans le menu des extensions pour faire la mise à jour."
        # icoPath = os.path.join(os.path.dirname(__file__), 'images', "plugin.png")
        # flashMsg(msg, category='error', button=self.loadPluginManager, buttonIco=icoPath)  
        flashMsg(msg, category='error')  
                    

    def loadPluginManager(self):
        repositories = "app/plugin_repositories/"
        manager = iface.pluginManagerInterface()
        manager.clearRepositoryList()
        manager.clearPythonPluginMetadata()
        
        s = QSettings() 
        s.beginGroup(repositories)
        list = s.childGroups()
        s.endGroup()
        for r in list:
            repo = {"name": r}
            s.beginGroup(repositories+r)
            keys = s.childKeys()
            for k in keys:
                repo[k] = str(s.value(k))
            s.endGroup()
            print(repo)
            # repo = {
                    # "name": r,
                    # "url": self.repository,
                    # "enabled": 'true',
                    # "valid": 'true',
                    # "state": '1',
                    # "inspection_filter": "true"
                # }
            manager.addToRepositoryList(repo)
        manager.reloadModel()
        manager.showPluginManager(3)


    
    def compare(self):
        ref = self.meta.getVersion().split('.')
        new = self.version.split('.')
        for i in range(len(new)):
            n = int(new[i])
            if i<len(ref):
                r = int(ref[i])
                if r>n:
                    return False
                if r<n:
                    return True
            else:
                return True

    def doRequest(self, url):
        req = QtNetwork.QNetworkRequest(QUrl(url))
        self.nam = QtNetwork.QNetworkAccessManager()
        self.nam.finished.connect(self.handleResponse)
        self.nam.get(req)

    def handleResponse(self, reply):
        er = reply.error()
        if er == QtNetwork.QNetworkReply.NoError:
            bytes_string = reply.readAll()
            self.lookIn(str(bytes_string, 'utf-8'))
        else:
            # print("Error occured: ", er)
            # print(reply.errorString())
            pass

    def lookIn(self, txt):
        xml = QtXml.QDomDocument()
        xml.setContent(txt)
        tag = "pyqgis_plugin"
        nodes = xml.elementsByTagName(tag)
        for n in range(nodes.count()):
            if self.dispo: break
            node = nodes.at(n)
            name = node.toElement().attribute("name")
            if name==self.name:
                print(name)
                self.version = node.toElement().attribute("version")
                if self.compare():
                    self.dispo = True
                    self.aff()
                break

    def manager(self):
        # manager = QtDesigner.QExtensionManager()
        # plugin = manager.findChild(self.name)
        # print(plugin)
        
        pass
        
        
        










