# -*- coding: utf-8 -*-

import sys, os, json, traceback
from functools import partial

from qgis.gui import *
from qgis.core import *
from qgis.utils import iface
from PyQt5 import QtGui, QtWidgets, uic, QtXml, QtSvg
from PyQt5.QtCore import *

from .rdi_param import rdiParam, rdiBaseParam
from .rdi_tools import *
from .rdi_trade import rdiTrade
from .rdi_async import mGlobalTask, manageTasks
from .rdi_layer import rdiLayer, rdiLayerField
from .rdi_statistic import rdiStatLayer


class rdiAdmin(QObject):

    dataChanged = pyqtSignal(int)
    datasChanged = pyqtSignal(list)

    def __init__(self, parent):
        QObject.__init__(self)
        self.dock = parent
        self.psql = parent.psql
        self.pdb = rdiBaseParam(self.psql)
        self.trade = rdiTrade(self)
        self.freeze = False
        self.actuParams()
        self.initData()
        self.imageFolder = os.path.join(os.path.dirname(__file__),'images')
        self.root = os.path.dirname(__file__).replace("\\","/")
        self.run()
    
    def actuParams(self):
        self.param = rdiParam()
        self.memoSchema = self.param.get('schema', 'CONN')  
        self.fullAdmin = self.psql.full(self.param.get('tableAdmin'), self.param.get('schema','ADMIN'))
    
    def tableView(self):
        pass
    
    def menu(self):
        self.popMenu = QtWidgets.QMenu()
        self.popMenu.addAction(QtGui.QIcon(os.path.join(self.imageFolder, "table.png")), "Voir la table", partial(self.psql.openDialog, 'gestionList'))
        self.popMenu.popup(QtGui.QCursor.pos())
    
    def run(self):
        self.widget = QtWidgets.QWidget()
        self.layout = QtWidgets.QVBoxLayout(self.widget)
        self.layout.setSpacing(0)
        self.layout.setContentsMargins(0,0,0,0)
        self.initList()
        
        self.action = adminWidget(self.translator['action']['mod'], self.makeAction)
        self.item = adminWidget()
        self.filter = adminWidget(None, self.refreshElementList)
        self.element = adminWidget(None, self.makeModificationElement)
        self.mode = adminWidget('Postgis', self.makeInsertionMode)
        self.table = adminWidget(None, self.checkTableName)
        self.schema = adminWidget(self.psql.PGschema)
        self.layer = adminWidget(None, self.actuTableName)
        self.dump = adminWidget()
        self.layerFilter = adminWidget()
        
        self.eltName = adminWidget(None, self.autoNomAff)
        self.eltParent = adminWidget(None, self.autoNomAff)
        self.eltAssoc = adminWidget()
        self.eltBloc = adminWidget()
        self.eltBlocRenameChoice = adminWidget()
        self.eltBlocRenameValue = adminWidget()
        self.eltTags = adminWidget()
        self.eltCluster = adminWidget()
        self.eltCode = adminWidget(None, self.codeChanged)
        self.eltStyle = adminWidget(None, self.autoStyle)
        self.eltStyleFill = adminWidget()
        self.eltStyleSvg = adminWidget()
        self.eltStyleEdit = adminWidget()
        self.eltStyleSize = adminWidget()
        self.eltOrder = adminWidget()
        
        self.modWidget = {'on':False}
        self.modWidget['butt'] = adminWidget()
        self.modWidget['list'] = [self.eltName, self.eltParent, self.eltTags, self.eltCode, self.eltBloc, self.eltCluster, self.eltStyle, self.eltStyleFill, self.eltStyleSvg, self.eltStyleEdit, self.eltStyleSize, self.eltOrder]
        for w in self.modWidget['list']:
            w.changed.connect(self.enabledModButton)
        
        # l = QtWidgets.QLabel("Gestion des données")
        l = dblClickLabel("Gestion des données")
        l.rightClick.connect(self.menu)
        font = QtGui.QFont()
        font.setBold(True)
        l.setFont(font)
        self.layout.addWidget(l)
        
        
        sc = QtWidgets.QScrollArea()
        sc.setWidgetResizable(True)
        self.layout.addWidget(sc)
        w = QtWidgets.QWidget()
        w.setObjectName("scrollAreaWidgetContents")
        gbox = QtWidgets.QVBoxLayout()
        gbox.setSpacing(0)
        gbox.setContentsMargins(0,0,0,0)
        gbox.setAlignment(Qt.AlignTop)
        w.setLayout(gbox)
        sc.setWidget(w)
        sc.setStyleSheet("QAbstractScrollArea {background-color: transparent;}  ");
        w.setStyleSheet("QWidget#scrollAreaWidgetContents {background-color: white; } ");
        # w = QtWidgets.QWidget()
        # self.layout.addWidget(w)     
        # gbox = QtWidgets.QVBoxLayout(w)
        # gbox.setSpacing(0)
        # gbox.setContentsMargins(0,0,0,0)
        # gbox.setAlignment(Qt.AlignTop)
        
        
        
        wl = QtWidgets.QWidget()
        gbox.addWidget(wl)
        hbox = QtWidgets.QHBoxLayout(wl)
        
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "back.png"))
        butt = QtWidgets.QPushButton(ico, "")
        butt.setToolTip("Revenir aux modifications des couches existantes")
        butt.setMaximumWidth(30)
        butt.clicked.connect(partial(self.action.set, self.translator['action']['mod']))
        hbox.addWidget(butt)
        self.modButton = butt
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "add.png"))
        butt = QtWidgets.QPushButton(ico, "")
        butt.setToolTip("Ajouter une nouvelle couche")
        butt.setMaximumWidth(30)
        butt.clicked.connect(partial(self.action.set, self.translator['action']['add']))
        hbox.addWidget(butt)
        self.addButton = butt
        self.addLabel = QtWidgets.QLabel(self.translator['action']['add'])
        hbox.addWidget(self.addLabel)
        hbox.setAlignment(self.addLabel, Qt.AlignRight)
        
        combo = QtWidgets.QComboBox()
        combo.hide()
        hbox.addWidget(combo)
        for e in self.translator['action']['list']:
            s = self.translator['action'][e]
            combo.addItem(s, s)
        self.action.setWidget(combo)
        # ico = QtGui.QIcon(os.path.join(self.imageFolder,'switch.png'))
        # list = []
        # for e in self.translator['action']['list']:
            # list.append((ico, self.translator['action'][e]))
        # butt = toggleButton(list)
        # hbox.addWidget(butt)
        # self.action.setWidget(butt)
        
        self.action.setLayout(self.makeLayout(gbox))
        combo = QtWidgets.QComboBox()
        for s in self.itemList:
            n = self.param.get(s)
            img = os.path.join(self.imageFolder,f"{s}.png")
            if os.path.exists(img):
                combo.addItem(QtGui.QIcon(img), n, s)
            else:
                combo.addItem(n, s)
        hbox.addWidget(combo)
        self.item.setWidget(combo)
        filter = QtWidgets.QLineEdit()
        filter.setClearButtonEnabled(True)
        filter.setPlaceholderText("Mots-clefs du filtre ici")
        hbox.addWidget(filter)
        # l = QtWidgets.QLabel()
        # hbox.addWidget(l)
        # filter.img = l
        # src = os.path.join(self.imageFolder,'filter.png')
        # pixmap = QtGui.QPixmap(src)
        # pixmap = pixmap.scaledToHeight(20)
        # l.setPixmap(pixmap)
        self.filter.setWidget(filter)
        self.memoId = None
        self.freeze = False
        self.dialogSVG = None
        self.action.restore()
        
        # l = QtWidgets.QLabel("\n\n")
        # gbox.addWidget(l)
        
    def reconnectButton(self): 
        wl = QtWidgets.QWidget()
        self.layout.addWidget(wl)
        vbox = QtWidgets.QVBoxLayout(wl)
        l = QtWidgets.QLabel()
        vbox.addWidget(l)
        l = QtWidgets.QLabel("A la fin du paramétrage, il est conseillé de reconnecter le plugin pour prendre en compte les modifications")
        l.setWordWrap(True)
        font = QtGui.QFont()
        font.setItalic(True)
        l.setFont(font)
        vbox.addWidget(l)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "plug.png"))
        butt = QtWidgets.QPushButton(ico, " Reconnecter")
        butt.setMaximumWidth(150)
        vbox.addWidget(butt)
        vbox.setAlignment(butt, Qt.AlignCenter)
        wl.butt = butt 
        self.reconnect = wl
        self.reconnect.hide()
        return wl
    
    
    def initList(self, psql=None):
        if psql is None:
            psql = self.psql
        self.itemList = ['enjeu', 'alea', 'stats', 'link']
        self.listElement = []
        self.dictElement = {}
        self.alias = {}
        self.bloc = {}
        blocDict = {}
        for c in self.itemList:
            self.alias[c] = [(" ",'NULL')]
            self.bloc[c] = [(" ",'NULL')]
            blocDict[c] = {}
        memo = {}
        for elt in psql.getTableAdmin(compact=True):             
            id = elt.get('id')
            code = elt.get('code')
            name = elt.get('name')
            table = elt.get('tablename')
            bloc = elt.get('bloc')
            if not code:
                continue
            if not name:
                name = table
            memo[elt['id']] = name
            parent = elt.get('parent')
            aff = name
            if not name or name=="":
                aff = table
            if not table:
                aff = f"Zone → {name} "
                a = name
                # if bloc and bloc!='':
                    # a = f"[{bloc}] {name}"
                self.alias[code].append((a, id))
            if parent:
                aff = f"{memo[parent]} ({aff})"
            if bloc:
                bloc = bloc.strip()
                if bloc!='' and bloc not in blocDict[code]:
                    self.bloc[code].append((bloc, bloc))
                    blocDict[code][bloc] = True    
                if bloc!='':
                    aff = f"[{bloc}] : {aff}"
            elt['nom_aff'] = aff
            self.dictElement[id] = elt  
            self.listElement.append({'aff':aff, 'code':self.param.get(code), 'elt':elt})
            
    def makeLayout(self, parent, scroll=False):
        w = QtWidgets.QWidget()
        if isinstance(parent, adminWidget):
            parent = parent.layout
        if scroll:
            sc = QtWidgets.QScrollArea()
            sc.setWidgetResizable(True)
            parent.addWidget(sc)
            sc.setWidget(w)
            sc.setStyleSheet("QAbstractScrollArea {background-color: transparent;}  ");
            w.setObjectName("scrollAreaWidgetContents")
            w.setStyleSheet("QWidget#scrollAreaWidgetContents {background-color: white; } ");
        else:
            parent.addWidget(w)
        layout = QtWidgets.QVBoxLayout(w)
        margins = layout.contentsMargins()
        margins.setTop(0)
        margins.setBottom(0)
        layout.setContentsMargins(margins)
        layout.setAlignment(Qt.AlignTop)
        return layout
        

        
 
    def makeAction(self):
        action = self.action.get()
        if action==self.translator['action']['add']:
            self.item.widget.show()
            self.modButton.show()
            self.addLabel.show()
            self.addButton.hide()
            self.filter.widget.hide()
            # self.filter.widget.img.hide()
            self.makeInsertion()
        if action==self.translator['action']['mod']:
            self.item.widget.hide()
            self.modButton.hide()
            self.addLabel.hide()
            self.addButton.show()
            self.filter.widget.show()
            # self.filter.widget.img.show()
            self.makeModification()
        
    def relodAfterChanged(self):
        # self.reconnect.show()
        try:
            id = self.element.get().get('id')
        except:
            id = None
        self.dataChanged.emit(id)
    
    
    
    
    
    
    # INSERTION
    def makeInsertion(self):
        combo = QtWidgets.QComboBox()
        for s in [('Postgis', 'postgis.png'), ('Qgis', 'qgis.png'), ('Fichier', 'folder.png')]:
            img = os.path.join(self.imageFolder,s[1])
            combo.addItem(QtGui.QIcon(img), s[0], s[0])
        self.mode.setWidget(combo)
        self.action.add(self.mode.widget)
        self.mode.setLayout(self.makeLayout(self.action))
        self.mode.restore()


    def makeInsertionMode(self):
        mode = self.mode.get()
        if mode=='Postgis':
            self.makeInsertionPostgis()
        if mode=='Qgis':
            self.makeInsertionQgis()
        if mode=='Fichier':
            self.makeInsertionFichier()
    
    def saveInsertionMode(self):
        code = self.item.get()
        mode = self.mode.get()
        schema = self.schema.get()
        table = self.table.get()
        if not schema or not table:
            return
        if self.noInstance and self.noInstance.isChecked():
            self.psql.sqlInsert(f"DROP TABLE IF EXISTS {self.psql.full(table, schema)} CASCADE", True)
        if mode=='Postgis':
            QTimer.singleShot(1000, partial(self.endInsertion, self.psql.full(table, schema)))
        if mode=='Qgis':
            layer = self.layer.get()
            dump = self.dump.get() and self.dump.widget.isVisible()
            table = self.trade.createTableFromFeatures(layer, table, schema, self.endInsertion, dump)
        if mode=='Fichier':
            layer = self.layer.get()
            dump = self.dump.get() and self.dump.widget.isVisible()
            table = self.trade.createTableFromFile(layer, table, schema, self.endInsertion, dump) 
        if table:
            if self.noInstance and self.noInstance.isChecked():
                sql = f"SELECT id FROM {self.fullAdmin}" + \
                    f" WHERE tablename='{table}' AND schemaname='{schema}'"
            else:
                sql = f"INSERT INTO {self.fullAdmin} (code, tablename, schemaname)" + \
                    f" VALUES ('{code}', '{table}', '{schema}')" + \
                    f" RETURNING id"
            id = self.psql.sqlInsert(sql, True)
            if id!=None:
                self.initList()
                self.viewElt(id)
                self.relodAfterChanged()
    
    def zipDetection(self):
        self.zipzones = {}
        clearLayout(self.zipList.layout())
        w = QtWidgets.QWidget()
        self.zipList.layout().addWidget(w)
        form = QtWidgets.QFormLayout(w)
        form.setContentsMargins(0,0,0,0) 
        nb = 0
        for l in self.dock.parent.iface.layerTreeView().selectedLayers():
            n = l.name().split('_')
            if len(n)!=3: continue
            hydro = n[1]
            if hydro not in self.zipzones:
                wf = QtWidgets.QComboBox()
                wf.setEditable(True)
                wf.setInsertPolicy(QtWidgets.QComboBox.InsertAlphabetically)
                self.eltParent.setWidget(wf)
                self.refreshParentList(code='alea')
                self.eltParent.setWidget(None)
                form.addRow(hydro,wf)
                self.zipzones[hydro] = wf
                
                for f in l.getFeatures():
                    try:
                        wf.setCurrentText(f.attribute('LbStationHydro'))
                        break
                    except: pass
                wf.lst = []
            wf.lst.append(l)
            nb += 1
        if nb>0:
            s = "s" if nb>1 else ""
            self.zipList.layout().addWidget(QtWidgets.QLabel(f"{nb} couche{s} compatible{s}"))
            butt = QtWidgets.QPushButton("Charger les couches")
            butt.setFixedSize(130, 30)
            self.zipList.layout().addWidget(butt)
            self.zipList.layout().setAlignment(butt, Qt.AlignCenter)
            butt.clicked.connect(self.zipLoader)  
        else:
            self.zipList.layout().addWidget(QtWidgets.QLabel(f"Aucune couche compatible"))
    
    def zipLoader(self):
        for hydro,w in self.zipzones.items():
            name = w.currentText().strip()
            if name=='': continue
            sql = f"SELECT id FROM {self.fullAdmin} WHERE (tablename is null or tablename='') and name='{name}'"
            parent = self.psql.sqlInsert(sql)
            if not parent:
                sql = f"INSERT INTO {self.fullAdmin} (code, name)" + \
                    f" VALUES ('alea', '{self.encaps(name)}')" + \
                    f" RETURNING id"
                parent = self.psql.sqlInsert(sql)
            for l in w.lst:
                n = l.name().split('_')
                schema = self.schema.get()
                table = self.trade.createTableFromFeatures(l, l.name(), schema, self.endInsertion)
                if table:
                    try: 
                        alias = str(int(n[2])/1000).replace('.','m')
                        try: 
                            if len(alias.split('m')[1])<2:
                                alias += "0"
                        except: pass
                    except: alias = n[2]
                    sql = f"SELECT id FROM {self.fullAdmin}" + \
                        f" WHERE tablename='{table}' AND schemaname='{schema}'"
                    id = self.psql.sqlInsert(sql, True)
                    if not id: 
                        sql = f"INSERT INTO {self.fullAdmin} (tablename, schemaname)" + \
                            f" VALUES ('{table}', '{schema}')" + \
                            f" RETURNING id"
                        id = self.psql.sqlInsert(sql, True)
                    if id:
                        sql = f"UPDATE {self.fullAdmin} SET code='alea', name='{self.encaps(alias)}', " + \
                            f" parent={parent}, bloc='{self.encaps(n[0])}' WHERE id={id}"
                        self.psql.sqlInsert(sql, True)
            self.initList()
            self.relodAfterChanged()        
    
    def viewElt(self, id=None):
        self.memoId = id
        self.action.set(self.translator['action']['mod'])
        
    def switchToElt(self, id=None):
        self.action.set(self.translator['action']['mod'])
        self.element.set({'id':id})
    
    def checkTableName(self):
        table = self.table.get()
        schema = self.schema.get()
        if self.table.error!=None:
            clearLayout(self.table.error)
            if self.psql.isTable(table, schema):
                l = QtWidgets.QLabel(f"La table est existante et sera écrasée")
                font = QtGui.QFont()
                font.setItalic(True)
                l.setFont(font)
                self.table.error.addWidget(l)
        self.refreshInstances()
        self.refreshDumpable()
        
    def refreshInstances(self):
        already = []
        self.table.clear()
        self.noInstance = None
        for it in self.listElement:             
            table = it['elt'].get('tablename')
            schema = it['elt'].get('schemaname')
            if table==self.table.get() and schema==self.schema.get():
                already.append(it)
        if len(already)>0:
            s = "s" if len(already)>1 else ""
            l = QtWidgets.QLabel(f"\nInstance{s} de cette table déjà importée{s} :")
            font = QtGui.QFont()
            font.setBold(True)
            l.setFont(font)
            self.table.add(l)
            
            w = QtWidgets.QCheckBox("Ne pas créer de nouvelle instance")
            w.setChecked(True)
            self.table.add(w)
            self.noInstance = w
            
            for it in already:       
                hbox = QtWidgets.QHBoxLayout()
                self.table.add(hbox)
                
                ico = QtGui.QIcon(os.path.join(self.imageFolder, "delete.png"))
                b = QtWidgets.QPushButton(ico, "")
                b.setMaximumWidth(20)
                b.clicked.connect(partial(self.deleteInstance, it['elt']['id']))
                hbox.addWidget(b)
                
                l = QtWidgets.QLabel(f"{it['code']}: {it['aff']}")
                hbox.addWidget(l)
                ico = QtGui.QIcon(os.path.join(self.imageFolder, "see.png"))
                b = QtWidgets.QPushButton(ico, "")
                b.setMaximumWidth(30)
                hbox.addWidget(b)
                b.clicked.connect(partial(self.viewElt, it['elt']['id']))
                
    def refreshDumpable(self):
        table = self.table.get()
        schema = self.schema.get()
        layer = self.layer.get()
        # return
        if self.dump.widget:
            if layer:
                if not isinstance(layer,str) and layer.geometryType()==0:
                    self.dump.widget.show()
                else:
                    self.dump.widget.hide()
            else:
                if self.psql.isGeomPoint(table, schema):
                    self.dump.widget.show()
                else:
                    self.dump.widget.hide()
    
    def endInsertion(self, full):
        t = full.split('.')
        schema = t[0].replace('"', "")
        table = t[1].replace('"', "")
        # self.setMetaData(table, schema, self.psql)
        # self.initList()
        # self.refreshStyleList()
        self.setMetaDataAsync(table, schema)
        if self.element.working:
            if self.element.working.full==full:
                try:
                    self.element.working.hide()
                except:
                    pass
                    
        try:
            elt = self.element.get()
            id = elt.get('id')
            elt = self.psql.getTableAdminElt(id)[0]
            self.showTableInfos(elt)
        except:
            pass
    
    def setMetaDataAsync(self, table, schema, callback=None, target=None):
        psql = self.psql.clone()
        m = mGlobalTask(f"Set Metadatas for {schema}.{table}")
        m.task.setCallin(self.setMetaData, table=table, schema=schema, psql=psql, target=target)
        m.setAutoKillConnexion(psql)
        if callback is not None:
            m.setCallback(callback)
        else:
            m.setCallback(self.endMetaData)
        self.psql.manager.add(m)
    
    def setMetaData(self, table, schema, psql, target=None):
        if table is None or not table or table=="" or table=="NULL":
            return
        if target is None or 'geom' in target or 'type' in target or 'index' in target:
            geom = self.setGeomTable(table, schema, psql)
        if target is None or 'type' in target:
            self.setTypeTable(table, schema, geom, psql)
        if target is None or 'index' in target:
            self.setIndexTable(table, schema, geom, psql)
        if target is None or 'valid' in target:
            self.setValidTable(table, schema, psql)
        if target is None or 'pkey' in target:
            pkey = self.setPkeyTable(table, schema, psql)
            self.setPkeyIndexTable(table, schema, pkey, psql)
        self.initList(psql)
        
    def endMetaData(self):
        try: self.refreshStyleList()
        except: pass
    
    def setGeomTable(self, table, schema, psql=None):
        if psql is None:
            psql = self.psql
        geom = psql.getGeometryField(table, schema)
        if geom:
            geomS = f"'{geom}'"
        else:
            geomS = 'NULL'
        sql = f"UPDATE {self.fullAdmin} SET geom={geomS} WHERE tablename='{table}' and schemaname='{schema}'"
        psql.sqlSend(sql)
        return geom
        
    def setTypeTable(self, table, schema, geom=None, psql=None):
        if psql is None:
            psql = self.psql
        geomType = psql.getGeomType(table, schema, geom)
        type = None
        if psql.isGeomPoint(table, schema, geomType=geomType):
            type = "point"
        if psql.isGeomLinestring(table, schema, geomType=geomType):
            type = "line"
        if psql.isGeomPolygon(table, schema, geomType=geomType):
            type = "polygon"
        if type:
            typeS = f"'{type}'"
        else:
            typeS = 'NULL'
        sql = f"UPDATE {self.fullAdmin} SET type={typeS} WHERE tablename='{table}' and schemaname='{schema}'"
        psql.sqlSend(sql)
        return type
        
    def setIndexTable(self, table, schema, geom, psql=None):
        if psql is None:
            psql = self.psql
        index = psql.hasIndex(geom, table, schema)
        if index:
            indexS = 'TRUE'
        else:
            indexS = 'FALSE'
        sql = f"UPDATE {self.fullAdmin} SET index={indexS} WHERE tablename='{table}' and schemaname='{schema}'"
        psql.sqlSend(sql)
        return index
        
    def setValidTable(self, table, schema, psql=None):
        if psql is None:
            psql = self.psql
        valid = psql.isValidGeos(table, schema)
        if valid:
            validS = 'TRUE'
        else:
            validS = 'FALSE'
        sql = f"UPDATE {self.fullAdmin} SET valid={validS} WHERE tablename='{table}' and schemaname='{schema}'"
        psql.sqlSend(sql)
        return valid

    def setPkeyTable(self, table, schema, psql=None):
        if psql is None:
            psql = self.psql
        pkey = psql.getPrimaryKey(table, schema)
        if pkey:
            pkeyS = f"'{pkey}'"
        else:
            pkeyS = 'NULL'
        sql = f"UPDATE {self.fullAdmin} SET pkey={pkeyS} WHERE tablename='{table}' and schemaname='{schema}'"
        psql.sqlSend(sql)
        return pkey
    
    def setPkeyIndexTable(self, table, schema, pkey, psql=None):
        if psql is None:
            psql = self.psql
        index = psql.hasIndex(pkey, table, schema)
        if index:
            indexS = 'TRUE'
        else:
            indexS = 'FALSE'
        sql = f"UPDATE {self.fullAdmin} SET pkey_index={indexS} WHERE tablename='{table}' and schemaname='{schema}'"
        psql.sqlSend(sql)
        return index
        
        
        
        
        
    def actuInfosLayer(self):
        elt = self.element.get()
        if elt is not None:
            table = elt.get('tablename')
            schema = elt.get('schemaname')
            self.setMetaDataAsync(table, schema, self.actualize)
        else:
            self.actuInfosLayerButton.setEnabled(False)
            self.actuInfosLayerButton.textMemo = self.actuInfosLayerButton.text()
            self.actuInfosLayerButton.setText(f"Mise à jour en cours...")
            QtWidgets.QApplication.processEvents()
            for id in self.action.multipleListChoosen:
                elt = self.psql.getTableAdminElt(id)[0]
                table = elt.get('tablename')
                schema = elt.get('schemaname')
                self.setMetaDataAsync(table, schema, self.actuInfosLayerEnd)
            # self.initList()
            # self.actuInfosLayerButton.setEnabled(True)
            # self.actuInfosLayerButton.setText(text)
            
    def actuInfosLayerEnd(self, text):
        self.initList()
        self.actuInfosLayerButton.setEnabled(True)
        self.actuInfosLayerButton.setText(self.actuInfosLayerButton.textMemo)

    def makeDumpable(self, form):
        cb = QtWidgets.QCheckBox("Forcer géométrie simple")
        cb.setToolTip("Accélère le traitement du rendu cluster")
        cb.hide()
        # cb.setEnabled(False)
        form.addRow("", cb)
        self.dump.setWidget(cb)

    def makeAddButton(self):
        butt = QtWidgets.QPushButton("Ajouter")
        butt.setFixedSize(130, 30)
        self.mode.add(butt)
        self.mode.layout.setAlignment(butt, Qt.AlignCenter)
        butt.clicked.connect(self.saveInsertionMode)
        if self.psql.error:
            butt.setEnabled(False)

        

    # Postgis
    def makeInsertionPostgis(self):   
        w = QtWidgets.QWidget()
        self.mode.add(w)
        form = QtWidgets.QFormLayout(w)
        form.setContentsMargins(0,0,0,0) 
        combo = QtWidgets.QComboBox()
        for s in self.psql.getSchemas():
            combo.addItem(s, s)
        self.schema.setWidget(combo)
        form.addRow("Schéma", self.schema.widget)
        combo = QtWidgets.QComboBox()
        self.table.setWidget(combo)
        form.addRow("Table", self.table.widget)
        self.table.error = None
        self.makeDumpable(form)
        self.makeAddButton()
        self.table.setLayout(self.makeLayout(self.mode))
        self.schema.setCallback(self.refreshTablesList)
        self.schema.restore()
    
    def refreshTablesList(self):
        schema = self.schema.get()
        list = [""]
        list.extend(self.psql.getTables(schema))
        self.table.refresh(list)
        self.table.restore()
        
    def refreshTableListFromCombos(self, cs, ct, name):
        schema = cs.currentText()
        list = self.psql.getTables(schema)
        while ct.count():
            ct.removeItem(0)
        ct.addItem("", "")
        for e in list:
            ct.addItem(e, e)
        ct.setCurrentText(name)
        
    def updateTableSchema(self, cs, ct):
        sql = f"UPDATE {self.fullAdmin} SET schemaname='{cs.currentText()}', tablename='{ct.currentText()}' WHERE id={self.element.get().get('id')}"
        self.psql.sqlSend(sql, True)
        self.actualize()
    
    # Qgis
    def makeInsertionQgis(self):   
        w = QtWidgets.QWidget()
        self.mode.add(w)
        form = QtWidgets.QFormLayout(w)
        form.setContentsMargins(0,0,0,0) 
        combo = QgsMapLayerComboBox()
        combo.setFilters(QgsMapLayerProxyModel.VectorLayer)
        combo.setExcludedProviders(['postgres'])
        form.addRow("Couche", combo)
        self.layer.setWidget(combo)
        cb = QtWidgets.QCheckBox("Inclure source Postgres")
        cb.stateChanged.connect(partial(self.actuComboLayer, combo, cb))
        form.addRow("", cb)
        self.layerFilter.setWidget(cb)
        
        combo = QtWidgets.QComboBox()
        for s in self.psql.getSchemas():
            combo.addItem(s, s)
        self.schema.setWidget(combo)
        form.addRow("Schéma", combo)
        l = QtWidgets.QLineEdit()
        self.table.setWidget(l)
        form.addRow("Table", l)
        self.schema.setCallback(self.checkTableName)
        self.table.error = QtWidgets.QVBoxLayout()
        form.addRow("", self.table.error)
        
        self.makeDumpable(form)
        self.makeAddButton()  
        
        self.table.setLayout(self.makeLayout(self.mode))
        self.table.set(self.layer.getText())       
        
        self.layer.freeze = True
        self.layerFilter.restore()
        self.layer.freeze = False
        self.layer.restore()
        self.schema.set(self.param.get('schema','ADMIN'))
        
        if self.param.get('zipLoader'):
            self.mode.add(QtWidgets.QLabel())
            w = QtWidgets.QLabel("Insertion massive VIGINOND depuis les couches sélectionnées :")
            w.setWordWrap(True)
            font = QtGui.QFont()
            font.setBold(True)
            w.setFont(font)
            self.mode.add(w)
            butt = QtWidgets.QPushButton("ZIP détection")
            butt.setFixedSize(130, 30)
            self.mode.add(butt)
            self.mode.layout.setAlignment(butt, Qt.AlignCenter)
            butt.clicked.connect(self.zipDetection)
            self.zipList = QtWidgets.QWidget()
            v = QtWidgets.QVBoxLayout(self.zipList)
            self.mode.add(self.zipList)
            

    def actuTableName(self):
        self.table.set(self.layer.getText())
    
    def actuComboLayer(self, combo, cb):
        list = ['postgres']
        if cb.isChecked():
            list = []
        combo.setExcludedProviders(list)
        
    # Fichier    
    def makeInsertionFichier(self):
        w = QtWidgets.QWidget()
        self.mode.add(w)
        form = QtWidgets.QFormLayout(w)
        form.setContentsMargins(0,0,0,0) 
        hbox = QtWidgets.QHBoxLayout()
        form.addRow("Couche", hbox)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "folder.png"))
        b = QtWidgets.QPushButton(ico, "")
        b.setMaximumWidth(30)
        b.clicked.connect(self.openFile)
        hbox.addWidget(b)
        l = QtWidgets.QLineEdit()
        hbox.addWidget(l)
        l.hide()
        self.layer.setWidget(l)
        l = QtWidgets.QLabel()
        hbox.addWidget(l)
        self.layer.aff = l
        
        combo = QtWidgets.QComboBox()
        for s in self.psql.getSchemas():
            combo.addItem(s, s)
        self.schema.setWidget(combo)
        form.addRow("Schéma", combo)
        l = QtWidgets.QLineEdit()
        self.table.setWidget(l)
        form.addRow("Table", l)
        self.schema.setCallback(self.checkTableName)
        self.table.error = QtWidgets.QVBoxLayout()
        form.addRow("", self.table.error)
        
        self.makeDumpable(form)
        self.makeAddButton()  
        self.table.setLayout(self.makeLayout(self.mode))
        self.schema.set(self.param.get('schema','ADMIN'))
        
    def openFile(self):
        dialog = QtWidgets.QFileDialog()
        fileName = dialog.getOpenFileName(None, "Ouvrir une couche vecteur", "", "Vector Files (*.shp *.gpkg)")
        file = fileName[0]
        self.layer.set(file)
        self.layer.aff.setText(os.path.basename(file))
        nom, ext = os.path.splitext(os.path.basename(file))
        self.table.set(nom)
        QtWidgets.QApplication.processEvents()
        
    






    # SUPPRESSION
    def deleteInstance(self, id):
        sql = f"DELETE FROM {self.fullAdmin} WHERE id={id}"
        self.psql.sqlSend(sql)
        self.initList()
        # self.viewElt()
        self.action.restore()
        self.relodAfterChanged()

    def actualize(self):
        self.initList()
        self.action.restore()
        self.relodAfterChanged()
        
    def deleteInstanceMultiple(self):
        nb = len(self.action.multipleListChoosen)
        s = "s" if nb>1 else ""
        qm = QtWidgets.QMessageBox
        resp = qm.question(None,'', f"Cela va supprimer {nb} entité{s}\nCette action est irréversible", qm.Yes | qm.No)
        if resp!=qm.Yes: return
        ids = ",".join(map(str, self.action.multipleListChoosen))
        sql = f"DELETE FROM {self.fullAdmin} WHERE id in ({ids})"
        self.psql.sqlSend(sql)
        self.initList()
        self.chooseMultiple()
        self.affMultipleCount()
        self.relodAfterChanged()


    # MODIFICATION
    def makeModification(self):
        w1 = QtWidgets.QWidget()
        h1 = QtWidgets.QHBoxLayout(w1)
        self.action.add(w1)
        self.action.choiceBar = w1
        
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "back.png"))
        b = QtWidgets.QPushButton(ico, "")
        b.setFixedSize(20, 30)
        b.clicked.connect(self.element.set)
        self.backToNoChoice = b
        h1.addWidget(b)
        
        combo = QtWidgets.QComboBox()
        combo.setMaximumWidth(200)
        h1.addWidget(combo)
        w2 = QtWidgets.QWidget()
        self.action.add(w2)
        w2.hide()
        self.action.multipleBar = w2
        self.action.multipleList = []
        self.element.setWidget(combo)
        self.element.setLayout(self.makeLayout(self.action, scroll=True))
        # self.element.setLayout(self.makeLayout(self.action))
        self.element.affList = None
        self.element.working = None
        self.refreshElementList()
        self.makeMultiple()
        if not self.element.get():
            self.makeModificationElement()
            
    def makeMultiple(self):
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "multiple.png"))
        b = QtWidgets.QPushButton(ico, "")
        b.setToolTip(f"Affecter une propriété à un ensemble de couches")
        b.setFixedSize(22, 22)
        b.clicked.connect(self.toggleMultiple)
        self.action.choiceBar.layout().addWidget(b)
        
        lay = QtWidgets.QVBoxLayout(self.action.multipleBar)
        l = QtWidgets.QLabel(f"Modification par lots :")
        font = QtGui.QFont()
        font.setBold(True)
        l.setFont(font)
        lay.addWidget(l)
        h2 = QtWidgets.QHBoxLayout()
        lay.addLayout(h2)
        l = QtWidgets.QLabel()
        h2.addWidget(l)
        self.action.multipleBar.label = l
        self.affMultipleCount()
        b = QtWidgets.QPushButton(ico, "")
        b.setFixedSize(22, 22)
        h2.addWidget(b)
        h2.setAlignment(b, Qt.AlignLeft)
        self.action.multipleBar.valid = b
        b.clicked.connect(self.chooseMultiple)
        b.state = "mod"
        self.chooseMultiple()
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "back.png"))
        b = QtWidgets.QPushButton(ico, "")
        b.setToolTip(f"Revenir à la modification unitaire")
        b.setFixedSize(22, 22)
        b.clicked.connect(self.toggleMultiple)
        h2.addWidget(b)
        h2.setAlignment(b, Qt.AlignRight)
    
    def makeModificationMultipleButton(self, form, target=None):
        hbox = QtWidgets.QHBoxLayout()
        form.addRow("", hbox)
        b = QtWidgets.QPushButton("Affecter")
        b.clicked.connect(partial(self.saveModificationMultiple, target))
        hbox.addWidget(b)
        hbox.setAlignment(Qt.AlignRight)
        form.addRow(" ", QtWidgets.QHBoxLayout())
        if len(self.action.multipleListChoosen)<1:
            b.setEnabled(False)
        return b
        
    def toggleMultiple(self):
        if self.action.multipleBar.isVisible():
            self.action.multipleBar.hide()
            self.action.choiceBar.show()
            if self.action.multipleMemo:
                self.element.set(self.action.multipleMemo)
            else:
                self.refreshElementList()
        else:
            self.action.multipleMemo = self.element.get()
            self.element.set(None)
            self.action.multipleBar.show()
            self.action.choiceBar.hide()
            self.refreshElementList()
    
    def setMultipleAll(self):
        state = self.action.multipleAllButton.isChecked()
        for w in self.action.multipleList:
            w.setChecked(state)
            
    def actuMultipleAll(self):
        try:
            self.action.multipleAllButton.blockSignals(True)
            if len(self.action.multipleListChoosen)>=len(self.action.multipleList):
                self.action.multipleAllButton.setChecked(True)
            else:
                self.action.multipleAllButton.setChecked(False)
            self.action.multipleAllButton.blockSignals(False)
        except:
            pass
    
    def affMultipleCount(self):
        self.action.multipleListChoosen = []
        txt = ""
        for w in self.action.multipleList:
            if w.isChecked():
                self.action.multipleListChoosen.append(w.elt['id'])
                txt += w.aff + "\n"
        nb = len(self.action.multipleListChoosen)
        s = ""     
        if nb>1:
            s = "s"
        self.action.multipleBar.label.setText(f"{nb} élément{s} sélectionné{s}")
        self.action.multipleBar.label.setToolTip(txt)
        self.actuMultipleAll()
    
    def chooseMultiple(self):
        if self.action.multipleBar.valid.state=="ok":
            self.action.multipleBar.valid.state = "mod"
            self.action.multipleBar.valid.setIcon(QtGui.QIcon(os.path.join(self.imageFolder, "modify.png")))
            self.action.multipleBar.valid.setToolTip(f"Modifier la sélection")
        else:
            self.action.multipleBar.valid.state = "ok"
            self.action.multipleBar.valid.setIcon(QtGui.QIcon(os.path.join(self.imageFolder, "ok.png")))
            self.action.multipleBar.valid.setToolTip(f"Valider la sélection")
        self.refreshElementList()
        
    def decomposeFilter(self, list, char):
        if isinstance(list, str):
            return list.lower().split(char)
        else:
            l = []
            for e in list:
                l.extend(e.split(char))
            return l
    
    def matchElement(self, it, needles):
        bool = False
        for e in needles:
            if bool:
                break
            if len(e)>0:
                for s in ['aff', 'code']:
                    if s in it and it[s]:
                        bool = bool or (it[s].lower().find(e)>=0)
                for k in ['code', 'tablename', 'name', 'tags', 'bloc']:
                    if bool:
                        break
                    if 'elt' in it and it['elt'] and it['elt'].get(k):
                        v = it['elt'][k].lower()
                        if len(v)>=len(e):
                            bool = bool or (v.find(e)>=0)
        return bool
        
    def getNeedles(self, needle):
        list = needle
        list = self.decomposeFilter(list, " ")
        list = self.decomposeFilter(list, ",")
        list = self.decomposeFilter(list, "+")
        return list
    
    def getValuesElts(self, key):
        s = set()
        v = None
        txt = ""
        for id in self.action.multipleListChoosen:
            s.add(self.dictElement.get(id,{}).get(key))
        if len(s)==1:
            for e in s: v = e
        return v, s
    
    def setToolTipValues(self, widget, s):
        l = [x for x in s if x not in (None,'')]
        if len(l)>1:
            txt = "\n\nPlusieurs valeurs détectées:\n" + "\n".join(map(str,l))
            widget.setToolTip(widget.toolTip()+txt)
    
    def refreshElementList(self):
        needle = self.filter.get()
        bool = (len(needle)<1)
        needles = self.getNeedles(needle)
        list = [("", None)]
        for it in self.listElement:             
            if bool or self.matchElement(it, needles):
                code = it['elt'].get('code')
                img = os.path.join(self.imageFolder,f"{code}.png")
                if os.path.exists(img):
                    list.append((QtGui.QIcon(img), it['aff'], it['elt']))
                else:
                    list.append((it['aff'], it['elt']))
        self.element.refresh(list)
        self.element.set({'id':self.memoId})
        if not self.element.get():
            gbox = QtWidgets.QVBoxLayout()
            if self.action.multipleBar.isVisible():
                self.action.multipleList = []
                gbox.setSpacing(0)
                if self.action.multipleBar.valid.state=="ok":
                    lab = QtWidgets.QCheckBox("TOUS")
                    if len(self.action.multipleListChoosen)==len(list)-1:
                        lab.setChecked(True)
                    font = QtGui.QFont()
                    font.setItalic(True)
                    font.setBold(True)
                    lab.setFont(font)
                    lab.stateChanged.connect(self.setMultipleAll)
                    gbox.addWidget(lab)  
                    self.action.multipleAllButton = lab
                    # gbox.addWidget(QtWidgets.QLabel(" "))  
                    gbox.addSpacing(5)
                
            self.element.add(gbox)
            self.element.affList = gbox
            noIndex = False
            errGeom = False
            for l in list:
                indLib = len(l)-2
                indElt = len(l)-1
                if l[indElt]!=None: 
                    hbox = QtWidgets.QHBoxLayout()
                    hbox.setSpacing(0)
                    gbox.addLayout(hbox)
                    
                    aff = ""
                    if l[indElt].get('tablename') and not l[indElt].get('index'):
                        aff += "  ‼"
                        noIndex = True
                    
                    if l[indElt].get('tablename') and not l[indElt].get('valid'):
                        aff += "  †"
                        errGeom = True
                    
                    if self.action.multipleBar.isVisible():
                        if self.action.multipleBar.valid.state=="ok":
                            lab = QtWidgets.QCheckBox(l[indLib])
                            if l[indElt]['id'] in self.action.multipleListChoosen:
                                lab.setChecked(True)
                            lab.elt = l[indElt]
                            lab.aff = l[indLib]
                            self.action.multipleList.append(lab)
                            lab.setIcon(l[0])
                            lab.stateChanged.connect(self.affMultipleCount)
                            hbox.addWidget(lab)  
                    else:
                        if len(l)>2:
                            ll = QtWidgets.QLabel()
                            ll.setPixmap(l[0].pixmap(15,15))
                        else:
                            c = l[indElt].get('code')[:1]
                            ll = QtWidgets.QLabel(f"[{c}] ")
                        ll.setMaximumWidth(20)
                        hbox.addWidget(ll)
                        lab = clickLabel(l[indLib] + aff)    
                        lab.clicked.connect(partial(self.element.set, {'id':l[indElt]['id']}))
                        hbox.addWidget(lab)  
            l = QtWidgets.QLabel("\n")
            gbox.addWidget(l)
            if not self.action.multipleBar.isVisible() and noIndex:
                l = QtWidgets.QLabel("≈ indique une table qui n'a pas d'index spatial")
                l.setWordWrap(True)
                font = QtGui.QFont()
                font.setItalic(True)
                l.setFont(font)
                gbox.addWidget(l)
            if not self.action.multipleBar.isVisible() and errGeom:
                l = QtWidgets.QLabel("† indique une table qui a une géométrie invalide")
                l.setWordWrap(True)
                font = QtGui.QFont()
                font.setItalic(True)
                l.setFont(font)
                gbox.addWidget(l)
            l = QtWidgets.QLabel("\n\n")
            gbox.addWidget(l)
                    
            if self.action.multipleBar.isVisible() and self.action.multipleBar.valid.state=="mod":     
                w = QtWidgets.QWidget()
                self.element.add(w)
                form = QtWidgets.QFormLayout(w)
                form.setContentsMargins(0,0,0,0)
                self.makeModificationElementStyle(form)
                self.makeModificationMultipleButton(form, "style")
                v,s = self.getValuesElts('style')
                self.refreshStyleList(value=v)
                s = set(map(lambda x: self.lookForStyle(x), s))
                self.setToolTipValues(self.eltStyle.widget, s)
                
                self.makeModificationElementBloc(form)
                b = self.makeModificationMultipleButton(form, "bloc")
                self.eltBloc.widget.buttonRP = b
                v,s = self.getValuesElts('bloc')
                self.refreshBlocList(value=v)
                self.setToolTipValues(self.eltBloc.widget, s)
                
                self.makeModificationElementTags(form)
                cb = QtWidgets.QCheckBox("Ecraser les anciens mot-clefs")
                cb.setToolTip("Si non coché, les mots clefs seront ajoutés à ceux présents dans chaque entité")
                form.addRow("", cb)
                self.eltTags.erase = cb
                b = self.makeModificationMultipleButton(form, "tags")
                self.eltTags.widget.buttonRP = b
                v,s = self.getValuesElts('tags')
                self.eltTags.set(v)
                self.setToolTipValues(self.eltTags.widget, s)
                if len(s)<2:
                    cb.setChecked(True)
                    cb.hide()
                
                ids = ",".join(map(str, self.action.multipleListChoosen))
                sql = f"select code, (case when tablename is null or tablename='' then 0 else 1 end)"
                sql += f" from {self.fullAdmin} WHERE id in ({ids})"
                sql += f" group by 1,2"
                res = self.psql.makeDictResult(self.psql.sqlSend(sql))
                if len(res)==1 and res[0]['case']==1:
                    self.makeModificationElementZone(form)
                    b = self.makeModificationMultipleButton(form, "parent")
                    self.eltParent.widget.buttonRP = b
                    v,s = self.getValuesElts('parent')
                    self.refreshParentList(code=res[0]['code'], value=v)
                    s = set(map(lambda x: "Zone → "+str(self.dictElement.get(x,{}).get('name',x)), s))
                    self.setToolTipValues(self.eltParent.widget, s)
                
                # self.makeModificationElementOrder(form)
                # self.makeModificationMultipleButton(form, "order")
                
                b = QtWidgets.QPushButton(f"Mettre à jour les infos collectées")
                self.actuInfosLayerButton = b
                b.clicked.connect(self.actuInfosLayer)
                self.element.add(b)
                
                l = QtWidgets.QLabel("\n\n")
                self.element.add(l)
                ico = QtGui.QIcon(os.path.join(self.imageFolder, "delete.png"))
                b = QtWidgets.QPushButton(ico, f"Supprimer les entités sélectionnées")
                self.actuInfosLayerButton = b
                b.clicked.connect(self.deleteInstanceMultiple)
                self.element.add(b)
     
    def makeModificationElementStyle(self, form):
        wl = QtWidgets.QLabel("Style")
        wf = QtWidgets.QComboBox()
        wf.setToolTip("Définit le rendu visuel de la couche, rendu par défaut de Qgis si laissé en \"Auto\"")
        self.eltStyle.setWidget(wf)
        hbox = QtWidgets.QHBoxLayout()
        form.addRow(wl, hbox)
        hbox.addWidget(wf)
        self.dock.makeHelpButton(hbox, 'p4-data-style')
        self.eltStyle.setLayout(QtWidgets.QVBoxLayout())
        form.addRow("", self.eltStyle.layout)
        self.eltStyle.detail = None
    
    def makeModificationElementBloc(self, form):
        wl = QtWidgets.QLabel("Thème")
        hbox = QtWidgets.QHBoxLayout()
        form.addRow(wl, hbox)
        wf = QtWidgets.QComboBox()
        wf.setToolTip("Thème de regroupement pour l'arboresence déroulante")
        wf.setEditable(True)
        wf.setInsertPolicy(QtWidgets.QComboBox.InsertAlphabetically)
        wf.editTextChanged.connect(self.enabledModButton)
        wf.lineEdit().returnPressed.connect(partial(self.returnPressed, wf))
        self.eltBloc.setWidget(wf)
        wf.buttonRP = None
        hbox.addWidget(wf)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "modify.png"))
        b = QtWidgets.QPushButton(ico, "")
        b.setFixedSize(22, 22)
        b.clicked.connect(self.renameBlocAff)
        hbox.addWidget(b)
        self.dock.makeHelpButton(hbox, 'p4-data-block')
        w = QtWidgets.QWidget()
        hbox = QtWidgets.QHBoxLayout(w)
        hbox.setSpacing(0)
        hbox.setContentsMargins(0,0,0,10)
        form.addRow(w)
        w.hide()
        self.eltBlocRename = w
        l = QtWidgets.QLabel(f"       →  Renommer ")
        hbox.addWidget(l)
        wf = QtWidgets.QComboBox()
        wf.currentIndexChanged.connect(self.renameBlocChange)
        self.eltBlocRenameChoice.setWidget(wf)
        hbox.addWidget(wf)
        wf = QtWidgets.QLineEdit()
        self.eltBlocRenameValue.setWidget(wf)
        hbox.addWidget(wf)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "ok.png"))
        b = QtWidgets.QPushButton(ico, "")
        b.setFixedSize(22, 22)
        b.clicked.connect(self.renameBlocGo)
        hbox.addWidget(b)
        self.eltBlocRename.ok = b
        
    def makeModificationElementTags(self, form, tags=""):  
        wl = QtWidgets.QLabel("Mots-clefs")
        wf = QtWidgets.QLineEdit(tags)
        wf.returnPressed.connect(partial(self.returnPressed, wf))
        wf.setToolTip("Mots-clefs utilisés dans la recherche pour filtrer les éléments\n(en plus d'autres champs comme l'alias, la table, la zone, le thème, etc)")
        self.eltTags.setWidget(wf)
        wf.buttonRP = None
        hbox = QtWidgets.QHBoxLayout()
        form.addRow(wl, hbox)
        hbox.addWidget(wf)
        self.dock.makeHelpButton(hbox, 'p4-data-block')    
    
    def makeModificationElementOrder(self, form):  
        wl = QtWidgets.QLabel("Ordre")
        hbox = QtWidgets.QHBoxLayout()
        form.addRow(wl, hbox)
        wf = QtWidgets.QSpinBox()
        wf.setToolTip("Ordonnacement des couches (supplantera l'ordre alphabétique)")
        self.eltOrder.setWidget(wf)
        hbox.addWidget(wf)
        self.dock.makeHelpButton(hbox, 'p4-data-order')
        
    def makeModificationElementZone(self, form):
        wl = QtWidgets.QLabel("Zone")
        hbox = QtWidgets.QHBoxLayout()
        form.addRow(wl, hbox)
        wf = QtWidgets.QComboBox()
        wf.setToolTip("Zone géographique de rattachement pour faire des listes déroulantes en mode \"compact\"")
        wf.setEditable(True)
        wf.setInsertPolicy(QtWidgets.QComboBox.InsertAlphabetically)
        wf.editTextChanged.connect(self.enabledModButton)
        wf.lineEdit().returnPressed.connect(partial(self.returnPressed, wf))
        self.eltParent.setWidget(wf)
        wf.buttonRP = None
        hbox.addWidget(wf)
        self.nameAff = QtWidgets.QLabel()
        form.addRow(self.nameAff)
        self.dock.makeHelpButton(hbox, 'p4-data-group')
    
    
    def makeModificationElement(self):
        self.element.affList = None
        elt = self.element.get()
        if elt:
            self.freeze = True
            self.backToNoChoice.setEnabled(True)
            self.memoId = elt.get('id')
            table = elt.get('tablename')
            name = elt.get('name', "") or ""
            code = elt.get('code')
            children = self.getChildren()

            hbox = QtWidgets.QHBoxLayout()
            hbox.setContentsMargins(0,0,0,0)
            hbox.setSpacing(0)
            self.element.add(hbox)
            if table:
                schema = elt.get('schemaname') or self.psql.PGschema
                txt = f"BD: {table} ({schema})"
                unknown = "[?]"
                if self.param.get('baseAdmin'):
                    l = clickLabel(unknown)      
                    l.clicked.connect(self.modBase)
                    w = QtWidgets.QWidget()
                    self.element.add(w)
                    w.hide()
                    self.element.adminBase = w
                    vbox2 = QtWidgets.QVBoxLayout(w)
                    
                    hbox2 = QtWidgets.QHBoxLayout()
                    vbox2.addLayout(hbox2)
                    hbox2.setContentsMargins(0,0,0,0)
                    hbox2.setSpacing(0)
                    ll = QtWidgets.QLabel()
                    ll.setToolTip("Déplacer et/ou renommer la source de cet élément")
                    hbox2.addWidget(ll)
                    ico = QtGui.QIcon(os.path.join(self.imageFolder, "move.png"))
                    ll.setPixmap(ico.pixmap(15,15))
                    combo = QtWidgets.QComboBox()
                    for s in self.psql.getSchemas():
                        combo.addItem(s, s)
                    combo.setCurrentText(schema)
                    hbox2.addWidget(combo)
                    le = QtWidgets.QLineEdit(table)
                    hbox2.addWidget(le)
                    ico = QtGui.QIcon(os.path.join(self.imageFolder, "ok.png"))
                    b = QtWidgets.QPushButton(ico, "")
                    b.setFixedSize(22, 22)
                    b.clicked.connect(partial(self.trade.changeTableReference, table, schema, le, combo, self.actualize))
                    hbox2.addWidget(b)

                    hbox2 = QtWidgets.QHBoxLayout()
                    vbox2.addLayout(hbox2)
                    hbox2.setContentsMargins(0,0,0,20)
                    hbox2.setSpacing(0)
                    ll = QtWidgets.QLabel()
                    ll.setToolTip("Changer la source pour cet élément")
                    hbox2.addWidget(ll)
                    ico = QtGui.QIcon(os.path.join(self.imageFolder, "switch.png"))
                    ll.setPixmap(ico.pixmap(15,15))
                    cs = QtWidgets.QComboBox()
                    for s in self.psql.getSchemas():
                        cs.addItem(s, s)
                    cs.setCurrentText(schema)
                    hbox2.addWidget(cs)
                    ct = QtWidgets.QComboBox()
                    ct.setMaximumWidth(150)
                    hbox2.addWidget(ct)
                    cs.currentIndexChanged.connect(partial(self.refreshTableListFromCombos, cs, ct, table))
                    self.refreshTableListFromCombos(cs, ct, table)
                    ico = QtGui.QIcon(os.path.join(self.imageFolder, "ok.png"))
                    b = QtWidgets.QPushButton(ico, "")
                    b.setFixedSize(22, 22)
                    b.clicked.connect(partial(self.updateTableSchema, cs, ct))
                    hbox2.addWidget(b)
                    
                    
                else:
                    l = QtWidgets.QLabel(unknown)
                self.element.tableType = l
                l.setMaximumWidth(20)
                hbox.addWidget(l)
            else:
                txt = f"Groupe pour choix multiple"
                self.element.tableType = None
            l = QtWidgets.QLabel(txt)
            l.setWordWrap(True)
            font = QtGui.QFont()
            font.setItalic(True)
            l.setFont(font)
            hbox.addWidget(l)
            
            if table:
                box = QtWidgets.QVBoxLayout()
                self.element.add(box)
                self.element.tableInfos = box
                full = self.psql.full(table, schema)
                running = ""
                if not self.psql.isTable(table, schema):
                    running = "       référence introuvable..."
                if full in self.psql.manager.waiting:
                    running = "       insertion en cours..."
                if running!="":
                    l = QtWidgets.QLabel(running)
                    l.full = full
                    l.setWordWrap(True)
                    font = QtGui.QFont()
                    font.setItalic(True)
                    l.setFont(font)
                    self.element.tableInfos.addWidget(l)
                    self.element.working = l
                else:
                    self.showTableInfos(elt)
            
            w = QtWidgets.QWidget()
            self.element.add(w)
            form = QtWidgets.QFormLayout(w)
            form.setContentsMargins(0,0,0,0)
            
            wl = QtWidgets.QLabel("Dans")
            wf = QtWidgets.QComboBox()
            wf.setToolTip("Appartenance de la couche ou du groupe")
            if len(children)>0:
                wf.setEnabled(False)
            for i,s in enumerate(self.itemList):
                n = self.param.get(s)
                img = os.path.join(self.imageFolder,f"{s}.png")
                if os.path.exists(img):
                    wf.addItem(QtGui.QIcon(img), n, s)
                else:
                    wf.addItem(n, s)
                if s==code:
                    wf.setCurrentIndex(i)
            self.eltCode.setWidget(wf)
            hbox = QtWidgets.QHBoxLayout()
            form.addRow(wl, hbox)
            hbox.addWidget(wf)
            self.dock.makeHelpButton(hbox, 'p4-data-in')
            
            wl = QtWidgets.QLabel("Alias")
            wf = QtWidgets.QLineEdit(name)
            wf.returnPressed.connect(partial(self.returnPressed, wf))
            wf.setToolTip("Alias de substitution qui s'affichera à la place du nom de la table")
            self.eltName.setWidget(wf)
            wf.buttonRP = None
            hbox = QtWidgets.QHBoxLayout()
            form.addRow(wl, hbox)
            hbox.addWidget(wf)
            self.dock.makeHelpButton(hbox, 'p4-data-aka')
            if not table:
                wf.setPlaceholderText("Alias du groupe obligatoire")
                self.eltName.label = wl

            self.makeModificationElementStyle(form)
            
            tags = elt.get('tags', "") or ""
            self.makeModificationElementTags(form, tags)
            
            if table:
                self.makeModificationElementZone(form)
                self.eltAssoc.setWidget()
                self.makeModificationElementBloc(form)
            
            else:
                self.eltParent.setWidget()
                self.nameAff = None
                self.eltBloc.setWidget()
                
                if elt.get('bloc'):
                    hbox = QtWidgets.QHBoxLayout()
                    wl = QtWidgets.QLabel(f"\"{elt.get('bloc')}\" affecté mais obsolète pour une zone")
                    wl.setWordWrap(True)
                    font = QtGui.QFont()
                    font.setItalic(True)
                    wl.setFont(font)
                    hbox.addWidget(wl)
                    ico = QtGui.QIcon(os.path.join(self.imageFolder, "delete.png"))
                    b = QtWidgets.QPushButton(ico, "")
                    b.setMaximumWidth(20)
                    b.clicked.connect(partial(self.setBlocNull, elt.get('id')))
                    hbox.addWidget(b)
                    form.addRow("Thème", hbox)
                
                hbox = QtWidgets.QHBoxLayout()
                form.addRow("Associé avec", hbox)
                wf = QtWidgets.QComboBox()
                hbox.addWidget(wf)
                self.eltAssoc.setWidget(wf)
                self.eltAssoc.changed.connect(partial(self.actuAssoc, add=True))
                vbox = QtWidgets.QVBoxLayout()
                form.addRow("", vbox)
                self.eltAssoc.targetLayout = vbox
                l = splitId(elt.get('assoc'),',')
                self.eltAssoc.targetOrigine = l
                self.eltAssoc.targetList = l.copy()
                self.actuAssoc()
            
            
                        
            if table:
                wl = QtWidgets.QLabel("Cluster")
                hbox = QtWidgets.QHBoxLayout()
                form.addRow(wl, hbox)
                rdiField = rdiLayerField(rdiLayer(elt), self.psql)
                rdiField.setNumeric()
                rdiField.makeCombo(hbox)
                wl.setToolTip("Choix par défaut du champ à sommer pour le rendu cluster")
                self.eltCluster.setWidget(rdiField.combo)
                self.dock.makeHelpButton(hbox, 'p4-data-cluster')
            if table:
                wl = QtWidgets.QLabel("Stats")
                hbox = QtWidgets.QHBoxLayout()
                form.addRow(wl, hbox)
                rdi = rdiLayer(elt)
                rdi.stat = rdiStatLayer(rdi, hbox, self.dock)
                rdi.stat.dataChanged.connect(self.enabledModButton)
                self.eltStats = rdi
                self.dock.makeHelpButton(hbox, 'p4-data-stats')
            else:
                self.eltStats = None
                
            self.makeModificationElementOrder(form)
            order = elt.get('order', "") or ""
            if order!="": self.eltOrder.set(order)
                
            hbox = QtWidgets.QHBoxLayout()
            self.element.add(hbox)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "back.png"))
            b = QtWidgets.QPushButton(ico, "")
            b.setFixedSize(20, 30)
            b.clicked.connect(self.element.set)
            hbox.addWidget(b)
            hbox.setAlignment(b, Qt.AlignLeft)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "save.png"))
            butt = QtWidgets.QPushButton(ico, "  Enregistrer")
            butt.setFixedSize(130, 30)
            hbox.addWidget(butt)
            hbox.setAlignment(butt, Qt.AlignCenter)
            butt.clicked.connect(self.saveModificationElement)
            self.modWidget['butt'].setWidget(butt)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "delete.png"))
            b = QtWidgets.QPushButton(ico, "")
            b.setFixedSize(20, 30)
            b.clicked.connect(partial(self.deleteInstance, elt.get('id')))
            hbox.addWidget(b)
            hbox.setAlignment(b, Qt.AlignRight)
            if len(children)>0:
                b.setEnabled(False)
                
            self.codeChanged()
            self.refreshStyleList()
            self.autoNomAff()
            butt.setEnabled(False)
            self.freeze = False
            
            if table:
                if elt.get('parent'):
                    l = QtWidgets.QLabel(f"\nRegroupé dans :")
                    font = QtGui.QFont()
                    font.setUnderline(True)
                    l.setFont(font)
                    self.element.add(l)
                    hbox = QtWidgets.QHBoxLayout()
                    self.element.add(hbox)
                    l = QtWidgets.QLabel(f" {self.eltParent.widget.currentText()}")
                    hbox.addWidget(l)
                    ico = QtGui.QIcon(os.path.join(self.imageFolder, "see.png"))
                    b = QtWidgets.QPushButton(ico, "")
                    b.setMaximumWidth(30)
                    hbox.addWidget(b)
                    b.clicked.connect(partial(self.element.set, {'id':elt['parent']}))
                    
                l = QtWidgets.QLabel()
                self.element.add(l)
                w = QtWidgets.QGroupBox(f"Infos collectées")
                self.element.add(w)
                vbox = QtWidgets.QVBoxLayout(w)
                vbox.setSpacing(0)
                self.collectedInfos = w
                self.actuGBinfos(elt)
                
                
            else:
                l = QtWidgets.QLabel()
                self.element.add(l)
                hbox = QtWidgets.QHBoxLayout()
                self.element.add(hbox)
                ico = QtGui.QIcon(os.path.join(self.imageFolder, "refresh.png"))
                b = QtWidgets.QPushButton(ico, "")
                b.setIconSize(QSize(11, 11))
                b.setFixedSize(15, 15)
                b.clicked.connect(self.actualize)
                hbox.addWidget(b)
                l = QtWidgets.QLabel(f"Dépendances :")
                font = QtGui.QFont()
                font.setUnderline(True)
                l.setFont(font)
                hbox.addWidget(l)
                
                gbox = QtWidgets.QVBoxLayout()
                self.element.add(gbox)
                for it in children:             
                    hbox = QtWidgets.QHBoxLayout()
                    gbox.addLayout(hbox)
                    ico = QtGui.QIcon(os.path.join(self.imageFolder, "delete.png"))
                    b = QtWidgets.QPushButton(ico, "")
                    b.setMaximumWidth(20)
                    b.clicked.connect(partial(self.setParent, it['elt']['id'], 'NULL'))
                    hbox.addWidget(b)
                    
                    wf = QtWidgets.QSpinBox()
                    wf.id = it['elt']['id']
                    wf.setMaximumWidth(30)
                    order = it['elt'].get('order', "") or ""
                    if order!="":
                        wf.setValue(order)
                    hbox.addWidget(wf)
                    wf.valueChanged.connect(partial(self.setOrder, wf))
                    
                    l = QtWidgets.QLabel(f" {it['aff']}")
                    hbox.addWidget(l)
                    ico = QtGui.QIcon(os.path.join(self.imageFolder, "see.png"))
                    b = QtWidgets.QPushButton(ico, "")
                    b.setMaximumWidth(30)
                    hbox.addWidget(b)
                    b.clicked.connect(partial(self.element.set, {'id':it['elt']['id']}))
                hbox = QtWidgets.QHBoxLayout()
                gbox.addLayout(hbox)
                combo = QtWidgets.QComboBox()
                hbox.addWidget(combo)
                combo.addItem("", None)
                for it in self.listElement:             
                    if it['elt']['tablename'] and it['elt']['code']==code and it['elt']['parent']==None:
                        combo.addItem(it['aff'], it['elt']['id'])
                b = QtWidgets.QPushButton("Ajouter")
                b.setMaximumWidth(60)
                hbox.addWidget(b)
                b.clicked.connect(partial(self.setParent, combo, elt.get('id')))
        else:
            self.backToNoChoice.setEnabled(False)
            self.memoId = None
            self.refreshElementList()
    
    def actuGBinfos(self, elt):
        try:
            vbox = self.collectedInfos.layout()
        except:
            return
        clearLayout(vbox)
        l = QtWidgets.QLabel(f"Géométrie")
        font = QtGui.QFont()
        font.setUnderline(True)
        l.setFont(font)
        vbox.addWidget(l)
        l = QtWidgets.QLabel(f" colonne: {elt.get('geom')}")
        vbox.addWidget(l)
        l = QtWidgets.QLabel(f" indexée: {elt.get('index')}")
        vbox.addWidget(l)
        l = QtWidgets.QLabel(f" type: {elt.get('type')}")
        vbox.addWidget(l)
        l = QtWidgets.QLabel(f" validité: {elt.get('valid')}")
        vbox.addWidget(l)
        l = QtWidgets.QLabel()
        vbox.addWidget(l)
        l = QtWidgets.QLabel(f"Clé primaire")
        font = QtGui.QFont()
        font.setUnderline(True)
        l.setFont(font)
        vbox.addWidget(l)
        l = QtWidgets.QLabel(f" colonne: {elt.get('pkey')}")
        vbox.addWidget(l)
        l = QtWidgets.QLabel(f" indexée: {elt.get('pkey_index')}")
        vbox.addWidget(l)
        l = QtWidgets.QLabel()
        vbox.addWidget(l)
        b = QtWidgets.QPushButton(f"Mettre à jour")
        b.setMaximumWidth(80)
        vbox.addWidget(b)
        vbox.setAlignment(b, Qt.AlignCenter)
        b.clicked.connect(self.actuInfosLayer)
    
    def modBase(self):
        if self.element.adminBase.isVisible():
            self.element.adminBase.hide()
        else:    
            self.element.adminBase.show()
    
    def renameBlocAff(self):
        if self.eltBlocRename.isVisible():
            self.eltBlocRename.hide()
        else:
            self.eltBlocRename.show()
    
    def renameBlocChange(self):
        val = self.eltBlocRenameChoice.get() or ""
        if val=="NULL":
            val = ""
        self.eltBlocRenameValue.set(val)
        if val=="":
            self.eltBlocRename.ok.setEnabled(False)
        else:
            self.eltBlocRename.ok.setEnabled(True)
        
    def renameBlocGo(self):
        bloc = self.eltBlocRenameValue.get()
        if bloc and bloc!="":
            sql = f"UPDATE {self.fullAdmin} SET bloc='{bloc}' WHERE bloc='{self.eltBlocRenameChoice.get()}'"
            self.psql.sqlSend(sql, True)
            self.initList()
            self.refreshBlocList()
            self.action.restore()
            self.relodAfterChanged()
    
    def codeChanged(self):
        self.refreshParentList()
        # self.refreshStyleList()
        self.refreshBlocList()
        
    def enabledModButton(self):
        elt = self.element.get()
        if elt==None:
            return
        if not self.freeze:
            butt = self.modWidget['butt'].widget
            butt.setEnabled(True)
        if not elt.get('tablename'):
            if self.eltName.get().strip()=="":
                butt.setEnabled(False)
                self.eltName.label.setStyleSheet("color:red;")
            else:
                self.eltName.label.setStyleSheet("")

    def returnPressed(self, widget=None):
        butt = widget.buttonRP
        if not butt: butt = self.modWidget['butt'].widget
        self.timerRP = QtCore.QTimer()
        self.timerRP.setSingleShot(True)
        self.timerRP.timeout.connect(butt.click)
        if butt.isEnabled():
            butt.setFocus()
            self.timerRP.start(1)
    
    def getChildren(self, id=None):
        list = []
        if id==None:
            elt = self.element.get()
            id = elt['id']
        for it in self.listElement:             
            if it['elt']['parent']==id:
                list.append(it)
        return list
    
    def setParent(self, target, parent):
        id = None
        if isinstance(target, int):
            id = target
        if isinstance(target, QtWidgets.QComboBox):
            id = target.currentData()
        if id:
            sql = f"UPDATE {self.fullAdmin} SET parent={parent} WHERE id={id}"
            self.psql.sqlSend(sql, True)
            self.initList()
            self.action.restore()
            self.relodAfterChanged()
            
    def setBlocNull(self, id):
        sql = f"UPDATE {self.fullAdmin} SET bloc=null WHERE id={id}"
        self.psql.sqlSend(sql, True)
        self.initList()
        self.action.restore()
        self.relodAfterChanged()
    
    def setOrder(self, spin):
        id = spin.id
        order = spin.value()
        sql = f"UPDATE {self.fullAdmin} SET \"order\"={order} WHERE id={id}"
        self.psql.sqlSend(sql, True)
        self.initList()
    
    def askTableInfos(self, elt):
        table = elt.get('tablename')
        schema = elt.get('schemaname')
        self.setTypeTable(table, schema)
            
    def showTableInfos(self, elt, retry=False):
        if retry:
            try: elt = self.dictElement[elt.get('id')]
            except: return
            if elt.get('id')!=self.element.get().get('id'):
                return
        table = elt.get('tablename')
        schema = elt.get('schemaname')
        type = elt.get('type')
        geom = elt.get('geom')
        index = elt.get('index')
        target = []
        for v in ['type', 'geom', 'index']:
            if not elt.get(v):
                target.append(v)
        if len(target)>0:
            if retry:
                return
            # print('not ready', target)
            self.setMetaDataAsync(table, schema, callback=partial(self.showTableInfos, elt, retry=True), target=target)
        img = f"{type}.png"
        ico = QtGui.QIcon(os.path.join(self.imageFolder, img))
        self.element.tableType.setPixmap(ico.pixmap(15,15))
        clearLayout(self.element.tableInfos)
        if not index:
            hbox = QtWidgets.QHBoxLayout()
            hbox.setAlignment(Qt.AlignRight)
            self.element.tableInfos.addLayout(hbox)
            l = QtWidgets.QLabel("Créer un index spatial")
            hbox.addWidget(l)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "index.png"))
            b = QtWidgets.QPushButton(ico, "")
            b.setMaximumWidth(30)
            b.clicked.connect(partial(self.addSpatialIndex, elt, b))
            hbox.addWidget(b)
        valid = elt.get('valid') 
        if not valid:
            if valid==False:
                txt = "Réparer la géométrie"
                img = "fix.png"
                func = self.fixGeometry
            else:
                txt = "Tester la géométrie"
                img = "try.png"
                func = self.tryGeometry
            hbox = QtWidgets.QHBoxLayout()
            hbox.setAlignment(Qt.AlignRight)
            self.element.tableInfos.addLayout(hbox)
            l = QtWidgets.QLabel(txt)
            hbox.addWidget(l)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, img))
            b = QtWidgets.QPushButton(ico, "")
            b.setMaximumWidth(30)
            b.clicked.connect(partial(func, elt, b))
            hbox.addWidget(b)
        self.actuGBinfos(elt)
    
    def endActionTable(self):
        self.initList()
        self.action.restore()
        self.relodAfterChanged()
    
    def addSpatialIndex(self, elt, butt):
        butt.setEnabled(False)
        id = elt.get('id')
        table = elt.get('tablename')
        schema = elt.get('schemaname')
        geom = elt.get('geom')
        # if not geom:
            # geom = self.psql.getGeometryField(table, schema)
            # self.setGeomTable(table, schema)
        # self.psql.makeSpatialIndex(table, schema, geom)
        # self.setIndexTable(table, schema, geom)
        # self.initList()
        # self.action.restore()
        # self.relodAfterChanged()  
        psql = self.psql.clone()
        m = mGlobalTask(f"Set spatial index for {schema}.{table}")
        m.task.setCallin(self.addSpatialIndexIn, table=table, schema=schema, geom=geom, psql=psql)
        m.setAutoKillConnexion(psql)
        m.setCallback(self.endActionTable)
        self.psql.manager.add(m)
        
    def addSpatialIndexIn(self, table, schema, geom, psql):
        if not geom:
            geom = psql.getGeometryField(table, schema)
            self.setGeomTable(table, schema, psql)
        psql.makeSpatialIndex(table, schema, geom)
        self.setIndexTable(table, schema, geom, psql)
    
    def tryGeometry(self, elt, butt):
        butt.setEnabled(False)
        id = elt.get('id')
        table = elt.get('tablename')
        schema = elt.get('schemaname')
        # self.setValidTable(table, schema)
        # self.initList()
        # self.action.restore()
        # self.relodAfterChanged()
        psql = self.psql.clone()
        m = mGlobalTask(f"Try geometry for {schema}.{table}")
        m.task.setCallin(self.setValidTable, table=table, schema=schema, psql=psql)
        m.setAutoKillConnexion(psql)
        m.setCallback(self.endActionTable)
        self.psql.manager.add(m)

    def fixGeometry(self, elt, butt):
        butt.setEnabled(False)
        id = elt.get('id')
        table = elt.get('tablename')
        schema = elt.get('schemaname')
        geom = elt.get('geom')
        # if not geom:
            # geom = self.psql.getGeometryField(table, schema)
            # self.setGeomTable(table, schema)
        # self.psql.makeValidGeos(table, schema, geom)
        # valid = self.psql.isValidGeos(table, schema, geom)
        # self.setValidTable(table, schema)
        # self.initList()
        # self.action.restore()
        # self.relodAfterChanged()
        psql = self.psql.clone()
        m = mGlobalTask(f"Fix geometry for {schema}.{table}")
        m.task.setCallin(self.fixGeometryIn, table=table, schema=schema, geom=geom, psql=psql)
        m.setAutoKillConnexion(psql)
        m.setCallback(self.endActionTable)
        self.psql.manager.add(m)

    def fixGeometryIn(self, table, schema, geom, psql):
        if not geom:
            geom = psql.getGeometryField(table, schema)
            self.setGeomTable(table, schema, psql)
        psql.makeValidGeos(table, schema, geom)
        # valid = psql.isValidGeos(table, schema, geom)
        self.setValidTable(table, schema, psql)
     
    def refreshParentList(self, code=None, value=None):
        elt = None
        if code is None: 
            code = self.eltCode.get()
            elt = self.element.get()
        if self.eltParent.widget!=None:
            self.eltParent.refresh(self.alias[code])
            self.eltParent.targetCode = code
            if elt is not None: self.eltParent.set(elt.get('parent'), True)
            if value: self.eltParent.set(value, True)
        if self.eltAssoc.widget!=None: 
            l = self.alias[code].copy()
            r = []
            a = []
            for e in l:
                if elt and e[1]==elt.get('id') or e[1] in self.eltAssoc.targetList: r.append(e)
                # elif elt and elt.get('name')!="" and e[0].find(elt.get('name'))>=0: a.append(e)
            for e in r: l.remove(e)
            if len(a)>0: l.insert(1, None)
            for e in a: l.insert(1, e)
            self.eltAssoc.refresh(l)
        
    def refreshBlocList(self, value=None):
        elt = self.element.get()
        if elt==None:
            list = [(" ",'NULL')]
            list.extend(self.psql.getTableAdminBlocs(mixed=True))
            self.eltBloc.refresh(list)
            self.eltBlocRenameChoice.refresh(list)
            self.eltBloc.set(value, True)
            self.eltBlocRenameChoice.set(value, True)
        else:
            code = self.eltCode.get()
            self.eltBloc.refresh(self.bloc[code])
            self.eltBloc.set(elt.get('bloc'), True)
            self.eltBlocRenameChoice.refresh(self.bloc[code])
            self.eltBlocRenameChoice.set(elt.get('bloc'), True)
    
    
    def actuAssoc(self, add=None, supp=None):
        elt = self.element.get()
        if self.eltAssoc.widget is None: return
        clearLayout(self.eltAssoc.targetLayout)
        if add: add = self.eltAssoc.get()
        if add not in (None, False,'','NULL') and add not in self.eltAssoc.targetList and add!=elt.get('id'): self.eltAssoc.targetList.append(add)
        if supp is not None and supp in self.eltAssoc.targetList: self.eltAssoc.targetList.remove(supp)
        for id in self.eltAssoc.targetList:
            try: elt = self.dictElement[id]
            except: continue
            hbox = QtWidgets.QHBoxLayout()
            self.eltAssoc.targetLayout.addLayout(hbox)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "delete.png"))
            b = QtWidgets.QPushButton(ico, "")
            b.setMaximumWidth(20)
            b.clicked.connect(partial(self.actuAssoc, supp=id))
            hbox.addWidget(b)
            # name = f"[{elt.get('bloc','')}] {elt.get('name')}"
            # name = name.replace("[] ","")
            # w = QtWidgets.QLabel(name)
            w = dblClickLabel(elt.get('nom_aff'))
            w.rightClick.connect(partial(self.menuAssoc, id))
            hbox.addWidget(w)
            if id in self.eltAssoc.targetOrigine:
                ico = QtGui.QIcon(os.path.join(self.imageFolder, "see.png"))
                b = QtWidgets.QPushButton(ico, "")
                b.setMaximumWidth(20)
                b.clicked.connect(partial(self.element.set, {'id':id}))
                hbox.addWidget(b)
            else:
                font = QtGui.QFont()
                font.setItalic(True)
                w.setFont(font)
                w.setStyleSheet("color:#888888")
        if add or supp:
            self.refreshParentList()
            self.enabledModButton()
    
    def menuAssoc(self, id):
        # if not self.dock.param.get('allowBeta'): return
        self.popMenu = QtWidgets.QMenu()
        self.popMenu.addAction("Dissoudre", partial(self.dissolution, id))
        self.popMenu.popup(QtGui.QCursor.pos())
    
    def dissolution(self, id):
        elt = self.element.get()
        elt2 = self.dictElement[id]
        qm = QtWidgets.QMessageBox
        resp = qm.question(None,'', f"Cela va supprimer {elt2.get('nom_aff')} et toutes les dépendances seront réaffectées à {elt.get('nom_aff')}\nCette action est irréversible", qm.Yes | qm.No)
        if resp==qm.Yes:
            sql = f"update {self.fullAdmin} set parent={elt.get('id')} where parent={id}; "
            sql += f"delete from {self.fullAdmin} where id={id}; "
            self.psql.sqlSend(sql, True)
            self.initList()
            self.action.restore()
            self.relodAfterChanged()
    
    def getFileStyle(self, a, data):
        if 'file' in data['jsStyle'] and not os.path.exists(os.path.join(self.styleFolder, data['jsStyle'].get('file'))):
            path = self.pdb.setFile(path=self.styleFolder, key=data['jsStyle'].get('file'), code='file_json')
        for file in os.listdir(self.styleFolder):
            try:
                name, ext = os.path.splitext(file)
                if ext.lower()!='.json':
                    continue
                f = open(os.path.join(self.styleFolder, file), 'r')
                js = json.loads(f.read())
                f.close()
                b = {'file':file, 'do':'file', 'content':a['content'], 'label':js['name']}
                if 'target' in js:
                    b['target'] = js['target']
                if 'vars' in js:
                    b['vars'] = js['vars']
                if os.path.isfile(os.path.join(self.styleFolder, name+".freeze")):
                    if file==data['jsStyle'].get('file'):
                        b['do'] = None
                        b['content'] = elt.get('style')
                        toGray = True
                    else:
                        continue
                self.actuStyleItem(b, data)
            except:
                print(sys.exc_info())
                print(traceback.format_exc())
                pass
    
    def refreshStyleList(self, retry=False, value=None):
        self.eltStyle.widget
        elt = self.element.get()
        toGray = False
        if elt==None:
            jsStyle = self.jsStyle(value)
            data = {'elt':{}, 'jsStyle':jsStyle, 'code':None, 'list':[], 'ind':0, 'found':0, 'isPoint':False, 'isPolygon':False, 'isLine':False, 'isGroup':True}
            data['elt']['style'] = value
        else:
            jsStyle = self.jsStyle(elt.get('style'))
            code = self.eltCode.get()
            table = elt.get('tablename')
            schema = elt.get('schemaname')
            # isPoint = self.psql.isGeomPoint(table, schema)
            # isLine = self.psql.isGeomLinestring(table, schema)
            # isPolygon = self.psql.isGeomPolygon(table, schema)
            type = elt.get('type')
            if type is None:
                if retry:
                    return
                self.setMetaDataAsync(table, schema, callback=partial(self.refreshStyleList, retry=True), target=['type'])
            isPoint = type=='point'
            isLine = type=='line'
            isPolygon = type=='polygon'
            data = {'elt':elt, 'jsStyle':jsStyle, 'code':code, 'list':[], 'ind':0, 'found':0, 'isPoint':isPoint, 'isPolygon':isPolygon, 'isLine':isLine, 'isGroup':table==None}
        for a in self.translator['style']:
            if 'type' in a and a['type']=='file':
                self.getFileStyle(a, data)
            else:
                self.actuStyleItem(a, data)
        self.eltStyle.refresh(data['list'])
        self.eltStyle.set(data['found'])
        if toGray:
            self.eltStyle.widget.setItemData(data['found'], QtGui.QColor('#888888'), Qt.TextColorRole)
        
    def lookForStyle(self, value):
        data = {'elt':{'style':value}, 'jsStyle':self.jsStyle(value), 'code':None, 'list':[], 'ind':0, 'found':0, 'isPoint':False, 'isPolygon':False, 'isLine':False, 'isGroup':True}
        for a in self.translator['style']:
            if 'type' in a and a['type']=='file': self.getFileStyle(a, data)
            else: self.actuStyleItem(a, data)
        return data['list'][data['found']][-2]
    
    def actuStyleItem(self, a, data):
        if (not 'target' in a) or (data['isGroup']) or (a['target']=="point" and data['isPoint']) or (a['target']=="polygon" and data['isPolygon']) or (a['target']=="line" and data['isLine']):
            if 'file' in a:
                ico = QtGui.QIcon(os.path.join(self.imageFolder, 'file.png'))
                if a['do']==None:
                    ico = QtGui.QIcon(os.path.join(self.imageFolder, 'file-off.png'))
                data['list'].append((ico, a['label'], a))
            else:
                data['list'].append((a['label'], a))
            if data['elt'].get('style'):
                if 'content' in a:
                    js = a['content'].split('_self_')[0]
                    if 'file' in a:
                        if data['jsStyle'].get('file')==a['file']:
                            data['found'] = data['ind']
                    elif js!="" and data['elt'].get('style').lower().find(js)>=0:
                        data['found'] = data['ind']
                    elif js=="" and not data['found']:
                        data['found'] = data['ind']
            data['ind'] += 1
        return ""
    
    def autoNomAff(self):
        # if self.freeze:
            # return
        elt = self.element.get()
        txt = self.eltName.get()
        try: 
            if self.nameAff!=None:
                if txt=="":
                    txt = elt.get('tablename')
                if self.eltParent.widget!=None:
                    parent = self.eltParent.getText().strip()
                    if parent!="":
                        txt = f"{parent} ({txt})"
                        b = False
                    else: b = True
                    try: self.eltCode.widget.setEnabled(b)
                    except: pass
                if self.eltBloc.widget!=None:
                    bloc = self.eltBloc.getText().strip()
                    if bloc!="":
                        txt = f"[{bloc}] {txt}"
                self.nameAff.setText(f"       →  {txt}")
        except: return
    
    def autoStyle(self, data=None):
        self.eltStyle.clear()
        elt = self.element.get()
        if elt==None:
            js = {}
            txt = ""
        else:
            js = self.jsStyle(elt.get('style'))
            txt = elt.get('style') or ""
        style = self.eltStyle.get()
        content = style.get('content')
        self.memoStyle = {}
        do = style.get('do')
        self.eltStyle.detail = None
        self.eltStyleFill.setWidget()
        self.eltStyleSvg.setWidget()
        self.eltStyleEdit.setWidget()
        self.eltStyleSize.setWidget()
        

        if do=='edit':
            w = QtWidgets.QLineEdit(txt)
            self.eltStyle.add(w)
            self.eltStyle.detail = w
            self.eltStyleEdit.setWidget(w)
            
        if do=='qml':
            hbox = QtWidgets.QHBoxLayout()
            self.eltStyle.add(hbox)
            hsbox = QtWidgets.QHBoxLayout()
            hbox.addLayout(hsbox)
            hbox.setAlignment(hsbox, Qt.AlignLeft)
            l = QtWidgets.QLabel(f" Voir")
            hsbox.addWidget(l)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "qml.png"))
            bView = QtWidgets.QPushButton(ico, "")
            bView.setMaximumWidth(30)
            hsbox.addWidget(bView)
            hsbox = QtWidgets.QHBoxLayout()
            hbox.addLayout(hsbox)
            hbox.setAlignment(hsbox, Qt.AlignRight)
            l = QtWidgets.QLabel(f" Charger")
            hsbox.addWidget(l)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "folder.png"))
            bOpen = QtWidgets.QPushButton(ico, "")
            bOpen.setMaximumWidth(30)
            hsbox.addWidget(bOpen)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "qgis.png"))
            bQgis = QtWidgets.QPushButton(ico, "")
            bQgis.setMaximumWidth(30)
            hsbox.addWidget(bQgis)
            bView.clicked.connect(partial(self.qmlChooseAction, 'qml'))
            bOpen.clicked.connect(partial(self.qmlChooseAction, 'open'))
            bQgis.clicked.connect(partial(self.qmlChooseAction, 'qgis'))
            self.eltStyle.bView = bView
            
            w = QtWidgets.QWidget()
            self.eltStyle.add(w)
            hbox = QtWidgets.QHBoxLayout(w) 
            l = QtWidgets.QLabel()
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "qgis.png"))
            l.setMaximumWidth(20)
            l.setPixmap(ico.pixmap(15,15))
            hbox.addWidget(l)
            combo = QgsMapLayerComboBox()
            combo.setFilters(QgsMapLayerProxyModel.VectorLayer)
            hbox.addWidget(combo)
            self.selLoadedLayer(combo)
            w.combo = combo
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "ok.png"))
            b = QtWidgets.QPushButton(ico, "")
            b.setMaximumWidth(30)
            hbox.addWidget(b)
            b.clicked.connect(self.getStyleFromLayer)
            w.butt = b
            self.eltStyle.wQgis = w
            w = QtWidgets.QWidget()
            self.eltStyle.add(w)
            hbox = QtWidgets.QHBoxLayout(w) 
            l = QtWidgets.QLabel()
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "folder.png"))
            l.setMaximumWidth(20)
            l.setPixmap(ico.pixmap(15,15))
            hbox.addWidget(l)
            l = QtWidgets.QLabel()
            hbox.addWidget(l)
            w.label = l
            w.file = ""
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "ok.png"))
            b = QtWidgets.QPushButton(ico, "")
            b.setMaximumWidth(30)
            hbox.addWidget(b)
            b.clicked.connect(self.getStyleFromQml)
            w.butt = b
            self.eltStyle.wOpen = w
            self.eltStyle.detail = {'qml':True, 'value':txt}
            self.qmlChooseAction()

  
        if do=='simple':
            fill = js.get('fill')
            size = js.get('size') or 1
            if data:
                fill = data.get('fill', fill)
                size = data.get('size', size)
            self.memoStyle['fill'] = fill
            hbox = QtWidgets.QHBoxLayout()
            self.eltStyle.add(hbox)
            w = QgsColorButton()
            hbox.addWidget(w)
            self.eltStyle.detail = w
            self.eltStyleFill.setWidget(w)
            self.eltStyleFill.set(fill)
            w.colorChanged.connect(partial(self.reloadStyleSVG, w))
            w = QtWidgets.QDoubleSpinBox()
            self.eltStyleSize.setWidget(w)
            w.setRange(0.1, 10)
            try:
                w.setStepType(QAbstractSpinBox.AdpativeDecimalStepType)
            except:
                pass
            w.setValue(float(size))
            hbox.addWidget(w)
            w.valueChanged.connect(self.enabledModButton)
            w.valueChanged.connect(partial(self.changeStyleDetail, 'size', w))
            
            self.eltStyle.detail = {'simple':True, 'fill':fill, 'size':size}

            
        if do=='svg':
            file = js.get('marker', {}).get('svg')
            code = js.get('marker', {}).get('code') or None
            fill = js.get('marker', {}).get('fill')
            size = js.get('marker', {}).get('size') or 1
            if data:
                file = data.get('svg', file)
                code = data.get('code', code)
                fill = data.get('fill', fill)
                size = data.get('size', size)
            self.memoStyle['svg'] = file
            self.memoStyle['fill'] = fill    
            self.memoStyle['size'] = size
            param = {}
            if fill:
                param['fill'] = fill

            if not file or file=='None':
                ico = QtGui.QIcon(os.path.join(self.imageFolder, "svg.png"))
                butt = QtWidgets.QPushButton(ico, "")
                file2 = None
            else:
                file2 = getSvgPath(file, code)
                
                if not file2:
                    file2 = self.pdb.setFile(path=self.svgFolder, key=file, code='file_svg')
                
                ico = svgIco(file2, param)
                butt = QtWidgets.QPushButton(ico, "")
                butt.setToolTip(file)
            hbox = QtWidgets.QHBoxLayout()
            self.eltStyle.add(hbox)
            butt.setMaximumWidth(50)
            hbox.addWidget(butt)
            self.eltStyleSvg.setWidget(butt)
            butt.clicked.connect(partial(self.openSVG, file2, param))  
            self.enabledModButton()
            if file2 and ico.isFillable():
                w = QgsColorButton()
                hbox.addWidget(w)
                self.eltStyleFill.setWidget(w)
                self.eltStyleFill.set(fill)
                w.colorChanged.connect(partial(self.reloadStyleSVG, w))
            
            w = QtWidgets.QDoubleSpinBox()
            self.eltStyleSize.setWidget(w)
            w.setRange(0.1, 10)
            try:
                w.setStepType(QAbstractSpinBox.AdpativeDecimalStepType)
            except:
                pass
            w.setValue(float(size))
            hbox.addWidget(w)
            w.valueChanged.connect(self.enabledModButton)
            w.valueChanged.connect(partial(self.changeStyleDetail, 'size', w))
            self.eltStyle.detail = {'image':True, 'svg':file, 'code':code, 'fill':fill, 'size':size, 'fullPath':file2}
        
        if do=='file':
            self.eltStyle.detail = {'file':style['file']}
            file2 = os.path.join(self.styleFolder, style['file'])
            self.eltStyle.detail['fullPath'] = file2
            if 'vars' in style:
                self.eltStyle.detail['widgets'] = {}
                form = QtWidgets.QFormLayout()
                form.setContentsMargins(0,0,0,0)
                self.eltStyle.add(form)
                list = [""]
                try:
                    table = elt.get('tablename')
                except:
                    table = None
                if table:
                    list.extend(self.psql.getColumnsTable(table, elt.get('schemaname')))
                for k,c in style.get('vars').items():
                    l = QtWidgets.QLabel(c['label'])
                    if table:
                        combo = QtWidgets.QComboBox()
                    else:
                        combo = QtWidgets.QLineEdit()
                    wf = combo
                    w = adminWidget()
                    w.setWidget(combo)
                    w.refresh(list)
                    w.changed.connect(self.enabledModButton)
                    self.eltStyle.detail['widgets'][k] = w
                    v = js.get(k, {}).get('col')
                    if not v:
                        v = c.get('default')
                    w.set(v)
                    if 'coeff' in c:
                        wf = QtWidgets.QHBoxLayout()
                        wf.setSpacing(0)
                        wf.addWidget(combo)
                        v = js.get(k, {}).get('coeff')
                        if not v:
                            v = c.get('coeff', {}).get('default')
                        list2 = []
                        if 'unit' in c['coeff'] and c['coeff']['unit'] in self.translator['units']:
                            for kk,vv in self.translator['units'][c['coeff']['unit']].items():
                                list2.append((kk,vv))
                        if len(list2)>0:
                            label2 = None
                            combo2 = QtWidgets.QComboBox()
                            combo2.setMaximumWidth(50)
                        else:
                            l = QtWidgets.QLabel("*")
                            l.setMaximumWidth(6)
                            wf.addWidget(l)
                            combo2 = QtWidgets.QSpinBox()
                            combo2.setButtonSymbols(QtWidgets.QAbstractSpinBox.NoButtons)
                            combo2.setMaximumWidth(44)
                            combo2.setRange(1, 1000000)
                        w2 = adminWidget()
                        w2.setWidget(combo2)
                        w2.refresh(list2)
                        w2.changed.connect(self.enabledModButton)
                        w.coeff = w2
                        w2.set(v, True)
                        wf.addWidget(combo2)    
                    form.addRow(l, wf)
                if not table:
                    l = QtWidgets.QLabel("La paramétrisation du style au niveau du groupe impose de retrouver les mêmes noms de champs dans toutes les couches associées")
                    l.setWordWrap(True)
                    font = QtGui.QFont()
                    font.setItalic(True)
                    l.setFont(font)
                    self.eltStyle.add(l)
            
        
    def changeStyleDetail(self, name, widget):
        self.eltStyle.detail[name] = widget.value()
     
    def makeStyle(self):
        style = self.eltStyle.get()
        if style:
            content = style.get('content')
            w = self.eltStyle.detail
            if w:
                if isinstance(w, QtWidgets.QComboBox):    
                    content = content.replace('_self_', f"{w.currentData()}")
                if isinstance(w, QgsColorButton):    
                    content = content.replace('_self_', f"{w.color().name()}")
                if isinstance(w, QtWidgets.QLineEdit):    
                    content = content.replace('_self_', f"{w.text()}")
                if isinstance(w, dict):    
                    if 'qml' in w:
                        content = w['value'].replace("'","''")
                    elif 'simple' in w:
                        content = content.replace('_self_', f"{w['fill']}") 
                        content = content.replace('_self2_', f"{w['size']}") 
                    elif 'image' in w:
                        content = content.replace('_self_', f"{w['svg']}")
                        content = content.replace('_self1_', f"{w['code']}")
                        content = content.replace('_self2_', f"{w['fill']}") 
                        content = content.replace('_self3_', f"{w['size']}") 
                        # blob = self.pdb.readFile(getSvgPath(w['svg']))
                        blob = self.pdb.readFile(w['fullPath'])
                        self.pdb.appendData(w['svg'], code='file_svg', blob=blob)
                    elif 'file' in w:
                        file = w['file']
                        
                        blob = self.pdb.readFile(w['fullPath'])
                        self.pdb.appendData(file, code='file_json', blob=blob)
                        
                        txt = f'"{file}"'
                        if 'vars' in style:
                            for k,v in style.get('vars').items():
                                try:
                                    s = w['widgets'][k]
                                    col = s.get()
                                    try:
                                        coeff = s.coeff.get()
                                    except:
                                        coeff = None
                                except:
                                    col = c.get('default')
                                    coeff = c.get('coeff', {}).get('default')
                                if coeff:
                                    coeff = f', "coeff":{coeff}'
                                else:    
                                    coeff = ""
                                txt += f', "{k}":{{"col":"{col}"{coeff}}}'
                        content = content.replace('_self_', txt) 
                    else:
                        content = None
            if content:
                return f"'{content}'"
            else:
                return 'NULL'
        else:
            return 'NULL'          
        
    def jsStyle(self, style):
       
        try:
            jsStyle = json.loads(style)
        except:
            # print(sys.exc_info())
            jsStyle = {}
            
        if jsStyle==None:
            return {}    
            
        return jsStyle
    
    def encaps(self, txt):
        txt = txt.replace("'", "''")
        return txt
    
    def makeWordlist(self, *v, sep=','):
        l = []
        for s in v:
            for m in str(s).split(sep):
                m = m.strip().lower()
                if m!="" and m not in l: l.append(m)
        return ", ".join(l)
    
    def saveModificationElement(self): 
        self.pdb.resetData()
        elt = self.element.get()
        fields = []
        sqlplus = ""
        fields.append(f"code='{self.eltCode.get()}'")
        fields.append(f"name='{self.encaps(self.eltName.get())}'")
        fields.append(f"tags='{self.encaps(self.makeWordlist(self.eltTags.get()))}'")
        fields.append(f"style={self.makeStyle()}")
        if self.eltStats!=None:
            fields.append(f"stats={self.eltStats.stat.setMemorize()}")
        if self.eltBloc.widget:
            fields.append(f"bloc='{self.encaps(self.eltBloc.getText().strip())}'")
        fields.append(f"cluster='{self.eltCluster.get()}'")
        order = self.eltOrder.get()
        if order==0:  order = 'NULL'
        fields.append(f'"order"={order}')
        if self.eltParent.widget!=None:
            parent = self.eltParent.get()
            if not parent or parent=='NULL':
                parentNew = self.eltParent.getText().strip()
                if parentNew!="":
                    sql = f"SELECT id FROM {self.fullAdmin} WHERE (tablename is null or tablename='') and name='{parentNew}'"
                    parent = self.psql.sqlInsert(sql)
                    if not parent:
                        sql = f"INSERT INTO {self.fullAdmin} (code, name)" + \
                            f" VALUES ('{self.eltCode.get()}', '{self.encaps(parentNew)}')" + \
                            f" RETURNING id"
                        parent = self.psql.sqlInsert(sql)
                else:
                    parent = 'null'
            fields.append(f"parent={parent}")
        if self.eltAssoc.widget!=None:
            assoc = ",".join(list(map(str,self.eltAssoc.targetList)))
            if assoc=="": assoc = 'null'
            else: assoc = f"'{assoc}'"
            fields.append(f"assoc={assoc}")
            sqlplus += self.autoAssocSave(elt.get('id'), self.eltAssoc.targetOrigine, self.eltAssoc.targetList)
        sql = f"UPDATE {self.fullAdmin} SET " + ", ".join(fields) + \
            f" WHERE id={elt.get('id')}" + sqlplus
        self.psql.sqlSend(sql, True)
        self.pdb.sendData()
        self.initList()
        self.action.restore()
        self.relodAfterChanged()
        
    def autoAssocSave(self, ido, ori, dest):
        if not self.dock.param.get('autoAssoc'): return ""
        sql = ""
        s = set(ori)
        s.update(dest)
        for id in s:
            if id not in self.dictElement: continue
            l = splitId(self.dictElement[id].get('assoc'), ',')
            nb = len(l)
            if id not in ori and ido not in l: l.append(ido)
            if id not in dest and ido in l: l.remove(ido)
            if len(l)!=nb:
                assoc = ','.join(list(map(str,l))) if len(l)>0 else 'null'
                sql += f"; UPDATE {self.fullAdmin} SET assoc='{assoc}' WHERE id={id}"
        return sql
    
    def saveModificationMultiple(self, target):
        self.pdb.resetData()
        field = ""
        cond = ""
        if target=="style":
            field = f"style={self.makeStyle()}"
        if target=="bloc":
            field = f"bloc='{self.eltBloc.getText().strip()}'"
            # cond = " and tablename is not null"
        if target=="tags":
            tags =self.encaps(self.makeWordlist(self.eltTags.get()))
            if self.eltTags.erase.isChecked():
                field = f"tags='{tags}'"
            else:
                field = f"tags=case when tags is null or tags='' then '{tags}' else concat(tags,', ','{tags}') end"
        
        if target=="parent":
            parent = self.eltParent.get()
            if not parent or parent=='NULL':
                parentNew = self.eltParent.getText().strip()
                if parentNew!="":
                    sql = f"INSERT INTO {self.fullAdmin} (code, name)" + \
                        f" VALUES ('{self.eltParent.targetCode}', '{self.encaps(parentNew)}')" + \
                        f" RETURNING id"
                    parent = self.psql.sqlInsert(sql)
                else:
                    parent = 'null'
            field = f"parent={parent}"
            cond = " and tablename is not null"
        if target=="order":
            order = self.eltOrder.get()
            if order==0:  order = 'NULL'
            field = f"\"order\"={order}"
        
        if field!="":
            ids = ",".join(map(str, self.action.multipleListChoosen))
            sql = f"UPDATE {self.fullAdmin} SET {field}" + \
                f" WHERE id in ({ids})" + cond
            self.psql.sqlSend(sql, True)
            self.pdb.sendData()
            self.initList()
            self.datasChanged.emit(self.action.multipleListChoosen)

    def openSVG(self, file, param):
        if not self.dialogSVG:
            dialog = svgDialog(file, param)
            dialog.accepted.connect(partial(self.reloadStyleSVG, dialog))
            dialog.finished.connect(self.closeSVG)
            self.dialogSVG = dialog
    
    def closeSVG(self):
        self.dialogSVG = None
    
    def reloadStyleSVG(self, dialog=None):
        if dialog!=None:
            if isinstance(dialog, svgDialog):    
                code, file = dialog.choice()
                self.memoStyle['code'] = code
                self.memoStyle['svg'] = file
                dialog.clean()
            if isinstance(dialog, QgsColorButton):    
                self.memoStyle['fill'] = dialog.color().name()
            if isinstance(dialog, QtWidgets.QDoubleSpinBox):    
                self.memoStyle['size'] = dialog.value()    
        self.autoStyle(self.memoStyle)
        
    def importSVG(self):
        dialog = QtGui.QFileDialog()
        fname = dialog.getOpenFileName(None, "Import SVG", "", "SVG files (*.svg)")
         
    def selLoadedLayer(self, combo):
        elt = self.element.get()
        if elt==None:
            return
        ids = []
        for p in [elt.get('id'), elt.get('parent'), self.eltParent.get()]:
            if p!=None and p!='NULL' and p!='null' and p not in ids:
                ids.append(p)
                for it in self.getChildren(p):
                    ids.append(it['elt']['id'])
        layers = self.dock.dyn.getAll()
        layer = None
        for id in ids:
            if layer!=None:
                break
            for k,v in layers.items():
                if layer!=None:
                    break
                if id==k:
                    layer = v
        combo.setLayer(layer)     
  
    def getStyleFromLayer(self):
        layer = self.eltStyle.wQgis.combo.currentLayer()
        if layer!=None:
            xml = QtXml.QDomDocument()
            layer.exportNamedStyle(xml)
            txt = xml.toString()
        else:
            txt = ""
        self.setStyleFromText(txt)
        
    def getFileFromQml(self, file):
        self.eltStyle.wOpen.file = file[0]
        self.eltStyle.wOpen.label.setText(file[0])
        
    def getStyleFromQml(self):
        f = QFile(self.eltStyle.wOpen.file)
        content = ""
        if f.open(QIODevice.ReadOnly | QIODevice.Text):
            buff = QTextStream(f)
            while not buff.atEnd():
                line = buff.readLine()
                content += line
            f.close()
        self.setStyleFromText(content)
        
    def setStyleFromText(self, txt):
        self.eltStyle.detail['value'] = txt
        self.enabledModButton()
        self.qmlChooseAction()
        
    def qmlChooseAction(self, code=None):
        self.eltStyle.wQgis.hide()
        self.eltStyle.wOpen.hide()
        txt = self.eltStyle.detail['value']
        if txt!="":
            self.eltStyle.bView.setEnabled(True)
        else:
            self.eltStyle.bView.setEnabled(False)
        if code=='qml':
            dialog = showDialog("Contenu du QML", txt)
        if code=='qgis':
            self.eltStyle.wQgis.show()
        if code=='open':
            self.eltStyle.wOpen.butt.setEnabled(False)
            self.eltStyle.wOpen.show()
            dialog = QtWidgets.QFileDialog()
            fileName = dialog.getOpenFileName(None, "Open QML", "", "QML Files (*.qml)")
            file = fileName[0]
            self.eltStyle.wOpen.file = file
            self.eltStyle.wOpen.label.setText(os.path.basename(file))
            QtWidgets.QApplication.processEvents()
            self.eltStyle.wOpen.butt.setEnabled(True)

        

    def initData(self):
        self.svgFolder = os.path.join(os.path.dirname(__file__),'svg')
        self.styleFolder = os.path.join(os.path.dirname(__file__),'styles')
        for path in (self.svgFolder,self.styleFolder):
            if not os.path.exists(path):
                os.mkdir(path)
        self.translator = {
            'style': [
                {
                    'label':'Auto',
                    'do': None,
                },
                {
                    'label':'Simple',
                    'do': 'simple',
                    'content': '{"fill":"_self_", "size":"_self2_"}',
                },
                {
                    'label':'Image',
                    'target': 'point',
                    'do': 'svg',
                    'content': '{"marker":{"svg":"_self_", "code":"_self1_", "fill":"_self2_", "size":"_self3_"}}',
                },
                {
                    'type': 'file',
                    'content': '{"file":_self_}',
                },
                {
                    'label':'Personnalisé',
                    'do': 'qml',
                    'content': '<!doctype_self_',
                },
                {
                    'label':'Texte brut',
                    'do': 'edit',
                    'content': '_self_',
                },
            ],
            
            'action': {
                'mod': "  Modifier",
                'add': "  Ajouter dans",
                'list': ['mod', 'add'],

            },
            
            'units': {
                'meter': {
                    'm': 1,
                    'cm': 100,
                    'mm': 1000,
                }
            },
            
        }




        

class adminWidget(QObject):
    
    changed = pyqtSignal()
    
    def __init__(self, default=None, callback=None, *args, **kwargs):
        QObject.__init__(self)
        self.widget =None
        self.layout = None
        self.memo = default
        self.setCallback(callback, *args, **kwargs)
        self.freeze = False
    
    def setLayout(self, layout):
        self.layout = layout
        
    def setCallback(self, callback=None, *args, **kwargs):
        self.callback = callback
        self.args = args
        self.kwargs = kwargs
        
    def setWidget(self, widget=None):
        self.widget = widget
        if widget!=None:
            if isinstance(self.widget, QgsMapLayerComboBox):
                self.widget.layerChanged.connect(self.onChanged)
            if isinstance(self.widget, toggleButton):
                self.widget.changed.connect(self.onChanged)
            if isinstance(self.widget, QtWidgets.QComboBox):
                self.widget.currentIndexChanged.connect(self.onChanged)
            if isinstance(self.widget, QtWidgets.QCheckBox):
                self.widget.stateChanged.connect(self.onChanged)
            if isinstance(self.widget, QtWidgets.QLineEdit):
                self.widget.textChanged.connect(self.onChanged)
            if isinstance(self.widget, QgsColorButton):
                self.widget.colorChanged.connect(self.onChanged)
            if isinstance(self.widget, QtWidgets.QSpinBox):
                self.widget.valueChanged.connect(self.onChanged)   
        
    def refresh(self, l):
        if isinstance(self.widget, QtWidgets.QComboBox):
            if isinstance(l, list):
                self.clear()
                self.freeze = True
                try:
                    while self.widget.count():
                        self.widget.removeItem(0)
                    for e in l:
                        if isinstance(e, tuple):
                            self.widget.addItem(*e)
                        elif e is None:
                            self.widget.insertSeparator(self.widget.count())
                        else:
                            self.widget.addItem(e, e)
                except: pass
                self.freeze = False
        
    def onChanged(self, toto=True):
        if self.freeze:
            return
        self.save()
        self.clear()
        if self.callback:
            self.callback(*self.args, **self.kwargs)
        self.changed.emit()
    
    def get(self):
        try:
            if isinstance(self.widget, QgsMapLayerComboBox):
                return self.widget.currentLayer()
            if isinstance(self.widget, QtWidgets.QComboBox):
                return self.widget.currentData()
            if isinstance(self.widget, QtWidgets.QCheckBox):
                return self.widget.isChecked()
            if isinstance(self.widget, QtWidgets.QLineEdit):
                return self.widget.text()
            if isinstance(self.widget, toggleButton):
                return self.widget.text()
            if isinstance(self.widget, QgsColorButton):
                return self.widget.color().name()
            if isinstance(self.widget, QtWidgets.QSpinBox):
                return self.widget.value()
        except:
            pass
    
    def getText(self):
        try:
            if isinstance(self.widget, QgsMapLayerComboBox):
                return self.widget.currentLayer().name()
            if isinstance(self.widget, QtWidgets.QComboBox):
                return self.widget.currentText()
            if isinstance(self.widget, QtWidgets.QCheckBox):
                return self.widget.isChecked()
            if isinstance(self.widget, QtWidgets.QLineEdit):
                return self.widget.text()
            if isinstance(self.widget, toggleButton):
                return self.widget.text()   
            if isinstance(self.widget, QgsColorButton):
                return self.widget.color().name()
            if isinstance(self.widget, QtWidgets.QSpinBox):
                return self.widget.value()
        except:
            pass
                
    def set(self, val, data=None):
        try:
            if isinstance(self.widget, QgsMapLayerComboBox):
                self.widget.setLayer(val)
            elif isinstance(self.widget, QtWidgets.QComboBox):
                if data or val==None:
                    for i in range(self.widget.count()):
                        if self.widget.itemData(i)==val:
                            self.widget.setCurrentIndex(i)
                            break
                elif isinstance(val, dict):
                    for i in range(self.widget.count()):
                        data = self.widget.itemData(i)
                        if data and isinstance(data, dict):
                            if val.get('id')==data.get('id'):
                                self.widget.setCurrentIndex(i)
                                break
                elif isinstance(val, int):
                    self.widget.setCurrentIndex(val)
                else:
                    self.widget.setCurrentText(val)
            if isinstance(self.widget, QtWidgets.QCheckBox):
                self.widget.setChecked(val)
            if isinstance(self.widget, QtWidgets.QLineEdit):
                if val:
                    self.widget.setText(f"{val}")
                else:
                    self.widget.setText(f"")
            if isinstance(self.widget, toggleButton):
                self.widget.setFromText(val)
            if isinstance(self.widget, QgsColorButton):
                color = QtGui.QColor(val)
                self.widget.setColor(color)
            if isinstance(self.widget, QtWidgets.QSpinBox):
                if val:
                    self.widget.setValue(val)
        except:
            # print(sys.exc_info())
            pass
        self.save()
            
    def save(self):
        self.memo = self.get()
            
    def restore(self):
        if self.get()!=self.memo:
            self.set(self.memo)
        else:
            self.onChanged()
    
    def clear(self):
        if self.layout!=None:
            clearLayout(self.layout)
            
    def add(self, object):
        if self.layout!=None:
            if isinstance(object, QtWidgets.QWidget):
                self.layout.addWidget(object)
            if isinstance(object, QtWidgets.QLayout):
                self.layout.addLayout(object)
    
        


class jsStyle():
    def __init__(self):
        self.w = 1



class svgDialog(QgsDialog):
   
    def __init__(self, file=None, param={}):

        buttons = QtWidgets.QDialogButtonBox.Ok | QtWidgets.QDialogButtonBox.Cancel
        QgsDialog.__init__(self, iface.mainWindow(),
                            fl=Qt.WindowFlags(),
                            buttons=buttons,
                            orientation=Qt.Horizontal)
        
        self.svgFolder = os.path.join(os.path.dirname(__file__), 'svg')
        plugFolder = os.path.join(os.path.dirname(__file__), 'svg')
        qgisFolder = os.path.join(os.environ.get('QGIS_PREFIX_PATH'), '.', 'svg')
        self.maxRow = 8
        self.target = None
        self.list = []
        self.file = file
        self.fileList = {}
        self.manager = manageTasks()
        self.setWindowTitle("Sélection de l'icone SVG") 
        self.makeIcoBloc('plug', plugFolder, deep=1, exclude=["tmp"])
        self.makeIcoBloc('qgis', qgisFolder, 2)
        self.makeLabel()
        self.show()

    def makeIcoBloc(self, code, p, deep=0, exclude=[]):
        titles = {'plug':"SVG du plugin", 'qgis':"SVG Qgis"}
        title = titles[code]
        w = QtWidgets.QLabel(title, self)
        w.setMinimumWidth((self.maxRow+1)*60)
        self.layout().addWidget(w)
        
        sc = QtWidgets.QScrollArea(self)
        sc.setWidgetResizable(True)
        self.layout().addWidget(sc)
        w = QtWidgets.QWidget()
        w.setMinimumWidth(self.maxRow*60)
        gbox = QtWidgets.QGridLayout()
        gbox.setSpacing(0)
        gbox.setAlignment(Qt.AlignTop)
        w.setLayout(gbox)
        sc.setWidget(w)
        
        gbox.code = code
        gbox.i = 1
        gbox.j = 0
        self.fileList[p] = {'layout':gbox, list:[], 'sc':sc}
        if deep>0:
            l = QtWidgets.QLabel("Recherche en cours...")
            gbox.addWidget(l)
            timer = rdiTimer(self)
            timer.setLabel(l, deb=l.text())
            timer.setMaxPts(10)
            timer.start(200)
            gbox.timer = timer
            self.asyncBrowse(p, deep, exclude)
        else:
            self.browse(p)
            self.loadIcoInBloc(p)
                
    def std(self, f):
        if f is None: return f
        f2 = f
        f2 = f2.replace("\\", "/")
        f2 = f2.lower()
        return f2
    
    def loadIcoInBloc(self, p):
        gbox = self.fileList[p]['layout']
        try:
            gbox.timer.stop()
        except:
            pass
        clearLayout(gbox)
        list = self.fileList[p]['list']
        for file in list:
            gbox.j += 1
            if gbox.j>self.maxRow:
                gbox.j = 1
                gbox.i += 1
            l = svgChoice(file)
            l.code = gbox.code
            self.list.append(l)
            l.clicked.connect(partial(self.selectIcoSVG, l))
            gbox.addWidget(l, gbox.i, gbox.j)
            if self.std(self.file)==self.std(file):
                self.target = l
                self.selectIcoSVG(self.target)
        if gbox.i==1:
            for k in range(self.maxRow-gbox.j):
                gbox.j += 1
                l = svgChoice()
                gbox.addWidget(l, gbox.i, gbox.j)
        if gbox.i>1:
            nb = min(gbox.i, 5)
            self.fileList[p]['sc'].setMinimumHeight(nb*40)
    
    def asyncBrowse(self, p, deep=0, exclude=[]):
        m = mGlobalTask(f"Récupération svg dans {p}")
        m.task.setCallin(self.browse, p, deep, exclude)
        m.setCallback(self.loadIcoInBloc, p)
        self.manager.add(m)
    
    def browse(self, p, deep=0, exclude=[]):
        list = []
        for f in os.listdir(p):
            if f in exclude:
                continue
            file = os.path.join(p, f)
            name, ext = os.path.splitext(f)
            if ext.lower()=='.svg':
                l = svgChoice(file)
                list.append(file)
            else:
                if deep>0 and os.path.isdir(file):
                    list.extend(self.browse(file, deep-1, exclude))
        if p in self.fileList:
            self.fileList[p]['list'] = list
        return list
    
    def makeLabel(self):
        self.choiceLabel = QtWidgets.QLabel("", self)
        self.layout().addWidget(self.choiceLabel)
        if self.target:
            self.selectIcoSVG(self.target)
  
    def selectIcoSVG(self, target):
        if self.target:
            self.target.setSelected(False)
        self.target = target   
        self.target.setSelected(True)   
        self.choiceLabel.setText(os.path.basename(self.target.file))
        
    def choice(self):
        if self.target:
            path = self.target.file.replace("\\","/")
            tt = path.split('svg/')
            if len(tt)>1:
                file = tt[1]
            else:
                file = os.path.basename(path)
            return self.target.code, file

    def clean(self):
        for l in self.list:
            if l!=self.target:
                l.ico.clean()


    
        
class svgChoice(QtWidgets.QLabel):

    clicked = pyqtSignal()
    
    def __init__(self, file=None, param={}):
        QtWidgets.QLabel.__init__(self)
        self.svgFolder = os.path.join(os.path.dirname(__file__), 'svg')
        self.tmpFolder = 'tmp'
        self.makeTmp()
        self.file = file
        if file:
            self.ico = svgIco(file, param)
            pixmap = self.ico.pixmap(40,40)
            self.setPixmap(pixmap)
            self.setToolTip(file)

    def mousePressEvent(self, event):
        self.clicked.emit()
        
    def setSelected(self, bool):
        if bool:
            self.setStyleSheet("border: 2px solid black;")
            pixmap = self.ico.pixmap(60,60)
            self.setPixmap(pixmap)
        else:
            self.setStyleSheet("border: None;")
            pixmap = self.ico.pixmap(40,40)
            self.setPixmap(pixmap)
        
    def makeTmp(self):
        tmp = os.path.join(self.svgFolder, self.tmpFolder)
        if not os.path.isdir(tmp):
            os.mkdir(tmp)


class svgIco(QtGui.QIcon):
    
    def __init__(self, file, param={}):
        super(svgIco, self).__init__(file)
        self.file = file
        self.initData()
        self.changeIco(param)
    
    def initData(self):
        self.defaultParam = {
                'param(fill)': '#000000',
                'param(fill-opacity)': '1',
                'param(outline)': '#000000',
                'param(outline-opacity)': '1',
                'param(outline-width)': '1',
            }
        self.svgFolder = os.path.join(os.path.dirname(__file__), 'svg')
        self.tmpFolder = 'tmp'
        self.makeTmp()
        self.fill = False
        self.svg = None
        self.tmp = None
        
    def changeIco(self, param={}):
        self.param = param
        bool = False
        if param:
            bool = True
        if self.file and self.file!='None':
            self.deleteFile(self.tmp)
            self.tmp = self.copySVG(self.file, bool)
            if self.tmp:
                self.addFile(self.tmp)
    
    def makeTmp(self):
        tmp = os.path.join(self.svgFolder, self.tmpFolder)
        if not os.path.isdir(tmp):
            os.mkdir(tmp)
    
    def clean(self):
        # self.deleteFile(self.tmp)
        pass
    
    def copySVG(self, file, force=False):
        d, n = os.path.split(file)
        if not self.param:
            n = "default_" + n
        tmp = makeUniqueIdent()
        file2 = os.path.join(self.svgFolder, self.tmpFolder, n)
        if not os.path.exists(file2) or force:
            self.svg = self.readFile(file)
            if not self.svg:
                return None
            svg = self.replaceParam(self.svg)
            self.writeFile(file2, svg)
        return file2
        
    def replaceParam(self, svg):
        if svg:
            svg2 = svg
            for k,v in self.getParams().items():
                while svg2.find(k)>=0:
                    e = svg2[svg2.find(k):]
                    e = e.split('"')[0]
                    svg2 = svg2.replace(e, v)
            return svg2
     
    def isFillable(self):
        if not self.svg:
            self.svg = self.readFile(self.file)
        if self.svg!=None and self.svg.find('param(fill)')>=0:
            return True
        
    def getParams(self):
        param = self.defaultParam
        if 'fill' in self.param:
            param['param(fill)'] = self.param['fill']
            param['param(outline)'] = self.param['fill']
        return param
            
    def readFile(self, file):
        f = QFile(file)
        if not f.open(QIODevice.ReadOnly | QIODevice.Text):
            return
        content = ""
        buff = QTextStream(f)
        while not buff.atEnd():
            line = buff.readLine()
            content += line
        f.close()
        return content
        
    def writeFile(self, file, content):
        f = QFile(file)
        if not f.open(QIODevice.WriteOnly | QIODevice.Text):
            return
        out = QTextStream(f)
        out << content   
        f.close()

    def deleteFile(self, file):
        if file and os.path.exists(file):
            os.remove(file)
            
            
            
            
            