# -*- coding: utf-8 -*-

import sys, os, json
from functools import partial

from qgis.gui import *
from qgis.core import *
from PyQt5 import QtGui, QtWidgets, uic, QtXml, QtSvg
from PyQt5.QtCore import *

from .rdi_param import rdiParamBloc
from .rdi_tools import quote, makeUniqueIdent, clearLayout, rdiTimer, dblClickLabel
from .rdi_layer import rdiLayer, rdiLayersCollection



class rdiHyperlink():
    
    def __init__(self, dock):
        self.dock = dock
        self.tool = rdiHyperlinkTool(self)
        self.initData()

    def load(self, layout):
        self.layout = layout
        # self.makeTitle()
        self.cbMod = QtWidgets.QCheckBox("Affecter une action ")
        self.cbMod.setChecked(self.modActif)
        self.makeList()
        self.makeParams()
        self.makeModif()
        
    def actuAdmin(self):
        b = self.dock.param.get('admin')
        self.modifWidget.setVisible(b)
        
    
    def makeTitle(self):
        l = QtWidgets.QLabel("Hyperliens")
        font = QtGui.QFont()
        font.setBold(True)
        l.setFont(font)
        self.layout.addWidget(l)
        
    def makeList(self):
        self.coll = rdiLayersCollection(self.dock, 'link')
        self.coll.setActu(self.actuLayers)
        self.coll.construct(self.layout)
        recup = self.dock.dyn.getAll()
        for elt in self.dock.psql.getTableAdmin('link', True):
            rdi = rdiLayer(elt)
            self.coll.add(rdi)
            if rdi.id() in recup.keys():
                rdi.recup(recup[rdi.id()])  
                del recup[rdi.id()]
        # QtWidgets.QApplication.processEvents()
        h = 60
        for rdi in self.coll.list:
            h += 20
        self.coll.wg.setMaximumHeight(h)        
        for k,v in recup.items():
            if not v.rdi.coll.matchCode('link'):
                continue
            self.dock.dyn.removeMapLayer(v.rdi)
    
    def makeFirst(self):
        if not self.dock.param.get('autoLinkLoad'): return
        for rdi in self.coll.list:
            if rdi.getJsonFromMeta('link').get('start'):
                rdi.cb.setChecked(True)
    
    def getChecked(self):
        nb = 0
        for rdi in self.coll.list:
            if rdi.checked: nb += 1
        return nb
        
    def makeParams(self):
        elts = [
            {
                'label': f"Chargement automatique",
                'help': 'p5-link',
                'description': f"Chargement automatique des couches hyperliens au démarrage",
                'ini': 'autoLinkLoad',
                'func': ['self.link.makeFirst()']
            },
            {
                'label': f"Forçage du tri",
                'help': 'p5-link',
                'description': f"Supplante le choix de tri défini dans chacune des couches",
                'ini': 'linkOrder',
                'next': {
                    'label': f"   ",
                    'ini': 'linkOrderChoice',
                    'type': 'combo',
                    'elements': self.linkOrderOptions,
                    'maxWidth': 100,
                },
            },
            {
                'label': f"Renvoi onglet dynamique",
                'help': 'p5-link',
                'description': f"Renvoi automatique sur l'onglet de croisement dynamique lorsque qu'une couche est chargée",
                'ini': 'linkCallDyn',
            },
            {
                'label': u"Accrochage ",
                'help': 'p5-link',
                'description': u"Tolérance d'accrochage sur la position du curseur par rapport à la localisation des entités",
                'ini': 'linkDist',
                'type': 'range',
                'min': -4,
                'max': 15,
                'func': ['self.link.actuLayers()']
            },
        ]
        gb = rdiParamBloc("link_Options", "Options", self.dock)
        self.layout.addWidget(gb)
        gb.add(elts, self.dock.changeParameter)
    
    def makeModif(self):
        sc = QtWidgets.QScrollArea()
        sc.setWidgetResizable(True)
        self.layout.addWidget(sc)
        w = QtWidgets.QWidget()
        self.modifWidget = w
        w.setObjectName("scrollAreaWidgetContents")
        gbox = QtWidgets.QVBoxLayout()
        gbox.setSpacing(0)
        gbox.setAlignment(Qt.AlignTop)
        w.setLayout(gbox)
        sc.setWidget(w)
        sc.setStyleSheet("QAbstractScrollArea {background-color: transparent;}  ")
        w.setStyleSheet("QWidget#scrollAreaWidgetContents {background-color: white; } ")
        
        h = QtWidgets.QHBoxLayout()
        gbox.addLayout(h)
        self.cbMod.stateChanged.connect(self.activeModif)
        font = QtGui.QFont()
        font.setBold(True)
        self.cbMod.setFont(font)
        h.addWidget(self.cbMod)
        w = QtWidgets.QComboBox()
        w.currentIndexChanged.connect(self.changeAction)
        self.comboAction = w
        h.addWidget(w)
        w = QtWidgets.QWidget()
        QtWidgets.QVBoxLayout(w)
        gbox.addWidget(w)
        self.actionData = w
        w = QtWidgets.QWidget()
        QtWidgets.QVBoxLayout(w)
        gbox.addWidget(w)
        self.itemData = w
        for k,v in self.actions.items():
            self.comboAction.addItem(v,k)


    def activeModif(self):
        self.modActif = self.cbMod.isChecked()
        self.actuLayers()
        
    def actuLayers(self, rdi=None):
        if not self.dock.on:
            return
        if rdi is None:
            for rdi in self.coll.list:
                if rdi.checked: self.actuLayers(rdi)
            return
        rdi.setLayer()
        if not self.cbMod.isChecked(): 
            self.setModif()
            return
        try:
            l,f = self.targetFeature
            if l.rdi.id()!=rdi.id(): return
            pkey = rdi.getIdentFeature()
            for fi in rdi.vlayer.getFeatures():
                if fi.attribute(pkey)==f.attribute(pkey):
                    self.setModif(rdi.vlayer, fi)
                    return
        except: 
            pass
        
    
    def getName(self, name, table):
        if not name or name=="": return table
        return name
    
    def getEntityName(self, l, f):
        try: name = f.attributes()[0]
        except: name = ""
        try: name = f.attribute(json.loads(l.rdi.getValueFromMeta('link')).get('col'))
        except: pass
        return f"{name}"
    
    def setModif(self, l=None, f=None):
        clearLayout(self.itemData.layout())
        self.targetFeature = (l,f)
        self.addButtonEnable()
        
        if l is None: return
        name = self.getEntityName(l, f)
        
        l = QtWidgets.QLabel(f"Actions pour {l.rdi.name} / {name}:")
        l.setWordWrap(True)
        font = QtGui.QFont()
        font.setUnderline(True)
        l.setFont(font)
        self.itemData.layout().addWidget(l)
        try: self.data = json.loads(f.attribute(self.a))
        except: self.data = {}
        v = QtWidgets.QVBoxLayout()
        v.setContentsMargins(30,0,0,0)
        self.itemData.layout().addLayout(v)
        lst = self.data.get('targets',[]).copy()
        for elt in self.dock.psql.getTableAdminEltFull(*lst):
        # for e in self.data.get('targets',[]):
            if not elt.get('id'): continue
            h = QtWidgets.QHBoxLayout()
            v.addLayout(h)
            ico = QtGui.QIcon(os.path.join(self.dock.imageFolder, "delete.png"))
            b = QtWidgets.QPushButton(ico, "")
            b.setMaximumWidth(20)
            b.clicked.connect(partial(self.deleteAction, elt.get('id')))
            h.addWidget(b)
            bloc = elt.get('bloc',elt.get('pbloc'))
            if bloc: bloc.strip()
            aff = self.getName(elt.get('name'),elt.get('tablename')) 
            if not elt.get('tablename'): aff = f" → {aff} "
            if elt.get('parent'): aff = f"{self.getName(elt.get('pname'),elt.get('ptablename'))} ({aff})"
            if bloc and bloc!='': aff = f"[{bloc}] : {aff}"  
            l = QtWidgets.QLabel(f"{aff}")
            h.addWidget(l)
            lst.remove(elt.get('id'))
        if len(lst)>0:
            h = QtWidgets.QHBoxLayout()
            v.addLayout(h)
            ico = QtGui.QIcon(os.path.join(self.dock.imageFolder, "delete.png"))
            b = QtWidgets.QPushButton(ico, "Supprimer les fantômes")
            b.setToolTip("Des affectations présentes sur cette entité ne correspondent plus à rien")
            b.clicked.connect(partial(self.deleteAction, *lst))
            h.addWidget(b)
            
        
        l = QtWidgets.QLabel("\n\n")
        self.itemData.layout().addWidget(l)
        l = self.makeInfoLabel(f"Détails des attributs l'entité :")
        self.itemData.layout().addWidget(l)
        form = QtWidgets.QFormLayout()
        form.setContentsMargins(30,0,0,0)
        self.itemData.layout().addLayout(form)
        na = f.fields().names()
        for i,a in enumerate(f): 
            l = self.makeInfoLabel(f"{na[i]} :")
            l.setMaximumWidth(100)
            l2 = self.makeInfoLabel(f"   {a}")
            form.addRow(l, l2)
        self.changeAction()
        
        if self.dock.tab.currentIndex()!=self.dock.lLink.indice:
            self.dock.tab.setCurrentIndex(self.dock.lLink.indice)


    def makeInfoLabel(self, txt):
        l = QtWidgets.QLabel(txt)
        l.setWordWrap(True)
        font = QtGui.QFont()
        font.setItalic(True)
        l.setFont(font)
        l.setStyleSheet('color:#888888')
        return l
    
    def changeAction(self):
        clearLayout(self.actionData.layout())
        self.addButton = None
        listealea = self.dock.psql.getTableAdmin(code='alea', compact=True)
        ca = self.comboAction.currentData()
        
        if ca in ('alea', 'aleazone'):
            h = QtWidgets.QHBoxLayout()
            self.actionData.layout().addLayout(h)
            w = QtWidgets.QComboBox()
            self.comboTarget = w
            h.addWidget(w)
            w.addItem("", None)
            memo = {}
            for elt in listealea:
                id = elt.get('id')
                code = elt.get('code')
                name = elt.get('name')
                table = elt.get('tablename')
                bloc = elt.get('bloc')
                if not name: name = table
                memo[id] = name
                
                if ca=='alea' and not table: continue
                if ca=='aleazone' and table: continue
                if id in self.data.get('targets',[]): continue
                
                parent = elt.get('parent')
                aff = name
                if not name or name=="":
                    aff = table
                if not table:
                    aff = f" → {name} "
                if parent:
                    aff = f"{memo[parent]} ({aff})"
                if bloc:
                    bloc = bloc.strip() 
                    if bloc!='':
                        aff = f"[{bloc}] : {aff}"  
                w.addItem(aff, id)
            w = QtWidgets.QPushButton("Ajouter")
            w.clicked.connect(self.addAction)
            self.addButton = w
            h.addWidget(w)
        self.comboTarget.currentIndexChanged.connect(self.addButtonEnable)
        self.addButtonEnable()
               
    def addButtonEnable(self):
        if self.addButton is None: return
        b = True
        if self.comboTarget.currentData() in (None, ""): b = False
        if self.targetFeature is None: b = False
        self.addButton.setEnabled(b)
    
    def addAction(self):
        if self.comboTarget.currentData() in (None, ''): return
        if 'targets' not in self.data:
            self.data['targets'] = []
        self.data['targets'].append(self.comboTarget.currentData())
        self.sendAction()
        
    def deleteAction(self, *ids):
        if 'targets' not in self.data: return
        for id in ids: 
            try: self.data['targets'].remove(id)
            except: pass
        self.sendAction()

    def sendAction(self):
        l,f = self.targetFeature
        rdiAttr = l.rdi.getAttr()
        rdiTotal = self.dock.psql.full(rdiAttr['table'], rdiAttr['schema'])
        if self.a not in l.rdi.vlayer.fields().names():
            sql = f'alter table {rdiTotal} add "{self.a}" character varying'
            self.dock.psql.sqlSend(sql)
        pkey = l.rdi.getIdentFeature()
        if len(self.data.get('targets',[]))==0: txt = "NULL"
        else: txt = "'"+ json.dumps(self.data) + "'"
        sql = f'update {rdiTotal} set "{self.a}"={txt} where "{pkey}"={f.attribute(pkey)}'
        self.dock.psql.sqlSend(sql)
        self.actuLayers(l.rdi)
    
    
    def loadAction(self, l, f):
        try: data = json.loads(f.attribute(self.a))
        except: return
        loaded = list(map(lambda x: x.actif(), self.dock.alea.getEltsSelected()))
        loaded.extend(list(map(lambda x: x.actif(), self.dock.enjeu.getEltsSelected())))
        self.popMenu = QtWidgets.QMenu()
        self.popMenu.addSection(l.rdi.layerName()+" : "+self.getEntityName(l,f))
        if self.dock.param.get('linkOrder'): o = self.dock.param.get('linkOrderChoice')
        else: o = l.rdi.getJsonFromMeta('link').get('order')
        for elt in self.dock.psql.getTableAdminEltChilds(*data.get('targets',[]), ordered=o):
            if self.dock.alleviate.isExcludeId(elt.get('id')): continue
            b = elt.get('id') in loaded
            if b: ico = QtGui.QIcon(os.path.join(self.dock.imageFolder, "check.png"))
            else: ico = QtGui.QIcon()
            bloc = elt.get('bloc',elt.get('pbloc'))
            if bloc: bloc.strip()
            aff = self.getName(elt.get('name'),elt.get('tablename')) 
            if not elt.get('tablename'): continue
            if elt.get('parent'): aff = f"{self.getName(elt.get('pname'),elt.get('ptablename'))} ({aff})"
            if bloc and bloc!='': aff = f"[{bloc}] : {aff}"  
            self.popMenu.addAction(ico, aff, partial(self.loadAlea, elt.get('id'), not b))   
        if len(self.popMenu.children())>2:
            self.popMenu.popup(QtGui.QCursor.pos())
        else:
            self.cbMod.setChecked(True)
            self.setModif(l, f)
    
    def loadAlea(self, id, on):
        rdi, rdi2 = self.dock.alea.find(id, deep=True)
        if rdi2 is not None:
            rdi.combo.setCurrentIndex(rdi.combo.findData(rdi2))
        if on and not rdi.checked:
            rdi.cb.setChecked(True)
            rdi.checked = True
        if not on and rdi.checked:
            rdi.cb.setChecked(False)
            rdi.checked = False  
        if self.dock.param.get('linkCallDyn') and self.dock.tab.currentIndex()!=self.dock.lDyn.indice:
            self.dock.tab.setCurrentIndex(self.dock.lDyn.indice)
    
    
    def initData(self):
        self.addButton = None
        self.modActif = False
        self.targetFeature = (None,None)
        self.a = 'rdi_link'
        self.data = {}
        self.actions = {
            'aleazone' : "Charger une zone d'aléa",
            'alea' : "Charger un aléa",
        }
        self.linkOrderOptions = {
            'parent':"Natif", 
            'layer':"Couches",
            'bloc': "Thèmes",
        }

class rdiHyperlinkTool(QgsMapTool):
    def __init__(self, link):
        self.link = link
        self.dock = link.dock
        self.iface = self.dock.parent.iface
        self.canvas = self.iface.mapCanvas()
        super().__init__(self.canvas)

    def activate(self):
        super().activate()
        self.canvas.setCursor(QtGui.QCursor(QtCore.Qt.WhatsThisCursor))

    def deactivate(self):
        super().deactivate()
        self.canvas.setCursor(QtGui.QCursor(QtCore.Qt.ArrowCursor))
        self.deactivated.emit()

    def getLayers(self):
        l = []
        for rdi in self.link.coll.list:
            if rdi.checked: l.append(rdi.vlayer)
        return l
        return [self.iface.activeLayer()]
    
    def makeSelection(self, l, e):
        crs = self.canvas.mapSettings().destinationCrs()
        pt = e.mapPoint()
        d = self.getDistance(l)
        if l.crs().authid()!=crs.authid():
            tr = QgsCoordinateTransform(crs, l.crs(), QgsProject.instance())
            pt = tr.transform(pt)
        r = QgsRectangle(pt.x()-d, pt.y()-d, pt.x()+d, pt.y()+d)
        l.selectByRect(r)
    
    def getDistance(self, l):
        try: d = l.rdi.mmSize*self.canvas.scale()/2000
        except: d = self.canvas.mapUnitsPerPixel()*5
        return d*(5+self.dock.param.get('linkDist'))/5
    
    def canvasMoveEvent(self, e):
        nb = 0
        for l in self.getLayers():
            if l is None: continue
            try:
                self.makeSelection(l, e)
                nb += len(list(l.getSelectedFeatures()))
                l.removeSelection()
            except: pass
        if nb>0: self.canvas.setCursor(QtGui.QCursor(QtCore.Qt.PointingHandCursor))
        else: self.canvas.setCursor(QtGui.QCursor(QtCore.Qt.WhatsThisCursor))

    def canvasPressEvent(self, e):
        found = False
        for l in self.getLayers():
            if l is None: continue
            if found: break
            try:
                self.makeSelection(l, e)
                for f in l.getSelectedFeatures():
                    if found: break
                    if self.link.cbMod.isChecked():
                        self.link.setModif(l, f)
                    else:
                        self.link.loadAction(l, f)
                    found = True
                l.removeSelection()
            except: pass
        if not found:
            if self.link.cbMod.isChecked():
                self.link.setModif()
            
 
    






