# -*- coding: utf-8 -*-

import os, logging, json, time, sys
from functools import partial

from qgis.gui import *
from qgis.core import *
from PyQt5 import QtGui, QtWidgets, uic
from PyQt5.QtCore import *
from qgis.utils import iface

from .rdi_postgis import rdiPostgis
from .rdi_dynamic import rdiDynamic
from .rdi_param import rdiParam, rdiParamBloc, rdiParamElt, rdiBaseParam
from .rdi_layer import rdiLayer, rdiLayersCollection
from .rdi_tools import *
from .rdi_admin import rdiAdmin
from .rdi_legend import rdiFilter, rdiLegend, rdiAlleviate
from .rdi_statistic import rdiStatistic
from .rdi_link import rdiHyperlink
from .rdi_save import rdiSave
from .rdi_maj import rdiMaj
from .rdi_atlas import rdiAtlas
from .rdi_mask import rdiMask
from .rdi_map import rdiMap, rdiZoom
from .rdi_configure import rdiConfigTools

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'base.ui'))


class rdiDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        self.parent = parent
        super(rdiDockWidget, self).__init__()
        self.setupUi(self)
        layout = QtWidgets.QGridLayout()
        layout.setAlignment(Qt.AlignTop)
        layout.setSpacing(0)
        layout.setContentsMargins(0,0,0,0)
        self.dockWidgetContents.setLayout(layout)
        self.setWindowTitle(self.parent.pluginName)
        self.layout = layout
        self.connectionStatus = False
        self.reconnecting = False
        self.alea = None
        self.enjeu = None
        self.offline = False
        self.on = True
        self.blocExists = {}
        self.imageFolder = os.path.join(os.path.dirname(__file__),'images')
        self.alleviate = rdiAlleviate(self)
        self.mask = rdiMask(self)
        self.initData()
        self.majDispo()
        self.waitWidget()
        self.canvas = self.parent.iface.mapCanvas()
    
    def majDispo(self):
        self.maj = rdiMaj()
        self.maj.test()
    
    def actuParams(self):
        self.param = rdiParam()
        self.dyn.actuParams()   
        self.psql.actuParams()
        self.psql.actuMask(self.mask.table)
        
    def majBlocState(self):
        blocs = self.psql.getTableAdminBlocs()
        targets = eval(self.param.get('blocDropTargets'))
        for b in list(targets):
            if b not in blocs and b not in self.blocExists: targets.remove(b)
        self.param.set('blocDropTargets', targets)

    def actuTabs(self, list):
        for code in list:
            if code=='all':
                ind = self.tab.currentIndex()
                self.builtWidget()
                self.tab.setCurrentIndex(ind)
            if code=='dynamic':
                clearLayout(self.lDyn)
                self.buildTabDyn()
            if code=='parameter':    
                clearLayout(self.lPar)
                self.buildTabPar()
            if code=='filter':
                clearLayout(self.lFil)
                self.buildTabFil()
            if code=='statistic':
                clearLayout(self.lStat)
                self.buildTabStat()
            if code=='hyperlink':
                clearLayout(self.lLink)
                self.buildTabLink()
            if code=='database':        
                clearLayout(self.lBd)
                self.buildTabBd()
            if code=='journal':    
                clearLayout(self.lLog)
                self.buildTabLog()
            if code=='cure':    
                clearLayout(self.lCure)
                self.buildTabCure()
            if code=='layer':    
                for enjeu in self.enjeu.getElts():
                    enjeu.cluster = self.param.get('cluster')
                self.actuLayersEnjeu()
                self.actuLayersAlea()
                self.mask.affLayer()
                
    
    def recupPassword(self):
        try:
            password = self.parent.passwordTmp
            del self.parent.passwordTmp
        except:
            password = None
        return password
    
    def connectSubClasses(self):
        try:
            self.disconnectSignals()
        except: pass
        self.param = rdiParam(True)
        self.map = rdiMap(self)
        self.zoomIni = rdiZoom(self)
        self.psql = rdiPostgis(self.builtWidget, self.waitConn, self.recupPassword())
        self.dyn = rdiDynamic()
        self.stat = rdiStatistic(self)
        self.save = rdiSave(self)
        self.atlas = rdiAtlas(self)
        self.link = rdiHyperlink(self)
        self.alleviate.recupIni()
        
    def checkConfig(self):
        bool = True
        if self.psql.error:
            return
        for item in rdiConfigTools.ADMIN:
            if 'default' in item:
                schema = self.param.get('schema', 'CONN')
            else:
                schema = self.param.get('schema', 'ADMIN')
            table = self.param.get(item['ini']) 
            if not rdiConfigTools.checkRdiTable(self.psql, item['ini'], table, schema):
                bool = False
        if not bool:
            txt = f"Le SGBD détecté n'est pas conforme, veuillez procéder à la mise à jour par le menu de configuration"
            flashMsg(f"RDI plugin", txt, category='error', button=partial(self.parent.configure, True), buttonIco=os.path.join(self.imageFolder, "config.png"))
    
    def waitWidget(self):      
        l = QtWidgets.QLabel("\n")
        self.layout.addWidget(l)
        self.waitConn = l
        
        self.connectSubClasses()
    
    def brokeWidget(self):
        try:
            self.dbTimer.stop()
        except:
            pass
        clearLayout(self.layout)

        l = QtWidgets.QLabel()
        self.layout.addWidget(l)
        l = QtWidgets.QLabel("Connexion perdue")
        l.setWordWrap(True)
        self.layout.addWidget(l)
        l = QtWidgets.QLabel()
        self.layout.addWidget(l)
        
        w = QtWidgets.QWidget()
        self.layout.addWidget(w)
        hbox = QtWidgets.QHBoxLayout(w)
        hbox.setSpacing(0)
        hbox.setContentsMargins(0,0,0,0)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "plug.png"))
        butt = QtWidgets.QPushButton(ico, " Ressayer")
        butt.setMaximumWidth(200)
        hbox.addWidget(butt)
        butt.clicked.connect(self.rebuilt)  

    def setOffline(self, state):
        self.offline = state
    
    def builtOffline(self):
        self.setOffline(True)
        self.builtWidget()
            
    def builtWidget(self):
        clearLayout(self.layout)
        w = QtWidgets.QWidget()
        self.layout.addWidget(w)
        vbox = QtWidgets.QVBoxLayout(w)
        w.hide()
        self.outTabInfos = w
        
        w = QtWidgets.QWidget()
        self.layout.addWidget(w)
        vbox = QtWidgets.QVBoxLayout(w)
        w.hide()
        self.widgetFastConnect = w
        self.dbTimer = QTimer(self.widgetFastConnect)
        self.dbTimer.timeout.connect(self.autoDbCheck)
        
        
        # w = QtWidgets.QPushButton("maj")
        # self.layout.addWidget(w)
        # w.clicked.connect(self.maj.loadPluginManager)
        
        if self.psql.error and not self.offline:
            l = QtWidgets.QLabel()
            self.layout.addWidget(l)
            gb = QtWidgets.QGroupBox("Echec de connexion:")
            self.layout.addWidget(gb)
            lgb = QtWidgets.QVBoxLayout(gb)
            l = QtWidgets.QLabel(self.psql.error)
            l.setWordWrap(True)
            lgb.addWidget(l)
            
            w = QtWidgets.QWidget()
            self.layout.addWidget(w)
            hbox = QtWidgets.QHBoxLayout(w)
            hbox.setSpacing(0)
            hbox.setContentsMargins(0,0,0,0)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "config.png"))
            butt = QtWidgets.QPushButton(ico, " Configurer")
            butt.setMaximumWidth(150)
            butt.clicked.connect(self.parent.configure)
            hbox.addWidget(butt)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "plug.png"))
            butt = QtWidgets.QPushButton(ico, " Ressayer")
            butt.setMaximumWidth(200)
            hbox.addWidget(butt)
            butt.clicked.connect(self.rebuilt)  

            self.save.makeListed(self.layout)
            
            l = QtWidgets.QLabel()
            self.layout.addWidget(l)
            ico = QtGui.QIcon(os.path.join(self.imageFolder, "plug-ko.png"))
            butt = QtWidgets.QPushButton(ico, " Hors connexion")
            butt.setMaximumWidth(200)
            self.layout.addWidget(butt)
            self.layout.setAlignment(butt, Qt.AlignRight)
            butt.clicked.connect(self.builtOffline)
            
        else:            
            self.psql.connectionLost.connect(self.askForConnect)
            self.psql.connected.connect(self.okConnect)
            self.checkConfig()
            self.mask.recupIni()
            self.psql.actuMask(self.mask.table)
            self.pdb = rdiBaseParam(self.psql)
            if self.offline:
                w = QtWidgets.QWidget()
                self.layout.addWidget(w)
                hbox = QtWidgets.QHBoxLayout(w)
                # hbox.setSpacing(0)
                # hbox.setContentsMargins(0,0,0,0)
                ico = QtGui.QIcon(os.path.join(self.imageFolder,'plug-ko.png'))
                l = QtWidgets.QLabel()
                l.setMaximumWidth(20)
                l.setPixmap(ico.pixmap(15,15))
                hbox.addWidget(l)
                l = QtWidgets.QLabel(f"Hors connexion")
                font = QtGui.QFont()
                font.setBold(True)
                l.setFont(font)
                hbox.addWidget(l)
                ico = QtGui.QIcon(os.path.join(self.imageFolder, "plug.png"))
                butt = QtWidgets.QPushButton(ico, " Se connecter")
                butt.setMaximumWidth(150)
                butt.clicked.connect(self.rebuilt)
                hbox.addWidget(butt)
            else:
                self.connectionStatus = True
                interval = int(self.param.get('autoCheckConnection'))
                if interval>1000:
                    self.dbTimer.start(interval)
            self.tab = QtWidgets.QTabWidget()
            self.tab.tabBarDoubleClicked.connect(self.openNotice)
            self.layout.addWidget(self.tab) 
            self.tabLayouts = {}
            self.lDyn = self.makeTab('dyn')
            self.lPar = self.makeTab('par')
            self.lFil = self.makeTab('fil')
            self.lStat = self.makeTab('stat') 
            self.lLink = self.makeTab('link') 
            self.buildTabDyn()
            self.buildTabFil()
            self.buildTabPar()
            self.buildTabStat()
            self.buildTabLink()
            self.link.makeFirst()
            
            try:
                self.tab.setTabVisible(0, True)
                self.qt15 = True
            except:
                self.qt15 = False
            
            if self.qt15:
                self.lBd = self.makeTab('bd')
                self.lLog = self.makeTab('log')
                self.lCure = self.makeTab('cure')
                self.buildTabBd()
                self.buildTabLog()
                self.buildTabCure()
            
            self.actuTabAdminVisibility()
            # self.askZoom()
            self.map.affMap()
            self.prevTool = None
            self.tab.currentChanged.connect(self.changeTab)
            self.tab.tabBarClicked.connect(self.changeTab)
            self.changeTab()
            self.majBlocState()
    
    def changeTab(self, *v):
        if self.canvas.mapTool()!=self.link.tool:
            self.prevTool = self.canvas.mapTool()
        tool = self.prevTool
        if self.tab.currentIndex()==self.lLink.indice: tool = self.link.tool
        try: tl = eval(self.param.get('linkToolTabs'))
        except: tl = []
        l = list(map(lambda x: x.indice, [l for c,l in self.tabLayouts.items() if c in tl]))
        if self.tab.currentIndex() in l and self.link.getChecked()>0: tool = self.link.tool
        self.canvas.setMapTool(tool)
    
    def askZoom(self, tableList=None):
        if tableList is None:
            tableList = []
            for rdi in self.alea.getLoadedLayers():
                tableList.append((rdi.tableName(), rdi.schemaName(), rdi.topAttr('geom')))
        self.psql.getExtentAsync(callback=self.zoom, tableList=tableList)
    
    def zoom(self, box):
        if box is None:
            return
        box = self.psql.boxToList(box)
        rect = QgsRectangle(box[0], box[1], box[2], box[3])
        self.zoomExtent(rect)
            
    def zoomExtent(self, rect):
        try:
            iface.mapCanvas().setExtent(rect)
            iface.mapCanvas().refresh()
        except:
            pass
        
    def makeTab(self, code):
        item = self.tabDef.get(code)
        tip = item.get('info')
        w = QtWidgets.QWidget()
        l = QtWidgets.QVBoxLayout()
        l.setSpacing(0)
        l.setContentsMargins(0,0,0,0)
        l.setAlignment(Qt.AlignTop)
        self.makeInfoLabel(l, tip + f"\n(double-clic sur icône onglet pour afficher l'aide)")
        w.setLayout(l)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, item.get('img')))
        i = self.tab.addTab(w, ico, "")
        self.tabInd[i] = item
        l.indice = i
        self.tabLayouts[code] = l
        if tip:
            self.tab.setTabToolTip(i, tip)
        return l

    def actuTabAdminVisibility(self):
        self.link.actuAdmin()
        if self.qt15:
            for i,t in self.tabInd.items():
                if not t.get('admin') or self.param.get('admin'):
                    self.tab.setTabVisible(i, True)
                else:
                    self.tab.setTabVisible(i, False) 
        else:    
            if self.param.get('admin'):
                self.lBd = self.makeTab('bd')
                self.lLog = self.makeTab('log')
                self.lCure = self.makeTab('cure')
                self.buildTabBd()
                self.buildTabLog()
                self.buildTabCure()
            else:          
                try:
                    
                    self.tab.removeTab(self.lCure.indice)
                    self.tab.removeTab(self.lLog.indice)
                    self.tab.removeTab(self.lBd.indice)
                except:
                    pass
                self.lBd = None
                self.lLog = None
                self.lCure = None         
    
    def rebuilt(self):
        self.closeAllLayer()
        self.closeTool()
        clearLayout(self.layout)
        self.setOffline(False)
        self.waitWidget() 
   
    def makeInfoLabel(self, layout, text):
        if self.param.get('info') and text:
            l = QtWidgets.QLabel(text)
            l.setWordWrap(True)
            font = QtGui.QFont()
            font.setItalic(True)
            l.setFont(font)
            layout.addWidget(l)

    def makeHelpButton(self, layout, tag=None, lib=False):
        if self.param.get('help'):
            ico = QtGui.QIcon(os.path.join(self.imageFolder,'help.png'))
            l = clickLabel()
            l.setToolTip(u"Aide en ligne ")
            l.setMaximumWidth(20)
            l.setPixmap(ico.pixmap(15,15))
            l.clicked.connect(partial(self.parent.notice, tag))
            if lib:
                hbox = QtWidgets.QHBoxLayout()
                hbox.setAlignment(Qt.AlignRight)
                layout.addLayout(hbox)
                lab = QtWidgets.QLabel(u"Aide en ligne ")
                font = QtGui.QFont()
                font.setItalic(True)
                lab.setFont(font)
                hbox.addWidget(lab)
                hbox.addWidget(l)
            else:
                layout.addWidget(l)
            
    def openNotice(self, ind):
        tag = self.tabInd[ind].get('help')
        self.parent.notice(tag)
    
    def askForConnect(self):
        if not self.connectionStatus:
            return
        self.connectionStatus = False
        msg = f"Connexion à la base postgis perdue"
        icoPath = os.path.join(self.imageFolder, "plug.png")
        # flashMsg(msg, category='error', button=self.startReConnect, buttonIco=icoPath)          
        # flashMsg(msg, category='error') 
        
        layout = self.widgetFastConnect.layout()
        clearLayout(layout)
        self.widgetFastConnect.show()
        hbox = QtWidgets.QHBoxLayout()
        layout.addLayout(hbox)
        l = QtWidgets.QLabel("")
        l.setMaximumWidth(30)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "plug-ko.png"))
        l.setPixmap(ico.pixmap(20,20))
        hbox.addWidget(l)
        l = QtWidgets.QLabel("Connexion perdue")
        font = QtGui.QFont()
        font.setBold(True)
        font.setPointSize(14)
        l.setFont(font)
        l.setWordWrap(True)
        hbox.addWidget(l)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "plug.png"))
        butt = QtWidgets.QPushButton(ico, "")
        butt.setMaximumWidth(40)
        butt.clicked.connect(self.startReConnect)
        hbox.addWidget(butt)
        l = QtWidgets.QLabel("")
        layout.addWidget(l)
        self.labelFastConnect = l
        self.buttonFastConnect = butt
    
    def startReConnect(self):
        if self.reconnecting:
            return
        self.reconnecting = True
        self.buttonFastConnect.setEnabled(False)
        self.labelFastConnect.setText("")
        self.psql.asyncConnect(self.endReConnect, self.labelFastConnect)
    
    def endReConnect(self):
        self.reconnecting = False
        self.buttonFastConnect.setEnabled(True)
        self.labelFastConnect.setText(f"Echec")
        
    def okConnect(self):
        if self.connectionStatus:
            return
        self.connectionStatus = True
        layout = self.widgetFastConnect.layout()
        clearLayout(layout)
        self.widgetFastConnect.hide()
        
    def autoDbCheck(self):
        if not self.psql.isDbConnected():
            self.startReConnect()
        else:
            self.psql.checkDbAsync()

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    # ONGLET CROISEMENT DYNAMIQUE
    def buildTabDyn(self):
        if self.lDyn==None:
            return
        self.infoTask = QtWidgets.QLabel()
        self.infoTask.setAlignment(Qt.AlignRight)
        font = QtGui.QFont()
        font.setPointSize(2)
        self.infoTask.setFont(font)
        self.lDyn.addWidget(self.infoTask)
        
        order='bloc' if self.param.get('blocDrop') else 'parent'
        
        self.recup = self.dyn.getAll()
        txt = u"\n\nCe premier bloc regroupe toutes les couches d'enjeux, " + \
                "c'est à dire celles dont les informations seront extraites à l'intérieur " + \
                "(ou à l'extérieur en activant l'inversibilité sur clic droit)" + \
                "des aléas"
        self.makeInfoLabel(self.lDyn, txt)
        self.enjeu = self.makeBlocLayerFromList(self.lDyn, "enjeu", self.psql.getTableAdmin('enjeu', True), self.actuLayersEnjeu)
        txt = u"\n\nCe deuxième bloc regroupe toutes les couches d'aléas, " + \
                "c'est à dire celles dont les périmètres vont servir pour extraire les enjeux" + \
                "(ce sont donc forcément des polygones)"
        self.makeInfoLabel(self.lDyn, txt)
        self.alea = self.makeBlocLayerFromList(self.lDyn, "alea", self.psql.getTableAdmin('alea', True, order=order), self.actuLayersAlea)
        
        bool = False
        for k,v in self.recup.items():
            if not (v.rdi.coll.matchCode('alea') or v.rdi.coll.matchCode('enjeu')):
                continue
            
            self.dyn.removeMapLayer(v.rdi)
            if v.rdi.coll.matchCode('alea'):
                bool = True
        if bool:
            self.actuLayersEnjeu()
            
        if self.param.get('cluster'):
            self.enjeu.addLayerField()

        item = self.tabDef.get('dyn')
        self.makeHelpButton(self.lDyn, item.get('help'), lib=True)
        
        
    def makeBlocLayerFromList(self, layout, code, list, actu=None):
        coll = rdiLayersCollection(self, code)
        if actu:
            coll.setActu(actu)
        coll.construct(layout)
        parents = {}
        dico = {}
        for elt in list:
            rdi = rdiLayer(elt)
            dico[elt.get('id')] = elt
            if self.alleviate.isExclude(rdi):
                coll.setFiltered(True)
                continue
            if not self.hasChildrens(rdi, list):
                continue
            target = rdi

            if self.param.get('cbCompact'):
                parent = coll.findParent(rdi)
                if not parent:
                    if rdi.parent() not in dico: 
                        if not rdi.parent(): coll.add(rdi)
                        continue
                    parent = rdiLayer(dico[rdi.parent()])
                    coll.add(parent, bloc=elt.get('bloc'))
                parent.addCombo(rdi)
                target = parent
            else:
                coll.add(rdi)

            if rdi.id() in self.recup.keys() and (not parent or parent.id() not in parents):
                target.recup(self.recup[rdi.id()])  
                del self.recup[rdi.id()]
                if parent and self.param.get('cbCompact'):
                    parents[parent.id()] = True

        if not self.param.get('blocDrop'):
            for rdi in coll.list:
                rdi.adaptBlocPosition()
        
        return coll
        
    def hasChildrens(self, rdi, list):
        bool = False
        if rdi.tableName():
            bool = True
        for elt in list:
            if bool:
                break
            if elt.get('parent')==rdi.id() and not self.alleviate.isExcludeId(elt.get('id')):
                bool = True
        return bool
      
    def actuLayersEnjeu(self, enjeu=None):
        if not self.on:
            return
        action = self.psql.getExtractEnjeu
        if self.param.get('asyncGetSql'):
            action = self.psql.getExtractEnjeuAsync
        try:
            aleaList = self.alea.getEltsSelected()
            if enjeu:
                action(enjeu=enjeu, aleaList=aleaList)    
            else:
                for enjeu in self.enjeu.getEltsSelected():
                    action(enjeu=enjeu, aleaList=aleaList)   
        except:
            print(sys.exc_info())
            pass
    
    def actuLayersAlea(self, alea=None):
        if not self.on:
            return
        action = self.psql.getExtractAlea
        if self.param.get('asyncGetSql'):
            action = self.psql.getExtractAleaAsync        
        try:
            if alea:
                action(alea=alea)   
            else:
                for alea in self.alea.getEltsSelected():
                    action(alea=alea)  
        except:
            print(sys.exc_info())
            pass
                    
    def majEntityCount(self):
        for enjeu in self.enjeu.getEltsSelected():
            enjeu.getEntityCount()


    def showTab(self, vlayer):
        iface.showAttributeTable(vlayer)
     
    def showProp(self, vlayer):
        iface.showLayerProperties(vlayer) 
     
    def goToAdmin(self, rdi=None):
        try:
            self.admin.switchToElt(rdi.id())
            self.tab.setCurrentIndex(self.lBd.indice)
        except:
            print(sys.exc_info())
     
     
     
     
     
     
     
    # ONGLET LEGENDE ET FILTRES
    def buildTabFil(self):  
        if self.lFil==None:
            return

        sc = QtWidgets.QScrollArea()
        sc.setWidgetResizable(True)
        self.lFil.addWidget(sc)
        w = QtWidgets.QWidget()
        w.setObjectName("scrollAreaWidgetContents")
        gbox = QtWidgets.QVBoxLayout()
        gbox.setSpacing(0)
        gbox.setContentsMargins(0,0,0,0)
        gbox.setAlignment(Qt.AlignTop)
        w.setLayout(gbox)
        sc.setWidget(w)
        sc.setStyleSheet("QAbstractScrollArea {background-color: transparent;}  ");
        w.setStyleSheet("QWidget#scrollAreaWidgetContents {background-color: white; } ");

        self.filter = rdiFilter(self, gbox)
        self.mask.paint(gbox)
        
        item = self.tabDef.get('fil')
        self.makeHelpButton(self.lFil, item.get('help'), lib=True)

    def actuIcoTabFil(self):
        i = self.lFil.indice
        img = 'img'
        if hasattr(self, 'filter') and self.filter.filterMode is not None and self.filter.filterMode!=self.filter.filterOptions['no']:
            img = 'img-on'
        if self.param.get('maskWorking') and self.mask.table is not None:
            img = 'img-on'
        self.tab.setTabIcon(i, QtGui.QIcon(os.path.join(self.imageFolder, self.tabInd[i].get(img))))
        
    def reloadForMask(self):
        self.param.set('maskWorking', True)
        self.actuParams()
        self.actuTabs(['layer', 'parameter', 'filter'])
    
    
    
    
    
    
        
    # ONGLET PARAMETRES
    def buildTabPar(self):  
        if self.lPar==None:
            return
        self.makeParameters(self.lPar)
        
        item = self.tabDef.get('par')
        self.makeHelpButton(self.lPar, item.get('help'), lib=True)
        
    def makeParameters(self, layout):
        # l = QtWidgets.QLabel("Options du plugin")
        l = dblClickLabel("Options du plugin")
        l.rightClick.connect(self.paramMenu)
        font = QtGui.QFont()
        font.setBold(True)
        l.setFont(font)
        layout.addWidget(l)

        sc = QtWidgets.QScrollArea()
        sc.setWidgetResizable(True)
        layout.addWidget(sc)
        w = QtWidgets.QWidget()
        w.setObjectName("scrollAreaWidgetContents")
        gbox = QtWidgets.QVBoxLayout()
        gbox.setSpacing(0)
        gbox.setContentsMargins(0,0,0,0)
        gbox.setAlignment(Qt.AlignTop)
        w.setLayout(gbox)
        sc.setWidget(w)
        sc.setStyleSheet("QAbstractScrollArea {background-color: transparent;}  ");
        w.setStyleSheet("QWidget#scrollAreaWidgetContents {background-color: white; } ");

        for b, bloc in self.param.translator.items():
            self.makeInfoLabel(gbox, "\n\n" + bloc['info'])
            l = QtWidgets.QLabel()
            gbox.addWidget(l)
            # gb = QtWidgets.QGroupBox(bloc['label'])
            code = f"par_{bloc['label']}"
            gb = rdiParamBloc(code, bloc['label'], self, memo=False)
            gbox.addWidget(gb)
            # lgb = QtWidgets.QVBoxLayout(gb) 
            gb.add(bloc['list'], changed=self.changeParameter)

            # for elt in bloc['list']:
                # p = rdiParamElt(elt, self)
                # p.changed.connect(self.changeParameter)
                # p.draw(lgb)
                    
        self.map.paint(gbox)
        self.zoomIni.paint(gbox)
        

    def changeParameter(self, elt):
        self.actuParams()
        if 'callback' in elt:
            for f in elt['callback']:
                f()
        if 'func' in elt:
            for f in elt['func']:
                exec(f)
        if 'tab' in elt:
            self.actuTabs(elt['tab'])
        
    def paramMenu(self):
        self.popMenu = QtWidgets.QMenu()
        self.popMenu.addAction("Rétablir les valeurs par défaut", partial(self.param.forceDefault, partial(self.actuTabs, ['all'])))
        self.popMenu.popup(QtGui.QCursor.pos())
        
        




    # ONGLET HYPERLIENS
    def buildTabLink(self):
        if self.lLink==None:
            return
        self.makeLink(self.lLink)
        
        item = self.tabDef.get('link')
        self.makeHelpButton(self.lLink, item.get('help'), lib=True)
    
    def makeLink(self, layout):
        self.link.load(layout)
        
        



    # ONGLET STATISTIQUES
    def buildTabStat(self):
        if self.lStat==None:
            return
        self.makeStat(self.lStat)
        
        item = self.tabDef.get('stat')
        self.makeHelpButton(self.lStat, item.get('help'), lib=True)
    
    def makeStat(self, layout):
        self.stat.load(layout)
        self.enjeu.changed.connect(self.stat.makeStatLayers)
        
        
        
        
        



    # ONGLET BASE DE DONNEES
    def buildTabBd(self):  
        if self.lBd==None:
            return
        self.makeBD(self.lBd)
        
        item = self.tabDef.get('bd')
        self.makeHelpButton(self.lBd, item.get('help'), lib=True)
    
    def makeBD(self, layout):
        self.admin = rdiAdmin(self)
        layout.addWidget(self.admin.widget)
        self.admin.dataChanged.connect(self.reloadBD)
        self.admin.datasChanged.connect(self.reloadBDlist)
        reco = self.admin.reconnectButton()
        layout.addWidget(reco)
        reco.butt.clicked.connect(self.rebuilt) 

    def reloadBDlist(self, list):
        self.actuTabs(['dynamic', 'statistic', 'hyperlink'])
        for id in list:
            rdi = self.alea.find(id) or self.enjeu.find(id) or self.link.coll.find(id)
            self.reloadBDrdi(rdi)
                    
    def reloadBD(self, id=None):
        self.actuTabs(['dynamic', 'statistic', 'hyperlink'])
        rdi = self.alea.find(id) or self.enjeu.find(id) or self.link.coll.find(id)
        self.reloadBDrdi(rdi)
        
    def reloadBDrdi(self, rdi):
        if rdi!=None:
            # rdi.resetRenderer()

            if rdi.style!=None:
                rdi.style.actuStyle()
            if rdi.checked:
                if rdi.coll.matchCode('alea'):
                    self.actuLayersAlea(rdi)
                if rdi.coll.matchCode('enjeu'):
                    self.actuLayersEnjeu(rdi)
                if rdi.coll.matchCode('link'):
                    self.link.actuLayers(rdi)





    # ONGLET JOURNALISATION
    def buildTabLog(self):  
        if self.lLog==None:
            return
        self.makeLogsInfo(self.lLog)
        
        item = self.tabDef.get('log')
        self.makeHelpButton(self.lLog, item.get('help'), lib=True)
        
    def makeLogsInfo(self, layout):      
        gb = QtWidgets.QGroupBox("Journal des tâches")
        layout.addWidget(gb)
        lgb = QtWidgets.QVBoxLayout(gb)
        lgb.setSpacing(0)
        lgb.setContentsMargins(0,0,0,0)
        sc = QtWidgets.QScrollArea()
        sc.setWidgetResizable(True)
        lgb.addWidget(sc)
        w = QtWidgets.QWidget()
        gbox = QtWidgets.QVBoxLayout(w)
        gbox.setSpacing(0)
        gbox.setContentsMargins(0,0,0,0)
        gbox.setAlignment(Qt.AlignTop)
        l = QtWidgets.QTextEdit()
        l.setReadOnly(True)
        gbox.addWidget(l)
        self.tasksLog = l
        sc.setWidget(w)
        sc.setStyleSheet("QScrollArea {background-color:transparent;}");
        w.setStyleSheet("background-color:transparent;");
        
        wl = QtWidgets.QWidget()
        layout.addWidget(wl)
        hbox = QtWidgets.QHBoxLayout()
        hbox.setContentsMargins(15,0,5,5)
        hbox.setSpacing(1)
        wl.setLayout(hbox)
        cb = QtWidgets.QCheckBox("Actualisation auto")
        if self.param.get('animation'):
            cb.setChecked(True)
        else:
            cb.setEnabled(False)
        cb.stateChanged.connect(self.checkActiveTasksStart)
        self.actuAuto = cb
        hbox.addWidget(cb)
        
        ico = QtGui.QIcon(os.path.join(self.imageFolder,'stop.png'))
        butt = QtWidgets.QPushButton(ico, '')
        butt.setToolTip("Tout arrêter")
        butt.setMaximumWidth(30)
        hbox.addWidget(butt)
        butt.clicked.connect(self.psql.manager.killAll)
        butt.setEnabled(False)
        self.stopAll = butt
        ico = QtGui.QIcon(os.path.join(self.imageFolder,'refresh.png'))
        butt = QtWidgets.QPushButton(ico, '')
        butt.setToolTip("Actualiser")
        butt.setMaximumWidth(30)
        hbox.addWidget(butt)
        butt.clicked.connect(self.checkActiveTasks)

        self.psql.manager.changed.connect(self.checkActiveTasksStart)
        self.psql.manager.changed.connect(self.showCharge)
        self.timer = rdiTimer(self, self.checkActiveTasks)
        self.checkActiveTasks()

    def checkActiveTasksStart(self):
        try:
            if self.actuAuto.isChecked():
                self.timer.start(1000)
                self.checkActiveTasks()
            else:
                self.timer.stop()
        except:
            self.timer.stop()
            pass
    
    def checkActiveTasks(self):
        try:
            nb = self.psql.manager.countAlive()
            self.psql.manager.setLog(self.tasksLog)
            QtWidgets.QApplication.processEvents()
            if nb==0:
                self.stopAll.setEnabled(False)
                self.timer.stop(10000)
            else:
                self.stopAll.setEnabled(True)
        except:
            self.timer.stop()
            pass
        
    def showCharge(self):
        i = self.psql.manager.countAlive()
        r = min(255, i*50)
        g = 255 - min(255, max(0,i-5)*10)
        b = 0
        a = min(i*30, 255)
        color = QtGui.QColor(r, g, b, a)
        self.infoTask.setStyleSheet(f"background-color:{color.name(QtGui.QColor.HexArgb)};")
        if i>0:
            s = "s" if i>1 else ""
            txt = f"{i} requête{s} active{s}"
            self.infoTask.setToolTip(txt)
        else:
            self.infoTask.setToolTip(None)

        






    # ONGLET MAINTENANCE
    def buildTabCure(self):  
        if self.lCure==None:
            return
        self.makeCure(self.lCure)
        
        item = self.tabDef.get('cure')
        self.makeHelpButton(self.lCure, item.get('help'), lib=True)
    
    def makeCure(self, layout):
        
        
        gb = QtWidgets.QGroupBox("Maintenance")
        layout.addWidget(gb)
        lgb = QtWidgets.QVBoxLayout(gb)
        lgb.setSpacing(0)
        lgb.setContentsMargins(1,1,1,1)
        version = "1.1"
        txt = ""
        txt += f"Plugin version {self.maj.meta.getVersion()}"
        if self.offline:
            txt += f"\nMode déconnecté"
        else:
            txt += f"\nConnexion: {self.psql.PGuser} (sur {self.psql.PGhost})"
            txt += f"\nBase de données: {self.psql.PGdb}"
            txt += f"\n     Execution sur {self.psql.getSchema(self.param.get('schema', 'CONN'))} ({self.param.get('tableTmp')})"
            txt += f"\n     Administration sur {self.psql.getSchema(self.param.get('schema', 'ADMIN'))} ({self.param.get('tableAdmin')})"
        l = QtWidgets.QLabel(txt)
        l.setWordWrap(True)
        font = QtGui.QFont()
        font.setItalic(True)
        l.setFont(font)
        lgb.addWidget(l)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "save.png"))
        butt = QtWidgets.QPushButton(ico, "")
        butt.setIconSize(QSize(12,12))
        butt.setToolTip("Enregistrer une copie de toute la configuration")
        butt.setMaximumWidth(30)
        lgb.addWidget(butt)
        lgb.setAlignment(butt, Qt.AlignRight)
        butt.clicked.connect(self.save.memorize)
        
        self.save.listFiles()
        if len(self.save.list)>0:
            wl = QtWidgets.QWidget()
            layout.addWidget(wl)
            hbox = QtWidgets.QHBoxLayout(wl)
            hbox.setContentsMargins(30,0,0,0)
            l = QtWidgets.QLabel("Changer d'environnement")
            l.setWordWrap(True)
            hbox.addWidget(l)
            self.save.setLayout(hbox)
            self.save.makeCombo(compact=True)
            self.save.makeInfo(compact=True)
        
        
        sc = QtWidgets.QScrollArea()
        sc.setWidgetResizable(True)
        layout.addWidget(sc)
        w = QtWidgets.QWidget()
        w.setObjectName("scrollAreaWidgetContents")
        gbox = QtWidgets.QVBoxLayout()
        gbox.setSpacing(0)
        gbox.setContentsMargins(0,0,0,0)
        gbox.setAlignment(Qt.AlignTop)
        w.setLayout(gbox)
        sc.setWidget(w)
        sc.setStyleSheet("QAbstractScrollArea {background-color: transparent;}  ");
        w.setStyleSheet("QWidget#scrollAreaWidgetContents {background-color: white; } ");
        layout2 = gbox
        
        if self.maj.dispo:
            txt = f"\n     → MàJ disponible: v{self.maj.version}"
            l = QtWidgets.QLabel(txt)
            font = QtGui.QFont()
            font.setBold(True)
            font.setPointSize(10)
            l.setFont(font)
            layout2.addWidget(l)
        
        wl = QtWidgets.QLabel("\n")
        layout.addWidget(wl)
        
        
        
        
        wl = QtWidgets.QLabel("\n")
        layout2.addWidget(wl)
        wl = QtWidgets.QLabel()
        layout2.addWidget(wl)
        # wl = QtWidgets.QLabel(f"Base de données")
        wl = dblClickLabel("Gestion des données")
        wl.rightClick.connect(self.baseMenu)
        font = QtGui.QFont()
        font.setBold(True)
        wl.setFont(font)
        layout2.addWidget(wl)
        wl = QtWidgets.QWidget()
        layout2.addWidget(wl)
        hbox = QtWidgets.QHBoxLayout(wl)
        butt = QtWidgets.QPushButton("Etat du serveur")
        hbox.addWidget(butt)
        butt.clicked.connect(partial(self.psql.openDialog, 'serverState'))  
        butt = QtWidgets.QPushButton("Paramètres communs")
        hbox.addWidget(butt)
        butt.clicked.connect(partial(self.psql.openDialog, 'paramShare'))  
        # butt = QtWidgets.QPushButton("Voir table")
        # layout2.addWidget(butt)
        # butt.clicked.connect(partial(self.psql.openDialog, 'gestionList'))     
        
        wl = QtWidgets.QWidget()
        layout2.addWidget(wl)
        hbox = QtWidgets.QHBoxLayout(wl)
        w = QtWidgets.QWidget()
        hbox.addWidget(w)
        hbox.setAlignment(w, Qt.AlignLeft)
        hbox2 = QtWidgets.QHBoxLayout(w)
        hbox2.setSpacing(0)
        hbox2.setContentsMargins(0,0,0,0)
        b = QtWidgets.QPushButton("?")
        b.setToolTip("Teste le nombre de requêtes stockées en base de données")
        b.setFixedSize(15, 32)
        hbox2.addWidget(b)
        hbox2.setAlignment(b, Qt.AlignLeft)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "delete.png"))
        butt = QtWidgets.QPushButton(ico, ' Purger stockage\n    temporaire')
        butt.setIconSize(QSize(25,25))
        butt.setToolTip("Supprime toutes les requêtes stockées en base de données")
        butt.setMinimumWidth(120)
        butt.sender = b
        hbox2.addWidget(butt)
        hbox2.setAlignment(butt, Qt.AlignLeft)
        b.clicked.connect(partial(self.startPurge, butt, self.psql.nbTmp))
        butt.clicked.connect(partial(self.startPurge, butt, self.psql.purgeAsync, True))
        w = QtWidgets.QWidget()
        w.setMaximumWidth(80)
        hbox.addWidget(w)
        hbox.setAlignment(w, Qt.AlignRight)
        hbox2 = QtWidgets.QHBoxLayout(w)
        hbox2.setSpacing(0)
        hbox2.setContentsMargins(0,0,0,0)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "config.png"))
        butt = QtWidgets.QPushButton(ico, "")
        butt.setIconSize(QSize(25,25))
        butt.setToolTip("Configurer")
        hbox2.addWidget(butt)
        butt.clicked.connect(self.parent.configure)  
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "plug.png"))
        butt = QtWidgets.QPushButton(ico, "")
        butt.setIconSize(QSize(25,25))
        butt.setToolTip("Reconnecter")
        hbox2.addWidget(butt)
        butt.clicked.connect(self.rebuilt)  
        

        wl = QtWidgets.QLabel("\n")
        layout2.addWidget(wl)
        wl = QtWidgets.QLabel()
        layout2.addWidget(wl)
        wl = QtWidgets.QLabel(f"Ouvrir")
        font = QtGui.QFont()
        font.setBold(True)
        wl.setFont(font)
        layout2.addWidget(wl)
        wl = QtWidgets.QWidget()
        layout2.addWidget(wl)
        hbox = QtWidgets.QHBoxLayout(wl)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "folder.png"))
        butt = QtWidgets.QPushButton(ico, ' Plugin')
        butt.setToolTip("Ouvre le dossier du plugin")
        hbox.addWidget(butt)
        butt.clicked.connect(openExplorer)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "file.png"))
        butt = QtWidgets.QPushButton(ico, ' parameter.ini')
        butt.setToolTip("Ouvre le fichier de paramétrage")
        hbox.addWidget(butt)
        butt.clicked.connect(partial(openFile, 'parameter.ini'))
        
        wl = QtWidgets.QLabel("\n\n")
        layout2.addWidget(wl)
        wl = QtWidgets.QLabel(f"Sauvegarde locale")
        font = QtGui.QFont()
        font.setBold(True)
        wl.setFont(font)
        layout2.addWidget(wl)
        wl = QtWidgets.QWidget()
        layout2.addWidget(wl)
        hbox = QtWidgets.QHBoxLayout(wl)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "backup.png"))
        butt = QtWidgets.QPushButton(ico, " Enregistrer")
        butt.setToolTip("Enregistrer les fichiers persos\nPermet de conserver la paramétrisation locale lors d'une mise à jour du plugin")
        butt.setMaximumWidth(300)
        hbox.addWidget(butt)
        butt.clicked.connect(self.save.backup)
        ico = QtGui.QIcon(os.path.join(self.imageFolder, "restore.png"))
        butt = QtWidgets.QPushButton(ico, " Restaurer")
        butt.setToolTip("Restorer les fichiers persos depuis une sauvegarde locale")
        butt.setMaximumWidth(300)
        hbox.addWidget(butt)
        butt.clicked.connect(self.save.restore)
        
        wl = QtWidgets.QLabel("\n\n")
        layout2.addWidget(wl)
        wl = QtWidgets.QLabel(f"Génération Automatique")
        font = QtGui.QFont()
        font.setBold(True)
        wl.setFont(font)
        layout2.addWidget(wl)
        self.atlas.make(layout2)


    def startPurge(self, obj, action, confirm=False):
        if confirm:
            qm = QtWidgets.QMessageBox
            rep = qm.question(None, "", f"Cette action peut impacter d'autres utilisateurs actuellement connectés\nVoulez-vous continuer ?", qm.Yes | qm.No)
            if not rep==qm.Yes:
                return
        obj.setEnabled(False)
        try:
            obj.sender.setEnabled(False)
        except:
            pass
        obj.memoText = obj.text()
        obj.setText("...")
        QtWidgets.QApplication.processEvents()
        action(self.endPurge, obj)
    
    def endPurge(self, txt, obj):
        obj.setText(txt)
        obj.timeout = setTimeout(2000, self.resetPurge, obj)
        
    def resetPurge(self, obj):
        del obj.timeout
        try:
            obj.setText(obj.memoText)
            obj.setEnabled(True)
            obj.sender.setEnabled(True)
        except:
            pass
    
    def baseMenu(self):
        self.popMenu = QtWidgets.QMenu()
        self.popMenu.addAction(QtGui.QIcon(os.path.join(self.imageFolder, "table.png")), "Voir la table d'administration", partial(self.psql.openDialog, 'gestionList'))
        self.popMenu.addAction(QtGui.QIcon(os.path.join(self.imageFolder, "table.png")), "Voir la table de stockage temporaire", partial(self.psql.openDialog, 'stockTemp'))
        self.popMenu.addAction(QtGui.QIcon(os.path.join(self.imageFolder, "table.png")), "Voir la table des données partagées", partial(self.psql.openDialog, 'shareTable'))
        self.popMenu.popup(QtGui.QCursor.pos())

    
    def initData(self):
        self.tabDef = {
            'dyn':{
                'img': 'analyze.png', 
                'title': u"Analyser",
                'info': u"Onglet de croisement dynamiques des enjeux avec les aléas",
                'help': 'p5-analyze',
                },
            'par':{
                'img': 'check.png', 
                'title': u"Options du plugin",
                'info': u"Onglet pour configurer le comportement du plugin\nPersonnalisation des croisements spatiaux et de l'affichage",
                'help': 'p5-option',
                },
            'fil':{
                'img': 'filter.png',
                'img-on': 'filterOn.png',
                'title': u"Filtre sur aléas",
                'info': u"Onglet pour filtrer le croisement sur un sous-ensemble des aléas",
                'help': 'p5-filter',
                },
            'stat':{
                'img': 'stats.png', 
                'title': u"Statistiques",
                'info': u"Onglet pour générer des statistiques sur les données d'enjeux",
                'help': 'p5-stats',
                },
            'link':{
                'img': 'link.png', 
                'title': u"Hyperliens",
                'info': u"Onglet pour gérer les couches permettant des actions depuis la carte",
                'help': 'p5-link',
                },

            'bd':{
                'img': 'database.png', 
                'title': u"Gestion des données",
                'info': u"Onglet pour administrer les couches du plugin\nCliquer sur + pour importer des couches\nOu choisir la couche à personnaliser\nNécessite des droits d'écritures sur le schéma défini en admin",
                'help': 'p4-data',
                'admin': True,
                },
            'log':{
                'img': 'journal.png', 
                'title': u"Journal des tâches",
                'info': u"Onglet de visualisation des requetes envoyées au serveur et en attente de traitement",
                'help': 'p4-logs',
                'admin': True,
                },
            'cure':{
                'img': 'wheel.png', 
                'title': u"Maintenance",
                'info': u"Onglet de maintenance générale\nNettoyage des couches temoraires\nParamétrage de la connexion",
                'help': 'p4-cure',
                'admin': True,
                }, 
        }
        self.tabInd = {}



    # fin du plugin
    def closeEvent(self, event):
        try:
            self.dbTimer.stop()
        except:
            pass
        if not self.param.get('keepActive'):
            self.on = False
            self.dyn.on = False
            self.closeTool()
        
        self.closingPlugin.emit()
        event.accept()
        
    def openPlugin(self):
        self.on = True
        self.dyn.on = True
        try: self.changeTab()
        except: pass
        
    def closeAllLayer(self):
        try:
            self.dyn.closeAll()
        except:
            pass


    def closeTool(self):
        try:
            self.canvas.unsetMapTool(self.link.tool)
            self.canvas.setMapTool(self.prevTool)
        except:
            pass
            
            
    def disconnectSignals(self):
        try: self.atlas.unload()
        except: pass
        try: self.stat.unload()
        except: pass
        try: self.map.unload()
        except: pass
        try: self.dyn.unload()
        except: pass


