from rastertimeseriesmanager.core import *
from hubdc.core import *

class Interface(object):

    def __init__(self):
        self.canvas = QgsMapCanvas()

    def addRasterLayer(self, filename):
        layer = QgsRasterLayer(filename)
        QgsProject.instance().addMapLayers([layer])
        self.canvas.setLayers([layer])
        return layer

    def mapCanvas(self):
        from hubdc.core import MapViewer
        mapViewer = MapViewer()
        return mapViewer.canvas

qgsApp = QgsApplication([], True)
qgsApp.initQgis()
qgsApp.messageLog().messageReceived.connect(lambda *args: print(args[0]))

iface = Interface()
rtm = RasterTimeseriesManager(iface=iface)
rtm.show()

def test_saveMp4():
    rtm.ui.fileFfmpeg().setFilePath(r'C:\Program Files\ImageMagick-7.0.3-Q16\ffmpeg.exe')
    rtm.onSaveMp4()

def test_saveGif():
    rtm.ui.fileImageMagick().setFilePath(r'C:\Program Files\ImageMagick-7.0.3-Q16\magick.exe')
    rtm.onSaveGif()

def test_ts_4d_infoAsBandnames():
    rtm.setTimeseries(layer=QgsRasterLayer(r'C:\source\QGISPlugIns\rastertimeseriesmanager\testdata\timeseries.bsq'))
    for a, b in zip(rtm.timeseries().dates, [QDate(1984, 4, 16), QDate(1984, 5, 9), QDate(1984, 5, 25), QDate(1984, 6, 3), QDate(1984, 6, 10), QDate(1984, 6, 19), QDate(1984, 6, 26), QDate(1984, 7, 21), QDate(1984, 8, 6), QDate(1984, 8, 13)]):
        assert a == b, (a, b)

    for a, b in zip(rtm.timeseries().names, ['blue', 'green', 'red', 'nir', 'swir1', 'swir2']):
        assert a == b

    rtm.setDateNumber(1)

def test_saveframes():
    # save frames not testable outside QGIS
    return
    rtm.ui.stepUnit().setCurrentIndex(1) # weeks
    rtm.saveFrames()
    print(rtm.ui.grabFolder().filePath())

def test_set_3d_ts_infoAsDYears():
    rtm.setTimeseries(layer=QgsRasterLayer(r'C:\Work\data\FORCE\marcel\2016-2018_001-365_LEVEL4_TSA_LNDLG_NDV_C0_S0_FAVG_TY_C95T_TSI.dat'))
    for a, b in zip(rtm.dates, [2016.003, 2016.016, 2016.03, 2016.044, 2016.057, 2016.071, 2016.085, 2016.098, 2016.112, 2016.126, 2016.139, 2016.153, 2016.167, 2016.18, 2016.194, 2016.208, 2016.221, 2016.235, 2016.249, 2016.262, 2016.276, 2016.29, 2016.303, 2016.317, 2016.331, 2016.344, 2016.358, 2016.372, 2016.385, 2016.399, 2016.413, 2016.426, 2016.44, 2016.453, 2016.467, 2016.481, 2016.495, 2016.508, 2016.522, 2016.536, 2016.549, 2016.563, 2016.577, 2016.59, 2016.604, 2016.617, 2016.631, 2016.645, 2016.658, 2016.672, 2016.686, 2016.699, 2016.713, 2016.727, 2016.74, 2016.754, 2016.768, 2016.781, 2016.795, 2016.809, 2016.822, 2016.836, 2016.85, 2016.863, 2016.877, 2016.891, 2016.904, 2016.918, 2016.932, 2016.945, 2016.959, 2016.973, 2016.986, 2017.003, 2017.016, 2017.03, 2017.044, 2017.057, 2017.071, 2017.085, 2017.098, 2017.112, 2017.126, 2017.139, 2017.153, 2017.167, 2017.18, 2017.194, 2017.208, 2017.221, 2017.235, 2017.249, 2017.262, 2017.276, 2017.29, 2017.303, 2017.317, 2017.331, 2017.344, 2017.358, 2017.372, 2017.385, 2017.399, 2017.413, 2017.426, 2017.44, 2017.453, 2017.467, 2017.481, 2017.495, 2017.508, 2017.522, 2017.536, 2017.549, 2017.563, 2017.577, 2017.59, 2017.604, 2017.617, 2017.631, 2017.645, 2017.658, 2017.672, 2017.686, 2017.699, 2017.713, 2017.727, 2017.74, 2017.754, 2017.768, 2017.781, 2017.795, 2017.809, 2017.822, 2017.836, 2017.85, 2017.863, 2017.877, 2017.891, 2017.904, 2017.918, 2017.932, 2017.945, 2017.959, 2017.973, 2017.986, 2018.003, 2018.016, 2018.03, 2018.044, 2018.057, 2018.071, 2018.085, 2018.098, 2018.112, 2018.126, 2018.139, 2018.153, 2018.167, 2018.18, 2018.194, 2018.208, 2018.221, 2018.235, 2018.249, 2018.262, 2018.276, 2018.29, 2018.303, 2018.317, 2018.331, 2018.344, 2018.358, 2018.372, 2018.385, 2018.399, 2018.413, 2018.426, 2018.44, 2018.453, 2018.467, 2018.481, 2018.495, 2018.508, 2018.522, 2018.536, 2018.549, 2018.563, 2018.577, 2018.59, 2018.604, 2018.617, 2018.631, 2018.645, 2018.658, 2018.672, 2018.686, 2018.699, 2018.713, 2018.727, 2018.74, 2018.754, 2018.768, 2018.781, 2018.795, 2018.809, 2018.822, 2018.836, 2018.85, 2018.863, 2018.877, 2018.891, 2018.904, 2018.918, 2018.932, 2018.945, 2018.959, 2018.973, 2018.986]):
        b = QDate(int(b), 1, 1).addDays(round((b - int(b)) * 366) - 1)
        assert a == b, (a, b)

    for a, b in zip(rtm.names, ['Interpolated NDV']):
        assert a == b

def test_split_and_merge_4d_ts():
    rtm.setTimeseries(layer=QgsRasterLayer(r'C:\source\QGISPlugIns\rastertimeseriesmanager\testdata\timeseries.bsq'))
    layers = rtm.splitTimeseries(dirname=r'c:\output\{}.vrt')
    for layer, name in zip(layers, ['blue', 'green', 'red', 'nir', 'swir1', 'swir2']):
        rtm.setTimeseries(layer)
        assert len(rtm.names) == 1
        assert rtm.names[0] == name
        for a, b in zip(rtm.dates, ['1984-04-16', '1984-05-09', '1984-05-25', '1984-06-03', '1984-06-10', '1984-06-19', '1984-06-26', '1984-07-21', '1984-08-06', '1984-08-13']):
            b = QDate(*map(int, b.split('-')))
            assert a == b, (a, b)

    layer = rtm.mergeTimeseries(filename=r'c:\output\ts.vrt', layers=layers)
    rtm.setTimeseries(layer=layer)

def test___():
    f = r'c:\output\x.tif'

    layer=None
    layers=None
    gdal.Translate(f, gdal.Open(layer.source()))
    layer = QgsRasterLayer(f)
    rtm.setTimeseries(layer=layer)


    layers2 = rtm.splitTimeseries(dirname=r'c:\output2')
    for layer, layer2 in zip(layers, layers2):
        rtm.setTimeseries(layer)
        names = rtm.names
        dates = rtm.dates
        rtm.setTimeseries(layer2)
        names2 = rtm.names
        dates2 = rtm.dates
        for a, b in zip(dates, dates2):
            assert a == b
        for a, b in zip(names, names2):
            assert a == b

def test_set_3d_ts_noInfo():

    rtm.setTimeseries(QgsRasterLayer(r'C:\Work\data\FORCE\crete\X0104_Y0103\1984-2018_001-365_LEVEL4_TSA_LNDLG_TCB_C0_S0_FAVG_TY_C95T_TSI.tif'))
    print(rtm.dates)
    print(rtm.names)

def test_merge_3d_ts_noInfo():
    # merge timeseries without any information

    layer = rtm.mergeTimeseries(filename=r'c:\output3\timeseries.vrt',
                        layers=[QgsRasterLayer(r'C:\Work\data\FORCE\crete\X0104_Y0103\1984-2018_001-365_LEVEL4_TSA_LNDLG_TCB_C0_S0_FAVG_TY_C95T_TSI.tif'),
                                QgsRasterLayer(r'C:\Work\data\FORCE\crete\X0104_Y0103\1984-2018_001-365_LEVEL4_TSA_LNDLG_TCG_C0_S0_FAVG_TY_C95T_TSI.tif'),
                                QgsRasterLayer(r'C:\Work\data\FORCE\crete\X0104_Y0103\1984-2018_001-365_LEVEL4_TSA_LNDLG_TCW_C0_S0_FAVG_TY_C95T_TSI.tif')])
    dates, names, numberOfObservations, numberOfBands = RasterTimeseriesManager.deriveInformation(layer=layer)
    print(dates)
    print(names)

def test_buddy():
    rtm.setTimeseries(layer=QgsRasterLayer(r'C:\source\QGISPlugIns\rastertimeseriesmanager\testdata\timeseries.bsq'))

    rtm.ui.layerBuddy(0).setLayer(QgsRasterLayer(r'C:\source\QGISPlugIns\rastertimeseriesmanager\testdata\timeseries.bsq'))

#    rtm.setTimeseriesBuddy(layer=QgsRasterLayer(r'C:\source\QGISPlugIns\rastertimeseriesmanager\testdata\timeseries.bsq'))
    rtm.setDateNumber(10)
    print('ts-red', rtm.timeseries().layer.renderer().redBand())
    for ts in rtm._timeseriesBuddy.values():
        print('tsBuddy-red', ts.layer.renderer().redBand())


def debug():
    f = r'C:\Users\janzandr\Desktop\Neuer Ordner (3)\2015-2015_001-365_LEVEL4_TSA_MULTI_TCB_C0_S0_FAVG_TY_C95T_TSI.dat'
    print(rtm.deriveInformation(QgsRasterLayer(f)))

if __name__ == '__main__':
    #test_ts_4d_infoAsBandnames()

    #test_saveGif()
    #test_merge_3d_ts_noInfo()
    #test_saveMp4()
    #test_saveGif()

    #test_saveframes()
    #test_set_3d_ts_infoAsDYears()
    #test_split_and_merge_4d_ts()
    #test_set_3d_ts_noInfo()
    #test_merge_3d_ts_noInfo()

    test_buddy()



#    qgsApp.exec_()