from hubdc.core import *

root = r'C:/Work/data/FORCE/crete/level2'
#root = r'C:\QGISProjects\RasterTimeseriesManagerExample\landsat_data\raw'

files = dict()

for tile in os.listdir(root):
    print(tile)

    for file in os.listdir(join(root, tile)):

        if not basename(file).startswith('1985'):
            continue

        if file.endswith('BOA.tif'):
            date = '{}-{}-{}'.format((basename(file)[0:4]), basename(file)[4:6], basename(file)[6:8])
            if not date in files:
                files[date] = list()
            files[date].append(join(root, tile, file))

assert 0 # need to copy crete data from server!!!

i = 0
for date in sorted(files.keys()):
    vrt = createVRTDataset(files[date], filename='ts/crete/mosaic/boa/{}.vrt'.format(date))

exit(0)



dates = list()
names = ['blue', 'green', 'red', 'nir', 'swir1', 'swir2']
bandNames = list()
rasters = list()
i = 0

for file in files:

    if not basename(file).startswith('2018'):
        pass
        #continue

    print(file)

    dates.append('{}-{}-{}'.format((basename(file)[0:4]), basename(file)[4:6], basename(file)[6:8]))

    raster = openRasterDataset(file)
    assert raster.zsize() == 6

    for bandNumber in range(1, 7):
        i += 1
        rasters.append(raster.translate(filename=r'C:\QGISProjects\RasterTimeseriesManagerExample\landsat_data\{}.vrt'.format(i),
                                        driver=VrtDriver(), bandList=[bandNumber]))
        bandNames.append('{} - {}'.format(dates[-1], names[bandNumber-1]))

stack = createVRTDataset(rasters, filename=r'C:\QGISProjects\RasterTimeseriesManagerExample\timeseries.vrt', separate=True)
#stack = vrt.translate(filename='timeseries.bsq', driver=EnviDriver())

for band, name in zip(stack.bands(), bandNames):
    band.setDescription(name)

stack.setMetadataItem('names', names, 'ENVI')
stack.setMetadataItem('dates', dates, 'ENVI')
stack.setNoDataValue(-9999)