import tempfile
from os.path import join, dirname
from os import listdir
from qgis.gui import *
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from PyQt5.QtGui import *
from .utils import loadUIFormClass


class RasterTimeseriesManagerUi(QgsDockWidget, loadUIFormClass(pathUi=join(join(dirname(__file__)), 'dockwidget.ui'))):

    def __init__(self, parent=None):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)

        # init widgets
        defaultRoot = join(tempfile.gettempdir(), 'frames')
        self.saveFolder().setDefaultRoot(defaultRoot)
        self.saveFolder().setFilePath(defaultRoot)
        self.saveFolder().setStorageMode(QgsFileWidget.GetDirectory)

        # set icons
        self.saveFrames().setIcon(QIcon(join(dirname(__file__), 'icon_frame.svg')))
        self.saveMp4().setIcon(QIcon(join(dirname(__file__), 'icon_mp4.svg')))
        self.saveGif().setIcon(QIcon(join(dirname(__file__), 'icon_gif.svg')))


    def date(self):
        assert isinstance(self._date, QDateEdit)
        return self._date

    def dateRangeStart(self):
        assert isinstance(self._dateRangeStart, QDateEdit)
        return self._dateRangeStart

    def dateRangeEnd(self):
        assert isinstance(self._dateRangeEnd, QDateEdit)
        return self._dateRangeEnd

    def stepSize(self):
        assert isinstance(self._stepSize, QSpinBox)
        return self._stepSize

    def stepUnit(self):
        assert isinstance(self._stepUnit, QComboBox)
        return self._stepUnit

    def slider(self):
        assert isinstance(self._dateSlider, QSlider)
        return self._dateSlider

    def play(self):
        assert isinstance(self._play, QToolButton)
        return self._play

    def next(self):
        assert isinstance(self._dateNext, QToolButton)
        return self._dateNext

    def previous(self):
        assert isinstance(self._datePrevious, QToolButton)
        return self._datePrevious

    def layer(self):
        assert isinstance(self._layer, QgsMapLayerComboBox)
        return self._layer

    def layerSplit(self):
        assert isinstance(self._layerSplit, QToolButton)
        return self._layerSplit

    def layerMerge(self):
        assert isinstance(self._layerMerge, QToolButton)
        return self._layerMerge

    def saveFrames(self):
        assert isinstance(self._saveFrames, QToolButton)
        return self._saveFrames

    #def viewFrames(self):
    #    assert isinstance(self._viewFrames, QToolButton)
    #    return self._viewFrames

    def saveMp4(self):
        assert isinstance(self._saveMp4, QToolButton)
        return self._saveMp4

    def saveGif(self):
        assert isinstance(self._saveGif, QToolButton)
        return self._saveGif

    def saveFolder(self):
        assert isinstance(self._saveFolder, QgsFileWidget)
        return self._saveFolder

    def fileFfmpeg(self):
        assert isinstance(self._fileFfmpeg, QgsFileWidget)
        return self._fileFfmpeg

    def fileImageMagick(self):
        assert isinstance(self._fileImageMagick, QgsFileWidget)
        return self._fileImageMagick

    def fileTimeseries(self):
        assert isinstance(self._fileTimeseries, QgsFileWidget)
        return self._fileTimeseries

    def openFolder(self):
        assert isinstance(self._openFolder, QToolButton)
        return self._openFolder

    def resetRange(self):
        assert isinstance(self._resetRange, QToolButton)
        return self._resetRange

    def status(self):
        assert isinstance(self._status, QLineEdit)
        return self._status

    def tab(self):
        assert isinstance(self._tab, QTabWidget)
        return self._tab

class Frame(QLabel):

    def __init__(self, parent, image: QImage):
        QLabel.__init__(self, parent)

        # todo just use pixmap?
        #assert isinstance(image, QImage)
        self.image = image

    def resizeEvent(self, event: QResizeEvent):
        QLabel.resizeEvent(self, event)

        size = QSize(self.parent().size().width(), 1)
        image = self.image.scaled(self.size(), Qt.KeepAspectRatioByExpanding)
        size.setHeight(image.height())
        self.setMinimumHeight(size.height())

        pixmap = QPixmap.fromImage(image)
        self.setPixmap(pixmap)

    def _resizeEvent(self, event: QResizeEvent):
        QLabel.resizeEvent(self, event)
        image = self.image.scaled(self.size(), Qt.KeepAspectRatio)
        pixmap = QPixmap.fromImage(image)
        self.setPixmap(pixmap)


class RasterTimeseriesFrameViewerUi(QgsDockWidget, loadUIFormClass(pathUi=join(join(dirname(__file__)), 'dockwidget2.ui'))):

    def __init__(self, parent=None):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.frames = list()

    def setFrames(self, filenames):

        #layout = QGridLayout(self._area)

        #layout = QVBoxLayout(self.scrollArea())
        folder = r'C:\Users\janzandr\AppData\Local\Temp\frames'

        nx = 2

        pngs = [join(folder, f) for f in listdir(folder) if f.endswith('.png')]
        pngs2 = []
        for i in range(1):
            pngs2.extend(pngs)
        pngs=pngs2
        print(len(pngs))
        i = 0
        for row in range(4000000):
            if i == len(pngs): break
            for column in range(nx):
                if i == len(pngs): break
                image = QImage(pngs[i])
                frame = Frame(parent=self._area, image=image)
                frame.setMinimumSize(100, 100)
                self._layout.addWidget(frame)

                print(i)
                i += 1


                self.frames.append(frame)

    def resizeEvent(self, event):
        QgsDockWidget.resizeEvent(self, event)

        for frame in self.frames:
            assert isinstance(frame, Frame)
            frame.setMinimumHeight(1)
