from hubdc.core import *
from datetime import date as Date, timedelta

roi = openVectorDataset(r'C:\Work\data\FORCE\crete\shapes\crete_region.shp')
for feature in openVectorDataset(r'C:\Work\data\gms\gis\countries\countries.shp').features():
    if feature.value('name') == 'Germany':
        germany = feature
        break

grid = Grid(extent=Extent.fromGeometry(germany.geometry()).reproject(Projection.fromEpsg(3035)), resolution=30)

date0 = Date(1984, 1, 1)
dateN = Date(1984, 1, 11)

ndates = (dateN-date0).days
nbands = 3

driver = GTiffDriver()
o = driver.Option
options = [o.NUM_THREADS(),
           o.INTERLEAVE.BAND,
           #o.COMPRESS.LZW,
           o.TILED.YES, o.BLOCKXSIZE(256), o.BLOCKYSIZE(256)
           ]
raster = GTiffDriver().create(grid=grid, bands=ndates*nbands, filename='timeseries.tif', options=options)

i = 0
for j in range(ndates):
    date = date0 + timedelta(days=j)
    print(date)
    for name in ['red', 'green', 'blue']:
        band = raster.band(i)
        band.writeArray(np.random.randint(0, 255, size=grid.shape()))
        band.setDescription('{} - {}'.format(date, name))
        i += 1
