from __future__ import absolute_import
from qgis.gui import QgisInterface, QtCore


class RasterTimeseriesManagerPlugin(object):

    def __init__(self, iface):
        """Initialize the plugin"""
        assert isinstance(iface, QgisInterface)
        self.iface = iface

    def initGui(self):
        """Initialize the gui"""
        from .controller import RasterTimeseriesManagerController
        self.timeManager = RasterTimeseriesManagerController(self.iface)
        self.timeManager.show()
        self.iface.addDockWidget(QtCore.Qt.BottomDockWidgetArea, self.timeManager.ui)

    def unload(self):
        """Unload the plugin"""
        # todo
