from os.path import join, dirname
from qgis.gui import *
from PyQt5.QtWidgets import *
from .utils import loadUIFormClass


class RasterTimeseriesManagerUi(QgsDockWidget, loadUIFormClass(pathUi=join(join(dirname(__file__)), 'dockwidget.ui'))):

    def __init__(self, parent=None):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)

    def date(self):
        assert isinstance(self._date, QSpinBox)
        return self._date

    def slider(self):
        assert isinstance(self._dateSlider, QSlider)
        return self._dateSlider

    def timestamp(self):
        assert isinstance(self._dateTimestamp, QLineEdit)
        return self._dateTimestamp

    def play(self):
        assert isinstance(self._play, QToolButton)
        return self._play

    def first(self):
        assert isinstance(self._dateFirst, QToolButton)
        return self._dateFirst

    def last(self):
        assert isinstance(self._dateLast, QToolButton)
        return self._dateLast

    def next(self):
        assert isinstance(self._dateNext, QToolButton)
        return self._dateNext

    def previous(self):
        assert isinstance(self._datePrevious, QToolButton)
        return self._datePrevious

    def layer(self):
        assert isinstance(self._layer, QgsMapLayerComboBox)
        return self._layer

    def groupTime(self):
        assert isinstance(self._groupTime, QWidget)
        return self._groupTime

    def groupTimeseries(self):
        assert isinstance(self._groupTimeseries, QWidget)
        return self._groupTimeseries

    def groupRenderer(self):
        assert isinstance(self._groupRenderer, QWidget)
        return self._groupRenderer
