# -*- coding: utf-8 -*-
"""
/***************************************************************************
 rasterinversor
                                 A QGIS plugin
 The plugin inverts the values of a raster
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-11-29
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Sergio Carrera Fernández
        email                : scarreraf@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QFileDialog
from qgis._core import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .raster_inversor_dialog import rasterinversorDialog
import os.path


class rasterinversor:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'rasterinversor_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = rasterinversorDialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&raster inversor')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'rasterinversor')
        self.toolbar.setObjectName(u'rasterinversor')

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('rasterinversor', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/raster_inversor/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Raster Inversor'),
            callback=self.run,
            parent=self.iface.mainWindow())
        self.dlg.tb_inRaster.clicked.connect(self.openRaster)
        self.dlg.tb_outRaster.clicked.connect(self.saveRaster)
        self.loadRasters()

    def loadRasters(self):
        self.dlg.cb_inRaster.clear()
        layers=[layer for layer in QgsProject.instance().mapLayers().values()]
        raster_layers=[]
        for layer in layers:
            if layer.type()==QgsMapLayer.RasterLayer:
                raster_layers.append(layer.name())
        self.dlg.cb_inRaster.addItems(raster_layers)

    def openRaster(self):
        """Open raster from file dialog"""
        inFile=str(QFileDialog.getOpenFileName(caption="Open raster", filter="Rasters (*.asc)")[0])
        if inFile is not None:
            self.iface.addRasterLayer(inFile, str.split(os.path.basename(inFile), ".")[0])
            self.loadRasters()

    def saveRaster(self):
        """Get the save file name for the inverted raster from a file dialog"""
        outFile=str(QFileDialog.getSaveFileName(caption="Save inverted raster as", filter="Raster (*.asc)")[0])
        self.setRasterLine(outFile)

    def setRasterLine(self, text):
        """Set the GUI text for the inverted raster filename"""
        self.dlg.le_outRaster.setText(text)

    def getRasterLayer(self):
        """Gets raster layer specified in combo box"""
        layer=None
        layername=self.dlg.cb_inRaster.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name()==layername:
                layer=lyr
                break
        return layer

    def setVariables(self):
        """Get and set all variables from UI"""
        self.inRaster=self.getRasterLayer()
        self.outRaster=self.dlg.le_outRaster.text()

    def inversion(self):
        lyr=self.inRaster

        cols = lyr.width()
        rows = lyr.height()
        dpr = lyr.dataProvider()
        bl = dpr.block(1, dpr.extent(), cols, rows)
        extent = lyr.extent()
        xmin, ymin, xmax, ymax = extent.toRectF().getCoords()
        xsize = lyr.rasterUnitsPerPixelX()
        nodatavalue=bl.noDataValue()

        elevation = []
        for i in range(rows):
            elevationline = []
            for j in range(cols):
                elevationline.append(bl.value(i, j))
            elevation.append(elevationline)

        headerdem={'ncols':cols,'nrows':rows,'xllcorner':xmin,'yllcorner':ymin,'cellsize':xsize,'NODATA_value':nodatavalue}

        inversionfilter = []
        for i in range(len(elevation)):
            for j in range(len(elevation[i])):
                if elevation[i][j] != headerdem['NODATA_value']:
                    valuemin = elevation[i][j]
                    valuemax = elevation[i][j]
                    i = len(elevation) - 1
                    j = len(elevation[i]) - 1
        for i in range(len(elevation)):
            for j in range(len(elevation[i])):
                if elevation[i][j] != headerdem['NODATA_value']:
                    if elevation[i][j] < valuemin:
                        valuemin = elevation[i][j]
                    if elevation[i][j] > valuemax:
                        valuemax = elevation[i][j]
        for i in range(len(elevation)):
            inversionline = []
            for j in range(len(elevation[i])):
                if elevation[i][j] == headerdem['NODATA_value']:
                    inversionline.append(elevation[i][j])
                else:
                    inversionline.append(valuemax - (elevation[i][j] - valuemin))
            inversionfilter.append(inversionline)

        escribir = open(self.outRaster, 'w')
        j = 0
        i = 0
        for key, value in headerdem.items():
            escribir.writelines(key + ' ' + str(value) + '\n')
        for item in elevation:
            for thing in elevation[j]:
                escribir.writelines(str(inversionfilter[j][i]) + ' ')
                i = i + 1
            escribir.writelines('\n')
            j = j + 1
            i = 0


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&raster inversor'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar


    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            self.setVariables()
            self.inversion()

