from os.path import join

from qgis._core import QgsPointXY
from qgis.gui import *
from qgis.core import *
from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import *
from .. import ui
from .rdplayerwidget import RdpLayerWidget
from ..site import RasterTimeseriesManager as rtm


debug = True

class RdpSpectralProfilePlotWidget(QWidget):

    iface = None # set by RdpDockWidget

    def __init__(self, parent=None):
        QWidget.__init__(self, parent)
        uic.loadUi(join(ui.path, 'spectralprofileplotwidget.ui'), self)
        self.ui = _Ui(self)
        self._initUi()

        self.dataHandler = DataHandler(layer=self.ui.layer(), mapCanvas=self.mapCanvas(),
                                       x=self.ui.pixelX(), y=self.ui.pixelY())
        self._connectSignals()

    def _initUi(self):
        self.ui.layer().setName('Raster')

    def _connectSignals(self):

        #self.mapCanvas().xyCoordinates.connect(self.onXyCoordinatesChanged)

        # group location


        # link to raster timeseries manager
        if rtm.rtmInstalled:
            # Can't connect directly, because RTM plugin may be initialized later.
            self.ui.layer().ui.updateDate().clicked.connect(self.onLayerUpdateDateClicked)

    def onLayerUpdateDateClicked(self):
        if rtm.rtmInterface(raiseError=False) is not None:
            # RTM plugin should be initialized now, so we can connect.
            rtm.rtmInterface().sigDateChanged.connect(self.onDateChanged)
            # Disconnect indirection.
            self.ui.layer().ui.updateDate().clicked.disconnect(self.onLayerUpdateDateClicked)

    def onXyCoordinatesChanged(self, p):
        assert isinstance(p, QgsPointXY)
        print(p)
        #self.readData()

    def onDateChanged(self, date, snap):
        layer = self.ui.layer()
        if self.ui.layer().ui.updateDate().isChecked():
            layer.blockSignals(True)
            layer.ui.date().setDate(date=date, snap=snap)
            layer.blockSignals(False)
            self.readData()
            if debug: print('date changed: {}'.format(date.toString('yyyy-MM-dd')))

    def mapCanvas(self):
        mapCanvas = self.iface.mapCanvas()
        assert isinstance(mapCanvas, QgsMapCanvas)
        return mapCanvas

    def resetData(self):
        pass

    def readData(self):
        if self.ui.showPlot().isChecked():
            self.dataReader.read()
            self.processData()

    def processData(self):
        if self.ui.showPlot().isChecked():
            if self.dataReader.isValid() and self.dataReaderY.isValid():
                bins = self.bins()
                self.setBins(bins=bins)

                range = self.range()
                self.setRange(range=range)

                self.dataBinner.bin(bins=bins, range=range)
                self.dataFitter.fitPredict(rangeX=range[0])
            else:
                self.dataBinner.setInvalidAndClearCache()
                self.dataFitter.setInvalidAndClearCache()
            self.plotData()

    def plotData(self):

        if self.ui.showPlot().isChecked():
            pass


class DataHandler(object):

    def __init__(self, layer, x, y, mapCanvas):
        assert isinstance(layer, RdpLayerWidget)
        assert isinstance(mapCanvas, QgsMapCanvas)
        assert isinstance(x, QSpinBox)
        assert isinstance(y, QSpinBox)
        self.layer = layer

    def read(self):

        layer = self.layer.ui.layer().currentLayer()
        assert isinstance(layer, QgsRasterLayer)
        provider = layer.dataProvider()
        assert isinstance(provider, QgsRasterDataProvider)

        # read data
        profile = list()
        for i in range(layer.bandCount()):
            provider.sample(point=point,)

        block = projector.block(band, extent, size.width(), size.height())
        assert isinstance(block, QgsRasterBlock)
        array = np.frombuffer(np.array(np.array(block.data())),
                              dtype=rdputils.qgisDataTypeToNumpyDataType(block.dataType()))

        # calculate mask from band layer
        mask = np.full_like(array, fill_value=True, dtype=np.bool)
        noDataValues = [obj.min() for obj in provider.userNoDataValues(band)]
        if provider.sourceHasNoDataValue(band) and provider.useSourceNoDataValue(band):
            noDataValues.append(provider.sourceNoDataValue(band))

        for noDataValue in noDataValues:
            mask[array == noDataValue] = False

        data = array[mask]

        if data.size == 0:
            self.setInvalidAndClearCache()
            return

        range = data.min(), data.max()

        self.setCache(array=array, mask=mask, range=range)
        self.setValid()

class _Ui(object):

    def __init__(self, obj):
        self.obj = obj

    def layer(self):
        assert isinstance(self.obj._layer, RdpLayerWidget)
        return self.obj._layer

    # location group
    def showPlot(self):
        assert isinstance(self.obj._showPlot, QToolButton)
        return self.obj._showPlot

    def pixelX(self):
        assert isinstance(self.obj._pixelX, QSpinBox)
        return self.obj._pixelX

    def pixelY(self):
        assert isinstance(self.obj._pixelY, QSpinBox)
        return self.obj._pixelY

