from collections import namedtuple
import traceback
import numpy as np
import math
from qgis.core import *
from os.path import join, dirname
from qgis.gui import *
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from PyQt5.QtGui import *

from .. import rdputils
from ..site import pyqtgraph as pg
from ..gui.rdpdockwidget import RdpDockWidget

debug = True

class RdpInterface(QObject):

    INSTANCE = None
    pluginName = 'Raster Data Plotting'
    pluginId = pluginName.replace(' ', '')

    def __init__(self, iface, parent=None):

        if self.INSTANCE is not None:
            raise Exception('{} already initialized.'.format(self.pluginName))
        else:
            RdpInterface.INSTANCE = self

        QObject.__init__(self, parent)
        assert isinstance(iface, QgisInterface)
        self.iface = iface
        self._initUi()
        self._integratePlugin()

    def _initUi(self):
        RdpDockWidget.iface = self.iface
        self.ui = RdpDockWidget()
        self.ui.setWindowIcon(self.icon())

    def _integratePlugin(self):
        if isinstance(self.iface, QgisInterface):
            self.action1 = QAction(self.icon(), self.pluginName.replace(' ', ''), self.iface.mainWindow())
            self.action1.triggered.connect(self.toggleUiVisibility)
            self.iface.addToolBarIcon(self.action1)

    @classmethod
    def instance(cls):
        if cls.INSTANCE is None:
            raise Exception('{} not initialized.'.format(cls.pluginName))

        assert isinstance(cls.INSTANCE, RdpInterface)
        return cls.INSTANCE

    def pluginFolder(self):
        return join(dirname(__file__), '..', '..')

    def icon(self):
        print(join(self.pluginFolder(), 'icon.png'))
        return QIcon(join(self.pluginFolder(), 'icon.png'))

    def toggleUiVisibility(self):
        self.ui.setVisible(not self.ui.isVisible())

    def show(self):
        self.ui.show()
