import numpy as np
from PyQt5.QtCore import *
from PyQt5.QtGui import *

from .site import pyqtgraph as pg

class ImageViewWidget(pg.ImageView):

    #sigRangeChanged = pyqtSignal(object, object)
    sigHistogramLevelsChanged = pyqtSignal(object)

    def __init__(self, *args, **kwargs):
        self.plotItem_ = pg.PlotItem()
        pg.ImageView.__init__(self, *args, view=self.plotItem_, **kwargs)

        self.rois = list()

        # init gui
        self.plotItem().setAspectLocked(lock=False)
        #self.setImage(np.array([[1, 0], [0, 1]]))  # need to initialize image to properly calculate native screen resolution
        self.setImage(np.array([[-1, 0]]), autoLevels=False, levels=[0, 0])  # need to initialize image to properly calculate native screen resolution
        #self._setDefaultColorMap()
        self.ui.menuBtn.hide()
        self.ui.roiBtn.hide()

        # connect signals
        #self.sigRangeChanged.connect(lambda *args: print('TEST'))#self.plotItem().sigRangeChanged)
        self.sigHistogramLevelsChanged.connect(self.ui.histogram.item.sigLevelsChanged)

    #def _setDefaultColorMap(self):
    #    from .site.pyqtgraph.graphicsItems.GradientEditorItem import Gradients
    #    colormap = pg.ColorMap(*zip(*Gradients['thermal']['ticks']))
    #    self.getImageItem().setLookupTable(colormap)

    def addRoi(self, roi):
        assert isinstance(roi, pg.ROI)
        zvalue = 10 + len(self.rois)
        roi.setZValue(zvalue)

        def removeRoi(*args):
            self.view.removeItem(roi)
            self.rois.remove(roi)

        roi.sigRemoveRequested.connect(removeRoi)
        roi.show()
        self.view.addItem(roi)
        self.rois.append(roi)

    def setHistogramVisibility(self, visible):
        self.ui.roiBtn.setVisible(False)
        self.ui.menuBtn.setVisible(False)
        self.ui.histogram.setVisible(visible)

    def plotItem(self):
        assert isinstance(self.plotItem_, pg.PlotItem)
        return self.plotItem_

    def timeout(self):
        pass # turn dead