from os.path import join, dirname
from qgis.gui import *
from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *

from .utils import loadUIFormClass, version
from .imageviewwidget import ImageViewWidget

class RasterDataPlottingDock(QgsDockWidget, loadUIFormClass(pathUi=join(join(dirname(__file__)), 'dockwidget.ui'))):

    def __init__(self, parent=None):
        QgsDockWidget.__init__(self, parent)
        self.setupUi(self)
        self.setWindowTitle('{} (v{})'.format(self.windowTitle(), version()))
        self._imageView = ImageViewWidget()
        self.verticalLayout.addWidget(self._imageView)
        self._setIcons()

    def _setIcons(self):
        self.roiCircle().setIcon(QIcon(join(dirname(__file__), 'icon_roi1.png')))
        self.roiRectangle().setIcon(QIcon(join(dirname(__file__), 'icon_roi2.png')))
        self.roiPolygon().setIcon(QIcon(join(dirname(__file__), 'icon_roi3.png')))

    def layerX(self):
        assert isinstance(self._layerX, QgsMapLayerComboBox)
        return self._layerX

    def layerY(self):
        assert isinstance(self._layerY, QgsMapLayerComboBox)
        return self._layerY

    def bandXRaster(self):
        assert isinstance(self._bandXRaster, QgsRasterBandComboBox)
        return self._bandXRaster

    def bandYRaster(self):
        assert isinstance(self._bandYRaster, QgsRasterBandComboBox)
        return self._bandYRaster

    def bandXRenderer(self):
        assert isinstance(self._bandXRenderer, QComboBox)
        return self._bandXRenderer

    def bandYRenderer(self):
        assert isinstance(self._bandYRenderer, QComboBox)
        return self._bandYRenderer

    def minX(self):
        assert isinstance(self._minX, QLineEdit)
        return self._minX

    def maxX(self):
        assert isinstance(self._maxX, QLineEdit)
        return self._maxX

    def minY(self):
        assert isinstance(self._minY, QLineEdit)
        return self._minY

    def maxY(self):
        assert isinstance(self._maxY, QLineEdit)
        return self._maxY

    def minH(self):
        assert isinstance(self._minH, QLineEdit)
        return self._minH

    def maxH(self):
        assert isinstance(self._maxH, QLineEdit)
        return self._maxH

    def percentageH(self):
        assert isinstance(self._percentageH, QDoubleSpinBox)
        return self._percentageH

    def bandMode(self):
        assert isinstance(self._bandMode, QComboBox)
        return self._bandMode

    def binsX(self):
        assert isinstance(self._binsX, QSpinBox)
        return self._binsX

    def binsY(self):
        assert isinstance(self._binsY, QSpinBox)
        return self._binsY

    def bandsX(self):
        assert isinstance(self._bandsX, QSpinBox)
        return self._bandsX

    def imageView(self):
        assert isinstance(self._imageView, ImageViewWidget)
        return self._imageView

    def plotType(self):
        assert isinstance(self._plotType, QComboBox)
        return self._plotType

    def refresh(self):
        assert isinstance(self._refresh, QToolButton)
        return self._refresh

    def doPlot(self):
        assert isinstance(self._doPlot, QToolButton)
        return self._doPlot

    def doRoi(self):
        assert isinstance(self._doRoi, QToolButton)
        return self._doRoi

    def roiCircle(self):
        assert isinstance(self._roiCircle, QToolButton)
        return self._roiCircle

    def roiRectangle(self):
        assert isinstance(self._roiRectangle, QToolButton)
        return self._roiRectangle

    def roiPolygon(self):
        assert isinstance(self._roiPolygon, QToolButton)
        return self._roiPolygon

    def roiColor(self):
        assert isinstance(self._roiColor, QgsColorButton)
        return self._roiColor

    def roiOpacity(self):
        assert isinstance(self._roiOpacity, QSpinBox)
        return self._roiOpacity

    def updateRangeX(self):
        assert isinstance(self._updateRangeX, QToolButton)
        return self._updateRangeX

    def updateRangeY(self):
        assert isinstance(self._updateRangeY, QToolButton)
        return self._updateRangeY

