# Changelog

All notable changes to Raster Blaster will be documented in this file.

## [2.1.0] - 2025-12-14

### Added

- **Qt5/Qt6 compatibility**: Works with both Qt5 and Qt6 versions of QGIS
- **Background processing**: All GDAL operations now run in a background thread using QgsTask, keeping QGIS fully responsive during processing
- **Progress tracking**: Real-time progress bar shows processing status
- **User-selectable CRS**: Full CRS selector widget replaces the hardcoded EPSG:3857 - choose any projection
- **Persistent settings**: Plugin remembers your preferences between sessions:
  - Last used directory
  - Compression method
  - Resampling method  
  - Transformation type
  - Target CRS
  - JPEG quality
  - Auto-load preference
- **Auto-load results**: Option to automatically add processed rasters to the map
- **JPEG quality control**: Adjustable quality slider (1-100%) when using JPEG compression
- **GCP validation warnings**:
  - Checks GCP count against transformation requirements (e.g., Polynomial order 2 needs 6+ GCPs)
  - Warns if GCPs are clustered in one area of the image
  - Warns if GCPs are arranged in a nearly straight line
- **Overwrite protection**: Prompts for confirmation before overwriting existing output files
- **Auto-fill output path**: Selecting an input image automatically fills the output field with a suggested filename
- **Additional compression options**: Added ZSTD and NONE to compression choices
- **Better encoding support**: Points file parser tries UTF-8, Windows-1252, and Latin-1 encodings

### Changed

- **Menu location**: Moved from `Plugins → Raster Blaster` to `Raster → Raster Blaster` for better discoverability
- **Dialog layout**: Reorganized with grouped sections (Files, Options) for cleaner interface
- **Error messages**: More informative error messages and logging

### Fixed

- **UI freeze**: Processing no longer freezes QGIS interface
- **File overwrite errors**: Properly handles existing output files instead of failing with GDAL error

## [1.0.1] - 2025-04-24

### Added

- Initial release
- Points→GeoTIFF conversion
- Points→COG conversion  
- GeoTIFF→COG conversion
- Integration with Georeferencer toolbar
- Basic transformation options (TPS, RPC, Geoloc, Polynomial 1-3)
- Basic resampling options
- Basic compression options (JPEG, LZW, DEFLATE, PACKBITS)