# -*- coding: utf-8 -*-
"""
/***************************************************************************
 RasterTools
                                 A QGIS plugin
 This plugin provides a raster calculator and delivered cost calculator.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-31
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Tim Van Driel
        email                : timothy.vandriel@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMenu, QToolButton

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidgets
from .delivered_cost.delivered_cost_dockwidget import DeliveredCostDockWidget
from .lazy_calculator.lazy_raster_calculator_dockwidget import (
    LazyRasterCalculatorDockWidget,
)
import os.path


class r_tools:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)

        locale = QSettings().value("locale/userLocale")[0:2]
        locale_path = os.path.join(self.plugin_dir, "i18n", f"RasterTools_{locale}.qm")

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr("&Raster Tools")
        self.toolbar = self.iface.addToolBar("RasterTools")
        self.toolbar.setObjectName("RasterTools")

        self.delivered_cost_dockwidget = None
        self.raster_calculator_dockwidget = None

        self.raster_tools_menu = None

    def tr(self, message):
        return QCoreApplication.translate("RasterTools", message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
    ):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip:
            action.setStatusTip(status_tip)

        if whats_this:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToRasterMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        icon_path = ":/plugins/rasterTools/icon.png"

        # ----- Add to Raster > Raster Tools menu -----
        raster_menu = self.iface.rasterMenu()
        self.raster_tools_menu = QMenu(self.tr("Raster Tools"), self.iface.mainWindow())
        raster_menu.addMenu(self.raster_tools_menu)

        # Create actions
        self.delivered_cost_action = QAction(
            QIcon(icon_path), self.tr("Delivered Cost"), self.iface.mainWindow()
        )
        self.delivered_cost_action.triggered.connect(
            self.open_delivered_cost_dockwidget
        )
        self.raster_tools_menu.addAction(self.delivered_cost_action)

        self.lazy_raster_action = QAction(
            QIcon(icon_path), self.tr("Lazy Raster Calculator"), self.iface.mainWindow()
        )
        self.lazy_raster_action.triggered.connect(
            self.open_raster_calculator_dockwidget
        )
        self.raster_tools_menu.addAction(self.lazy_raster_action)

        self.actions.append(self.delivered_cost_action)
        self.actions.append(self.lazy_raster_action)

        # ----- Create a single toolbar button with a dropdown menu -----
        self.toolbar = self.iface.addToolBar("Raster Tools Suite")

        self.tool_button = QToolButton()
        self.tool_button.setIcon(QIcon(icon_path))
        self.tool_button.setToolTip("Raster Tools Suite")
        self.tool_button.setPopupMode(QToolButton.InstantPopup)  # dropdown on click

        # Create the dropdown menu
        menu = QMenu()
        menu.addAction(self.delivered_cost_action)
        menu.addAction(self.lazy_raster_action)
        self.tool_button.setMenu(menu)

        # Add button to toolbar
        self.toolbar.addWidget(self.tool_button)

    def open_delivered_cost_dockwidget(self):
        if self.delivered_cost_dockwidget is None:
            self.delivered_cost_dockwidget = DeliveredCostDockWidget()
            # Optional: connect a closing signal here if needed

        self.iface.addDockWidget(Qt.RightDockWidgetArea, self.delivered_cost_dockwidget)
        self.delivered_cost_dockwidget.show()
        self.delivered_cost_dockwidget.raise_()

    def open_raster_calculator_dockwidget(self):
        if self.raster_calculator_dockwidget is None:
            self.raster_calculator_dockwidget = LazyRasterCalculatorDockWidget()

        self.iface.addDockWidget(
            Qt.RightDockWidgetArea, self.raster_calculator_dockwidget
        )
        self.raster_calculator_dockwidget.show()
        self.raster_calculator_dockwidget.raise_()

    def unload(self):
        for action in self.actions:
            self.raster_tools_menu.removeAction(action)

        raster_menu = self.iface.rasterMenu()
        if self.raster_tools_menu:
            raster_menu.removeAction(self.raster_tools_menu.menuAction())
            self.raster_tools_menu = None

        if self.tool_button:
            self.toolbar.removeAction(self.tool_button.defaultAction())
            self.tool_button = None

        del self.toolbar

        if self.delivered_cost_dockwidget:
            self.delivered_cost_dockwidget.close()
            self.delivered_cost_dockwidget = None
        if self.raster_calculator_dockwidget:
            self.raster_calculator_dockwidget.close()
            self.raster_calculator_dockwidget = None
