"""
/***************************************************************************
 RasterTools
                                 A QGIS plugin
 This plugin provides a raster calculator and delivered cost calculator.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-31
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Tim Van Driel
        email                : timothy.vandriel@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from .layer_manager import LayerManager
from .raster_manager import RasterManager
from .expression_evaluator import ExpressionEvaluator
from .raster_saver import RasterSaver
from .safe_evaluator import SafeEvaluator
from .lazy_manager import LazyLayerRegistry, get_lazy_layer_registry
from .exceptions import (
    RasterCalcError,
    LayerNotFoundError,
    InvalidExpressionError,
    RasterSaveError,
    RasterToolsUnavailableError,
    BandMismatchError,
    RasterExtentError,
)

__all__ = [
    "LayerManager",
    "RasterManager",
    "ExpressionEvaluator",
    "RasterSaver",
    "SafeEvaluator",
    "LazyLayerRegistry",
    "get_lazy_layer_registry",
    "RasterCalcError",
    "LayerNotFoundError",
    "InvalidExpressionError",
    "RasterSaveError",
    "RasterToolsUnavailableError",
    "BandMismatchError",
    "RasterExtentError",
]
