"""
/***************************************************************************
 RasterTools
                                 A QGIS plugin
 This plugin provides a raster calculator and delivered cost calculator.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-31
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Tim Van Driel
        email                : timothy.vandriel@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.gui import QgsMapTool
from qgis.PyQt.QtCore import pyqtSignal, Qt
from qgis.core import QgsPointXY


class PickPointTool(QgsMapTool):
    """A tool to pick a point on the map canvas and emit the coordinates."""

    pointPicked = pyqtSignal(QgsPointXY)  # Signal emitted when a point is picked.

    def __init__(self, canvas):
        """Initialize the tool with the given canvas.
        Args:
            canvas (QgsMapCanvas): The map canvas where the tool will operate.
        """
        super().__init__(canvas)
        self.canvas = canvas
        self.setCursor(Qt.CrossCursor)

    def canvasReleaseEvent(self, event):
        """Handle the mouse release event to pick a point.
        Args:
            event (QgsMapMouseEvent): The mouse event containing the position.
        """
        if event.button() == Qt.LeftButton:
            point = self.canvas.getCoordinateTransform().toMapCoordinates(event.pos())
            self.pointPicked.emit(point)
            self.deactivate()

    def deactivate(self):
        """Deactivate the tool and reset the cursor."""
        super().deactivate()
        self.canvas.unsetMapTool(self)
