# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SpatialStatistics
                                 A QGIS plugin
 This plugin provide spatial statistic tool
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-13
        copyright            : (C) 2025 by nbayashi
        email                : naoya_nstyle@hotmail.co.jp
 ***************************************************************************/

"""

__author__ = 'nbayashi'
__date__ = '2025-04-13'
__copyright__ = '(C) 2025 by nbayashi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'
import os
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon
from .r_spatial_statistics_setting_dialog import RSpatialStatisticsSettingDialog
from qgis.core import QgsProcessingProvider
from .processing import RScriptProcessingProvider
from qgis.core import QgsApplication

from .adjacency_matrix_provider.adjacency_matrix_provider import AdjacencyMatrixProvider

class RRunnerPlugin:
    def __init__(self, iface):
        self.iface = iface
        self.action = None
        self.dialog = None
        self.provider = None

    def initGui(self):
        self.initProcessing()
        icon_path = ''  # Add icon if needed
        self.action = QAction("Setting", self.iface.mainWindow())
        self.action.triggered.connect(self.show_dialog)
        self.iface.addPluginToMenu("R Spatial Statistics", self.action)


    def initProcessing(self):
        self.provider = AdjacencyMatrixProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

        

    def unload(self):
        self.iface.removePluginMenu("R Spatial Statistics", self.action)
        QgsApplication.processingRegistry().removeProvider(self.provider)


    def show_dialog(self):
        self.dialog = RSpatialStatisticsSettingDialog()
        self.dialog.show()