# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SpatialStatistics
                                 A QGIS plugin
 This plugin provide spatial statistic tool
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-13
        copyright            : (C) 2025 by nbayashi
        email                : naoya_nstyle@hotmail.co.jp
 ***************************************************************************/
"""

__author__ = 'nbayashi'
__date__ = '2025-04-13'
__copyright__ = '(C) 2025 by nbayashi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'
from pathlib import Path
from PyQt5.QtGui import QIcon

from qgis.core import QgsProcessingProvider
from .r_adjacency_matrix_algorithm import AdjacencyMatrixAlgorithm
from .r_knearneigh_algorithm import KnearneighAlgorithm
from .r_dnearneigh_algorithm import DnearneighAlgorithm
from .gisa.gisa_adjacency_matrix_algorithm import GISAAdjacencyMatrixAlgorithm
from .gisa.gisa_knearneigh_algorithm import GISAKnearneighAlgorithm
from .gisa.gisa_dnearneigh_algorithm import GISADnearneighAlgorithm
from .lisa.lisa_adjacency_matrix_algorithm import LISAAdjacencyMatrixAlgorithm
from .lisa.lisa_dnearneigh_algorithm import LISADnearneighAlgorithm
from .lisa.lisa_knearneigh_algorithm import LISAKnearneighAlgorithm


class AdjacencyMatrixProvider(QgsProcessingProvider):

    def __init__(self):
        QgsProcessingProvider.__init__(self)

    def unload(self):
        pass

    def loadAlgorithms(self):
        self.addAlgorithm(AdjacencyMatrixAlgorithm())
        self.addAlgorithm(KnearneighAlgorithm())
        self.addAlgorithm(DnearneighAlgorithm())
        # add GISA algorithms
        self.addAlgorithm(GISAAdjacencyMatrixAlgorithm())
        self.addAlgorithm(GISAKnearneighAlgorithm())
        self.addAlgorithm(GISADnearneighAlgorithm())
        # add LISA algorithms
        self.addAlgorithm(LISAAdjacencyMatrixAlgorithm())
        self.addAlgorithm(LISADnearneighAlgorithm())
        self.addAlgorithm(LISAKnearneighAlgorithm())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())


    def id(self):
        return 'rspatialstatistics'

    def name(self):
        return self.tr('R Spatial Statistics')

    def icon(self):
        path = (Path(__file__).parent / "../icon.png").resolve()
        return QIcon(str(path))
    

    def longName(self):
        return self.name()
