"""
Model exported as python.
Name : a
Group : a
With QGIS : 32809
"""

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterFeatureSink
import processing


class A(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('layer', 'layer', types=[QgsProcessing.TypeVectorAnyGeometry], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Elementi_duplicati', 'elementi_duplicati', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(1, model_feedback)
        results = {}
        outputs = {}

        # Estrai elementi duplicati aventi stessa geometria
        alg_params = {
            'EXPRESSION': 'count($id,geom_to_wkt($geometry)) > 1',
            'INPUT': parameters['layer'],
            'OUTPUT': parameters['Elementi_duplicati']
        }
        outputs['EstraiElementiDuplicatiAventiStessaGeometria'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Elementi_duplicati'] = outputs['EstraiElementiDuplicatiAventiStessaGeometria']['OUTPUT']
        return results

    def name(self):
        return 'a'

    def displayName(self):
        return 'a'

    def group(self):
        return 'a'

    def groupId(self):
        return ''

    def createInstance(self):
        return A()
