# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Quick_search
                                 A QGIS plugin
 Quick_search
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-11-20
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Sakal Mykhailo
        email                : 53861tmmb@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QDockWidget

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .code import *

import os.path



class Quick_search:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.
        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        self.menu = u'Quick_search'
        self.actions = []
        self.first_start = None
        self.dock_widget = None  # Зберігаємо посилання на головне докове вікно
        self.additional_dock_widget = None  # Зберігаємо посилання на додаткове докове вікно


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar."""
        
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)

        return action
    

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        plugin_dir = os.path.dirname(__file__)
        icon_path = os.path.join(plugin_dir, "icons", "icon.png")

        self.add_action(
            icon_path,
            text=u'Quick search',
            callback=self.run,
            parent=self.iface.mainWindow())

        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(u'&Quick_search', action)
            self.iface.removeToolBarIcon(action)

        # Видаляємо докові вікна при вимкненні плагіна
        if self.dock_widget:
            self.iface.removeDockWidget(self.dock_widget)
        if self.additional_dock_widget:
            self.iface.removeDockWidget(self.additional_dock_widget)

    def run(self):
        """Run method that performs all the real work"""

        if self.first_start:
            self.first_start = False
            
            # Створюємо головне докове вікно
            self.dock_widget = QDockWidget("Quick_search", self.iface.mainWindow())
            self.dock_widget.setObjectName("Quick_searchDockWidget")
            
            # Створюємо інтерфейс у головному докованому вікні
            self.dlg = SearchFeaturesDialog()
            self.dock_widget.setWidget(self.dlg)
            
            # Додаємо головне докове вікно до QGIS
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dock_widget)

            # Підключаємо кнопку "+" до методу відкриття додаткового вікна
            self.dlg.open_additional_search_button.clicked.connect(self.toggle_additional_search)

        self.dock_widget.show()

    def toggle_additional_search(self):
        """Відкриває або закриває додаткове докове вікно"""
        if self.additional_dock_widget is None or not self.additional_dock_widget.isVisible():
            # Створюємо додаткове докове вікно
            self.additional_dock_widget = QDockWidget(tr("Додатковий пошук"), self.iface.mainWindow())
            self.additional_dock_widget.setObjectName("AdditionalSearchDockWidget")
            
            # Створюємо інтерфейс у додатковому докованому вікні
            additional_dlg = SearchFeaturesDialog(is_additional=True)
            self.additional_dock_widget.setWidget(additional_dlg)
            
            # Додаємо додаткове докове вікно до QGIS
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.additional_dock_widget)

            # Змінюємо кнопку "+" на "-" у головному вікні
            self.dlg.open_additional_search_button.setText("-")
        else:
            # Закриваємо додаткове вікно
            self.additional_dock_widget.close()
            self.additional_dock_widget = None
            # Змінюємо кнопку "-" на "+" у головному вікні
            self.dlg.open_additional_search_button.setText("+")