# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QuickLayer
                                 A QGIS plugin
 Switch between the images of your choice using shortcuts
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-11-11
        copyright            : (C) 2021 by João P. Bueno
        email                : jo.bueno98@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon, QKeySequence
from qgis.PyQt.QtWidgets import QAction, QShortcut
from qgis.core import *
from qgis.utils import *
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .quick_layer_dialog import QuickLayerDialog
import os.path
from qgis.utils import *


class QuickLayer:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'QuickLayer_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&QuickLayer')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.shortcuts = []

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('QuickLayer', message)

    icon_path = ':/plugins/quick_layer/icon.png'
    def add_action(self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/quick_layer/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Quick Layer'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&QuickLayer'),
                action)
            self.iface.removeToolBarIcon(action)


    def alterna(self, layertree1, layertree2):
        
        if layertree1.isVisible():
            layertree1.setItemVisibilityChecked(False)
            layertree2.setItemVisibilityChecked(True)
            
        elif not(layertree1.isVisible()):
            layertree1.setItemVisibilityChecked(True)
            layertree2.setItemVisibilityChecked(False)
            
        iface.mapCanvas().refresh()



    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            
        
            self.dlg = QuickLayerDialog()
        
        # file = self.dlg.lineEdit1.text()
        # print(self.dlg.lineEdit2.text())
        # print(file)
        
        self.dlg.show() # show the dialog
        
        result = self.dlg.exec_() # See if OK was pressed
        
        if result:  # Run the dialog event loop
            
            skey = self.dlg.Key.text().capitalize().strip().replace(' ', '')
            lyr1 = self.dlg.mMapLayerComboBox1.currentLayer()
            lyr2 = self.dlg.mMapLayerComboBox2.currentLayer()

            #checking the validity of the shortcut key
            if skey == '':
                print('No shortcut key was inserted, please try again')
                return 'No shortcut key was inserted, please try again'
            
            elif skey in self.shortcuts:
                print('Please, do not repeat shortcut keys! INPUT : {}'.format(skey))
                return 'Please, do not repeat shortcut keys! INPUT : {}'.format(skey)
            

            lyr1tree = QgsProject.instance().layerTreeRoot().findLayer(lyr1.id())
            lyr2tree = QgsProject.instance().layerTreeRoot().findLayer(lyr2.id())

            print(lyr1tree)
            print(lyr2tree)
            
            shortcut1 = QShortcut(QKeySequence(skey), iface.mainWindow())
            shortcut1.setContext(Qt.ApplicationShortcut)
            shortcut1.activated.connect(lambda:self.alterna(lyr1tree, lyr2tree))
            self.shortcuts.append(skey)
    