# -*- coding: utf-8 -*-

"""
/***************************************************************************
 QThermonet
                                 A QGIS plugin
 This plugin links QGIS to pythermonet
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-06-10
        copyright            : (C) 2024 by Jane Lund Andersen/VIA University College
        email                : jana@via.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Jane Lund Andersen/VIA University College'
__date__ = '2025-06-10'
__copyright__ = '(C) 2025 by Jane Lund Andersen/VIA University College'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import inspect

from qgis.core import (
    QgsProcessing,
    QgsProcessingAlgorithm,
    QgsProcessingParameterVectorLayer,
    QgsProcessingException,
    QgsProcessingParameterEnum,
)
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QCoreApplication

class ToggleThermonetAlgorithm(QgsProcessingAlgorithm):
        
    #Handle input/output
    INPUT_LAYER = "INPUT_LAYER"
    THERMONET_VALUE = "THERMONET_VALUE"

    def initAlgorithm(self, config=None):
        
        # 1st input
        param = QgsProcessingParameterVectorLayer(
                self.INPUT_LAYER,
                "Buildings layer with selected buildings",
                [QgsProcessing.TypeVectorPolygon]
            )
        param.setHelp(
            "Input a layer with features selected that you want to "
            "include/exclude from the heatload and thermonet calculations")

        self.addParameter(param)
        
        # Add parameter for Thermonet value
        self.addParameter(
            QgsProcessingParameterEnum(
                self.THERMONET_VALUE,
                "Set the Thermonet value for selected buildings",
                ["Yes", "No"],
                allowMultiple=False,
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        # Get the input layer
        input_layer = self.parameterAsVectorLayer(parameters, self.INPUT_LAYER, context)
        if not input_layer:
            raise QgsProcessingException("Invalid input layer!")
        
        # Check if the layer is editable; make it editable if it's not
        if not input_layer.isEditable():
            if not input_layer.startEditing():
                raise QgsProcessingException("Failed to set the layer to edit mode. Please ensure the layer supports editing.")
        
        # Get the selected Thermonet value
        thermonet_value_index = self.parameterAsEnum(parameters, self.THERMONET_VALUE, context)
        thermonet_value = ["Yes", "No"][thermonet_value_index]
        
        # Ensure the "Thermonet" field exists
        if "Thermonet" not in [field.name() for field in input_layer.fields()]:
            raise QgsProcessingException("The layer does not contain a 'Thermonet' field!")

        # Get selected features
        selected_features = input_layer.selectedFeatures()
        if not selected_features:
            raise QgsProcessingException("No features selected! Please select features to modify.")

        thermonet_field_index = input_layer.fields().indexOf("Thermonet")

        # Start editing and update selected features
        feedback.pushInfo(f"Updating 'Thermonet' field to '{thermonet_value}' for {len(selected_features)} selected features.")
        for feature in selected_features:
            input_layer.changeAttributeValue(feature.id(), thermonet_field_index, thermonet_value)

        input_layer.triggerRepaint()  # Refresh layer to show changes
        
        # Deselect all features in the layer
        if input_layer.selectedFeatureCount() > 0:
            input_layer.removeSelection()
    
        #Save changes
        if not input_layer.commitChanges():
            raise QgsProcessingException("Failed to save changes to the layer. Please check for potential issues.")
        
        return {
            "Updated Features": len(selected_features)
        }

    def name(self):
        return "Optional: Toggle thermonet buildings"

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())
    
    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to.
        """
        return '1. Heatloads'
    
    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
    
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo2a.png')))
        return icon

    def shortHelpString(self):
        return (
            "<p> This helper tool allows you to easily update the 'Thermonet' "
            "field of all selected features in a buildings layer. <p> "
            "<p> Make sure to select the"
            " features (buildings) you want to include/exclude for heat load "
            "and thermonet calculations before running the tool <p>"
        )

    def createInstance(self):
        return ToggleThermonetAlgorithm()