# -*- coding: utf-8 -*-

"""
/***************************************************************************
 QThermonet
                                 A QGIS plugin
 This plugin links QGIS to pythermonet
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-12-05
        copyright            : (C) 2024 by Jane Lund Andersen/VIA University College
        email                : jana@via.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Jane Lund Andersen/VIA University College'
__date__ = '2024-12-05'
__copyright__ = '(C) 2024 by Jane Lund Andersen/VIA University College'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon
from PyQt5.QtWidgets import QMenu

from qgis.core import QgsApplication
import processing
from .QThermonet_processing_provider import QThermonetProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class QThermonetPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = QThermonetProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()
        
        # Check if the menu already exists, and create it if not
        self.menu = self.iface.mainWindow().menuBar().findChild(QMenu, "&QThermonet")
        if not self.menu:
            self.menu = QMenu("&QThermonet", self.iface.mainWindow().menuBar())
            self.iface.mainWindow().menuBar().addMenu(self.menu)
        
        self.plugin_actions = []  # Keep track of actions for cleanup
        
        # # Tool: test functionality
        # icon_tests = os.path.join(cmd_folder, 'logo.png')
        # self.action_tests = QAction(
        #     QIcon(icon_tests),
        #     u"Test", self.iface.mainWindow())
        # self.action_tests.triggered.connect(self.run_tests)
        # self.iface.addPluginToMenu(u"&QThermonet", self.action_tests)
        # self.menu.addAction(self.action_tests)
        # self.plugin_actions.append(self.action_tests)
        
        # Tool: Get buildings in AOI
        icon_get_buildings = os.path.join(cmd_folder, 'logo2.png')
        self.action_get_buildings = QAction(
            QIcon(icon_get_buildings),
            u"Get buildings and BBR information", self.iface.mainWindow())
        self.action_get_buildings.triggered.connect(self.run_GetbuildingsinAOI)
        self.iface.addPluginToMenu(u"&QThermonet", self.action_get_buildings)
        self.menu.addAction(self.action_get_buildings)
        self.plugin_actions.append(self.action_get_buildings)
        
        # Tool: Toggle Thermonet
        icon_toggle_thermonet = os.path.join(cmd_folder, 'logo2a.png')
        self.action_toggle_thermonet = QAction(
            QIcon(icon_toggle_thermonet),
            u"Optional: Toggle thermonet buildings", self.iface.mainWindow())
        self.action_toggle_thermonet.triggered.connect(self.run_ToggleThermonet)
        self.iface.addPluginToMenu(u"&QThermonet", self.action_toggle_thermonet)
        self.menu.addAction(self.action_toggle_thermonet)
        self.plugin_actions.append(self.action_toggle_thermonet)
        
        # Tool: Calculate heat loads
        icon_load_calculation = os.path.join(cmd_folder, 'logo2b.png')
        self.action_load_calculation = QAction(
            QIcon(icon_load_calculation),
            u"Calculate heatloads", self.iface.mainWindow())
        self.action_load_calculation.triggered.connect(self.run_LoadCalculation)
        self.iface.addPluginToMenu(u"&QThermonet", self.action_load_calculation)
        self.menu.addAction(self.action_load_calculation)
        self.plugin_actions.append(self.action_load_calculation)
        
        # # Tool: Calculate Aggregated loads
        # icon_aggregated_load = os.path.join(cmd_folder, 'logo3.png')
        # self.action_aggregated_load = QAction(
        #     QIcon(icon_aggregated_load),
        #     u"Calculate aggregated heat load", self.iface.mainWindow())
        # self.action_aggregated_load.triggered.connect(self.run_AggregatedLoads)
        # self.iface.addPluginToMenu(u"&QThermonet", self.action_aggregated_load)
        # self.menu.addAction(self.action_aggregated_load)
        # self.plugin_actions.append(self.action_aggregated_load)
        
        # Tool: Pipe hierarchy
        icon_pipe_hierarchy = os.path.join(cmd_folder, 'logo6-pipes-simple.png')
        self.action_pipe_hierarchy = QAction(
            QIcon(icon_pipe_hierarchy),
            u"Optional: Pipe hierarchy", self.iface.mainWindow())
        self.action_pipe_hierarchy.triggered.connect(self.run_PipeHierarchy)
        self.iface.addPluginToMenu(u"&QThermonet", self.action_pipe_hierarchy)
        self.menu.addAction(self.action_pipe_hierarchy)
        self.plugin_actions.append(self.action_pipe_hierarchy)
        
        # Tool: Service pipes
        icon_service_pipes = os.path.join(cmd_folder, 'logo-servicep.png')
        self.action_service_pipes = QAction(
            QIcon(icon_service_pipes),
            u"Shortest service pipes", self.iface.mainWindow())
        self.action_service_pipes.triggered.connect(self.run_ShortestServicePipes)
        self.iface.addPluginToMenu(u"&QThermonet", self.action_service_pipes)
        self.menu.addAction(self.action_service_pipes)
        self.plugin_actions.append(self.action_service_pipes)
        
        # Tool: Pipe topology
        icon_pipe_topology = os.path.join(cmd_folder, 'logo6-pipes-alt.png')
        self.action_pipe_topology = QAction(
            QIcon(icon_pipe_topology),
            u"Pipe topology", self.iface.mainWindow())
        self.action_pipe_topology.triggered.connect(self.run_PipeTopology)
        self.iface.addPluginToMenu(u"&QThermonet", self.action_pipe_topology)
        self.menu.addAction(self.action_pipe_topology)
        self.plugin_actions.append(self.action_pipe_topology)
        
        # Tool: Full dimensioning
        icon_full_dimensioning = os.path.join(cmd_folder, 'logo.png')
        self.action_full_dimensioning = QAction(
            QIcon(icon_full_dimensioning),
            u"Full_dimensioning", self.iface.mainWindow())
        self.action_full_dimensioning.triggered.connect(self.run_FullDimensioning)
        self.iface.addPluginToMenu(u"&QThermonet", self.action_full_dimensioning)
        self.menu.addAction(self.action_full_dimensioning)
        self.plugin_actions.append(self.action_full_dimensioning)
        
        # # Tool: Run pythermonet
        # icon_qpythermonet = os.path.join(os.path.join(cmd_folder, 'logo.png'))
        # self.action_qpythermonet = QAction(
        #     QIcon(icon_qpythermonet),
        #     u"Dimension sources", self.iface.mainWindow())
        # self.action_qpythermonet.triggered.connect(self.run_qpythermonet)
        # self.iface.addPluginToMenu(u"&QThermonet", self.action_qpythermonet)
        # self.menu.addAction(self.action_qpythermonet)
        # self.plugin_actions.append(self.action_qpythermonet)
        
        # Add toolbar icons for quick access to the tools
        # self.iface.addToolBarIcon(self.action_tests)
        self.iface.addToolBarIcon(self.action_get_buildings)
        self.iface.addToolBarIcon(self.action_toggle_thermonet)
        self.iface.addToolBarIcon(self.action_load_calculation)
        # self.iface.addToolBarIcon(self.action_aggregated_load)
        self.iface.addToolBarIcon(self.action_service_pipes)
        self.iface.addToolBarIcon(self.action_pipe_topology)
        self.iface.addToolBarIcon(self.action_full_dimensioning)
        # self.iface.addToolBarIcon(self.action_qpythermonet)
    
    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        
        # self.iface.removePluginMenu(u"&QThermonet", self.action_tests)
        # self.iface.removeToolBarIcon(self.action_tests)
        
        self.iface.removePluginMenu(u"&QThermonet", self.action_get_buildings)
        self.iface.removeToolBarIcon(self.action_get_buildings)
                
        self.iface.removePluginMenu(u"&QThermonet", self.action_toggle_thermonet)
        self.iface.removeToolBarIcon(self.action_toggle_thermonet)
                        
        self.iface.removePluginMenu(u"&QThermonet", self.action_load_calculation)
        self.iface.removeToolBarIcon(self.action_load_calculation)
        
        # self.iface.removePluginMenu(u"&QThermonet", self.action_aggregated_load)
        # self.iface.removeToolBarIcon(self.action_aggregated_load)
        
        
        self.iface.removePluginMenu(u"&QThermonet", self.action_pipe_hierarchy)
        self.iface.removeToolBarIcon(self.action_pipe_hierarchy)
        
        self.iface.removePluginMenu(u"&QThermonet", self.action_service_pipes)
        self.iface.removeToolBarIcon(self.action_service_pipes)
        
        self.iface.removePluginMenu(u"&QThermonet", self.action_pipe_topology)
        self.iface.removeToolBarIcon(self.action_pipe_topology)
        
        self.iface.removePluginMenu(u"&QThermonet", self.action_full_dimensioning)
        self.iface.removeToolBarIcon(self.action_full_dimensioning)
        
        # self.iface.removePluginMenu(u"&QThermonet", self.action_qpythermonet)
        # self.iface.removeToolBarIcon(self.action_qpythermonet)
        
        # Remove the menu and actions
        if hasattr(self, 'menu') and self.menu:
            for action in self.plugin_actions:
                self.menu.removeAction(action)
            menu_bar = self.iface.mainWindow().menuBar()
            menu_bar.removeAction(self.menu.menuAction())
        
    # def run_tests(self):
    #     processing.execAlgorithmDialog("QThermonet:Test")
            
    def run_GetbuildingsinAOI(self):
        processing.execAlgorithmDialog("QThermonet:Get buildings and BBR information")
        
    def run_ToggleThermonet(self):
        processing.execAlgorithmDialog("QThermonet:Optional: Toggle thermonet buildings")
        
    def run_LoadCalculation(self):
        processing.execAlgorithmDialog("QThermonet:Calculate heatloads")
        
    # def run_AggregatedLoads(self):
    #     processing.execAlgorithmDialog("QThermonet:Calculate aggregated heat load")
    
    def run_PipeHierarchy(self):
        processing.execAlgorithmDialog("QThermonet:Optional: Pipe hierarchy")
        
    def run_ShortestServicePipes(self):
        processing.execAlgorithmDialog("QThermonet:Shortest Service Pipes")
        
    def run_PipeTopology(self):
        processing.execAlgorithmDialog("QThermonet:Pipe Topology")
                
    def run_FullDimensioning(self):
        processing.execAlgorithmDialog("QThermonet:Full dimensioning")
        
    # def run_qpythermonet(self):
    #     processing.execAlgorithmDialog("QThermonet:Dimension sources")
    