def getAspectFromAzimuth(azimuth: float) -> float:
    """Convert azimuth into PVGIS aspect.

    In PVGIS, aspect is defined as an angle which values 0=south,
    90=west, -90=east.
    This function subtracts 180 from the input azimuth value.

    :param azimuth: standard azimuth values between 0 and 360 using North as origin
    :type azimuth: float
    :return: aspect taking values between -180 and 180 using South as origin
    :rtype: float
    """
    return azimuth - 180


def getPeakpower(
    area_3d: float, occupation_rate: float = 70, coeff: float = 0.215
) -> float:
    """Calculate peakpower value

    :param area_3d: Area value of a 3D roof surface
    :type area_3d: float
    :param occupation_rate: occupation rate, defaults to 70
    :type occupation_rate: float, optional
    :param coeff: peakpower coefficient, defaults to 0.215
    :type coeff: float, optional
    :return: peakpower value
    :rtype: float
    """
    return area_3d * occupation_rate / 100 * coeff


def getAngle(angle_pv: float, min_threshold: float = 5, forced_angle: float = 10):
    """Get angle value compared to a mimal threshold.

    If the angle is below the min threshold, the function returns a forced value.

    :param angle_pv: _description_
    :type angle_pv: float
    :param min_threshold: _description_, defaults to 5
    :type min_threshold: float, optional
    :param forced_angle: _description_, defaults to FORCED_ANGLE
    :type forced_angle: float, optional
    :return: _description_
    :rtype: _type_
    """
    return angle_pv if angle_pv > min_threshold else forced_angle
