# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Qsitg
                                 A QGIS plugin
 TODO
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-07
        git sha              : $Format:%H$
        copyright            : (C) 2025 by SITG
        email                : sitg@etat.ge.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import json
import os
import webbrowser

from qgis.core import (
    Qgis,
    QgsApplication,
    QgsAuthMethodConfig,
    QgsMessageLog,
    QgsSettings,
)
from qgis.gui import QgisInterface
from qgis.PyQt.QtCore import QItemSelectionModel, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import (
    QAction,
    QDockWidget,
    QMessageBox,
    QSplashScreen,
    QTreeView,
)

from .config import ARCGISFEATURESERVERS, AUTH_SETTING_ID, VECTORTILES
from .qsitg_dialog import QsitgDialog

KEY_CONFIG_DONE = "configuration_done_flag"
KEY_DONT_SHOW_AGAIN = "dont_show_again"


class Qsitg:
    """QGIS Plugin Implementation."""

    def __init__(self, iface: QgisInterface):
        # Save reference to the QGIS interface
        self.iface = iface
        self.dialog = None
        self.settings = QgsSettings()
        self.settings.beginGroup("qsitg")

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon = QIcon(os.path.join(os.path.dirname(__file__), "resources", "icon.png"))
        web_icon = QIcon(
            os.path.join(os.path.dirname(__file__), "resources", "catalog.png")
        )

        plugin_menu = self.iface.pluginMenu()
        if plugin_menu is None:
            raise RuntimeError("couldn't load plugin menu")
        self.menu = plugin_menu.addMenu(icon, "SITG (beta)")

        self.action_about = QAction(icon, "À propos du SITG...")
        self.action_about.triggered.connect(self.run_about)
        self.menu.addAction(self.action_about)

        self.action_catalog = QAction(
            web_icon, "Ouvrir le catalogue du SITG dans le navigateur"
        )
        self.action_catalog.triggered.connect(self.run_open_catalog)
        self.menu.addAction(self.action_catalog)

        self.action_services = QAction("Reconfigurer les géoservices du SITG")
        self.action_services.triggered.connect(self.run_prompt_reset_geoservices)
        self.menu.addAction(self.action_services)

        if self.is_starting_up():
            # if initializing, we do not show the gui right away, but wait until init is complete
            self.log("is starting up: gui deferred")
            if not self.settings.contains(KEY_DONT_SHOW_AGAIN):
                self.iface.initializationCompleted.connect(self.run_about)
            if not self.settings.contains(KEY_CONFIG_DONE):
                self.iface.initializationCompleted.connect(
                    self.run_prompt_reset_geoservices
                )
        else:
            # otherwise (right after manual install), we show the gui right away
            self.log("initialization already done: we show right away")
            if not self.settings.contains(KEY_DONT_SHOW_AGAIN):
                self.run_about()
            if not self.settings.contains(KEY_CONFIG_DONE):
                self.run_prompt_reset_geoservices()

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        self.iface.pluginMenu().removeAction(self.menu.menuAction())

    def log(self, message, level=Qgis.Info):
        QgsMessageLog.logMessage(message, "qsitg", level)

    def is_starting_up(self):
        """hacky way to retrieve if QGIS is still starting up"""
        for widget in QgsApplication.topLevelWidgets():
            if isinstance(widget, QSplashScreen) and widget.isVisible():
                return True
        return False

    def message(self, title, message, level=Qgis.Info):
        messagebar = self.iface.messageBar()
        if messagebar is None:
            raise RuntimeError("couldn't load messagebar")
        messagebar.pushMessage(title, message, level)

    def run_about(self):
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.dialog is None:
            self.dialog = QsitgDialog()

        # Run the dialog
        self.dialog.dont_show_again.setChecked(
            self.settings.contains(KEY_DONT_SHOW_AGAIN)
        )
        self.dialog.show()
        self.dialog.exec_()

        # Store don't show again
        QgsMessageLog.logMessage(f"{self.dialog.dont_show_again.isChecked()=}")
        if self.dialog.dont_show_again.isChecked():
            self.settings.setValue(KEY_DONT_SHOW_AGAIN, True)
        else:
            self.settings.remove(KEY_DONT_SHOW_AGAIN)

    def run_open_catalog(self):
        webbrowser.open_new_tab("https://sitg.ge.ch")

    def run_prompt_reset_geoservices(self):
        msgBox = QMessageBox(
            QMessageBox.Question,
            "Configuration des géoservices du SITG",
            "<p>Disposez-vous d'un compte GINA/E-Demarches vous permettant d'accéder à des données du SITG en accès restreint ?</p><p>Vous pourrez toujours changer cette option plus tard en choisissant <i>Reconfigurer les services</i> dans le menu de l'extension.</p>",
            QMessageBox.Yes | QMessageBox.No,
        )
        msgBox.setDefaultButton(QMessageBox.No)
        resp = msgBox.exec_()
        self.do_reset_geoservices(with_auth=resp == QMessageBox.Yes)

    def do_reset_geoservices(self, with_auth: bool):
        browser_items_names = []

        # Collapse all items in the browser (OAuth2 login is triggered if items are open when refreshing the browser)
        browser = self.iface.mainWindow().findChild(QDockWidget, "Browser")
        treeview = browser.findChild(QTreeView)
        treeview.clearSelection()
        treeview.collapseAll()

        # Create or update the OAuth2 configuration
        auth_manager = QgsApplication.authManager()
        if auth_manager is None:
            raise RuntimeError("couldn't load auth manager")
        auth_config = QgsAuthMethodConfig()
        auth_config.setId(AUTH_SETTING_ID)
        auth_config.setName("Authentification Portal SITG")
        auth_config.setMethod("OAuth2")
        auth_config.setConfig(
            "oauth2config",
            json.dumps(
                {
                    "clientId": "ioxyFVH8KND5M2Iu",
                    "grantFlow": 3,
                    "redirectPort": "7070",
                    "requestUrl": "https://app2.ge.ch/tergeoportal/sharing/rest/oauth2/authorize",
                    "tokenUrl": "https://app2.ge.ch/tergeoportal/sharing/rest/oauth2/token",
                    "persistToken": True,
                }
            ),
        )
        auth_manager.storeAuthenticationConfig(auth_config, overwrite=True)
        self.log(
            f"Successfully (re)created auth config {AUTH_SETTING_ID}", Qgis.Success
        )

        # Create or update the Arcgis REST entries in the browser
        settings = QgsSettings()
        settings.beginGroup("connections/arcgisfeatureserver/items")
        for name, config in ARCGISFEATURESERVERS.items():
            browser_items_names.append(name)
            if ("authcfg" in config) == with_auth:
                # include it
                settings.beginGroup(name)
                for key, val in config.items():
                    settings.setValue(key, val)
                settings.endGroup()
            else:
                # remove it
                settings.remove(name)

        self.log(
            f"Successfully (re)created {len(ARCGISFEATURESERVERS)} Arcgis REST entries",
            Qgis.Success,
        )

        # Create or update the vector tiles backgrounds
        settings = QgsSettings()
        settings.beginGroup("connections/vector-tile/items")
        for name, config in VECTORTILES.items():
            group_name = f"SITG - {name}"
            browser_items_names.append(group_name)
            settings.beginGroup(group_name)
            for key, val in config.items():
                settings.setValue(key, val)
            settings.endGroup()
        self.log(
            f"Successfully (re)created {len(VECTORTILES)} Vector tiles entries",
            Qgis.Success,
        )

        # Reload the browser GUI
        self.iface.reloadConnections()

        # Select freshly created items and show the browser
        model = treeview.model()
        if model:  # unsure why this can be None but let's not crash (see issue #2)
            for browser_item_name in browser_items_names:
                tree_items = model.match(
                    model.index(0, 0),
                    Qt.DisplayRole,
                    browser_item_name,
                    flags=Qt.MatchRecursive | Qt.MatchExactly | Qt.MatchCaseSensitive,
                )
                for tree_item in tree_items:
                    treeview.scrollTo(tree_item)
                    treeview.selectionModel().select(
                        tree_item, QItemSelectionModel.Select
                    )
            browser.setVisible(True)
            browser.raise_()

        self.message(
            "Succès !",
            "Les geoservices du SITG ont été (re)configurés avec succès et sont prêts à être utilisés.",
            Qgis.Success,
        )
        self.settings.setValue(KEY_CONFIG_DONE, "ok")
