# SFCGAL
import pysfcgal.sfcgal as sfcgal

# QGIS
from qgis.core import Qgis
from qgis.utils import qgsfunction

# Projet
from qsfcgal.core.sfcgal_wrapper import QgsGeometry_to_SFCGAL, SFCGAL_to_QgsGeometry


@qgsfunction(
    args="auto",
    group="SFCGAL",
    register=False,
    # helpText=(
    #     "A convex hull is the smallest convex shape that encloses a given set of "
    #     "points in space. It's like the tightest rubber band stretched around a set "
    #     "of points, forming the smallest convex polygon or polyhedron that contains "
    #     "all the points. "
    #     "To enter, you need to provide point or multipoint geometry. "
    # ),
)
def cg_triangulate_2dz(value, feature, parent):
    """
    <style>
    span { color: red }

    </style>
    <h1>Description</h1>

    Returns a Constrained Delaunay triangulation around the vertices of the input
    geometry, resulting in a Triangulated Irregular Network (TIN). This type of
    triangulation respects specified constraints, such as edges or segments.
    <br/><br/>
    <h1>Auguments</h1>
    <table>
        <tr><td><span>geometry</span></td><td>Any geometry</td></tr>
    </table>
    <br/><br/>
    <h1>Syntax</h1>
    cg_triangulate_2dz(<span>@geometry</span>)
    <br/><br/>
    """
    geom_input = QgsGeometry_to_SFCGAL(value)
    result_geom = geom_input.triangulate_2dz()
    if not Qgis.QGIS_VERSION_INT >= 33440:
        result_geom = sfcgal.read_wkt(
            (result_geom.wktDecim()).replace("TIN", "MULTIPOLYGON")
        )
    new_geom = SFCGAL_to_QgsGeometry(result_geom)
    return new_geom
